Validation.add('IsEmpty', '', function(v) {
				return  ((v == null) || (v.length == 0)); // || /^\s+$/.test(v));
			});

Validation.addAllThese([
	['required', 'Este es un campo requerido.', function(v) {
      function atrim(cadena)
      { 
        cadenaE="";
        for (i=0;i<cadena.length;i++)
        {     
           letra=cadena.substring(i,i+1);
           if (letra!=' ') { cadenaE=cadenaE + letra; }
        }
        return(cadenaE);
      };
				return !Validation.get('IsEmpty').test(atrim(v));
			}],
	['validate-number', 'Ingrese un n&uacute;mero v&aacute;lido.', function(v) {
				return Validation.get('IsEmpty').test(v) || (!isNaN(v) && !/^\s+$/.test(v));
			}],
	['validate-codigoid', 'Ingrese un c&oacute;digo v&aacute;lido.', function(v) {
				return Validation.get('IsEmpty').test(v) || /^([a-zA-Z0-9]{1,}[\-]{0,1}[a-zA-Z0-9]{1,}){1,}$/.test(v);
			}],      
	['validate-comentario', 'Ingrese un comentario v&aacute;lido.', function(v) {
				return Validation.get('IsEmpty').test(v) || /^([a-zA-Z0-9]{1,}[\-]{0,1}[a-zA-Z0-9]{1,}){1,}$/.test(v);
			}],      
	['validate-digits', 'Ingrese solo d&iacute;gitos.', function(v) {
				return Validation.get('IsEmpty').test(v) ||  !/[^\d]/.test(v);
			}],
	['validate-fonocod', 'Ingrese un tel&eacute;fono v&aacute;lido ejem 01-123456 o 1234567 .', function(v) {
				return Validation.get('IsEmpty').test(v) ||  /(^[0-9]{2,3}[\-][0-9]{6,10}$)|(^[0-9]{7,10}$)/.test(v);
			}],
	['validate-alpha', 'Ingrese solo letras (a-z).', function (v) {
				return Validation.get('IsEmpty').test(v) ||  /^([a-zA-Z]+[\s|a-zA-Z][a-zA-Z]+){1,}$/.test(v)
			}],
	['validate-names', 'Ingrese un nombre v&aacute;lido', function (v) {
				return Validation.get('IsEmpty').test(v) ||  /^([a-zA-ZA]+[\s|a-zA-ZA][a-zA-ZA]+){1,}$/.test(v)
			}],
	['validate-name', 'Ingrese un nombre v&aacute;lido', function (v) {
				return Validation.get('IsEmpty').test(v) ||  /^([a-zA-Z][a-zA-ZA]+){1,}$/.test(v) 
			}],
	['validate-lastname', 'Ingrese un apellido v&aacute;lido', function (v) {
				return Validation.get('IsEmpty').test(v) ||  /^([a-zA-ZA]){2,}([\s]?[a-zA-ZA]{2,})?$/.test(v)
			}],
	['validate-alphanum', 'Ingrese solo letras (a-z) o n&uacute; (0-9). sin espacios.', function(v) {
				return Validation.get('IsEmpty').test(v) ||  !/\W/.test(v)
			}],
	['validate-date', 'Ingrese una fecha v&aacute;lida.', function(v) {
				var test = new Date(v);
				return Validation.get('IsEmpty').test(v) || !isNaN(test);
			}],
	['validate-email', 'ingrese un email v&aacute;lido. ejemplo willjce@hotmail.com .', function (v) {
				return Validation.get('IsEmpty').test(v) || /\w{1,}[@][\w\-]{1,}([.]([\w\-]{1,})){1,3}$/.test(v)
			}],
	['validate-url', 'ingrese un URL v&aacute;lido. ejemplo http://deltron.com.pe', function (v) {
				return Validation.get('IsEmpty').test(v) || /^(http|https|ftp):\/\/(([A-Z0-9][A-Z0-9_-]*)(\.[A-Z0-9][A-Z0-9_-]*)+)(:(\d+))?\/?/i.test(v)
			}],
	['validate-date-au', 'Utilize este formato: dd/mm/yyyy. For example 17/03/2006 for the 17th of March, 2006.', function(v) {
				if(Validation.get('IsEmpty').test(v)) return true;
				var regex = /^(\d{2})\/(\d{2})\/(\d{4})$/;
				if(!regex.test(v)) return false;
				var d = new Date(v.replace(regex, '$2/$1/$3'));
				return ( parseInt(RegExp.$2, 10) == (1+d.getMonth()) ) && 
							(parseInt(RegExp.$1, 10) == d.getDate()) && 
							(parseInt(RegExp.$3, 10) == d.getFullYear() );
			}],
	['validate-date-pe', 'Utilize este formato: aaaa-mm-dd.', function(v) {
				if(Validation.get('IsEmpty').test(v)) return true;
				var regex = /^(\d{4})\-(\d{2})\-(\d{2})$/;
				if(!regex.test(v)) return false;
				var d = new Date(v.replace(regex, '$2/$3/$1'));
				return ( parseInt(RegExp.$2, 10) == (1+d.getMonth()) ) && 
							(parseInt(RegExp.$3, 10) == d.getDate()) && 
							(parseInt(RegExp.$1, 10) == d.getFullYear() );
			}],
  ['validate-date-beforecurrent', 'Utilize una fecha vlida: aaaa-mm-dd y anterior a la actual .', function(v) {
				if(Validation.get('IsEmpty').test(v)) return true;
				var regex = /^(\d{4})\-(\d{2})\-(\d{2})$/;
				if(!regex.test(v)) return false;
				var d = new Date(v.replace(regex, '$2/$3/$1'));
        val2=false;
				val1= ( parseInt(RegExp.$2, 10) == (1+d.getMonth()) ) && 
							(parseInt(RegExp.$3, 10) == d.getDate()) && 
							(parseInt(RegExp.$1, 10) == d.getFullYear() );
        if(val1)
          {
            fecha_actual = new Date();
            
            if(d.getFullYear() < fecha_actual.getFullYear())
            {
             val2=true;
            }else if(d.getFullYear() > fecha_actual.getFullYear())
            {

              val2 = false;
            }
            else
            {
              if(d.getMonth()<fecha_actual.getMonth()){
                val2=true;
              }else if(d.getMonth()>fecha_actual.getMonth())
              {
                val2=false;
              }
              else
              {
                val2 = (d.getDate()<=fecha_actual.getDate());
              }
            }
            //val2 =  (d.getFullYear() <= fecha_actual.getFullYear())?((d.getFullYear() == fecha_actual.getFullYear())?(d.getMonth()<=fecha_actual.getMonth()):true):false;
          } 
          return val1&&val2;          
			}],
	['validate-currency-dollar', 'Ingrese un monto v&aacute;lido $ . Ejemplo $100.00 .', function(v) {
				// [$]1[##][,###]+[.##]
				// [$]1###+[.##]
				// [$]0.##
				// [$].##
				return Validation.get('IsEmpty').test(v) ||  /^\$?\-?([1-9]{1}[0-9]{0,2}(\,[0-9]{3})*(\.[0-9]{0,2})?|[1-9]{1}\d*(\.[0-9]{0,2})?|0(\.[0-9]{0,2})?|(\.[0-9]{1,2})?)$/.test(v)
			}],
	['validate-currency-sol', 'Ingrese un monto v&aacute;lido S./ Ejemplo S./100.00 .', function(v) {
				// [$]1[##][,###]+[.##]
				// [$]1###+[.##]
				// [$]0.##
				// [$].##
				return Validation.get('IsEmpty').test(v) ||  /^S\.\/?\-?([1-9]{1}[0-9]{0,2}(\,[0-9]{3})*(\.[0-9]{0,2})?|[1-9]{1}\d*(\.[0-9]{0,2})?|0(\.[0-9]{0,2})?|(\.[0-9]{1,2})?)$/.test(v)
			}],
	['validate-currency', 'Ingrese un monto v&aacute;lido S./ o $. Ejemplo S./100.00 o $100.00 .', function(v) {
				// [$]1[##][,###]+[.##]
				// [$]1###+[.##]
				// [$]0.##
				// [$].##
				return Validation.get('IsEmpty').test(v) ||  /^S\.\/?\-?([1-9]{1}[0-9]{0,2}(\,[0-9]{3})*(\.[0-9]{0,2})?|[1-9]{1}\d*(\.[0-9]{0,2})?|0(\.[0-9]{0,2})?|(\.[0-9]{1,2})?)$/.test(v) || /^\$?\-?([1-9]{1}[0-9]{0,2}(\,[0-9]{3})*(\.[0-9]{0,2})?|[1-9]{1}\d*(\.[0-9]{0,2})?|0(\.[0-9]{0,2})?|(\.[0-9]{1,2})?)$/.test(v)
			}],			
	['validate-selection', 'Seleccione un valor', function(v,elm){
				return elm.options ? elm.selectedIndex > 0 : !Validation.get('IsEmpty').test(v);
			}],
	['validate-one-required', 'Please select one of the above options.', function (v,elm) {
				var p = elm.parentNode;
				var options = p.getElementsByTagName('INPUT');
				return $A(options).any(function(elm) {
					return $F(elm);
				});
			}],

	['validate-dni', 'El DNI ingresado no es v&aacute;lido', function(valor) {	  
	  
      if ( /^\d{8,8}$/.test(valor)){
         return true;
      }else{
        return false;
      }

	  
	}],
			
	['validate-ruc', 'El Ruc ingresado no es v&aacute;lido', function(valor) {
  
						   function trim(cadena){
						     cadena2 = "";
						     len = cadena.length;
						     for ( var i=0; i <= len ; i++ ){
						       if ( cadena.charAt(i) != " " ){
						         cadena2 = cadena2 + cadena.charAt(i);
						       }
						     }
						     return cadena2;
						   }
						    valor = trim(valor);
                if(valor.length==0)return true;
						    if ( !isNaN( valor ) ) {
						      if ( valor.length == 8 ){
						        suma = 0
						        for (i=0; i<valor.length-1;i++){
						          digito = valor.charAt(i) - '0';
						          if ( i==0 ) suma += (digito*2)
						          else suma += (digito*(valor.length-i))
						        }
						        resto = suma % 11;
						        if ( resto == 1) resto = 11;
						        if ( resto + ( valor.charAt( valor.length-1 ) - '0' ) == 11 ){
						          return true
						        }
						      } else if ( valor.length == 11 ){
						        suma = 0
						        x = 6
						        for (i=0; i<valor.length-1;i++){
						          if ( i == 4 ) x = 8
						          digito = valor.charAt(i) - '0';
						          x--
						          if ( i==0 ) suma += (digito*x)
						          else suma += (digito*x)
						        }
						        resto = suma % 11;
						        resto = 11 - resto

						        if ( resto >= 10) resto = resto - 10;
						        if ( resto == valor.charAt( valor.length-1 ) - '0' ){
						          return true
						        }
						      }
						    }
						    return false

			       }]		
]);
Object.extend(Validation, {
	validate : function(elm, options){
		options = Object.extend({
			useTitle : false,
			onElementValidate : function(result, elm) {}
		}, options || {});
		elm = $(elm);
		var cn = elm.classNames();
		return result = cn.all(function(value) {
			var test = Validation.test(value,elm,options.useTitle);
			options.onElementValidate(test, elm);
			return test;
		});
	},
	test : function(name, elm, useTitle) {
		var v = Validation.get(name);
		var prop = '__advice'+name.camelize();
		try {
		if(Validation.isVisible(elm) && !v.test($F(elm), elm)) {
			if(!elm[prop]) {
				var advice = Validation.getAdvice(name, elm);
				var errorMsg = useTitle ? ((elm && elm.title) ? elm.title : v.error) : v.error;
				if(advice == null) {
					//advice = '<div class="Validation-advice" id="advice-' + name + '-' + Validation.getElmID(elm) +'" style="display:none;'+($(elm).hasClassName('display_absolute')?'position:absolute':'')+'">' + errorMsg + '</div>'
					advice = '<div class="validation-advice" id="advice-' + name + '-' + Validation.getElmID(elm) +'" style="display:none">' + errorMsg + '</div>'
					switch (elm.type.toLowerCase()) {
						case 'checkbox':
						case 'radio':
							var p = elm.parentNode;
							if(p) {
								new Insertion.Bottom(p, advice);
							} else {
								new Insertion.After(elm, advice);
							}
							break;
						default:
							new Insertion.After(elm, advice);
				    }
					advice = Validation.getAdvice(name, elm);
				}
				if(!$(elm).hasClassName('onlyInSubmit'))
				if($(elm).hasClassName('display_alert'))
				{
				  alert(errorMsg);
				}else{
				  if(typeof Effect == 'undefined') {
					  advice.style.display = 'block';
				  } else {
					  new Effect.Appear(advice, {duration : 1 });
				  }
				}  
			}
			elm[prop] = true;
			elm.removeClassName('Validation-passed');
			elm.addClassName('Validation-failed');
			return false;
		} else {
			var advice = Validation.getAdvice(name, elm);
			if(advice != null) advice.hide();
			elm[prop] = '';
			elm.removeClassName('Validation-failed');
			elm.addClassName('Validation-passed');
			return true;
		}
		} catch(e) {
			throw(e)
		}
	}
});
Object.extend(Validation.prototype, {
	initialize : function(form, options){
		this.options = Object.extend({
			onSubmit : true,
			stopOnFirst : false,
			immediate : false,
			focusOnError : true,
			useTitles : false,
			onFormValidate : function(result, form) { return result},
			onElementValidate : function(result, elm) {}
		}, options || {});
		this.form = $(form);
		if(this.options.onSubmit) Event.observe(this.form,'submit',this.onSubmit.bind(this),false);
		if(this.options.immediate) {
			var useTitles = this.options.useTitles;
			var callback = this.options.onElementValidate;
			Form.getElements(this.form).each(function(input) { // Thanks Mike!
				Event.observe(input, 'blur', function(ev) { Validation.validate(Event.element(ev),{useTitle : useTitles, onElementValidate : callback}); });
			});
		}
	},
	validate : function() {
		var result = false;
		var useTitles = this.options.useTitles;
		var callback = this.options.onElementValidate;
		if(this.options.stopOnFirst) {
			result = Form.getElements(this.form).all(function(elm) { return Validation.validate(elm,{useTitle : useTitles, onElementValidate : callback}); });
		} else {
			result = Form.getElements(this.form).collect(function(elm) { return Validation.validate(elm,{useTitle : useTitles, onElementValidate : callback}); }).all();
		}
		if(!result && this.options.focusOnError) {
			Form.getElements(this.form).findAll(function(elm){return $(elm).hasClassName('Validation-failed')}).first().focus()
		}
		return result&&this.options.onFormValidate(result, this.form);;
	}
});
Object.extend(Validator.methods, {
  size : function(v,elm,opt) {return v.length == opt}
});
function validaFono(nomcod,nomfono,req)
{ 
  //alert(nomcod+'-'+nomfono);
  validar_fono = false;
  vcod = $F(nomcod).trim();
  vfono = $F(nomfono).trim();
  $(nomfono).value = vfono;
  $(nomcod).value = vcod;  
  if((vfono.length > 0 )||(vcod.length > 0))
  {
    validar_fono=true;
  } 
  validfono=true;
  mensaje='';
  if(req)validar_fono=true;
  if(validar_fono){
    
	if(vcod.length<2){
	  mensaje='El C&oacute;digo debe tener por lo menos 2 digitos';
	  validfono=false;
	}
	if(vcod.length>3){
	  mensaje='El C&oacute;digo debe tener como m&aacute;ximo 3 digitos';
	  validfono=false;
	}

	if(vfono.length<6){
	  mensaje='El Tel&eacute;fono debe tener por lo menos 6 digitos';
	  validfono=false;
	}
	if(vfono.length>10){
	  mensaje='El Tel&eacute;fono debe tener como m&aacute;ximo 10 digitos';
	  validfono=false;
	}
	if( /[^\d]/.test(vfono) || /[^\d]/.test(vcod) ){
	   mensaje='Ingrese Solo d&iacute;gitos';
	   validfono=false;
	}
	if(!validfono){
	  if($(nomfono+'_error')){
	    $(nomfono+'_error').update(mensaje);
	  }
    $(nomfono).focus();
	}else{
	  if($(nomfono+'_error')){
	    $(nomfono+'_error').update('');
	  }
	}
  }else{
    if($(nomfono+'_error')){
	  $(nomfono+'_error').update('');
    }
  }
   return validfono;
}
String.prototype.trim = function() { return this.replace(/^\s+|\s+$/, ''); };

esVacio = function (v){
  return  ((v == null) || (v.length == 0) /*|| (/^\s+$/.test(v))*/);
};
function validaDirecs(clasegrupo,obviar,req)
{
  dir = document.getElementsByClassName(clasegrupo);
  isvalid = true;
  validar_dir = dir.any(function (val){
    //Si alguno no es vaco
	if(val.tagName=='SELECT')
	{
		sel = val.selectedIndex;
		if(sel!=0){
		  return  true;
		}else{
		  return  false;
		}
	}else{
     // val.value=val.value.trim();
      if(!esVacio(val.value)){
       return true;
      }else{
	    return  false;
	  }
	}
  });
  if(req)validar_dir=true;
  if(validar_dir){
    isvalid = dir.all(function(val,id){
        if(val.id!=obviar){
		    if(val.tagName=='SELECT')
			{
			  sel = val.selectedIndex;
			  if(sel!=0){
			    return true;
			  }
			  val.focus();
			  return false
			}
          if(esVacio(val.value)){
			val.focus();
            return false;
          }
          return true;
        }
		return true;
    });
    if(!isvalid){
      alert('Debe ingresar una direccion completa');
    }
  }
  
  return  isvalid;
}