<?php
class MySQLConnection extends ConnectionCommon 
{
  /** Current database (used in mysql_select_db()). */
  private $database;

  /**
     * Connect to a database and log in as the specified user.
     *
     * @param $dsn the data source name (see DB::parseDSN for syntax)
     * @param $flags Any conneciton flags.
     * @access public
     * @throws Exception
     * @return void
     */
  function connect($dsninfo, $flags = 0)
  {
//    if (!extension_loaded('mysql')) {
//      throw new Exception('mysql extension not loaded');
//    }

    $this->dsn = $dsninfo;
    $this->flags = $flags;

    //$persistent = ($flags & Creole::PERSISTENT) === Creole::PERSISTENT;
    $persistent = $flags;

    if (isset($dsninfo['protocol']) && $dsninfo['protocol'] == 'unix') {
      $dbhost = ':' . $dsninfo['socket'];
    } else {
      $dbhost = $dsninfo['hostspec'] ? $dsninfo['hostspec'] : 'localhost';
      if (!empty($dsninfo['port'])) {
        $dbhost .= ':' . $dsninfo['port'];
      }
    }
    $user = $dsninfo['username'];
    $pw = $dsninfo['password'];

    $encoding = !empty($dsninfo['encoding']) ? $dsninfo['encoding'] : null;

    //$connect_function = $persistent ? 'mysql_pconnect' : 'mysql_connect';
    
    $conn = new PDO("mysql:host=".$dbhost,$user,$pw,
       array(
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        
        PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8"
        ));
    /*
    @ini_set('track_errors', true);
    if ($dbhost && $user && $pw) {
      $conn = @$connect_function($dbhost, $user, $pw);
    } elseif ($dbhost && $user) {
      $conn = @$connect_function($dbhost, $user);
    } elseif ($dbhost) {
      $conn = @$connect_function($dbhost);
    } else {
      $conn = false;
    }
    @ini_restore('track_errors');
    */
    if (empty($conn)) {
       $errorInfo = $conn->errorInfo();
      if (($err = @$errorInfo[0]) != '') {
        throw new Exception("connect failed", $err);
      } elseif (empty($php_errormsg)) {
        throw new Exception("connect failed");
      } else {
      	
        throw new Exception("connect failed");
      }
    }

    if ($dsninfo['database']) {
        try{    
          if (!@$conn->exec("use ".$dsninfo['database']."")) {
              
            
          }
          // fix to allow calls to different databases in the same script
          $this->database = $dsninfo['database'];
        }
        catch (PDOException $e) {        
            throw new Exception("cannot select database", $conn->errorCode());;
            }
        
        }
        $this->dblink = $conn;
    
        if ($encoding) {
          $this->executeUpdate("SET NAMES " . $encoding);
        }
  }

  /**
     * @see Connection::disconnect()
     */
  function close()
  {
    //$ret = mysql_close($this->dblink);
    $this->dblink = null;
    return $ret;
  }

  /**
     * @see Connection::applyLimit()
     */
  public function applyLimit(&$sql, $offset, $limit)
  {
    if ( $limit > 0 ) {
      $sql .= " LIMIT " . ($offset > 0 ? $offset . ", " : "") . $limit;
    } else if ( $offset > 0 ) {
      $sql .= " LIMIT " . $offset . ", 18446744073709551615";
    }
  }

  /**
     * @see Connection::executeQuery()
     */
  function executeQuery($sql, $fetchmode = null)
  {
    $this->lastQuery = $sql;
    
    if ($this->database) {
      if (!@$this->dblink->exec("use ".$this->database."")) {
        throw new Exception('No database selected', $this->dblink->errorInfo());
      }
    }
    //$result = @mysql_query($sql, $this->dblink);
    $result = $this->dblink->query($sql);
    if (!$result) {
      throw new Exception('Could not execute query', $this->dblink->errorCode(), $sql);
    }
    return new MySQLResultSet($this, $result, $fetchmode);
  }

  /**
     * @see Connection::executeUpdate()
     */
  function executeUpdate($sql)
  {
    $this->lastQuery = $sql;
    
    if ($this->database) {
      if (!@$this->dblink->exec("use ".$this->database."")) {
        throw new Exception('No database selected', $this->dblink->errorCode());
      }
    }
        
    //$result = @mysql_query($sql, $this->dblink);
    $result = $this->dblink->query($sql);
    if (!$result) {
      throw new Exception('Could not execute update', $this->dblink->errorCode(), $sql);
    }
    return (int) $this->dblink->rowCount();
  }

  /**
     * Start a database transaction.
     * @throws Exception
     * @return void
     */
  protected function beginTrans()
  {
    
    $result = $this->dblink->query('SET AUTOCOMMIT=0');
    $result = $this->dblink->query('BEGIN');
    if (!$result) {
      throw new Exception('Could not begin transaction', $this->dblink->errorCode());
    }
  }

  /**
     * Commit the current transaction.
     * @throws Exception
     * @return void
     */
  protected function commitTrans()
  {
    
    if ($this->database) {
      if (!@$this->dblink->exec("use ".$this->database."")) {
        throw new Exception('No database selected', $this->dblink->errorCode());
      }
    }
    
    $result = $this->dblink->query('COMMIT');
    $result = $this->dblink->query('SET AUTOCOMMIT=1');
    if (!$result) {
      throw new Exception('Can not commit transaction', $this->dblink->errorCode());
    }
  }

  /**
     * Roll back (undo) the current transaction.
     * @throws Exception
     * @return void
     */
  protected function rollbackTrans()
  {
    if ($this->database) {
      if (!@$this->dblink->exec("use ".$this->database."")) {
        throw new Exception('No database selected', $this->dblink->errorCode());
      }
    }
    $result = $this->dblink->query('ROLLBACK');
    $result = $this->dblink->query('SET AUTOCOMMIT=1');
    if (!$result) {
      throw new Exception('Could not rollback transaction', $this->dblink->errorCode());
    }
  }

  /**
     * Gets the number of rows affected by the data manipulation
     * query.
     *
     * @return int Number of rows affected by the last query.
     */
  function getUpdateCount()
  {
    return (int) @$this->dblink->rowCount();
  }

}