<?php
/**
 * Clase FN para CrUtilidadFN
 *
 * @package    
 * @subpackage CrUtilidadFN
 * @author     Willy
 * @version    SVN:: CrUtilidadFN.class.php,v 1.1 2016-11-11 13:29:56 william.taype Exp $
 */
class CrUtilidadFN extends BaseCrUtilidadFN
{
	
	public function getAnios()
  {
    try
    {
     
      $con = Conexion::getConexion();
      $sql = "SELECT AnioCancelacion
      		 FROM cr_utilidad
      		 GROUP BY AnioCancelacion" ; 
      //echo $sql;		 
         $result = $con->query($sql);
		$num_rows = $result->rowCount();
      $num_rows = $result->rowCount();
      $a_tmp = array();
      if($num_rows>0){
        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
          $a_tmp[] = $o_valor->AnioCancelacion;
        }
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }
  
  	
	public function getMeses($anio)
  {
    try
    {
     
      $con = Conexion::getConexion();
      $sql = "SELECT PeriodoCancelacion
      		 FROM cr_utilidad
      		 where AnioCancelacion ='$anio'
      		 GROUP BY PeriodoCancelacion" ; 
      		 
        $result = $con->query($sql);
		$num_rows = $result->rowCount();
      $num_rows = $result->rowCount();
      $a_tmp = array();
      if($num_rows>0){
        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
          $a_tmp[] = $o_valor->PeriodoCancelacion;
        }
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }
  
  public function getListado()
  {
    try
    {
      $tamPag = !property_exists($this, 'tamPag')?9999:$this->tamPag;
      $pagina = !property_exists($this, 'page')||$this->page==""?1:$this->page;
      $numeroRegistros = $this->selectNumRows();
      $limitInf = ($pagina-1)*$tamPag;

      $where = $this->buildConsult();
      $orden = $this->buildOrderByField();
      $group_ext = $this->groupBy();

      $con = Conexion::getConexion();
      $sql = "	SELECT IdSucursal, IdMercado, IdRepresentante $group_ext, Sucursal,	Mercado	,Representante ,count(IdPrestamo) as NumeroPrestamos,sum(MontoTotal) as Montototal,sum(MontoMora) as MontoMora,sum(Utilidad) as Utilidad,sum(GastoAdministrativo) as GastoAdministrativo,sum(Ganancia) as Ganancia
      			FROM cr_utilidad 
      			WHERE 1 ".$where."   
      			GROUP BY IdSucursal, IdRepresentante, IdMercado". $group_ext."
      			".$orden."
      			LIMIT ".$limitInf.",".$tamPag;
      //echo $sql;
      
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      $a_tmp = array();
      if($num_rows>0){
      	$i = 1;
        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
          $tiempo = $o_valor->{trim(str_replace(",","",$group_ext))};
          $a_tmp[$o_valor->IdSucursal."_".$o_valor->IdMercado."_".$o_valor->IdRepresentante."_".$tiempo]['IdSucursal'] = $o_valor->IdSucursal;
          $a_tmp[$o_valor->IdSucursal."_".$o_valor->IdMercado."_".$o_valor->IdRepresentante."_".$tiempo]['IdMercado']  = $o_valor->IdMercado;
          $a_tmp[$o_valor->IdSucursal."_".$o_valor->IdMercado."_".$o_valor->IdRepresentante."_".$tiempo]['IdRepresentante'] = $o_valor->IdRepresentante;
          $a_tmp[$o_valor->IdSucursal."_".$o_valor->IdMercado."_".$o_valor->IdRepresentante."_".$tiempo]['tiempo'] = $tiempo;
          $a_tmp[$o_valor->IdSucursal."_".$o_valor->IdMercado."_".$o_valor->IdRepresentante."_".$tiempo]['Sucursal'] = $o_valor->Sucursal;
          $a_tmp[$o_valor->IdSucursal."_".$o_valor->IdMercado."_".$o_valor->IdRepresentante."_".$tiempo]['Mercado'] = $o_valor->Mercado;
          $a_tmp[$o_valor->IdSucursal."_".$o_valor->IdMercado."_".$o_valor->IdRepresentante."_".$tiempo]['Representante'] = $o_valor->Representante;
          $a_tmp[$o_valor->IdSucursal."_".$o_valor->IdMercado."_".$o_valor->IdRepresentante."_".$tiempo]['NumeroPrestamos'] = $o_valor->NumeroPrestamos;
          $a_tmp[$o_valor->IdSucursal."_".$o_valor->IdMercado."_".$o_valor->IdRepresentante."_".$tiempo]['Montototal'] = $o_valor->Montototal;
          $a_tmp[$o_valor->IdSucursal."_".$o_valor->IdMercado."_".$o_valor->IdRepresentante."_".$tiempo]['MontoMora'] = $o_valor->MontoMora;
          $a_tmp[$o_valor->IdSucursal."_".$o_valor->IdMercado."_".$o_valor->IdRepresentante."_".$tiempo]['Utilidad'] = $o_valor->Utilidad;
          $a_tmp[$o_valor->IdSucursal."_".$o_valor->IdMercado."_".$o_valor->IdRepresentante."_".$tiempo]['GastoAdministrativo'] = $o_valor->GastoAdministrativo;
          $a_tmp[$o_valor->IdSucursal."_".$o_valor->IdMercado."_".$o_valor->IdRepresentante."_".$tiempo]['Ganancia'] = $o_valor->Ganancia;
          $i++;
        }
       /* echo "<pre>";
        print_r($a_tmp);
        echo "</pre>";
       */
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }
  
   public function getListadoDetalle()
  {
    try
    {
      $tamPag = !property_exists($this, 'tamPag')?9999:$this->tamPag;
      $pagina = !property_exists($this, 'page')||$this->page==""?1:$this->page;
      $numeroRegistros = $this->selectNumRows();
      $limitInf = ($pagina-1)*$tamPag;

      $where = $this->buildConsult();
      $orden = $this->buildOrderByField();
      
      $con = Conexion::getConexion();
      $sql = "	SELECT *
      			FROM cr_utilidad 
      			WHERE 1 ".$where." ".$orden."        			
      			LIMIT ".$limitInf.",".$tamPag;
      //echo $sql;
      
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      $a_tmp = array();
      if($num_rows>0){
        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
          $a_tmp[] = $this->insertObjectBN($o_valor);
        }
       /* echo "<pre>";
        print_r($a_tmp);
        echo "</pre>";
       */
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }
  
  
   public function groupBy()
  {
    try
    {
      $where = "";

      if($this->getTiempo() == '1'){ 
      	$groupBy .= " ,PeriodoCancelacion"; 
      }
      if($this->getTiempo() == '2'){ 
      	$groupBy .= " ,FechaCancelacion "; 
      }
      
      
      
      return $groupBy;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildConsult()
  {
    try
    {
      $where = "";

      if($this->getIdSucursal()){ $where .= " AND idsucursal = '".$this->getIdSucursal()."'"; }
      if($this->getIdMercado()){ $where .= " AND idmercado = '".$this->getIdMercado()."'"; }
      if($this->getIdRepresentante()){ $where .= " AND idrepresentante = '".$this->getIdRepresentante()."'"; }
      if($this->getIdPrestamo()){ $where .= " AND idprestamo = '".$this->getIdPrestamo()."'"; }
      
      if($this->getTiempo() == '1'){ 
	    if($this->getPeriodoCancelacionInicial()){ $where .= " AND periodocancelacion >= '".$this->getPeriodoCancelacionInicial()."'"; }
	    if($this->getPeriodoCancelacionFinal()){ $where .= " AND periodocancelacion <= '".$this->getPeriodoCancelacionFinal()."'"; }
	    if($this->getPeriodoCancelacion()){ $where .= " AND periodocancelacion = '".$this->getPeriodoCancelacion()."'"; }
      }elseif($this->getTiempo() == '2'){ 
	    if($this->getFechaCancelacionInicial()){ $where .= " AND fechacancelacion >= '".$this->getFechaCancelacionInicial()."'"; }
	    if($this->getFechaCancelacionFinal()){ $where .= " AND fechacancelacion <= '".$this->getFechaCancelacionFinal()."'"; }
	    if($this->getFechaCancelacion()){ $where .= " AND fechacancelacion = '".$this->getFechaCancelacion()."'"; }
      }else{
      	if($this->getFechaCancelacion()){ $where .= " AND fechacancelacion = '".$this->getFechaCancelacion()."'"; }
      	if($this->getPeriodoCancelacion()){ $where .= " AND periodocancelacion = '".$this->getPeriodoCancelacion()."'"; }
      }
      
      if($this->getOpfechavencimiento()){ $where .=" AND fechacancelacion ".$this->getOpfechavencimiento()." fechavencimiento";}
      if($this->getFechaInicio()){ $where .= " AND fechainicio = '".$this->getFechaInicio()."'"; }
      if($this->getFechaVencimiento()){ $where .= " AND fechavencimiento = '".$this->getFechaVencimiento()."'"; }
      if($this->getIdCliente()){ $where .= " AND idcliente = '".$this->getIdCliente()."'"; }
      if($this->getMontoTotal()){ $where .= " AND montototal = '".$this->getMontoTotal()."'"; }
      if($this->getGanancia()){ $where .= " AND ganancia = '".$this->getGanancia()."'"; }
      if($this->getSucursal()){ $where .= " AND sucursal = '".$this->getSucursal()."'"; }
      if($this->getMercado()){ $where .= " AND mercado = '".$this->getMercado()."'"; }
      if($this->getRepresentante()){ $where .= " AND representante = '".$this->getRepresentante()."'"; }
      if($this->getCliente()){ $where .= " AND cliente = '".$this->getCliente()."'"; }
      if($this->getGastoAdministrativo()){ $where .= " AND gastoadministrativo = '".$this->getGastoAdministrativo()."'"; }
      
      return $where;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }
}