<?php
/**
 * Clase Base DP para BaseCrUtilidadDP
 *
 * @package    
 * @subpackage BaseCrUtilidadDP
 * @author     Willy
 * @version    SVN:: BaseCrUtilidadDP.class.php,v 1.1 2016-11-11 13:29:27 william.taype Exp $
 */
abstract class BaseCrUtilidadDP extends CrUtilidadBN
{
  /* Nmero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof CrUtilidadBN )
    {
      $o_CrUtilidadBN = $bSetDefault;
      if($o_CrUtilidadBN->getIdSucursal()) : $this->setIdSucursal($o_CrUtilidadBN->getIdSucursal()); endif;
      if($o_CrUtilidadBN->getIdMercado()) : $this->setIdMercado($o_CrUtilidadBN->getIdMercado()); endif;
      if($o_CrUtilidadBN->getIdRepresentante()) : $this->setIdRepresentante($o_CrUtilidadBN->getIdRepresentante()); endif;
      if($o_CrUtilidadBN->getIdPrestamo()) : $this->setIdPrestamo($o_CrUtilidadBN->getIdPrestamo()); endif;
      if($o_CrUtilidadBN->getFechaCancelacion()) : $this->setFechaCancelacion($o_CrUtilidadBN->getFechaCancelacion()); endif;
      if($o_CrUtilidadBN->getFechaInicio()) : $this->setFechaInicio($o_CrUtilidadBN->getFechaInicio()); endif;
      if($o_CrUtilidadBN->getFechaVencimiento()) : $this->setFechaVencimiento($o_CrUtilidadBN->getFechaVencimiento()); endif;
      if($o_CrUtilidadBN->getIdCliente()) : $this->setIdCliente($o_CrUtilidadBN->getIdCliente()); endif;
      if($o_CrUtilidadBN->getMontoTotal()) : $this->setMontoTotal($o_CrUtilidadBN->getMontoTotal()); endif;
      if($o_CrUtilidadBN->getGanancia()) : $this->setGanancia($o_CrUtilidadBN->getGanancia()); endif;
      if($o_CrUtilidadBN->getSucursal()) : $this->setSucursal($o_CrUtilidadBN->getSucursal()); endif;
      if($o_CrUtilidadBN->getMercado()) : $this->setMercado($o_CrUtilidadBN->getMercado()); endif;
      if($o_CrUtilidadBN->getRepresentante()) : $this->setRepresentante($o_CrUtilidadBN->getRepresentante()); endif;
      if($o_CrUtilidadBN->getCliente()) : $this->setCliente($o_CrUtilidadBN->getCliente()); endif;
      if($o_CrUtilidadBN->getGastoAdministrativo()) : $this->setGastoAdministrativo($o_CrUtilidadBN->getGastoAdministrativo()); endif;
    }
  }

  /* Obtiene el nmero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(IdSucursal),(MAX(IdSucursal)+1), 1) AS Maximo FROM cr_utilidad;";
      $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
      $result = $oLink->query($sql);
      $row = $result->fetch(PDO::FETCH_ASSOC);
      $this->setIdSucursal($row["Maximo"]);

      if($this->getIdSucursal() && $this->getIdMercado() && $this->getIdRepresentante() && $this->getIdPrestamo()){
        $a_Fields = array();

        if($this->getIdSucursal()) : $a_Fields['IdSucursal'] = ($this->getIdSucursal()); endif;
        if($this->getIdMercado()) : $a_Fields['IdMercado'] = ($this->getIdMercado()); endif;
        if($this->getIdRepresentante()) : $a_Fields['IdRepresentante'] = ($this->getIdRepresentante()); endif;
        if($this->getIdPrestamo()) : $a_Fields['IdPrestamo'] = ($this->getIdPrestamo()); endif;
        if($this->getFechaCancelacion()) : $a_Fields['FechaCancelacion'] = ($this->getFechaCancelacion()); endif;
        if($this->getFechaInicio()) : $a_Fields['FechaInicio'] = ($this->getFechaInicio()); endif;
        if($this->getFechaVencimiento()) : $a_Fields['FechaVencimiento'] = ($this->getFechaVencimiento()); endif;
        if($this->getIdCliente()) : $a_Fields['IdCliente'] = ($this->getIdCliente()); endif;
        if($this->getMontoTotal()) : $a_Fields['MontoTotal'] = ($this->getMontoTotal()); endif;
        if($this->getGanancia()) : $a_Fields['Ganancia'] = ($this->getGanancia()); endif;
        if($this->getSucursal()) : $a_Fields['Sucursal'] = ($this->getSucursal()); endif;
        if($this->getMercado()) : $a_Fields['Mercado'] = ($this->getMercado()); endif;
        if($this->getRepresentante()) : $a_Fields['Representante'] = ($this->getRepresentante()); endif;
        if($this->getCliente()) : $a_Fields['Cliente'] = ($this->getCliente()); endif;
        if($this->getGastoAdministrativo()) : $a_Fields['GastoAdministrativo'] = ($this->getGastoAdministrativo()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO cr_utilidad (".$sStringField.") VALUES (".$sStringValue.");";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdSucursal() && $this->getIdMercado() && $this->getIdRepresentante() && $this->getIdPrestamo())
      {
        $a_Fields = array();

        if($this->getIdSucursal()) : $a_Fields['IdSucursal'] = ($this->getIdSucursal()); endif;
        if($this->getIdMercado()) : $a_Fields['IdMercado'] = ($this->getIdMercado()); endif;
        if($this->getIdRepresentante()) : $a_Fields['IdRepresentante'] = ($this->getIdRepresentante()); endif;
        if($this->getIdPrestamo()) : $a_Fields['IdPrestamo'] = ($this->getIdPrestamo()); endif;
        if($this->getFechaCancelacion()) : $a_Fields['FechaCancelacion'] = ($this->getFechaCancelacion()); endif;
        if($this->getFechaInicio()) : $a_Fields['FechaInicio'] = ($this->getFechaInicio()); endif;
        if($this->getFechaVencimiento()) : $a_Fields['FechaVencimiento'] = ($this->getFechaVencimiento()); endif;
        if($this->getIdCliente()) : $a_Fields['IdCliente'] = ($this->getIdCliente()); endif;
        if($this->getMontoTotal()) : $a_Fields['MontoTotal'] = ($this->getMontoTotal()); endif;
        if($this->getGanancia()) : $a_Fields['Ganancia'] = ($this->getGanancia()); endif;
        if($this->getSucursal()) : $a_Fields['Sucursal'] = ($this->getSucursal()); endif;
        if($this->getMercado()) : $a_Fields['Mercado'] = ($this->getMercado()); endif;
        if($this->getRepresentante()) : $a_Fields['Representante'] = ($this->getRepresentante()); endif;
        if($this->getCliente()) : $a_Fields['Cliente'] = ($this->getCliente()); endif;
        if($this->getGastoAdministrativo()) : $a_Fields['GastoAdministrativo'] = ($this->getGastoAdministrativo()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE cr_utilidad SET ".$sStringField." WHERE 1 AND IdSucursal='".$this->getIdSucursal()."' AND IdMercado='".$this->getIdMercado()."' AND IdRepresentante='".$this->getIdRepresentante()."' AND IdPrestamo='".$this->getIdPrestamo()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdSucursal() && $this->getIdMercado() && $this->getIdRepresentante() && $this->getIdPrestamo())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM cr_utilidad WHERE 1 AND IdSucursal='".$this->getIdSucursal()."' AND IdMercado='".$this->getIdMercado()."' AND IdRepresentante='".$this->getIdRepresentante()."' AND IdPrestamo='".$this->getIdPrestamo()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* Bsqueda del registro por la llave primaria */
  public static function selectByPK($vIdSucursal, $vIdMercado, $vIdRepresentante, $vIdPrestamo)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IdSucursal, IdMercado, IdRepresentante, IdPrestamo, FechaCancelacion, FechaInicio, FechaVencimiento, IdCliente, MontoTotal, Ganancia, Sucursal, Mercado, Representante, Cliente, GastoAdministrativo FROM cr_utilidad WHERE 1 AND IdSucursal='".$vIdSucursal."' AND IdMercado='".$vIdMercado."' AND IdRepresentante='".$vIdRepresentante."' AND IdPrestamo='".$vIdPrestamo."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con mtodos de acceso */
  private function insertObjectBN($o_propel){
    $o_CrUtilidadDP = new CrUtilidadDP();
    $o_CrUtilidadDP->setIdSucursal($o_propel->IdSucursal);
    $o_CrUtilidadDP->setIdMercado($o_propel->IdMercado);
    $o_CrUtilidadDP->setIdRepresentante($o_propel->IdRepresentante);
    $o_CrUtilidadDP->setIdPrestamo($o_propel->IdPrestamo);
    $o_CrUtilidadDP->setFechaCancelacion($o_propel->FechaCancelacion);
    $o_CrUtilidadDP->setFechaInicio($o_propel->FechaInicio);
    $o_CrUtilidadDP->setFechaVencimiento($o_propel->FechaVencimiento);
    $o_CrUtilidadDP->setIdCliente($o_propel->IdCliente);
    $o_CrUtilidadDP->setMontoTotal($o_propel->MontoTotal);
    $o_CrUtilidadDP->setGanancia($o_propel->Ganancia);
    $o_CrUtilidadDP->setSucursal($o_propel->Sucursal);
    $o_CrUtilidadDP->setMercado($o_propel->Mercado);
    $o_CrUtilidadDP->setRepresentante($o_propel->Representante);
    $o_CrUtilidadDP->setCliente($o_propel->Cliente);
    $o_CrUtilidadDP->setGastoAdministrativo($o_propel->GastoAdministrativo);
    return $o_CrUtilidadDP;
  }
}