<?php

/**
 * Clase Dispacher para Usuario
 *
 * @package    IM
 * @subpackage UsuarioDP
 * @author     Willy
 * @version    SVN: $Id: UsuarioDP.class.php,v 1.1 2008/02/07 17:43:32 william.taype Exp $
 */
class UsuarioDP implements interfaceDP {

  protected $o_Bean;
  
  
  private static $fieldNames = array (
    'UsuarioId' => 'user_id', 'Nombre' => 'user_name', 'EsDisabled' => 'is_disabled', 'RolId' => 'role_id'
	);
  
  /**
  * Constructor donde asigna a un atributo el objeto UsuarioBean
  *
  * @param UsuarioBean $o_UsuarioBean
  */
  public function __construct(UsuarioBean $o_UsuarioBean){
  
    $this->o_Bean = $o_UsuarioBean;
    
  }
  
  /**
  * Retorna el objeto UsuarioBean
  *
  * @return Object
  */
  protected function getObjetoBean(){
  
    if(!$this->o_Bean){
        $this->o_Bean = new UsuarioBean();
    }        
    return $this->o_Bean;
    
  }
  
   /**
   * Enter description here...
   *
   * @return Int
   */
  public function selectNumRows(){
    
    $where = $this->buildConsult();
    
    $con = Conexion::getConexion();
    
     $sql = "SELECT * FROM mnu_user WHERE user_elim <> '1'".$where;
   
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    
    
   
    return $num_rows;
    
  }
  
   private function buildConsult(){
    
     $where = "";
    
    if($this->getObjetoBean()->getNombre()){
      $where .= " AND user_name LIKE '%".$this->getObjetoBean()->getNombre()."%'";
    }
    
    if($this->getObjetoBean()->getRolId()){
      $where .= " AND role_id = '".$this->getObjetoBean()->getRolId()."'";
    }
    
    if($this->getObjetoBean()->getDateBegin()){
      $where .= " AND LEFT(created_date, 10) >= '".$this->getObjetoBean()->getDateBegin()."'";
    }
    
    if($this->getObjetoBean()->getDateEnd()){
      $where .= " AND LEFT(created_date, 10) <= '".$this->getObjetoBean()->getDateEnd()."'";
    }
    
    
    return $where;
    
  }
  
  /**
  * Ingresa un nuevo registro
  *
  * @return IdGenerado
  */
  public function save(){
    
    if($this->getObjetoBean()->getUsuarioId()){
      
      $a_Fields = array();
      
      if($this->getObjetoBean()->getUsuarioId()) : $a_Fields['user_id'] = ($this->getObjetoBean()->getUsuarioId()); endif;
      if($this->getObjetoBean()->getNombre()) : $a_Fields['user_name'] = ($this->getObjetoBean()->getNombre()); endif;
      if($this->getObjetoBean()->getContrasena()) : $a_Fields['user_password'] = ($this->getObjetoBean()->getContrasena()); endif;
      if($this->getObjetoBean()->getRolId()) : $a_Fields['role_id'] = ($this->getObjetoBean()->getRolId()); endif;
      if($this->getObjetoBean()->getPswdFechCambio()) : $a_Fields['pswd_chg_date'] = ($this->getObjetoBean()->getPswdFechCambio()); endif;
      if($this->getObjetoBean()->getPswdHoraCambio()) : $a_Fields['pswd_chg_time'] = ($this->getObjetoBean()->getPswdHoraCambio()); endif;
      if($this->getObjetoBean()->getPswdAciertos()) : $a_Fields['pswd_count'] = ($this->getObjetoBean()->getPswdAciertos()); endif;
      if($this->getObjetoBean()->getEnUso()) : $a_Fields['in_use'] = ($this->getObjetoBean()->getEnUso()); endif;
      if($this->getObjetoBean()->getEsDisabled()) : $a_Fields['is_disabled'] = ($this->getObjetoBean()->getEsDisabled()); endif;
      if($this->getObjetoBean()->getFechaInicioSesion()) : $a_Fields['logon_date'] = ($this->getObjetoBean()->getFechaInicioSesion()); endif;
      if($this->getObjetoBean()->getHoraInicioSesion()) : $a_Fields['logon_time'] = ($this->getObjetoBean()->getHoraInicioSesion()); endif;
      if($this->getObjetoBean()->getCodigoIdioma()) : $a_Fields['language_code'] = ($this->getObjetoBean()->getCodigoIdioma()); endif;
      if($this->getObjetoBean()->getFechaInicio()) : $a_Fields['start_date'] = ($this->getObjetoBean()->getFechaInicio()); endif;
      if($this->getObjetoBean()->getFechaFin()) : $a_Fields['end_date'] = ($this->getObjetoBean()->getFechaFin()); endif;
      if($this->getObjetoBean()->getDireccionIp()) : $a_Fields['ip_address'] = ($this->getObjetoBean()->getDireccionIp()); endif;
      if($this->getObjetoBean()->getCorreoElectronico()) : $a_Fields['email_addr'] = ($this->getObjetoBean()->getCorreoElectronico()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['created_date'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['created_user'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaActualizacion()) : $a_Fields['revised_date'] = ($this->getObjetoBean()->getFechaActualizacion()); endif;
      if($this->getObjetoBean()->getUsuarioActualizacion()) : $a_Fields['revised_user'] = ($this->getObjetoBean()->getUsuarioActualizacion()); endif;
      
      $sStringField = arrayClass::implode_keys(',', $a_Fields);
      $sStringValue = "'".implode("','", $a_Fields)."'";
      
      $con = Conexion::getConexion();
      $sql = "INSERT INTO mnu_user (".$sStringField.")
                            VALUES (".$sStringValue.");";
      //echo $sql;
  		$result   = $con->query($sql);
  		
      $iResultSave = $result;
      if($iResultSave){
        return true;
      }else{
        return false;
      }

    }else{
      return false;
    }
    
  }
  
  /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
  public function update() {
    
    if($this->getObjetoBean()->getUsuarioId()){
      $con = Conexion::getConexion();
      $a_Fields = array();
      
      if($this->getObjetoBean()->getUsuarioId()) : $a_Fields['user_id'] = ($this->getObjetoBean()->getUsuarioId()); endif;
      /*if($this->getObjetoBean()->getUsuarioNew()) {
        $a_Fields['user_id'] = ($this->getObjetoBean()->getUsuarioNew());
      }*/
      if($this->getObjetoBean()->getNombre()) : $a_Fields['user_name'] = ($this->getObjetoBean()->getNombre()); endif;
      if($this->getObjetoBean()->getContrasena()) : $a_Fields['user_password'] = ($this->getObjetoBean()->getContrasena()); endif;
      if($this->getObjetoBean()->getRolId()) : $a_Fields['role_id'] = ($this->getObjetoBean()->getRolId()); endif;
      if($this->getObjetoBean()->getPswdFechCambio()) : $a_Fields['pswd_chg_date'] = ($this->getObjetoBean()->getPswdFechCambio()); endif;
      if($this->getObjetoBean()->getPswdHoraCambio()) : $a_Fields['pswd_chg_time'] = ($this->getObjetoBean()->getPswdHoraCambio()); endif;
      if($this->getObjetoBean()->getPswdAciertos()) : $a_Fields['pswd_count'] = ($this->getObjetoBean()->getPswdAciertos()); endif;
      if($this->getObjetoBean()->getEnUso()) : $a_Fields['in_use'] = ($this->getObjetoBean()->getEnUso()); endif;
      if($this->getObjetoBean()->getEsDisabled()) : $a_Fields['is_disabled'] = ($this->getObjetoBean()->getEsDisabled()); endif;
      if($this->getObjetoBean()->getFechaInicioSesion()) : $a_Fields['logon_date'] = ($this->getObjetoBean()->getFechaInicioSesion()); endif;
      if($this->getObjetoBean()->getHoraInicioSesion()) : $a_Fields['logon_time'] = ($this->getObjetoBean()->getHoraInicioSesion()); endif;
      if($this->getObjetoBean()->getCodigoIdioma()) : $a_Fields['language_code'] = ($this->getObjetoBean()->getCodigoIdioma()); endif;
      if($this->getObjetoBean()->getFechaInicio()) : $a_Fields['start_date'] = ($this->getObjetoBean()->getFechaInicio()); endif;
      if($this->getObjetoBean()->getFechaFin()) : $a_Fields['end_date'] = ($this->getObjetoBean()->getFechaFin()); endif;
      if($this->getObjetoBean()->getDireccionIp()) : $a_Fields['ip_address'] = ($this->getObjetoBean()->getDireccionIp()); endif;
      if($this->getObjetoBean()->getCorreoElectronico()) : $a_Fields['email_addr'] = ($this->getObjetoBean()->getCorreoElectronico()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['created_date'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['created_user'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['revised_date'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['revised_user'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      
      $sString = arrayClass::implode_key_value(",", $a_Fields);
      
      $sql = "UPDATE mnu_user SET 
                    ".$sString."
              WHERE user_id = '".$this->getObjetoBean()->getUsuarioId()."'";
      //echo $sql;
      $result   = $con->query($sql);
      
      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

    }else{
      return false;
    }
    
  }
  
  /**
  * Elimina registro
  *
  * @return Boolean
  */
  public function delete(){
    
    $o_Usuario = new UsuarioBean();
      
      $con = Conexion::getConexion();
      
      if($this->getObjetoBean()->getUsuarioId()){
          $o_Usuario->setUsuarioId($this->getObjetoBean()->getUsuarioId());
      }
            
      $sql = "UPDATE mnu_user SET
                 user_elim = '1'
            WHERE 1 AND user_id = '".$this->getObjetoBean()->getUsuarioId()."' ";
      
      $result = $con->query($sql);
      echo $sql;
      $num_rows = $result->rowCount();
      
                  
      $iResultDelete = $num_rows;
      if($iResultDelete){
          return 1;
      }else{
          return false;
      }    
    
 
   
    
    /*
      $o_Usuario = new Usuario();
      
      if($this->getObjetoBean()->getTransfId()){
          $o_Usuario->setTransfId($this->getObjetoBean()->getTransfId());
      }
      $iResultDelete = $o_Usuario->delete();
      if($iResultDelete > 0){
          return true;
      }else{
          return false;
      }    
    */
  }

  /**
  * Selecciona un nuevo registro
  *
  * @return IdGenerado
  */
  public function select(){
      
    $where = $this->buildConsult();
    
    $tamPag           = $this->getObjetoBean()->tamPag;
    $pagina           = is_null($this->getObjetoBean()->page)?1:$this->getObjetoBean()->page;
    $numeroRegistros  = $this->selectNumRows();
    $limitInf         = ($pagina-1)*$tamPag;
    
    $where = $this->buildConsult();
    
    $orden = $this->buildOrderByField();
      
    $con = Conexion::getConexion();
		
		$sql = "SELECT * FROM mnu_user WHERE user_elim <> '1' ".$where." ".$orden." LIMIT ".$limitInf.",".$tamPag;
		
		//echo $sql;
		$result   = $con->query($sql);
		$num_rows = $result->rowCount();
		
    $a_tmp = array();
  
		if($num_rows>0){
			while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
        $a_tmp[] = $this->insertarObjetoBean($o_valor);
			}
		}
		
		
		
		return count($a_tmp)>0?$a_tmp:null;
      
  }
  
  /**
  * Retorna un objeto UsuarioBean
  *
  * @return Object
  */
  public function selectByPk(){
  
    //$o_Propel  = UsuarioPeer::retrieveByPK($this->getObjetoBean()->getUsuarioId());
    $con = Conexion::getConexion();
    $sql  = "SELECT * FROM mnu_user WHERE user_id = '".$this->getObjetoBean()->getUsuarioId()."'";
    $result = $con->query($sql);
    $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
    
    return $o_Propel?$this->insertarObjetoBean($o_Propel):null;
  
  }
  
  public function buildOrderByField(){
    $order_by = "";
    if($this->getObjetoBean()->sortCampos || $this->getObjetoBean()->sortCampos != ""){
      $a_valCampos = explode(";", $this->getObjetoBean()->sortCampos);
      $a_valtype   = explode(";", $this->getObjetoBean()->sortType);
      $order_by = " ORDER BY ";
      $a_order = array();
      foreach ($a_valCampos as $key => $val){
        $sTmpOrder = "";
        if(array_key_exists($val, self::$fieldNames)){
          $sTmpOrder .= self::$fieldNames[$val];
          switch ($a_valtype[$key]){
            case 1: $sTmpOrder .= " ASC"; break;
            case 2: $sTmpOrder .= " DESC"; break;
          }
          $a_order[] = $sTmpOrder;
        }
      }
      $order_by .= implode(", ", $a_order);
    }
    return $order_by;
  }
  
  /**
  * Reasigna valores retornados del propel a un objeto UsuarioBean
  *
  * @param Object $o_Propel
  * @return UsuarioBean
  */
  private function insertarObjetoBean($o_Propel){
    //user_id, user_name, user_password, role_id, pswd_chg_date, pswd_chg_time, pswd_count, in_use, is_disabled, logon_date, logon_time, language_code, start_date, end_date, ip_address, 
    //email_addr, created_date, created_user, revised_date, revised_user
    $o_UsuarioBean = new UsuarioBean();
    $o_UsuarioBean->setUsuarioId($o_Propel->user_id);
    $o_UsuarioBean->setNombre($o_Propel->user_name);
    $o_UsuarioBean->setContrasena($o_Propel->user_password);
    $o_UsuarioBean->setRolId($o_Propel->role_id);
    $o_UsuarioBean->setPswdFechCambio($o_Propel->pswd_chg_date);
    $o_UsuarioBean->setPswdHoraCambio($o_Propel->pswd_chg_time);
    $o_UsuarioBean->setPswdAciertos($o_Propel->pswd_count);
    $o_UsuarioBean->setEnUso($o_Propel->in_use);
    $o_UsuarioBean->setEsDisabled($o_Propel->is_disabled);
    $o_UsuarioBean->setFechaInicioSesion($o_Propel->logon_date);
    $o_UsuarioBean->setHoraInicioSesion($o_Propel->logon_time);
    $o_UsuarioBean->setCodigoIdioma($o_Propel->language_code);
    $o_UsuarioBean->setFechaInicio($o_Propel->start_date);
    $o_UsuarioBean->setFechaFin($o_Propel->end_date);
    $o_UsuarioBean->setDireccionIp($o_Propel->ip_address);
    $o_UsuarioBean->setCorreoElectronico($o_Propel->email_addr);
    $o_UsuarioBean->setFechaCreacion($o_Propel->created_date);
    $o_UsuarioBean->setUsuarioCreacion($o_Propel->created_user);
    $o_UsuarioBean->setFechaActualizacion($o_Propel->revised_date);
    $o_UsuarioBean->setUsuarioActualizacion($o_Propel->revised_user);
    
    return $o_UsuarioBean;    
    
  }
    
  
}