<?php
/**
 * Clase Base DP para BaseRhPensionPeriodoDP
 *
 * @package    
 * @subpackage BaseRhPensionPeriodoDP
 * @author     Willy
 * @version    SVN:: BaseRhPensionPeriodoDP.class.php,v 1.1 2015-01-25 15:09:55 william.taype Exp $
 */
abstract class BaseRhPensionPeriodoDP extends RhPensionPeriodoBN
{
  /* Nmero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof RhPensionPeriodoBN )
    {
      $o_RhPensionPeriodoBN = $bSetDefault;
      if($o_RhPensionPeriodoBN->getIdPeriodo()) : $this->setIdPeriodo($o_RhPensionPeriodoBN->getIdPeriodo()); endif;
      if($o_RhPensionPeriodoBN->getEstado()) : $this->setEstado($o_RhPensionPeriodoBN->getEstado()); endif;
    }
  }

  /* Obtiene el nmero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(IdPeriodo),(MAX(IdPeriodo)+1), 1) AS Maximo FROM rh_pension_periodo;";
      $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
      $result = $oLink->query($sql);
      $row = $result->fetch(PDO::FETCH_ASSOC);
      $this->setIdPeriodo($row["Maximo"]);

      if($this->getIdPeriodo()){
        $a_Fields = array();

        if($this->getIdPeriodo()) : $a_Fields['IdPeriodo'] = ($this->getIdPeriodo()); endif;
        if($this->getEstado()) : $a_Fields['Estado'] = ($this->getEstado()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO rh_pension_periodo (".$sStringField.") VALUES (".$sStringValue.");";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdPeriodo())
      {
        $a_Fields = array();

        if($this->getIdPeriodo()) : $a_Fields['IdPeriodo'] = ($this->getIdPeriodo()); endif;
        if($this->getEstado()) : $a_Fields['Estado'] = ($this->getEstado()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE rh_pension_periodo SET ".$sStringField." WHERE 1 AND IdPeriodo='".$this->getIdPeriodo()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdPeriodo())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM rh_pension_periodo WHERE 1 AND IdPeriodo='".$this->getIdPeriodo()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* Bsqueda del registro por la llave primaria */
  public static function selectByPK($vIdPeriodo)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IdPeriodo, Estado FROM rh_pension_periodo WHERE 1 AND IdPeriodo='".$vIdPeriodo."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con mtodos de acceso */
  private function insertObjectBN($o_propel){
    $o_RhPensionPeriodoDP = new RhPensionPeriodoDP();
    $o_RhPensionPeriodoDP->setIdPeriodo($o_propel->IdPeriodo);
    $o_RhPensionPeriodoDP->setEstado($o_propel->Estado);
    return $o_RhPensionPeriodoDP;
  }
}