<?php
/**
 * Clase ContSobranteFaltanteer para SobranteFaltante
 *
 * @package    IM
 * @subpackage SobranteFaltanteCT
 * @author     Willy
 * @version    SVN: $Id: SobranteFaltanteCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class SobranteFaltanteCT implements interfaceCT{
  /**
  * Funcin para Guardar el  SobranteFaltante
  *
  * @param $o_SobranteFaltanteBean, objeto bean de SobranteFaltante
  * @return booleam
  */
  public function guardar(&$o_SobranteFaltanteBean){ 
    
    $o_SobranteFaltanteDP = new SobranteFaltanteDP($o_SobranteFaltanteBean);
    return $o_SobranteFaltanteDP->save();
    
  }
  
  /**
  * Funcin para Modificar el  SobranteFaltante
  *
  * @param $o_SobranteFaltanteBean, objeto bean de SobranteFaltante
  * @return booleam
  */
  public function modificar(&$o_SobranteFaltanteBean){
    
    $o_SobranteFaltanteDP = new SobranteFaltanteDP($o_SobranteFaltanteBean);
    return $o_SobranteFaltanteDP->update();
    
  }
  
  /**
  * Funcin para Eliminar el  SobranteFaltante
  *
  * @param $o_SobranteFaltanteBean, objeto bean de SobranteFaltante
  * @return booleam
  */
  public function eliminar($o_SobranteFaltanteBean){ 
    $o_SobranteFaltanteDP = new SobranteFaltanteDP($o_SobranteFaltanteBean);
    return $o_SobranteFaltanteDP->delete();
  }
  
  
  public function totalRegistros($o_SobranteFaltanteBean){
    $o_SobranteFaltanteBeanDP = new SobranteFaltanteDP($o_SobranteFaltanteBean);
    return $o_SobranteFaltanteBeanDP->selectNumRows();
    
  }
  
  public function totalMonto($o_SobranteFaltanteBean){
    $o_SobranteFaltanteBeanDP = new SobranteFaltanteDP($o_SobranteFaltanteBean);
    return $o_SobranteFaltanteBeanDP->selectTotalMonto();
    
  }
  
  /**
  * Funcin para Seleccionar el  SobranteFaltante
  *
  * @param $o_SobranteFaltanteBeans, objeto bean de SobranteFaltante
  * @return booleam
  */
  public function seleccionar($o_SobranteFaltanteBean){
  
    $o_SobranteFaltanteDP = new SobranteFaltanteDP($o_SobranteFaltanteBean);
    if($o_SobranteFaltanteBean->getIdSofa()){
      return $o_SobranteFaltanteDP->selectByPk();
    }else{
      return $o_SobranteFaltanteDP->select();
    }
      
  }
  
}