<?php
/**
 * Clase DP para CrPlanillaDP
 *
 * @package    
 * @subpackage CrPlanillaDP
 * @author     Willy
 * @version    SVN:: CrPlanillaDP.class.php,v 1.1 2014-03-11 18:51:03 william.taype Exp $
 */
class CrPlanillaDP extends BaseCrPlanillaDP
{
	private $diasLaborables	= 30;
	private $sueldoBasico	= 930 ;
	
	public function getPlanilla($a_con_ingresos,$a_con_descuentos,$a_con_aportes,$a_con_otros,$a_con_header){
		
		
		if($this->getIdColaborador() == "67"){
			 "entro";
		}
		//reset($a_con_ingresos);
		foreach ($a_con_ingresos as $key =>$o_con_ingresos){
			switch($o_con_ingresos->getCodigo()){
				case "[REMUN]": $monto =$this->getRemuneracion();break;
				case "[BIAT]": $monto =$this->getBiaticos();break;
				case "[RBASICA]": $monto =$this->getRemuneracionBasica();break;
				case "[ASIG_FAM]": $monto = $this->getAsignacionFamiliar($this->getIdColaborador());break;
				case "[BONO]": $monto = $this->getBono($this->getIdColaborador());break;
				//Para lectura
				case "[VACACION]": $monto = $this->getPlanillaTemporal($o_con_ingresos->getIdConcepto());break;
			}
			$a_conceptos_valor[$o_con_ingresos->getCodigo()] = $monto;
		}	
		$this->setConceptosValor($a_conceptos_valor);
		//reset($a_con_descuentos);
		foreach ($a_con_descuentos as $key =>$o_con_descuentos){
			$monto = '0.00';
			switch($o_con_descuentos->getCodigo()){
				case "[ADEL]": $monto = $this->getAdelanto($this->getIdColaborador());break;
				case "[FALT]": $monto = $this->getFalta($this->getIdColaborador());break;
				case "[FALTANTES]": $monto = $this->getFaltantes($this->getIdColaborador());break;
				
				case "[TARD]": $monto = $this->getTardanza($this->getIdColaborador());break;
				case "[COMRPM]": $monto = $this->getRpm($this->getIdColaborador());break;
				case "[T.AFP]": $monto = $this->getTotalAFP();break;
				case "[T.ONP]": $monto = $this->getONP();break;
				
				
				case "[T.AFP_COM]": $monto =$this->getAFPComision();break;
				case "[T.AFP_SEG]": $monto =$this->getAFPSeguro();break;
				case "[T.AFP_PEN]": $monto = $this->getAFPPension();break;
				
				case "[PRESTAMO]": $monto = $this->getPlanillaTemporal($o_con_descuentos->getIdConcepto());break;
				
			}
			$a_conceptos_valor[$o_con_descuentos->getCodigo()] = $monto;
		}
		$this->setConceptosValor($a_conceptos_valor);
		//reset($a_con_descuentos);
		foreach ($a_con_aportes as $key =>$o_con_aportes){
			switch($o_con_aportes->getCodigo()){
				case "[ESSALUD]": $monto = $this->getEssalud($this->getIdColaborador());break;
				case "[SIS]": $monto = $this->getSis($this->getIdColaborador());break;
			}
			$a_conceptos_valor[$o_con_aportes->getCodigo()] = $monto;
		}
		$this->setConceptosValor($a_conceptos_valor);
		//reset($a_con_descuentos);
		foreach ($a_con_otros as $key =>$o_con_otros){
			switch($o_con_otros->getCodigo()){
				case "[NRO_TARD]": $valor = $this->getNTardanza($this->getIdColaborador());break;
				case "[NRO_FALT]": $valor = $this->getNFalta($this->getIdColaborador());break;
			}
			$a_conceptos_valor[$o_con_otros->getCodigo()] = $valor;
		}
		$this->setConceptosValor($a_conceptos_valor);
		foreach ($a_con_header as $key =>$o_con_header){
			switch($o_con_header->getCodigo()){
				case "[N.COMPANIA]"	: $valor = $this->getNCompania($this->getIdColaborador());break;
				case "[N.RUC]"		: $valor = $this->getNRUC($this->getIdColaborador());break;
				case "[AFP_NOMBRE]"		: $valor = $this->getNombreAFP($this->getIdColaborador());break;
				case "[DNI_COL]"		: $valor = $this->getDNI($this->getIdColaborador());break;
				case "[FECHAING_COL]"	: $valor = $this->getFechaIngreso($this->getIdColaborador());break;
				case "[PEN_TIPO]"	: $valor = $this->getPensionTipo($this->getIdColaborador());break;
				case "[PEN_NUMERO]"	: $valor = $this->getNumeroPension($this->getIdColaborador());break;
				case "[SEG_NUMERO]"	: $valor = $this->getNumeroSeguro($this->getIdColaborador());break;
				case "[SEG_TIPO]"	: $valor = $this->getSeguroTipo($this->getIdColaborador());break;
			}
			$a_conceptos_valor[$o_con_header->getCodigo()] = $valor;
		}
		$this->setConceptosValor($a_conceptos_valor);
		return $a_conceptos_valor;
	}
	
	public function getAFPComision(){
		$a_por = $this->getPorcentajesAFP();
		$totalIngresos = $this->getTotalIngresos();
		$montoComision =  round($a_por['comision'] * $totalIngresos,2);
		return $montoComision;
		
	}
	
	public function getAFPSeguro(){
		$a_por = $this->getPorcentajesAFP();
		$totalIngresos = $this->getTotalIngresos();
		if($a_por['Tipo'] == "flujo"){	
			if($totalIngresos >= $a_por['RMA']){
				$montoSeguro =  $a_por['seguro'] * $a_por['RMA'];
			}else{
				$montoSeguro =  $a_por['seguro'] * $totalIngresos;
			}
		}else{
			$montoSeguro =  round($a_por['seguro'] * $totalIngresos,2);	
		}
		return $montoSeguro;
	}
	
	public function getAFPPension(){
		$a_por = $this->getPorcentajesAFP();
		$totalIngresos = $this->getTotalIngresos();
		$montoPension =  round($a_por['pension'] * $totalIngresos,2);
		return $montoPension;
	}
	
	public function getPlanillaTemporal($concepto){
		if($this->getPeriodo()){ $where .= " AND Periodo = '".$this->getPeriodo()."'"; }
		if($this->getIdColaborador()){ $where .= " AND idColaborador = '".$this->getIdColaborador()."'"; }
		if($concepto){ $where .= " AND IdConcepto = '".$concepto."'"; }
	      
		$con = Conexion::getConexion();
		$sql = "SELECT Valor FROM cr_planilla_temp WHERE 1 ".$where." ";
		//echo $sql;
		$result = $con->query($sql);
		$num_rows = $result->rowCount();
		$a_tmp = array();
		if($num_rows>0){
		while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
		  return $o_valor->Valor;
		}
		}
	}
		
	public function getRemuneracion(){
			
	      if($this->getIdColaborador()){ $where .= " AND idcolaborador = '".$this->getIdColaborador()."'"; }
	      
	      $con = Conexion::getConexion();
	      $sql = "SELECT Sueldo FROM cr_colaborador WHERE 1 ".$where." ";
	      //echo $sql;
	       $result = $con->query($sql);
	      $num_rows = $result->rowCount();
	      $a_tmp = array();
	      if($num_rows>0){
	        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
	          return $o_valor->Sueldo;
	        }
	      }
	}
	
	public function getRemuneracionMovilidad(){
			
	      if($this->getIdColaborador()){ $where .= " AND idcolaborador = '".$this->getIdColaborador()."'"; }
	      
	      $con = Conexion::getConexion();
	      $sql = "SELECT SueldoMovilidad FROM cr_colaborador WHERE 1 ".$where." ";
	      //echo $sql;
	       $result = $con->query($sql);
	      $num_rows = $result->rowCount();
	      $a_tmp = array();
	      if($num_rows>0){
	        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
	          return $o_valor->SueldoMovilidad;
	        }
	      }
	}
	public function getEssalud(){
			
		
	      if($this->getIdColaborador()){ $where .= " AND idcolaborador = '".$this->getIdColaborador()."'"; }
	      
	      $con = Conexion::getConexion();
	      $sql = "SELECT TipoSeguro FROM cr_colaborador WHERE 1 ".$where." AND TipoSeguro = 'ESSALUD' ";
	      //if($this->getIdColaborador() == 39)    echo $sql;
	       $result = $con->query($sql);
	      $num_rows = $result->rowCount();
	      $a_tmp = array();
	      if($num_rows>0){
	      	$remuneracionBasica = $this->getConceptoPlanilla('[RBASICA]');
	      	//if($this->getIdColaborador() == 39)  echo $parametro_essalud."##";
	      	
	      	$parametro_essalud = $this->getParametroPlanilla('[P_ESSALUD]');
	      	//--view
	      	return round($remuneracionBasica*$parametro_essalud,2);
	      }
	}
	
	public function getSis(){
			
	      if($this->getIdColaborador()){ $where .= " AND idcolaborador = '".$this->getIdColaborador()."'"; }
	      
	      $con = Conexion::getConexion();
	      $sql = "SELECT TipoSeguro FROM cr_colaborador WHERE 1 ".$where." AND TipoSeguro = 'SIS' ";
	      //echo $sql;
	       $result = $con->query($sql);
	      $num_rows = $result->rowCount();
	      $a_tmp = array();
	            
	      if($num_rows>0){
	      	$remuneracionBasica = $this->getConceptoPlanilla('[RBASICA]');
	      	$parametro_sis = $this->getParametroPlanilla('[P_SIS]');
	        return round($remuneracionBasica*$parametro_sis,2);
	      }
	}
	
	public function getParametroPlanilla($codigo){
		
		$con = Conexion::getConexion();
	    $sql = "SELECT Formula FROM cr_planilla_concepto WHERE 1 ".$where." AND Codigo = '".$codigo."' and Tipo = 'P'";
	    
	   $result = $con->query($sql);
	      $num_rows = $result->rowCount();
	    
	      if($num_rows>0){
	        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
	          return $o_valor->Formula;
	        }
	      }
	}
	
	public function getConceptoPlanilla($codigo){
		
		$con = Conexion::getConexion();
	    $sql = "SELECT Formula FROM cr_planilla_concepto WHERE 1 ".$where." AND Codigo = '".$codigo."' and Tipo = 'CAL'";
	    
	 $result = $con->query($sql);
	      $num_rows = $result->rowCount();
	    
	      if($num_rows>0){
	        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
	          return $o_valor->Formula;
	        }
	      }
	}
	
	public function getBiaticos(){
			
	      $remuneracion = $this->getRemuneracion();
	      $remuneracionBasica = $this->getRemuneracionBasicaMovilidadPre();
	      //if($remuneracionBasica > $this->sueldoBasico)
	      	//$Biatico = $remuneracionBasica-$this->sueldoBasico;
	      //else
	      	//$Biatico = 0;
	      return $remuneracionBasica;
	}
	
	public function getRemuneracionBasicaMovilidadPre(){
	    $diaslaborables = $this->getDiasLaborables();  
	    $remuneracionMovilidad 	= $this->getRemuneracionMovilidad();
	    if($this->getIdColaborador()){
	    	//echo "---";
	    }
		return ($remuneracionMovilidad/$this->diasLaborables)*$diaslaborables;
	}
	
	public function getRemuneracionBasicaPre(){
	    $diaslaborables = $this->getDiasLaborables();  
	    $remuneracion 	= $this->getRemuneracionBasica();
	    if($this->getIdColaborador()){
	    	//echo "---";
	    }
		return ($remuneracion/$this->diasLaborables)*$diaslaborables;
	}
	
	public function getRemuneracionBasica(){
	    $remuneracion 	= $this->getRemuneracion();
		return $remuneracion;
	}
	
	public function getDiasLaborables(){
		$diasLaborables = $this->diasLaborables;
		if($this->getIdColaborador()){ $where .= " AND idcolaborador = '".$this->getIdColaborador()."'"; }
	    if($this->getPeriodo()){ $where .= " AND FechaIngreso like '".$this->getPeriodo()."%'"; }  
      	$con = Conexion::getConexion();
      	$sql = "SELECT FechaIngreso as FechaIngreso FROM cr_colaborador WHERE 1 ".$where." ";
		$result = $con->query($sql);
		  $num_rows = $result->rowCount();
		  $a_tmp = array();
		  if($num_rows>0){
		    while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
		      $FechaIngreso = $o_valor->FechaIngreso;
		      $diaIngreso = substr($FechaIngreso,8,2);
		      if($diaIngreso >$diasLaborables ) $diasLaborables = 1;
		      else $diasLaborables = $diasLaborables - $diaIngreso;
		    }
		  } 
		return $diasLaborables;
	}
	
	public function getRpm(){
			
	      if($this->getIdColaborador()){ $where .= " AND idcolaborador = '".$this->getIdColaborador()."'"; }
	      
	      $con = Conexion::getConexion();
	      $sql = "SELECT PagoRpm as RPM FROM cr_colaborador WHERE 1 ".$where." ";
	      //echo $sql;
	       $result = $con->query($sql);
	      $num_rows = $result->rowCount();
	      $a_tmp = array();
	      if($num_rows>0){
	        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
	          return $o_valor->RPM;
	        }
	      }
	}
	
	public function getAdelanto(){
		
		if($this->getIdColaborador()){ $where .= " AND idcolaborador = '".$this->getIdColaborador()."'"; }
		if($this->getPeriodo()){ $where .= " AND FechaAdelanto like '".$this->getPeriodo()."%'"; }
		$where .= " AND Eliminado = '0'"; 
		
		$con = Conexion::getConexion();
		$sql = "SELECT SUM(Monto) Monto FROM cr_adelanto_sueldo WHERE 1 ".$where." ";
		//echo $sql;
		$result = $con->query($sql);
		$num_rows = $result->rowCount();
		$a_tmp = array();
		if($num_rows>0){
			while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
			  return $o_valor->Monto;
			}
		}else{
			return "0.00";
		}
	}
	
	public function getDataSucursal($campo,$default){
		$where .= " AND idcolaborador = '".$this->getIdColaborador()."'";
		
		
		$con = Conexion::getConexion();
		$sql = "SELECT idcolaborador,idPadre,IdRol FROM cr_colaborador WHERE 1 $where  ";
		//echo $sql;
		$result = $con->query($sql);
		$num_rows = $result->rowCount();
		$a_tmp = array();
		if($num_rows>0){
			while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
			   if($o_valor->IdRol=='sys.ope'){
			   	$idAdministrador = $o_valor->idPadre;
			   }elseif($o_valor->IdRol=='sys.res'){
			   	$idAdministrador = $o_valor->idcolaborador;
			   }elseif($o_valor->IdRol=='sys.sup'){
			   	$idAdministrador = $o_valor->idPadre;
			   }else{
			   	$idAdministrador = "xx";	
			   }
			}
			if($idAdministrador <> "xx"){
				
				$wheres = " AND idAdministrador = '".$idAdministrador."'";
				$sql = "SELECT $campo FROM cr_sucursal WHERE 1 $wheres  ";
				
				$result2 = $con->query($sql);
				$num_rows2 = $result2->rowCount();
				$a_tmp = array();
				if($num_rows2 > 0){
					while ($o_valor2 = $result2->fetch(PDO::FETCH_OBJ)) {
						return $o_valor2->{$campo};
					}
				}else{
					return "-";
				}
				
			}else{
				return $default;
			}
		}else{
			return "-";
		}
	}
	
	public function getDataColaborador($campo,$default){
		$where .= " AND idcolaborador = '".$this->getIdColaborador()."'";
		
		
		$con = Conexion::getConexion();
		$sql = "SELECT $campo FROM cr_colaborador WHERE 1 $where  ";
		//echo $sql;
		$result = $con->query($sql);
		$num_rows = $result->rowCount();
		$a_tmp = array();
		if($num_rows>0){
			while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
			   return $o_valor->{$campo};
			}
		}
		return $default;
	}
	
	public function getNcompania(){
		
		return $this->getDataSucursal("RazonSocial","Creditos Santa Rosa");
			
	}
	
	public function getNumeroSeguro(){
		
		return $this->getDataColaborador("NumeroSeguro","-");
			
	}
	
	public function getSeguroTipo(){
		
		return $this->getDataColaborador("TipoSeguro","-");
			
	}
	
	public function getPensionTipo(){
		
		return $this->getDataColaborador("TipoPension","Pension");
			
	}
	
	public function getNumeroPension(){
		
		return $this->getDataColaborador("NumeroPension","Pension");
			
	}
	
	public function getNRUC(){
		
		return $this->getDataSucursal("Ruc","99999999999");
			
	}
	
	public function getNombreAFP(){
		
		return $this->getDataColaborador("NombrePension","-");
			
	}
	
	public function getDNI(){
		
		return $this->getDataColaborador("Dni","-");
			
	}
	
	public function getFechaIngreso(){
		
		return $this->getDataColaborador("FechaIngreso","-");
			
	}
	
	public function getNFalta(){
		
		if($this->getIdColaborador()){ $where .= " AND idcolaborador = '".$this->getIdColaborador()."'"; }
		if($this->getPeriodo()){ $where .= " AND Fecha like '".$this->getPeriodo()."%'"; }
		$where .= " AND TipoAsistencia = 'F'";
		$where .= " AND Eliminado = '-1'";
		
		$con = Conexion::getConexion();
		$sql = "SELECT Monto FROM cr_asistencia WHERE 1 ".$where." ";
		//echo $sql;
		$result = $con->query($sql);
		$num_rows = $result->rowCount();
		$a_tmp = array();
		return $num_rows;
			
	}
	
	public function getFalta(){
		
		if($this->getIdColaborador()){ $where .= " AND idcolaborador = '".$this->getIdColaborador()."'"; }
		if($this->getPeriodo()){ $where .= " AND Fecha like '".$this->getPeriodo()."%'"; }
		$where .= " AND TipoAsistencia = 'F'";
		$where .= " AND Eliminado = '-1'";
		
		$con = Conexion::getConexion();
		$sql = "SELECT SUM(Monto) Monto FROM cr_asistencia WHERE 1 ".$where." ";
		
		$result = $con->query($sql);
		$num_rows = $result->rowCount();
		$a_tmp = array();
		if($num_rows>0){
			while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
			  return $o_valor->Monto;
			}
		}else{
			return "0.00";
		}
	}
	
	public function getFaltantes(){
		
		
		if($this->getIdColaborador()){ $where .= " AND idcolaborador = '".$this->getIdColaborador()."'"; }
		if($this->getPeriodo()){ $where .= " AND FechaSofa like '".$this->getPeriodo()."%'"; }
		
		$where .= " AND Eliminado = '0'";
		
		$con = Conexion::getConexion();
		$sql = "SELECT TipoSofa,SUM(Monto) Monto FROM  cr_sobrante_faltante WHERE 1 ".$where." group by TipoSofa";
		//if($this->getIdColaborador() == 44) echo $sql;
		$result = $con->query($sql);
		$num_rows = $result->rowCount();
		$a_tmp = array();
		if($num_rows>0){
			while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
			  if($o_valor->TipoSofa == 'f') $MontoFaltante= $o_valor->Monto;
			  if($o_valor->TipoSofa == 's') $MontoSobrante= $o_valor->Monto;
			}
			if($MontoFaltante > $MontoSobrante){
				return round($MontoFaltante - $MontoSobrante,2);
			}
		}else{
			return "0.00";
		}
	}
	
	public function getTotalPorcentaje($idPension,$Periodo,$TipoPension){
		$con = Conexion::getConexion();
		
		$sql = "SELECT ComisionFlujo,ComisionMixtaFlujo,ComisionMixtaASaldo,Seguro,PorcentajeAporteObligatorio,RMA 
				FROM rh_pension_devengue  WHERE 1 ".$where." 
				and IdPension = '".$idPension."' 
				and IdPeriodo = '".str_replace("-","",$Periodo)."' 
				";
		//echo $sql;
		$result = $con->query($sql);
		$num_rows = $result->rowCount();
		$a_tmp = array();
		if($num_rows>0){
			while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
				$ComisionFlujo = $o_valor->ComisionFlujo;
				$ComisionMixtaFlujo = $o_valor->ComisionMixtaFlujo;
				$ComisionMixtaASaldo = $o_valor->ComisionMixtaASaldo;
				$Seguro = $o_valor->Seguro;
				$PorcentajeAporteObligatorio = $o_valor->PorcentajeAporteObligatorio;
				$RMA = $o_valor->RMA;
			}
		}
		 
		
		if($TipoPension == "flujo"){
			$a_por['comision'] = round(($ComisionFlujo)/100,4);
			$a_por['seguro'] = round($Seguro/100,4);
			$a_por['pension'] = round($PorcentajeAporteObligatorio/100,4);
			$a_por['RMA'] = $RMA;
			$a_por['Tipo'] = "flujo";
		}
		if($TipoPension == "mixto"){
			$a_por['comision'] = round($ComisionMixtaFlujo/100,4);
			$a_por['seguro'] = round($Seguro/100,4);
			$a_por['pension'] = round($PorcentajeAporteObligatorio/100,4);
			$a_por['Tipo'] = "mixto";
		}
				
		return $a_por;
	}
	
	public function getTotalPorcentajeONP($idPension,$Periodo){
		$con = Conexion::getConexion();
		
		$sql = "SELECT ComisionFlujo,ComisionMixtaFlujo,ComisionMixtaASaldo,Seguro,PorcentajeAporteObligatorio,RMA 
				FROM rh_pension_devengue  WHERE 1 ".$where." 
				and IdPension = '".$idPension."' 
				and IdPeriodo = '".str_replace("-","",$Periodo)."' 
				and Seguro = 0
				";
		
		$result = $con->query($sql);
		$num_rows = $result->rowCount();
		$a_tmp = array();
		if($num_rows>0){
			while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
				$PorcentajeAporteObligatorio = $o_valor->PorcentajeAporteObligatorio/100;
			}
		}
		 
		return $PorcentajeAporteObligatorio;
	}
	
	public function getTotalAFP(){
		$con = Conexion::getConexion();
		//Determinar si es mixto
		if($this->getIdColaborador()){ $where .= " AND idcolaborador = '".$this->getIdColaborador()."'"; }
		$con = Conexion::getConexion();
		$sql = "SELECT Pension,TipoPension FROM cr_colaborador WHERE 1 ".$where."";
		//echo $sql;
		$result = $con->query($sql);
		$num_rows = $result->rowCount();
		$a_tmp = array();
		if($num_rows>0){
			while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
			  $Pension = $o_valor->Pension;
			  $TipoPension = $o_valor->TipoPension;
			  
			  if($TipoPension){
			  	if($TipoPension == "nada") return 0;
			  		
			  	$a_porcentajes = $this->getTotalPorcentaje($Pension,$this->getPeriodo(),$TipoPension);
			  	$this->setPorcentajesAFP($a_porcentajes);
			  	
			  }
			}
		}
				
		if($this->getIdColaborador()==5){
			echo "entro";
			print_r($a_porcentajes);
			echo "C:".$this->getAFPComision()."S:".$this->getAFPSeguro()."P:".$this->getAFPPension();
		}
		return ($this->getAFPComision()+$this->getAFPSeguro()+$this->getAFPPension());
		
	}
	
	public function getONP(){
		$con = Conexion::getConexion();
		//Determinar si es mixto
		if($this->getIdColaborador()){ $where .= " AND idcolaborador = '".$this->getIdColaborador()."'"; }
		$con = Conexion::getConexion();
		$sql = "SELECT Pension,TipoPension FROM cr_colaborador WHERE 1 ".$where."";
		//echo $sql;
		$result = $con->query($sql);
		$num_rows = $result->rowCount();
		$a_tmp = array();
		if($num_rows>0){
			while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
			  $Pension = $o_valor->Pension;
			  $TipoPension = $o_valor->TipoPension;
			  
			  if($TipoPension){
			  	if($TipoPension == "nada") return 0;
			  		
			  	$porcentajeONP = $this->getTotalPorcentajeONP($Pension,$this->getPeriodo());
			  	$totalIngresos = $this->getTotalIngresos();
			  	
			  }
			}
		}
				
		
		return ($totalIngresos*$porcentajeONP);
		
	}
	
	public function getTotalIngresos(){
		$a_conceptos 	= $this->getConceptosValor();
		$ASIG_FAM 			= $a_conceptos['[ASIG_FAM]'];
		//$REMUN 			= $a_conceptos['[REMUN]'];
		//$BIAT 			= $a_conceptos['[BIAT]'];
		$RBASICA 		= $a_conceptos['[RBASICA]'];
		
		//$BONO 			= $a_conceptos['[BONO]'];
		
		$totalIngresos = $REMUN + $BIAT + $RBASICA + $BONO + $ASIG_FAM;
		if($this->getIdColaborador()==19){
			//echo "entro 2<br>";
			
			//echo $totalIngresos;
		}
		return $totalIngresos;
	}
	
	public function getBono(){
		
		return $this->getDataColaborador("Bono","-");
	}
	
		
	public function getAsignacionFamiliar(){
		
		if($this->getIdColaborador()){ $where .= " AND idcolaborador = '".$this->getIdColaborador()."'"; }
		
		
		$con = Conexion::getConexion();
		$sql = "SELECT AsignacionFamiliar FROM cr_colaborador WHERE 1 ".$where." and AsignacionFamiliar > 0 ";
		//echo $sql;
		$result = $con->query($sql);
		$num_rows = $result->rowCount();
		$a_tmp = array();
		if($num_rows>0){
			while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
			  $AsignacionFamiliar = $o_valor->AsignacionFamiliar;
			  if($AsignacionFamiliar){
			  	$remuneracionMV = $this->getParametroPlanilla('[P_RMV]');
	      	   	$porcentajeAsignado = $this->getParametroPlanilla('[P_PORC_ASIG_FAM]');
	      	   	return ($porcentajeAsignado*$remuneracionMV);
			  }
			}
		}else{
			return "0.00";
		}
		
	}
	
	public function getNTardanza(){
		if($this->getIdColaborador()){ $where .= " AND idcolaborador = '".$this->getIdColaborador()."'"; }
		if($this->getPeriodo()){ $where .= " AND Fecha like '".$this->getPeriodo()."%'"; }
		$where .= " AND TipoAsistencia = 'T'";
		$where .= " AND Eliminado = '-1'";
		
		$con = Conexion::getConexion();
		$sql = "SELECT Monto FROM cr_asistencia WHERE 1 ".$where." ";
		//echo $sql;
		$result = $con->query($sql);
		$num_rows = $result->rowCount();
		$a_tmp = array();
		return $num_rows;
	}
	
	public function getTardanza(){
		if($this->getIdColaborador()){ $where .= " AND idcolaborador = '".$this->getIdColaborador()."'"; }
		if($this->getPeriodo()){ $where .= " AND Fecha like '".$this->getPeriodo()."%'"; }
		$where .= " AND TipoAsistencia = 'T'";
		$where .= " AND Eliminado = '-1'";
		
		$con = Conexion::getConexion();
		$sql = "SELECT SUM(Monto) Monto FROM cr_asistencia WHERE 1 ".$where." ";
		$result = $con->query($sql);
		$num_rows = $result->rowCount();
		$a_tmp = array();
		if($num_rows>0){
			while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
			  return $o_valor->Monto;
			}
		}else{
			return "0.00";
		}
	}
	
	public function buildConsultPlanilla(){
		
		//if($this->getPeriodo()){ $where .= " AND periodo = '".$this->getPeriodo()."'"; }
      	
		return $where;
	}
	
	
}