<?php
/**
 * Clase DP para CrPlanillaConceptoPerDP
 *
 * @package    
 * @subpackage CrPlanillaConceptoPerDP
 * @author     Willy
 * @version    SVN:: CrPlanillaConceptoPerDP.class.php,v 1.1 2014-03-16 10:05:44 william.taype Exp $
 */
class CrPlanillaConceptoPerDP extends BaseCrPlanillaConceptoPerDP
{
	 public function saveCP()
  {
    try
    {
      $con = Conexion::getConexion();
     
      $oLink = method_exists($con, 'getResource')?$con->getResource():$con;

      if($this->getPeriodo()){
      	
       //Guarda backup de los conceptos para el periodo
	   
        $sql = "
        		INSERT INTO cr_planilla_concepto_per 
        		(Periodo,IdConcepto,Codigo,Tipo,Ubicacion,VisualizarPlanilla,PosicionPlanilla,Descripcion,DescripcionPlanilla,DescripcionBoleta,Estado,Formula,FechaCreacion,UsuarioCreacion)
        		SELECT '".$this->getPeriodo()."',IdConcepto,Codigo,Tipo,Ubicacion,VisualizarPlanilla,PosicionPlanilla,Descripcion,DescripcionPlanilla,DescripcionBoleta,Estado,Formula,FechaCreacion,UsuarioCreacion
        		FROM  cr_planilla_concepto";
        
        
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
		
        $sql = "
        		INSERT INTO cr_sucursal_per 
        		(Periodo,IdSucursal,Descripcion,Direccion,Telefono,Eliminado,fechaInicioBalance,Estado,FechaModificacion,UsuarioModificacion,FechaCreacion,UsuarioCreacion,IdAdministrador,SaldoDisponibleIni,FechaSaldoIni,FechaEliminado,UsuarioEliminado)
        		SELECT '".$this->getPeriodo()."',IdSucursal,Descripcion,Direccion,Telefono,Eliminado,fechaInicioBalance,Estado,FechaModificacion,UsuarioModificacion,FechaCreacion,UsuarioCreacion,IdAdministrador,SaldoDisponibleIni,FechaSaldoIni,FechaEliminado,UsuarioEliminado
        		FROM  cr_sucursal";
               
        $result = $oLink->query($sql);
        
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
        
	   
        $sql = "
        		INSERT INTO cr_colaborador_per 
        		(Periodo,IdColaborador,IdPadre,IdTipoColaborador,dni,Nombres,ApellidoPaterno,ApellidoMaterno,FechaNacimiento,Sueldo,Direccion,Telefono,Celular,Email,Estado,Eliminado,Sexo,EstadoCivil,IdRol,Usuario,NumeroHijos,GradoInstruccion,FechaIngreso,UsuarioEliminado,FechaEliminado,FechaCreacion,UsuarioCreacion,PagoRpm,TipoSeguro,NumeroSeguro,Pension,TipoPension,NombrePension,Bono,AsignacionFamiliar,HoraIngreso,MinutoIngreso)
        		SELECT '".$this->getPeriodo()."',IdColaborador,IdPadre,IdTipoColaborador,dni,Nombres,ApellidoPaterno,ApellidoMaterno,FechaNacimiento,Sueldo,Direccion,Telefono,Celular,Email,Estado,Eliminado,Sexo,EstadoCivil,IdRol,Usuario,NumeroHijos,GradoInstruccion,FechaIngreso,UsuarioEliminado,FechaEliminado,FechaCreacion,UsuarioCreacion,PagoRpm,TipoSeguro,NumeroSeguro,Pension,TipoPension,NombrePension,Bono,AsignacionFamiliar,HoraIngreso,MinutoIngreso
        		FROM  cr_colaborador";
        
        
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
        
        //Cierra el devengue para ese Periodo
        $sql = "
        		UPDATE rh_pension_periodo
        		SET Estado = 'C'
        		where IdPeriodo = '".str_replace("-","",$this->getPeriodo())."'"
        		;
        
        
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
        
        $anio = substr($this->getPeriodo(),0,4);
        $mes = substr($this->getPeriodo(),5,2);
        if($mes == "12"){
        	$anio = $anio + 1;
        	$mes  = "01";
        }else{
        	$mes = $mes + 1;
        	$mes = str_pad($mes, 2, "0", STR_PAD_LEFT);
        }
        $idPeriodoS = $anio."-".$mes;
         //Cierra el devengue para ese Periodo
     		
        $sql = "
        		REPLACE INTO rh_pension_periodo (IdPeriodo)
        		values('".str_replace("-","",$idPeriodoS)."')"
        		;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
        
        $sql = "
        		REPLACE INTO rh_pension_devengue 
        		(IdPeriodo,IdPension,ComisionFija,ComisionFlujo,ComisionMixtaFlujo,ComisionMixtaASaldo,Seguro,PorcentajeAporteObligatorio,RMA,FechaRegistro,UsuarioRegistro)
        		SELECT '".str_replace("-","",$idPeriodoS)."',IdPension,ComisionFija,ComisionFlujo,ComisionMixtaFlujo,ComisionMixtaASaldo,Seguro,PorcentajeAporteObligatorio,RMA,'".date('Y-m-d H:i:s')."',UsuarioRegistro
        		FROM  rh_pension_devengue
        		where IdPeriodo = '".str_replace("-","",$this->getPeriodo())."'
        		";
        
        
        
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }
}