<?php
/**
 * Clase Base FN para BaseCrPlanillaConceptoFN
 *
 * @package    
 * @subpackage BaseCrPlanillaConceptoFN
 * @author     Willy
 * @version    SVN:: BaseCrPlanillaConceptoFN.class.php,v 1.1 2014-03-12 10:44:57 william.taype Exp $
 */
class BaseCrPlanillaConceptoFN extends CrPlanillaConceptoBN
{
  private static $fieldNames = array (
    'IdConcepto'=>'IdConcepto', 'Codigo'=>'Codigo', 'Tipo'=>'Tipo', 'Ubicacion'=>'Ubicacion', 'PosicionPlanilla'=>'PosicionPlanilla', 'Descripcion'=>'Descripcion', 'DescripcionPlanilla'=>'DescripcionPlanilla', 'DescripcionBoleta'=>'DescripcionBoleta', 'Estado'=>'Estado', 'Formula'=>'Formula', 'FechaCreacion'=>'FechaCreacion', 'UsuarioCreacion'=>'UsuarioCreacion', 'VisualizarPlanilla'=>'VisualizarPlanilla'  
  );

  public function select()
  {
    try
    {
      $tamPag = !property_exists($this, 'tamPag')?9999:$this->tamPag;
      $pagina = !property_exists($this, 'page')||$this->page==""?1:$this->page;
      $numeroRegistros = $this->selectNumRows();
      $limitInf = ($pagina-1)*$tamPag;

      $where = $this->buildConsult();
      $orden = $this->buildOrderByField();

      $con = Conexion::getConexion();
      $sql = "SELECT IdConcepto, Codigo, Tipo,TipoDato, Ubicacion, PosicionPlanilla, Descripcion, DescripcionPlanilla, DescripcionBoleta,Editable, Estado, Formula, FechaCreacion, UsuarioCreacion, VisualizarPlanilla FROM cr_planilla_concepto WHERE 1 ".$where." ".$orden."  LIMIT ".$limitInf.",".$tamPag;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      $a_tmp = array();
      if($num_rows>0){
        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
          $a_tmp[] = $this->insertObjectBN($o_valor);
        }
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function selectNumRows()
  {
    try
    {
      $where = $this->buildConsult();

      $con = Conexion::getConexion();
      $sql = "SELECT IdConcepto, Codigo, Tipo, TipoDato, Ubicacion, PosicionPlanilla, Descripcion, DescripcionPlanilla, DescripcionBoleta,Editable, Estado, Formula, FechaCreacion, UsuarioCreacion, VisualizarPlanilla FROM cr_planilla_concepto WHERE 1 ".$where;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      
      return $num_rows;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildConsult()
  {
    try
    {
      $where = "";

      if($this->getIdConcepto()){ $where .= " AND idconcepto = '".$this->getIdConcepto()."'"; }
      if($this->getCodigo()){ $where .= " AND codigo = '".$this->getCodigo()."'"; }
      if($this->getTipo()){ $where .= " AND tipo = '".$this->getTipo()."'"; }
      if($this->getTipoDato()){ $where .= " AND tipoDato = '".$this->getTipoDato()."'"; }
      if($this->getUbicacion()){ $where .= " AND ubicacion = '".$this->getUbicacion()."'"; }
      if($this->getPosicionPlanilla()){ $where .= " AND posicionplanilla = '".$this->getPosicionPlanilla()."'"; }
      if($this->getDescripcion()){ $where .= " AND descripcion = '".$this->getDescripcion()."'"; }
      if($this->getDescripcionPlanilla()){ $where .= " AND descripcionplanilla = '".$this->getDescripcionPlanilla()."'"; }
      if($this->getDescripcionBoleta()){ $where .= " AND descripcionboleta = '".$this->getDescripcionBoleta()."'"; }
      if($this->getEditable()){ $where .= " AND editable = '".$this->getEditable()."'"; }
      if($this->getEstado()){ $where .= " AND estado = '".$this->getEstado()."'"; }
      if($this->getFormula()){ $where .= " AND formula = '".$this->getFormula()."'"; }
      if($this->getFechaCreacion()){ $where .= " AND fechacreacion = '".$this->getFechaCreacion()."'"; }
      if($this->getUsuarioCreacion()){ $where .= " AND usuariocreacion = '".$this->getUsuarioCreacion()."'"; }
      if($this->getVisualizarPlanilla()){ $where .= " AND visualizarplanilla = '".$this->getVisualizarPlanilla()."'"; }
      return $where;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildOrderByField()
  {
    try
    {
      $order_by = "";

      if(property_exists($this,'sortCampos')){
      if($this->sortCampos != ""){
        $a_valCampos = explode(";", $this->sortCampos);
        $a_valtype   = explode(";", $this->sortType);
        $order_by = " ORDER BY ";
        $a_order = array();
        foreach ($a_valCampos as $key => $val){
          $sTmpOrder = "";
          if(array_key_exists($val, self::$fieldNames)){
            $sTmpOrder .= self::$fieldNames[$val];
            switch ($a_valtype[$key]){
              case 1: $sTmpOrder .= " ASC"; break;
              case 2: $sTmpOrder .= " DESC"; break;
            }
            $a_order[] = $sTmpOrder;
          }
        }
        $order_by .= implode(", ", $a_order);
      }
      }
      return $order_by;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* B�squeda del registro por la llave primaria */
  public function selectByPK()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IdConcepto, Codigo, Tipo, Ubicacion, PosicionPlanilla, Descripcion, DescripcionPlanilla, DescripcionBoleta, Estado, Formula, FechaCreacion, UsuarioCreacion, VisualizarPlanilla FROM cr_planilla_concepto WHERE 1 AND IdConcepto='".$this->getIdConcepto()."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      

      return $o_Propel?$this->insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_BaseCrPlanillaConceptoFN = new BaseCrPlanillaConceptoFN();
    $o_BaseCrPlanillaConceptoFN->setIdConcepto($o_propel->IdConcepto);
    $o_BaseCrPlanillaConceptoFN->setCodigo($o_propel->Codigo);
    $o_BaseCrPlanillaConceptoFN->setTipoDato($o_propel->TipoDato);
    $o_BaseCrPlanillaConceptoFN->setTipo($o_propel->Tipo);
    $o_BaseCrPlanillaConceptoFN->setUbicacion($o_propel->Ubicacion);
    $o_BaseCrPlanillaConceptoFN->setPosicionPlanilla($o_propel->PosicionPlanilla);
    $o_BaseCrPlanillaConceptoFN->setDescripcion($o_propel->Descripcion);
    $o_BaseCrPlanillaConceptoFN->setDescripcionPlanilla($o_propel->DescripcionPlanilla);
    $o_BaseCrPlanillaConceptoFN->setDescripcionBoleta($o_propel->DescripcionBoleta);
    $o_BaseCrPlanillaConceptoFN->setEditable($o_propel->Editable);
    $o_BaseCrPlanillaConceptoFN->setEstado($o_propel->Estado);
    $o_BaseCrPlanillaConceptoFN->setFormula($o_propel->Formula);
    $o_BaseCrPlanillaConceptoFN->setFechaCreacion($o_propel->FechaCreacion);
    $o_BaseCrPlanillaConceptoFN->setUsuarioCreacion($o_propel->UsuarioCreacion);
    $o_BaseCrPlanillaConceptoFN->setVisualizarPlanilla($o_propel->VisualizarPlanilla);
    return $o_BaseCrPlanillaConceptoFN;
  }
}