<?php
/**
 * Clase Base DP para BaseCrPlanillaPeriodoDP
 *
 * @package    
 * @subpackage BaseCrPlanillaPeriodoDP
 * @author     Willy
 * @version    SVN:: BaseCrPlanillaPeriodoDP.class.php,v 1.1 2014-03-12 10:45:04 william.taype Exp $
 */
abstract class BaseCrPlanillaPeriodoDP extends CrPlanillaPeriodoBN
{
  /* N�mero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof CrPlanillaPeriodoBN )
    {
      $o_CrPlanillaPeriodoBN = $bSetDefault;
      if($o_CrPlanillaPeriodoBN->getPeriodo()) : $this->setPeriodo($o_CrPlanillaPeriodoBN->getPeriodo()); endif;
      if($o_CrPlanillaPeriodoBN->getEstado()) : $this->setEstado($o_CrPlanillaPeriodoBN->getEstado()); endif;
      if($o_CrPlanillaPeriodoBN->getActivo()) : $this->setActivo($o_CrPlanillaPeriodoBN->getActivo()); endif;
      if($o_CrPlanillaPeriodoBN->getTotalIngresos()) : $this->setTotalIngresos($o_CrPlanillaPeriodoBN->getTotalIngresos()); endif;
      if($o_CrPlanillaPeriodoBN->getTotalDescuentos()) : $this->setTotalDescuentos($o_CrPlanillaPeriodoBN->getTotalDescuentos()); endif;
      if($o_CrPlanillaPeriodoBN->getNeto()) : $this->setNeto($o_CrPlanillaPeriodoBN->getNeto()); endif;
      if($o_CrPlanillaPeriodoBN->getFechaCierre()) : $this->setFechaCierre($o_CrPlanillaPeriodoBN->getFechaCierre()); endif;
      if($o_CrPlanillaPeriodoBN->getFechaApertura()) : $this->setFechaApertura($o_CrPlanillaPeriodoBN->getFechaApertura()); endif;
    }
  }

  /* Obtiene el n�mero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      if($this->getPeriodo()){
        $a_Fields = array();

        if($this->getPeriodo()) : $a_Fields['Periodo'] = ($this->getPeriodo()); endif;
        if($this->getEstado()) : $a_Fields['Estado'] = ($this->getEstado()); endif;
        if($this->getActivo()) : $a_Fields['Activo'] = ($this->getActivo()); endif;
        if($this->getTotalIngresos()) : $a_Fields['TotalIngresos'] = ($this->getTotalIngresos()); endif;
        if($this->getTotalDescuentos()) : $a_Fields['TotalDescuentos'] = ($this->getTotalDescuentos()); endif;
        if($this->getTotalAportes()) : $a_Fields['TotalAportes'] = ($this->getTotalDescuentos()); endif;
        if($this->getNeto()) : $a_Fields['Neto'] = ($this->getNeto()); endif;
        if($this->getFechaCierre()) : $a_Fields['FechaCierre'] = ($this->getFechaCierre()); endif;
        if($this->getFechaApertura()) : $a_Fields['FechaApertura'] = ($this->getFechaApertura()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO cr_planilla_periodo (".$sStringField.") VALUES (".$sStringValue.");";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getPeriodo())
      {
        $a_Fields = array();

        if($this->getPeriodo()) : $a_Fields['Periodo'] = ($this->getPeriodo()); endif;
        if($this->getEstado()) : $a_Fields['Estado'] = ($this->getEstado()); endif;
        if($this->getActivo()) : $a_Fields['Activo'] = ($this->getActivo()); endif;
        if($this->getTotalIngresos()) : $a_Fields['TotalIngresos'] = ($this->getTotalIngresos()); endif;
        if($this->getTotalDescuentos()) : $a_Fields['TotalDescuentos'] = ($this->getTotalDescuentos()); endif;
        if($this->getTotalAportes()) : $a_Fields['TotalAportes'] = ($this->getTotalAportes()); endif;
        if($this->getNeto()) : $a_Fields['Neto'] = ($this->getNeto()); endif;
        if($this->getFechaCierre()) : $a_Fields['FechaCierre'] = ($this->getFechaCierre()); endif;
        if($this->getFechaApertura()) : $a_Fields['FechaApertura'] = ($this->getFechaApertura()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE cr_planilla_periodo SET ".$sStringField." WHERE 1 AND Periodo='".$this->getPeriodo()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getPeriodo())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM cr_planilla_periodo WHERE 1 AND Periodo='".$this->getPeriodo()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* B�squeda del registro por la llave primaria */
  public static function selectByPK($vPeriodo)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT Periodo, Estado, Activo, TotalIngresos, TotalDescuentos, TotalAportes, Neto, FechaCierre, FechaApertura FROM cr_planilla_periodo WHERE 1 AND Periodo='".$vPeriodo."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_CrPlanillaPeriodoDP = new CrPlanillaPeriodoDP();
    $o_CrPlanillaPeriodoDP->setPeriodo($o_propel->Periodo);
    $o_CrPlanillaPeriodoDP->setEstado($o_propel->Estado);
    $o_CrPlanillaPeriodoDP->setActivo($o_propel->Activo);
    $o_CrPlanillaPeriodoDP->setTotalIngresos($o_propel->TotalIngresos);
    $o_CrPlanillaPeriodoDP->setTotalDescuentos($o_propel->TotalDescuentos);
    $o_CrPlanillaPeriodoDP->setTotalAportes($o_propel->TotalAportes);
    $o_CrPlanillaPeriodoDP->setNeto($o_propel->Neto);
    $o_CrPlanillaPeriodoDP->setFechaCierre($o_propel->FechaCierre);
    $o_CrPlanillaPeriodoDP->setFechaApertura($o_propel->FechaApertura);
    return $o_CrPlanillaPeriodoDP;
  }
}