<?php
/**
 * Clase Base DP para BaseCrPlanillaConceptoDP
 *
 * @package    
 * @subpackage BaseCrPlanillaConceptoDP
 * @author     Willy
 * @version    SVN:: BaseCrPlanillaConceptoDP.class.php,v 1.1 2014-03-12 10:45:05 william.taype Exp $
 */
abstract class BaseCrPlanillaConceptoDP extends CrPlanillaConceptoBN
{
  /* N�mero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof CrPlanillaConceptoBN )
    {
      $o_CrPlanillaConceptoBN = $bSetDefault;
      if($o_CrPlanillaConceptoBN->getIdConcepto()) : $this->setIdConcepto($o_CrPlanillaConceptoBN->getIdConcepto()); endif;
      if($o_CrPlanillaConceptoBN->getCodigo()) : $this->setCodigo($o_CrPlanillaConceptoBN->getCodigo()); endif;
      if($o_CrPlanillaConceptoBN->getTipo()) : $this->setTipo($o_CrPlanillaConceptoBN->getTipo()); endif;
      if($o_CrPlanillaConceptoBN->getTipoDato()) : $this->setTipo($o_CrPlanillaConceptoBN->getTipoDato()); endif;
      if($o_CrPlanillaConceptoBN->getUbicacion()) : $this->setUbicacion($o_CrPlanillaConceptoBN->getUbicacion()); endif;
      if($o_CrPlanillaConceptoBN->getPosicionPlanilla()) : $this->setPosicionPlanilla($o_CrPlanillaConceptoBN->getPosicionPlanilla()); endif;
      if($o_CrPlanillaConceptoBN->getDescripcion()) : $this->setDescripcion($o_CrPlanillaConceptoBN->getDescripcion()); endif;
      if($o_CrPlanillaConceptoBN->getDescripcionPlanilla()) : $this->setDescripcionPlanilla($o_CrPlanillaConceptoBN->getDescripcionPlanilla()); endif;
      if($o_CrPlanillaConceptoBN->getDescripcionBoleta()) : $this->setDescripcionBoleta($o_CrPlanillaConceptoBN->getDescripcionBoleta()); endif;
      if($o_CrPlanillaConceptoBN->getEstado()) : $this->setEstado($o_CrPlanillaConceptoBN->getEstado()); endif;
      if($o_CrPlanillaConceptoBN->getFormula()) : $this->setFormula($o_CrPlanillaConceptoBN->getFormula()); endif;
      if($o_CrPlanillaConceptoBN->getFechaCreacion()) : $this->setFechaCreacion($o_CrPlanillaConceptoBN->getFechaCreacion()); endif;
      if($o_CrPlanillaConceptoBN->getUsuarioCreacion()) : $this->setUsuarioCreacion($o_CrPlanillaConceptoBN->getUsuarioCreacion()); endif;
      if($o_CrPlanillaConceptoBN->getVisualizarPlanilla()) : $this->setVisualizarPlanilla($o_CrPlanillaConceptoBN->getVisualizarPlanilla()); endif;
    }
  }

  /* Obtiene el n�mero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(IdConcepto),(MAX(IdConcepto)+1), 1) AS Maximo FROM cr_planilla_concepto;";
      $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
      $result = $oLink->query($sql);
      $row = $result->fetch(PDO::FETCH_ASSOC);
      $this->setIdConcepto($row["Maximo"]);

      if($this->getIdConcepto()){
        $a_Fields = array();

        if($this->getIdConcepto()) : $a_Fields['IdConcepto'] = ($this->getIdConcepto()); endif;
        if($this->getCodigo()) : $a_Fields['Codigo'] = ($this->getCodigo()); endif;
        if($this->getTipo()) : $a_Fields['Tipo'] = ($this->getTipo()); endif;
        if($this->getTipoDato()) : $a_Fields['TipoDato'] = ($this->getTipoDato()); endif;
        if($this->getUbicacion()) : $a_Fields['Ubicacion'] = ($this->getUbicacion()); endif;
        if($this->getPosicionPlanilla()) : $a_Fields['PosicionPlanilla'] = ($this->getPosicionPlanilla()); endif;
        if($this->getDescripcion()) : $a_Fields['Descripcion'] = ($this->getDescripcion()); endif;
        if($this->getDescripcionPlanilla()) : $a_Fields['DescripcionPlanilla'] = ($this->getDescripcionPlanilla()); endif;
        if($this->getDescripcionBoleta()) : $a_Fields['DescripcionBoleta'] = ($this->getDescripcionBoleta()); endif;
        if($this->getEditable()) : $a_Fields['Editable'] = ($this->getEditable()); endif;
        if($this->getEstado()) : $a_Fields['Estado'] = ($this->getEstado()); endif;
        if($this->getFormula()) : $a_Fields['Formula'] = ($this->getFormula()); endif;
        if($this->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getFechaCreacion()); endif;
        if($this->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getUsuarioCreacion()); endif;
        if($this->getVisualizarPlanilla()) : $a_Fields['VisualizarPlanilla'] = ($this->getVisualizarPlanilla()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO cr_planilla_concepto (".$sStringField.") VALUES (".$sStringValue.");";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdConcepto())
      {
        $a_Fields = array();

        if($this->getIdConcepto()) : $a_Fields['IdConcepto'] = ($this->getIdConcepto()); endif;
        if($this->getCodigo()) : $a_Fields['Codigo'] = ($this->getCodigo()); endif;
        if($this->getTipo()) : $a_Fields['Tipo'] = ($this->getTipo()); endif;
        if($this->getTipoDato()) : $a_Fields['TipoDato'] = ($this->getTipoDato()); endif;
        if($this->getUbicacion()) : $a_Fields['Ubicacion'] = ($this->getUbicacion()); endif;
        if($this->getPosicionPlanilla()) : $a_Fields['PosicionPlanilla'] = ($this->getPosicionPlanilla()); endif;
        if($this->getDescripcion()) : $a_Fields['Descripcion'] = ($this->getDescripcion()); endif;
        if($this->getDescripcionPlanilla()) : $a_Fields['DescripcionPlanilla'] = ($this->getDescripcionPlanilla()); endif;
        if($this->getDescripcionBoleta()) : $a_Fields['DescripcionBoleta'] = ($this->getDescripcionBoleta()); endif;
        if($this->getEditable()) : $a_Fields['Editable'] = ($this->getEditable()); endif;
        if($this->getEstado()) : $a_Fields['Estado'] = ($this->getEstado()); endif;
        if($this->getFormula()) : $a_Fields['Formula'] = ($this->getFormula()); endif;
        if($this->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getFechaCreacion()); endif;
        if($this->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getUsuarioCreacion()); endif;
        if($this->getVisualizarPlanilla()) : $a_Fields['VisualizarPlanilla'] = ($this->getVisualizarPlanilla()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE cr_planilla_concepto SET ".$sStringField." WHERE 1 AND IdConcepto='".$this->getIdConcepto()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdConcepto())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM cr_planilla_concepto WHERE 1 AND IdConcepto='".$this->getIdConcepto()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* B�squeda del registro por la llave primaria */
  public static function selectByPK($vIdConcepto)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IdConcepto, Codigo, Tipo, Ubicacion, PosicionPlanilla, Descripcion, DescripcionPlanilla, DescripcionBoleta,Editable, Estado, Formula, FechaCreacion, UsuarioCreacion, VisualizarPlanilla FROM cr_planilla_concepto WHERE 1 AND IdConcepto='".$vIdConcepto."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_CrPlanillaConceptoDP = new CrPlanillaConceptoDP();
    $o_CrPlanillaConceptoDP->setIdConcepto($o_propel->IdConcepto);
    $o_CrPlanillaConceptoDP->setCodigo($o_propel->Codigo);
    $o_CrPlanillaConceptoDP->setTipo($o_propel->Tipo);
    $o_CrPlanillaConceptoDP->setUbicacion($o_propel->Ubicacion);
    $o_CrPlanillaConceptoDP->setPosicionPlanilla($o_propel->PosicionPlanilla);
    $o_CrPlanillaConceptoDP->setDescripcion($o_propel->Descripcion);
    $o_CrPlanillaConceptoDP->setDescripcionPlanilla($o_propel->DescripcionPlanilla);
    $o_CrPlanillaConceptoDP->setDescripcionBoleta($o_propel->DescripcionBoleta);
    $o_CrPlanillaConceptoDP->setEstado($o_propel->Estado);
    $o_CrPlanillaConceptoDP->setFormula($o_propel->Formula);
    $o_CrPlanillaConceptoDP->setFechaCreacion($o_propel->FechaCreacion);
    $o_CrPlanillaConceptoDP->setUsuarioCreacion($o_propel->UsuarioCreacion);
    $o_CrPlanillaConceptoDP->setVisualizarPlanilla($o_propel->VisualizarPlanilla);
    return $o_CrPlanillaConceptoDP;
  }
}