<?php
/**
 * Clase Base FN para BaseCrPedidodetalleFN
 *
 * @package    
 * @subpackage BaseCrPedidodetalleFN
 * @author     Willy
 * @version    SVN:: BaseCrPedidodetalleFN.class.php,v 1.1 2012-07-28 12:37:08 william.taype Exp $
 */
class BaseCrPedidodetalleFN extends CrPedidodetalleBN
{
  private static $fieldNames = array (
    'Idpedidodetalle'=>'idpedidodetalle', 'Idpedidocabecera'=>'idpedidocabecera', 'Tipocodigo'=>'tipocodigo', 'Idcliente'=>'idcliente', 'Codigocliente'=>'idprestamo', 
    'Nombrecompleto'=>'nombrecompleto', 'Fechaentrega'=>'fechaentrega', 'Montoprestado'=>'montoprestado', 'Cuotapago'=>'cuotapago', 'Montototal'=>'montototal', 
    'Interesmonto'=>'interesmonto', 'Interesporcentaje'=>'interesporcentaje', 'Duracion'=>'duracion', 'Nrocuotas'=>'nrocuotas', 'Estado'=>'estado', 'Fechainicio'=>'fechainicio', 
    'Fechavencimiento'=>'fechavencimiento', 'Gastoadministrativo'=>'gastoadministrativo', 'Idcolaborador'=>'idcolaborador', 'Turno'=>'turno', 'Observacion'=>'observacion', 
    'Usuariocreacion'=>'usuariocreacion', 'Fechacreacion'=>'fechacreacion', 'Usuariomodificacion'=>'usuariomodificacion', 'Fechamodificacion'=>'fechamodificacion', 
    'Usuarioeliminacion'=>'usuarioeliminacion', 'Fechaeliminacion'=>'fechaeliminacion', 'Eliminado'=>'eliminado', 'Periodicidadpago'=>'periodicidadpago', 
    'Saldoprestamo'=>'saldoprestamo', 'Entregado'=>'entregado', 'Fechaentregado'=>'fechaentregado', 'Usuarioentregado'=>'usuarioentregado', 'Montoreferencia'=>'montoreferencia'
  );

  public function select()
  {
    try
    {
      $tamPag = !property_exists($this, 'tamPag')?9999:$this->tamPag;
      $pagina = !property_exists($this, 'page')||$this->page==""?1:$this->page;
      $numeroRegistros = $this->selectNumRows();
      $limitInf = ($pagina-1)*$tamPag;

      $where = $this->buildConsult();
      $orden = $this->buildOrderByField();

      $con = Conexion::getConexion();
      $sql = "SELECT idpedidodetalle, idpedidocabecera, tipocodigo, idcliente, idprestamo, nombrecompleto, fechaentrega, montoprestado, cuotapago, montototal, interesmonto, 
              interesporcentaje, duracion, nrocuotas, estado, fechainicio, fechavencimiento, gastoadministrativo, idcolaborador, turno, observacion, usuariocreacion, 
              fechacreacion, usuariomodificacion, fechamodificacion, usuarioeliminacion, fechaeliminacion, eliminado, periodicidadpago, saldoprestamo, entregado, 
              fechaentregado, usuarioentregado, montoreferencia 
              FROM cr_pedidodetalle WHERE 1 ".$where." ".$orden."  LIMIT ".$limitInf.",".$tamPag;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      $a_tmp = array();
      if($num_rows>0){
        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
          $a_tmp[] = $this->insertObjectBN($o_valor);
        }
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function selectNumRows()
  {
    try
    {
      $where = $this->buildConsult();

      $con = Conexion::getConexion();
      $sql = "SELECT idpedidodetalle, idpedidocabecera, tipocodigo, idcliente, idprestamo, nombrecompleto, fechaentrega, montoprestado, cuotapago, montototal, interesmonto, 
              interesporcentaje, duracion, nrocuotas, estado, fechainicio, fechavencimiento, gastoadministrativo, idcolaborador, turno, observacion, usuariocreacion, fechacreacion, 
              usuariomodificacion, fechamodificacion, usuarioeliminacion, fechaeliminacion, eliminado, periodicidadpago, saldoprestamo, entregado, fechaentregado, usuarioentregado, montoreferencia
              FROM cr_pedidodetalle WHERE 1 ".$where;
      
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      
      return $num_rows;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildConsult()
  {
    try
    {
      $where = "";

      if(!is_null($this->getIdpedidodetalle())){ $where .= " AND idpedidodetalle = '".$this->getIdpedidodetalle()."'"; }
      if(!is_null($this->getIdpedidocabecera())){ $where .= " AND idpedidocabecera = '".$this->getIdpedidocabecera()."'"; }
      if(!is_null($this->getTipocodigo())){ $where .= " AND tipocodigo = '".$this->getTipocodigo()."'"; }
      if(!is_null($this->getIdcliente())){ $where .= " AND idcliente = '".$this->getIdcliente()."'"; }
      if(!is_null($this->getCodigocliente())){ $where .= " AND idprestamo = '".$this->getCodigocliente()."'"; }
      if(!is_null($this->getNombrecompleto())){ $where .= " AND nombrecompleto = '".$this->getNombrecompleto()."'"; }
      if(!is_null($this->getFechaentrega())){ $where .= " AND fechaentrega = '".$this->getFechaentrega()."'"; }
      if(!is_null($this->getMontoprestado())){ $where .= " AND montoprestado = '".$this->getMontoprestado()."'"; }
      if(!is_null($this->getCuotapago())){ $where .= " AND cuotapago = '".$this->getCuotapago()."'"; }
      if(!is_null($this->getMontototal())){ $where .= " AND montototal = '".$this->getMontototal()."'"; }
      if(!is_null($this->getInteresmonto())){ $where .= " AND interesmonto = '".$this->getInteresmonto()."'"; }
      if(!is_null($this->getInteresporcentaje())){ $where .= " AND interesporcentaje = '".$this->getInteresporcentaje()."'"; }
      if(!is_null($this->getDuracion())){ $where .= " AND duracion = '".$this->getDuracion()."'"; }
      if(!is_null($this->getNrocuotas())){ $where .= " AND nrocuotas = '".$this->getNrocuotas()."'"; }
      if(!is_null($this->getEstado())){ $where .= " AND estado = '".$this->getEstado()."'"; }
      if(!is_null($this->getFechainicio())){ $where .= " AND fechainicio = '".$this->getFechainicio()."'"; }
      if(!is_null($this->getFechavencimiento())){ $where .= " AND fechavencimiento = '".$this->getFechavencimiento()."'"; }
      if(!is_null($this->getGastoadministrativo())){ $where .= " AND gastoadministrativo = '".$this->getGastoadministrativo()."'"; }
      if(!is_null($this->getIdcolaborador())){ $where .= " AND idcolaborador = '".$this->getIdcolaborador()."'"; }
      if(!is_null($this->getTurno())){ $where .= " AND turno = '".$this->getTurno()."'"; }
      if(!is_null($this->getObservacion())){ $where .= " AND observacion = '".$this->getObservacion()."'"; }
      if(!is_null($this->getUsuariocreacion())){ $where .= " AND usuariocreacion = '".$this->getUsuariocreacion()."'"; }
      if(!is_null($this->getFechacreacion())){ $where .= " AND fechacreacion = '".$this->getFechacreacion()."'"; }
      if(!is_null($this->getUsuariomodificacion())){ $where .= " AND usuariomodificacion = '".$this->getUsuariomodificacion()."'"; }
      if(!is_null($this->getFechamodificacion())){ $where .= " AND fechamodificacion = '".$this->getFechamodificacion()."'"; }
      if(!is_null($this->getUsuarioeliminacion())){ $where .= " AND usuarioeliminacion = '".$this->getUsuarioeliminacion()."'"; }
      if(!is_null($this->getFechaeliminacion())){ $where .= " AND fechaeliminacion = '".$this->getFechaeliminacion()."'"; }
      if(!is_null($this->getEliminado())){ $where .= " AND eliminado = '".$this->getEliminado()."'"; }
      if(!is_null($this->getPeriodicidadpago())){ $where .= " AND periodicidadpago = '".$this->getPeriodicidadpago()."'"; }
      if(!is_null($this->getSaldoprestamo())){ $where .= " AND saldoprestamo = '".$this->getSaldoprestamo()."'"; }
      if(!is_null($this->getEntregado())){ $where .= " AND entregado = '".$this->getEntregado()."'"; }
      if(!is_null($this->getFechaentregado())){ $where .= " AND fechaentregado = '".$this->getFechaentregado()."'"; }
      if(!is_null($this->getUsuarioentregado())){ $where .= " AND usuarioentregado = '".$this->getUsuarioentregado()."'"; }
      return $where;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildOrderByField()
  {
    try
    {
      $order_by = "";

      if(property_exists($this,'sortCampos')){
      if($this->sortCampos != ""){
        $a_valCampos = explode(";", $this->sortCampos);
        $a_valtype   = explode(";", $this->sortType);
        $order_by = " ORDER BY ";
        $a_order = array();
        foreach ($a_valCampos as $key => $val){
          $sTmpOrder = "";
          if(array_key_exists($val, self::$fieldNames)){
            $sTmpOrder .= self::$fieldNames[$val];
            switch ($a_valtype[$key]){
              case 1: $sTmpOrder .= " ASC"; break;
              case 2: $sTmpOrder .= " DESC"; break;
            }
            $a_order[] = $sTmpOrder;
          }
        }
        $order_by .= implode(", ", $a_order);
      }
      }
      return $order_by;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* B�squeda del registro por la llave primaria */
  public function selectByPK()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idpedidodetalle, idpedidocabecera, tipocodigo, idcliente, idprestamo, nombrecompleto, fechaentrega, montoprestado, cuotapago, montototal, interesmonto, 
                     interesporcentaje, duracion, nrocuotas, estado, fechainicio, fechavencimiento, gastoadministrativo, idcolaborador, turno, observacion, usuariocreacion, 
                     fechacreacion, usuariomodificacion, fechamodificacion, usuarioeliminacion, fechaeliminacion, eliminado, periodicidadpago, saldoprestamo, entregado, 
                     fechaentregado, usuarioentregado, montoreferencia
              FROM cr_pedidodetalle WHERE 1 AND idpedidodetalle='".$this->getIdpedidodetalle()."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      

      return $o_Propel?$this->insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_BaseCrPedidodetalleFN = new BaseCrPedidodetalleFN();
    $o_BaseCrPedidodetalleFN->setIdpedidodetalle($o_propel->idpedidodetalle);
    $o_BaseCrPedidodetalleFN->setIdpedidocabecera($o_propel->idpedidocabecera);
    $o_BaseCrPedidodetalleFN->setTipocodigo($o_propel->tipocodigo);
    $o_BaseCrPedidodetalleFN->setIdcliente($o_propel->idcliente);
    $o_BaseCrPedidodetalleFN->setCodigocliente($o_propel->idprestamo);
    $o_BaseCrPedidodetalleFN->setNombrecompleto($o_propel->nombrecompleto);
    $o_BaseCrPedidodetalleFN->setFechaentrega($o_propel->fechaentrega);
    $o_BaseCrPedidodetalleFN->setMontoprestado($o_propel->montoprestado);
    
    $o_BaseCrPedidodetalleFN->setMontoreferencia($o_propel->montoreferencia);
    
    $o_BaseCrPedidodetalleFN->setCuotapago($o_propel->cuotapago);
    $o_BaseCrPedidodetalleFN->setMontototal($o_propel->montototal);
    $o_BaseCrPedidodetalleFN->setInteresmonto($o_propel->interesmonto);
    $o_BaseCrPedidodetalleFN->setInteresporcentaje($o_propel->interesporcentaje);
    $o_BaseCrPedidodetalleFN->setDuracion($o_propel->duracion);
    $o_BaseCrPedidodetalleFN->setNrocuotas($o_propel->nrocuotas);
    $o_BaseCrPedidodetalleFN->setEstado($o_propel->estado);
    $o_BaseCrPedidodetalleFN->setFechainicio($o_propel->fechainicio);
    $o_BaseCrPedidodetalleFN->setFechavencimiento($o_propel->fechavencimiento);
    $o_BaseCrPedidodetalleFN->setGastoadministrativo($o_propel->gastoadministrativo);
    $o_BaseCrPedidodetalleFN->setIdcolaborador($o_propel->idcolaborador);
    $o_BaseCrPedidodetalleFN->setTurno($o_propel->turno);
    $o_BaseCrPedidodetalleFN->setObservacion($o_propel->observacion);
    $o_BaseCrPedidodetalleFN->setUsuariocreacion($o_propel->usuariocreacion);
    $o_BaseCrPedidodetalleFN->setFechacreacion($o_propel->fechacreacion);
    $o_BaseCrPedidodetalleFN->setUsuariomodificacion($o_propel->usuariomodificacion);
    $o_BaseCrPedidodetalleFN->setFechamodificacion($o_propel->fechamodificacion);
    $o_BaseCrPedidodetalleFN->setUsuarioeliminacion($o_propel->usuarioeliminacion);
    $o_BaseCrPedidodetalleFN->setFechaeliminacion($o_propel->fechaeliminacion);
    $o_BaseCrPedidodetalleFN->setEliminado($o_propel->eliminado);
    $o_BaseCrPedidodetalleFN->setPeriodicidadpago($o_propel->periodicidadpago);
    $o_BaseCrPedidodetalleFN->setSaldoprestamo($o_propel->saldoprestamo);
    $o_BaseCrPedidodetalleFN->setEntregado($o_propel->entregado);
    $o_BaseCrPedidodetalleFN->setFechaentregado($o_propel->fechaentregado);
    $o_BaseCrPedidodetalleFN->setUsuarioentregado($o_propel->usuarioentregado);
    return $o_BaseCrPedidodetalleFN;
  }
}