<?php
/**
 * Clase Base FN para BaseCrPedidocabeceraFN
 *
 * @package    
 * @subpackage BaseCrPedidocabeceraFN
 * @author     Willy
 * @version    SVN:: BaseCrPedidocabeceraFN.class.php,v 1.1 2012-07-28 12:37:09 william.taype Exp $
 */
class BaseCrPedidocabeceraFN extends CrPedidocabeceraBN
{
  private static $fieldNames = array (
    'Idsucursal'=>'idsucursal', 'Idpedidocabecera'=>'idpedidocabecera', 'Fechaoperacion'=>'fechaoperacion', 'Montototal'=>'montototal', 'Montoaprobado'=>'montoaprobado', 'Montorechazado'=>'montorechazado', 'Montoentregado'=>'montoentregado', 'Montonoentregado'=>'montonoentregado', 'Estado'=>'estado', 'Usuariocreacion'=>'usuariocreacion', 'Fechacreacion'=>'fechacreacion', 'Usuariomodificacion'=>'usuariomodificacion', 'Fechamodificacion'=>'fechamodificacion', 'Comentario'=>'comentariorepresentante', 'Usuarioeliminado'=>'usuarioeliminado', 'Fechaeliminado'=>'fechaeliminado', 'Eliminado'=>'eliminado', 'Idcolaboradordestino'=>'idcolaboradorsupervisor', 'Idcolaboradorrepresentante'=>'idcolaboradorrepresentante', 'Comentariosupervisor'=>'comentariosupervisor', 'Numeropedidos'=>'numeropedidos', 'Numeropedidosaprobados'=>'numeropedidosaprobados', 'Numeropedidosdesaprobados'=>'numeropedidosdesaprobados'  
  );

  public function select()
  {
    try
    {
      $tamPag = !property_exists($this, 'tamPag')?9999:$this->tamPag;
      $pagina = !property_exists($this, 'page')||$this->page==""?1:$this->page;
      $numeroRegistros = $this->selectNumRows();
      $limitInf = ($pagina-1)*$tamPag;

      $where = $this->buildConsult();
      $orden = $this->buildOrderByField();

      $con = Conexion::getConexion();
      $sql = "SELECT idpedidocabecera, idsucursal, fechaoperacion, montototal, montoaprobado, montorechazado, montoentregado, montonoentregado, estado, usuariocreacion, fechacreacion, usuariomodificacion, fechamodificacion, comentariorepresentante, usuarioeliminado, fechaeliminado, eliminado, idcolaboradorsupervisor, idcolaboradorrepresentante, comentariosupervisor, numeropedidos, numeropedidosaprobados, numeropedidosdesaprobados FROM cr_pedidocabecera WHERE 1 ".$where." ".$orden."  LIMIT ".$limitInf.",".$tamPag;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      $a_tmp = array();
      if($num_rows>0){
        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
          $a_tmp[] = $this->insertObjectBN($o_valor);
        }
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function selectNumRows()
  {
    try
    {
      $where = $this->buildConsult();

      $con = Conexion::getConexion();
      $sql = "SELECT idpedidocabecera, idsucursal, fechaoperacion, montototal, montoaprobado, montorechazado, montoentregado, montonoentregado, estado, usuariocreacion, fechacreacion, usuariomodificacion, fechamodificacion, comentariorepresentante, usuarioeliminado, fechaeliminado, eliminado, idcolaboradorsupervisor, idcolaboradorrepresentante, comentariosupervisor, numeropedidos, numeropedidosaprobados, numeropedidosdesaprobados FROM cr_pedidocabecera WHERE 1 ".$where;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      
      return $num_rows;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildConsult()
  {
    try
    {
      $where = "";

      if(!is_null($this->getIdSucursal())){ $where .= " AND idsucursal = '".$this->getIdSucursal()."'"; }
      if(!is_null($this->getIdpedidocabecera())){ $where .= " AND idpedidocabecera = '".$this->getIdpedidocabecera()."'"; }
      if(!is_null($this->getFechaoperacion())){ $where .= " AND fechaoperacion = '".$this->getFechaoperacion()."'"; }
      if(!is_null($this->getMontototal())){ $where .= " AND montototal = '".$this->getMontototal()."'"; }
      if(!is_null($this->getMontoaprobado())){ $where .= " AND montoaprobado = '".$this->getMontoaprobado()."'"; }
      if(!is_null($this->getMontorechazado())){ $where .= " AND montorechazado = '".$this->getMontorechazado()."'"; }
      if(!is_null($this->getMontoentregado())){ $where .= " AND montoentregado = '".$this->getMontoentregado()."'"; }
      if(!is_null($this->getMontonoentregado())){ $where .= " AND montonoentregado = '".$this->getMontonoentregado()."'"; }
      if(!is_null($this->getEstado())){ $where .= " AND estado = '".$this->getEstado()."'"; }
      if(!is_null($this->getUsuariocreacion())){ $where .= " AND usuariocreacion = '".$this->getUsuariocreacion()."'"; }
      if(!is_null($this->getFechacreacion())){ $where .= " AND fechacreacion = '".$this->getFechacreacion()."'"; }
      if(!is_null($this->getUsuariomodificacion())){ $where .= " AND usuariomodificacion = '".$this->getUsuariomodificacion()."'"; }
      if(!is_null($this->getFechamodificacion())){ $where .= " AND fechamodificacion = '".$this->getFechamodificacion()."'"; }
      if(!is_null($this->getComentario())){ $where .= " AND comentariorepresentante = '".$this->getComentario()."'"; }
      if(!is_null($this->getUsuarioeliminado())){ $where .= " AND usuarioeliminado = '".$this->getUsuarioeliminado()."'"; }
      if(!is_null($this->getFechaeliminado())){ $where .= " AND fechaeliminado = '".$this->getFechaeliminado()."'"; }
      if(!is_null($this->getEliminado())){ $where .= " AND eliminado = '".$this->getEliminado()."'"; }
      if(!is_null($this->getIdcolaboradordestino())){ $where .= " AND idcolaboradorsupervisor = '".$this->getIdcolaboradordestino()."'"; }
      if(!is_null($this->getIdcolaboradorrepresentante())){ $where .= " AND idcolaboradorrepresentante = '".$this->getIdcolaboradorrepresentante()."'"; }
      if(!is_null($this->getComentariosupervisor())){ $where .= " AND comentariosupervisor = '".$this->getComentariosupervisor()."'"; }
      if(!is_null($this->getNumeropedidos())){ $where .= " AND numeropedidos = '".$this->getNumeropedidos()."'"; }
      if(!is_null($this->getNumeropedidosaprobados())){ $where .= " AND numeropedidosaprobados = '".$this->getNumeropedidosaprobados()."'"; }
      if(!is_null($this->getNumeropedidosdesaprobados())){ $where .= " AND numeropedidosdesaprobados = '".$this->getNumeropedidosdesaprobados()."'"; }
      return $where;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildOrderByField()
  {
    try
    {
      $order_by = "";

      if(property_exists($this,'sortCampos')){
      if($this->sortCampos != ""){
        $a_valCampos = explode(";", $this->sortCampos);
        $a_valtype   = explode(";", $this->sortType);
        $order_by = " ORDER BY ";
        $a_order = array();
        foreach ($a_valCampos as $key => $val){
          $sTmpOrder = "";
          if(array_key_exists($val, self::$fieldNames)){
            $sTmpOrder .= self::$fieldNames[$val];
            switch ($a_valtype[$key]){
              case 1: $sTmpOrder .= " ASC"; break;
              case 2: $sTmpOrder .= " DESC"; break;
            }
            $a_order[] = $sTmpOrder;
          }
        }
        $order_by .= implode(", ", $a_order);
      }
      }
      return $order_by;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* B�squeda del registro por la llave primaria */
  public function selectByPK()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idpedidocabecera, idsucursal, fechaoperacion, montototal, montoaprobado, montorechazado, montoentregado, montonoentregado, estado, usuariocreacion, fechacreacion, usuariomodificacion, fechamodificacion, comentariorepresentante, usuarioeliminado, fechaeliminado, eliminado, idcolaboradorsupervisor, idcolaboradorrepresentante, comentariosupervisor, numeropedidos, numeropedidosaprobados, numeropedidosdesaprobados FROM cr_pedidocabecera WHERE 1 AND idpedidocabecera='".$this->getIdpedidocabecera()."'; ";
      //echo $sql;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      

      return $o_Propel?$this->insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  public function insertObjectBN($o_propel){
    $o_BaseCrPedidocabeceraFN = new BaseCrPedidocabeceraFN();
    $o_BaseCrPedidocabeceraFN->setIdpedidocabecera($o_propel->idpedidocabecera);
    $o_BaseCrPedidocabeceraFN->setIdSucursal($o_propel->idsucursal);
    $o_BaseCrPedidocabeceraFN->setFechaoperacion($o_propel->fechaoperacion);
    $o_BaseCrPedidocabeceraFN->setMontototal($o_propel->montototal);
    $o_BaseCrPedidocabeceraFN->setMontoaprobado($o_propel->montoaprobado);
    $o_BaseCrPedidocabeceraFN->setMontorechazado($o_propel->montorechazado);
    $o_BaseCrPedidocabeceraFN->setMontoentregado($o_propel->montoentregado);
    $o_BaseCrPedidocabeceraFN->setMontonoentregado($o_propel->montonoentregado);
    $o_BaseCrPedidocabeceraFN->setEstado($o_propel->estado);
    $o_BaseCrPedidocabeceraFN->setUsuariocreacion($o_propel->usuariocreacion);
    $o_BaseCrPedidocabeceraFN->setFechacreacion($o_propel->fechacreacion);
    $o_BaseCrPedidocabeceraFN->setUsuariomodificacion($o_propel->usuariomodificacion);
    $o_BaseCrPedidocabeceraFN->setFechamodificacion($o_propel->fechamodificacion);
    $o_BaseCrPedidocabeceraFN->setComentario($o_propel->comentariorepresentante);
    $o_BaseCrPedidocabeceraFN->setUsuarioeliminado($o_propel->usuarioeliminado);
    $o_BaseCrPedidocabeceraFN->setFechaeliminado($o_propel->fechaeliminado);
    $o_BaseCrPedidocabeceraFN->setEliminado($o_propel->eliminado);
    $o_BaseCrPedidocabeceraFN->setIdcolaboradordestino($o_propel->idcolaboradorsupervisor);
    $o_BaseCrPedidocabeceraFN->setIdcolaboradorrepresentante($o_propel->idcolaboradorrepresentante);
    $o_BaseCrPedidocabeceraFN->setComentariosupervisor($o_propel->comentariosupervisor);
    $o_BaseCrPedidocabeceraFN->setNumeropedidos($o_propel->numeropedidos);
    $o_BaseCrPedidocabeceraFN->setNumeropedidosaprobados($o_propel->numeropedidosaprobados);
    $o_BaseCrPedidocabeceraFN->setNumeropedidosdesaprobados($o_propel->numeropedidosdesaprobados);
    return $o_BaseCrPedidocabeceraFN;
  }
}