<?php
/**
 * Clase Base DP para BaseCrPedidodetalleDP
 *
 * @package    
 * @subpackage BaseCrPedidodetalleDP
 * @author     Willy
 * @version    SVN:: BaseCrPedidodetalleDP.class.php,v 1.1 2012-07-28 12:36:40 william.taype Exp $
 */
abstract class BaseCrPedidodetalleDP extends CrPedidodetalleBN
{
  /* Nmero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof CrPedidodetalleBN )
    {
      $o_CrPedidodetalleBN = $bSetDefault;
      if(!is_null($o_CrPedidodetalleBN->getIdpedidodetalle())) : $this->setIdpedidodetalle($o_CrPedidodetalleBN->getIdpedidodetalle()); endif;
      if(!is_null($o_CrPedidodetalleBN->getIdpedidocabecera())) : $this->setIdpedidocabecera($o_CrPedidodetalleBN->getIdpedidocabecera()); endif;
      if(!is_null($o_CrPedidodetalleBN->getTipocodigo())) : $this->setTipocodigo($o_CrPedidodetalleBN->getTipocodigo()); endif;
      if(!is_null($o_CrPedidodetalleBN->getIdcliente())) : $this->setIdcliente($o_CrPedidodetalleBN->getIdcliente()); endif;
      if(!is_null($o_CrPedidodetalleBN->getCodigocliente())) : $this->setCodigocliente($o_CrPedidodetalleBN->getCodigocliente()); endif;
      if(!is_null($o_CrPedidodetalleBN->getNombrecompleto())) : $this->setNombrecompleto($o_CrPedidodetalleBN->getNombrecompleto()); endif;
      if(!is_null($o_CrPedidodetalleBN->getFechaentrega())) : $this->setFechaentrega($o_CrPedidodetalleBN->getFechaentrega()); endif;
      
      if(!is_null($o_CrPedidodetalleBN->getMontoreferencia())) : $this->setMontoreferencia($o_CrPedidodetalleBN->getMontoreferencia()); endif;
      
      if(!is_null($o_CrPedidodetalleBN->getMontoprestado())) : $this->setMontoprestado($o_CrPedidodetalleBN->getMontoprestado()); endif;
      if(!is_null($o_CrPedidodetalleBN->getCuotapago())) : $this->setCuotapago($o_CrPedidodetalleBN->getCuotapago()); endif;
      if(!is_null($o_CrPedidodetalleBN->getMontototal())) : $this->setMontototal($o_CrPedidodetalleBN->getMontototal()); endif;
      if(!is_null($o_CrPedidodetalleBN->getInteresmonto())) : $this->setInteresmonto($o_CrPedidodetalleBN->getInteresmonto()); endif;
      if(!is_null($o_CrPedidodetalleBN->getInteresporcentaje())) : $this->setInteresporcentaje($o_CrPedidodetalleBN->getInteresporcentaje()); endif;
      if(!is_null($o_CrPedidodetalleBN->getDuracion())) : $this->setDuracion($o_CrPedidodetalleBN->getDuracion()); endif;
      if(!is_null($o_CrPedidodetalleBN->getNrocuotas())) : $this->setNrocuotas($o_CrPedidodetalleBN->getNrocuotas()); endif;
      if(!is_null($o_CrPedidodetalleBN->getEstado())) : $this->setEstado($o_CrPedidodetalleBN->getEstado()); endif;
      if(!is_null($o_CrPedidodetalleBN->getFechainicio())) : $this->setFechainicio($o_CrPedidodetalleBN->getFechainicio()); endif;
      if(!is_null($o_CrPedidodetalleBN->getFechavencimiento())) : $this->setFechavencimiento($o_CrPedidodetalleBN->getFechavencimiento()); endif;
      if(!is_null($o_CrPedidodetalleBN->getGastoadministrativo())) : $this->setGastoadministrativo($o_CrPedidodetalleBN->getGastoadministrativo()); endif;
      if(!is_null($o_CrPedidodetalleBN->getIdcolaborador())) : $this->setIdcolaborador($o_CrPedidodetalleBN->getIdcolaborador()); endif;
      if(!is_null($o_CrPedidodetalleBN->getTurno())) : $this->setTurno($o_CrPedidodetalleBN->getTurno()); endif;
      if(!is_null($o_CrPedidodetalleBN->getObservacion())) : $this->setObservacion($o_CrPedidodetalleBN->getObservacion()); endif;
      if(!is_null($o_CrPedidodetalleBN->getUsuariocreacion())) : $this->setUsuariocreacion($o_CrPedidodetalleBN->getUsuariocreacion()); endif;
      if(!is_null($o_CrPedidodetalleBN->getFechacreacion())) : $this->setFechacreacion($o_CrPedidodetalleBN->getFechacreacion()); endif;
      if(!is_null($o_CrPedidodetalleBN->getUsuariomodificacion())) : $this->setUsuariomodificacion($o_CrPedidodetalleBN->getUsuariomodificacion()); endif;
      if(!is_null($o_CrPedidodetalleBN->getFechamodificacion())) : $this->setFechamodificacion($o_CrPedidodetalleBN->getFechamodificacion()); endif;
      if(!is_null($o_CrPedidodetalleBN->getUsuarioeliminacion())) : $this->setUsuarioeliminacion($o_CrPedidodetalleBN->getUsuarioeliminacion()); endif;
      if(!is_null($o_CrPedidodetalleBN->getFechaeliminacion())) : $this->setFechaeliminacion($o_CrPedidodetalleBN->getFechaeliminacion()); endif;
      if(!is_null($o_CrPedidodetalleBN->getEliminado())) : $this->setEliminado($o_CrPedidodetalleBN->getEliminado()); endif;
      if(!is_null($o_CrPedidodetalleBN->getPeriodicidadpago())) : $this->setPeriodicidadpago($o_CrPedidodetalleBN->getPeriodicidadpago()); endif;
      if(!is_null($o_CrPedidodetalleBN->getSaldoprestamo())) : $this->setSaldoprestamo($o_CrPedidodetalleBN->getSaldoprestamo()); endif;
      if(!is_null($o_CrPedidodetalleBN->getEntregado())) : $this->setEntregado($o_CrPedidodetalleBN->getEntregado()); endif;
      if(!is_null($o_CrPedidodetalleBN->getFechaentregado())) : $this->setFechaentregado($o_CrPedidodetalleBN->getFechaentregado()); endif;
      if(!is_null($o_CrPedidodetalleBN->getUsuarioentregado())) : $this->setUsuarioentregado($o_CrPedidodetalleBN->getUsuarioentregado()); endif;
    }
  }

  /* Obtiene el nmero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(idpedidodetalle),(MAX(idpedidodetalle)+1), 1) AS Maximo FROM cr_pedidodetalle;";
      $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
      $result = $oLink->query($sql);
      $row = $result->fetch(PDO::FETCH_ASSOC);
      $this->setIdpedidodetalle($row["Maximo"]);

      if($this->getIdpedidodetalle()){
        $a_Fields = array();

        if(!is_null($this->getIdpedidodetalle())) : $a_Fields['idpedidodetalle'] = ($this->getIdpedidodetalle()); endif;
        if(!is_null($this->getIdpedidocabecera())) : $a_Fields['idpedidocabecera'] = ($this->getIdpedidocabecera()); endif;
        if(!is_null($this->getTipocodigo())) : $a_Fields['tipocodigo'] = ($this->getTipocodigo()); endif;
        if(!is_null($this->getIdcliente())) : $a_Fields['idcliente'] = ($this->getIdcliente()); endif;
        if(!is_null($this->getCodigocliente())) : $a_Fields['idprestamo'] = ($this->getCodigocliente()); endif;
        if(!is_null($this->getNombrecompleto())) : $a_Fields['nombrecompleto'] = ($this->getNombrecompleto()); endif;
        if(!is_null($this->getFechaentrega())) : $a_Fields['fechaentrega'] = ($this->getFechaentrega()); endif;
        
        if(!is_null($this->getMontoreferencia())) : $a_Fields['montoreferencia'] = ($this->getMontoreferencia()); endif;
        
        if(!is_null($this->getMontoprestado())) : $a_Fields['montoprestado'] = ($this->getMontoprestado()); endif;
        if(!is_null($this->getCuotapago())) : $a_Fields['cuotapago'] = ($this->getCuotapago()); endif;
        if(!is_null($this->getMontototal())) : $a_Fields['montototal'] = ($this->getMontototal()); endif;
        if(!is_null($this->getInteresmonto())) : $a_Fields['interesmonto'] = ($this->getInteresmonto()); endif;
        if(!is_null($this->getInteresporcentaje())) : $a_Fields['interesporcentaje'] = ($this->getInteresporcentaje()); endif;
        if(!is_null($this->getDuracion())) : $a_Fields['duracion'] = ($this->getDuracion()); endif;
        if(!is_null($this->getNrocuotas())) : $a_Fields['nrocuotas'] = ($this->getNrocuotas()); endif;
        if(!is_null($this->getEstado())) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if(!is_null($this->getFechainicio())) : $a_Fields['fechainicio'] = ($this->getFechainicio()); endif;
        if(!is_null($this->getFechavencimiento())) : $a_Fields['fechavencimiento'] = ($this->getFechavencimiento()); endif;
        if(!is_null($this->getGastoadministrativo())) : $a_Fields['gastoadministrativo'] = ($this->getGastoadministrativo()); endif;
        if(!is_null($this->getIdcolaborador())) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if(!is_null($this->getTurno())) : $a_Fields['turno'] = ($this->getTurno()); endif;
        if(!is_null($this->getObservacion())) : $a_Fields['observacion'] = ($this->getObservacion()); endif;
        if(!is_null($this->getUsuariocreacion())) : $a_Fields['usuariocreacion'] = ($this->getUsuariocreacion()); endif;
        if(!is_null($this->getFechacreacion())) : $a_Fields['fechacreacion'] = ($this->getFechacreacion()); endif;
        if(!is_null($this->getUsuariomodificacion())) : $a_Fields['usuariomodificacion'] = ($this->getUsuariomodificacion()); endif;
        if(!is_null($this->getFechamodificacion())) : $a_Fields['fechamodificacion'] = ($this->getFechamodificacion()); endif;
        if(!is_null($this->getUsuarioeliminacion())) : $a_Fields['usuarioeliminacion'] = ($this->getUsuarioeliminacion()); endif;
        if(!is_null($this->getFechaeliminacion())) : $a_Fields['fechaeliminacion'] = ($this->getFechaeliminacion()); endif;
        if(!is_null($this->getEliminado())) : $a_Fields['eliminado'] = ($this->getEliminado()); endif;
        if(!is_null($this->getPeriodicidadpago())) : $a_Fields['periodicidadpago'] = ($this->getPeriodicidadpago()); endif;
        if(!is_null($this->getSaldoprestamo())) : $a_Fields['saldoprestamo'] = ($this->getSaldoprestamo()); endif;
        if(!is_null($this->getEntregado())) : $a_Fields['entregado'] = ($this->getEntregado()); endif;
        if(!is_null($this->getFechaentregado())) : $a_Fields['fechaentregado'] = ($this->getFechaentregado()); endif;
        if(!is_null($this->getUsuarioentregado())) : $a_Fields['usuarioentregado'] = ($this->getUsuarioentregado()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO cr_pedidodetalle (".$sStringField.") VALUES (".$sStringValue.");";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdpedidodetalle())
      {
        $a_Fields = array();

        if(!is_null($this->getIdpedidodetalle())) : $a_Fields['idpedidodetalle'] = ($this->getIdpedidodetalle()); endif;
        if(!is_null($this->getIdpedidocabecera())) : $a_Fields['idpedidocabecera'] = ($this->getIdpedidocabecera()); endif;
        if(!is_null($this->getTipocodigo())) : $a_Fields['tipocodigo'] = ($this->getTipocodigo()); endif;
        if(!is_null($this->getIdcliente())) : $a_Fields['idcliente'] = ($this->getIdcliente()); endif;
        if(!is_null($this->getCodigocliente())) : $a_Fields['idprestamo'] = ($this->getCodigocliente()); endif;
        if(!is_null($this->getNombrecompleto())) : $a_Fields['nombrecompleto'] = ($this->getNombrecompleto()); endif;
        if(!is_null($this->getFechaentrega())) : $a_Fields['fechaentrega'] = ($this->getFechaentrega()); endif;
        
        if(!is_null($this->getMontoreferencia())) : $a_Fields['montoreferencia'] = ($this->getMontoreferencia()); endif;
        
        if(!is_null($this->getMontoprestado())) : $a_Fields['montoprestado'] = ($this->getMontoprestado()); endif;
        if(!is_null($this->getCuotapago())) : $a_Fields['cuotapago'] = ($this->getCuotapago()); endif;
        if(!is_null($this->getMontototal())) : $a_Fields['montototal'] = ($this->getMontototal()); endif;
        if(!is_null($this->getInteresmonto())) : $a_Fields['interesmonto'] = ($this->getInteresmonto()); endif;
        if(!is_null($this->getInteresporcentaje())) : $a_Fields['interesporcentaje'] = ($this->getInteresporcentaje()); endif;
        if(!is_null($this->getDuracion())) : $a_Fields['duracion'] = ($this->getDuracion()); endif;
        if(!is_null($this->getNrocuotas())) : $a_Fields['nrocuotas'] = ($this->getNrocuotas()); endif;
        if(!is_null($this->getEstado())) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if(!is_null($this->getFechainicio())) : $a_Fields['fechainicio'] = ($this->getFechainicio()); endif;
        if(!is_null($this->getFechavencimiento())) : $a_Fields['fechavencimiento'] = ($this->getFechavencimiento()); endif;
        if(!is_null($this->getGastoadministrativo())) : $a_Fields['gastoadministrativo'] = ($this->getGastoadministrativo()); endif;
        if(!is_null($this->getIdcolaborador())) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if(!is_null($this->getTurno())) : $a_Fields['turno'] = ($this->getTurno()); endif;
        if(!is_null($this->getObservacion())) : $a_Fields['observacion'] = ($this->getObservacion()); endif;
        if(!is_null($this->getUsuariocreacion())) : $a_Fields['usuariocreacion'] = ($this->getUsuariocreacion()); endif;
        if(!is_null($this->getFechacreacion())) : $a_Fields['fechacreacion'] = ($this->getFechacreacion()); endif;
        if(!is_null($this->getUsuariomodificacion())) : $a_Fields['usuariomodificacion'] = ($this->getUsuariomodificacion()); endif;
        if(!is_null($this->getFechamodificacion())) : $a_Fields['fechamodificacion'] = ($this->getFechamodificacion()); endif;
        if(!is_null($this->getUsuarioeliminacion())) : $a_Fields['usuarioeliminacion'] = ($this->getUsuarioeliminacion()); endif;
        if(!is_null($this->getFechaeliminacion())) : $a_Fields['fechaeliminacion'] = ($this->getFechaeliminacion()); endif;
        if(!is_null($this->getEliminado())) : $a_Fields['eliminado'] = ($this->getEliminado()); endif;
        if(!is_null($this->getPeriodicidadpago())) : $a_Fields['periodicidadpago'] = ($this->getPeriodicidadpago()); endif;
        if(!is_null($this->getSaldoprestamo())) : $a_Fields['saldoprestamo'] = ($this->getSaldoprestamo()); endif;
        if(!is_null($this->getEntregado())) : $a_Fields['entregado'] = ($this->getEntregado()); endif;
        if(!is_null($this->getFechaentregado())) : $a_Fields['fechaentregado'] = ($this->getFechaentregado()); endif;
        if(!is_null($this->getUsuarioentregado())) : $a_Fields['usuarioentregado'] = ($this->getUsuarioentregado()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE cr_pedidodetalle SET ".$sStringField." WHERE 1 AND idpedidodetalle='".$this->getIdpedidodetalle()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdpedidodetalle())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM cr_pedidodetalle WHERE 1 AND idpedidodetalle='".$this->getIdpedidodetalle()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* Bsqueda del registro por la llave primaria */
  public static function selectByPK($vIdpedidodetalle)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idpedidodetalle, idpedidocabecera, tipocodigo, idcliente, idprestamo, nombrecompleto, fechaentrega, montoprestado, cuotapago, montototal, interesmonto, interesporcentaje, duracion, nrocuotas, estado, fechainicio, fechavencimiento, gastoadministrativo, idcolaborador, turno, observacion, usuariocreacion, fechacreacion, usuariomodificacion, fechamodificacion, usuarioeliminacion, fechaeliminacion, eliminado, periodicidadpago, saldoprestamo, entregado, fechaentregado, usuarioentregado, montoreferencia FROM cr_pedidodetalle WHERE 1 AND idpedidodetalle='".$vIdpedidodetalle."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con mtodos de acceso */
  private function insertObjectBN($o_propel){
    $o_CrPedidodetalleDP = new CrPedidodetalleDP();
    $o_CrPedidodetalleDP->setIdpedidodetalle($o_propel->idpedidodetalle);
    $o_CrPedidodetalleDP->setIdpedidocabecera($o_propel->idpedidocabecera);
    $o_CrPedidodetalleDP->setTipocodigo($o_propel->tipocodigo);
    $o_CrPedidodetalleDP->setIdcliente($o_propel->idcliente);
    $o_CrPedidodetalleDP->setCodigocliente($o_propel->idprestamo);
    $o_CrPedidodetalleDP->setNombrecompleto($o_propel->nombrecompleto);
    $o_CrPedidodetalleDP->setFechaentrega($o_propel->fechaentrega);
    $o_CrPedidodetalleDP->setMontoprestado($o_propel->montoprestado);
    
    $o_CrPedidodetalleDP->setMontoreferencia($o_propel->montoreferencia);
    
    $o_CrPedidodetalleDP->setCuotapago($o_propel->cuotapago);
    $o_CrPedidodetalleDP->setMontototal($o_propel->montototal);
    $o_CrPedidodetalleDP->setInteresmonto($o_propel->interesmonto);
    $o_CrPedidodetalleDP->setInteresporcentaje($o_propel->interesporcentaje);
    $o_CrPedidodetalleDP->setDuracion($o_propel->duracion);
    $o_CrPedidodetalleDP->setNrocuotas($o_propel->nrocuotas);
    $o_CrPedidodetalleDP->setEstado($o_propel->estado);
    $o_CrPedidodetalleDP->setFechainicio($o_propel->fechainicio);
    $o_CrPedidodetalleDP->setFechavencimiento($o_propel->fechavencimiento);
    $o_CrPedidodetalleDP->setGastoadministrativo($o_propel->gastoadministrativo);
    $o_CrPedidodetalleDP->setIdcolaborador($o_propel->idcolaborador);
    $o_CrPedidodetalleDP->setTurno($o_propel->turno);
    $o_CrPedidodetalleDP->setObservacion($o_propel->observacion);
    $o_CrPedidodetalleDP->setUsuariocreacion($o_propel->usuariocreacion);
    $o_CrPedidodetalleDP->setFechacreacion($o_propel->fechacreacion);
    $o_CrPedidodetalleDP->setUsuariomodificacion($o_propel->usuariomodificacion);
    $o_CrPedidodetalleDP->setFechamodificacion($o_propel->fechamodificacion);
    $o_CrPedidodetalleDP->setUsuarioeliminacion($o_propel->usuarioeliminacion);
    $o_CrPedidodetalleDP->setFechaeliminacion($o_propel->fechaeliminacion);
    $o_CrPedidodetalleDP->setEliminado($o_propel->eliminado);
    $o_CrPedidodetalleDP->setPeriodicidadpago($o_propel->periodicidadpago);
    $o_CrPedidodetalleDP->setSaldoprestamo($o_propel->saldoprestamo);
    $o_CrPedidodetalleDP->setEntregado($o_propel->entregado);
    $o_CrPedidodetalleDP->setFechaentregado($o_propel->fechaentregado);
    $o_CrPedidodetalleDP->setUsuarioentregado($o_propel->usuarioentregado);
    return $o_CrPedidodetalleDP;
  }
}