<?php
/**
 * Clase Base DP para BaseCrCovid19detalleDP
 *
 * @package    
 * @subpackage BaseCrCovid19detalleDP
 * @author     Willy
 * @version    SVN:: BaseCrCovid19detalleDP.class.php,v 1.1 2020-04-15 14:48:11 william.taype Exp $
 */
abstract class BaseCrCovid19detalleDP extends CrCovid19detalleBN
{
  /* N�mero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof CrCovid19detalleBN )
    {
      $o_CrCovid19detalleBN = $bSetDefault;
      if($o_CrCovid19detalleBN->getIdsucursal()) : $this->setIdsucursal($o_CrCovid19detalleBN->getIdsucursal()); endif;
      if($o_CrCovid19detalleBN->getIdmercado()) : $this->setIdmercado($o_CrCovid19detalleBN->getIdmercado()); endif;
      if($o_CrCovid19detalleBN->getIdprestamo()) : $this->setIdprestamo($o_CrCovid19detalleBN->getIdprestamo()); endif;
      if($o_CrCovid19detalleBN->getFechavencimientoanterior()) : $this->setFechavencimientoanterior($o_CrCovid19detalleBN->getFechavencimientoanterior()); endif;
      if($o_CrCovid19detalleBN->getFechavencimientonuevo()) : $this->setFechavencimientonuevo($o_CrCovid19detalleBN->getFechavencimientonuevo()); endif;
      if($o_CrCovid19detalleBN->getDiasdiferencia()) : $this->setDiasdiferencia($o_CrCovid19detalleBN->getDiasdiferencia()); endif;
      if($o_CrCovid19detalleBN->getFecharegistro()) : $this->setFecharegistro($o_CrCovid19detalleBN->getFecharegistro()); endif;
      if($o_CrCovid19detalleBN->getUsuarioregistro()) : $this->setUsuarioregistro($o_CrCovid19detalleBN->getUsuarioregistro()); endif;
    }
  }

  /* Obtiene el n�mero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      

      if($this->getIdsucursal() && $this->getIdmercado() && $this->getIdprestamo()){
        $a_Fields = array();

        if($this->getIdsucursal()) : $a_Fields['idsucursal'] = ($this->getIdsucursal()); endif;
        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getIdprestamo()) : $a_Fields['idprestamo'] = ($this->getIdprestamo()); endif;
        if($this->getFechavencimientoanterior()) : $a_Fields['fechavencimientoanterior'] = ($this->getFechavencimientoanterior()); endif;
        if($this->getFechavencimientonuevo()) : $a_Fields['fechavencimientonuevo'] = ($this->getFechavencimientonuevo()); endif;
        if($this->getDiasdiferencia()) : $a_Fields['diasdiferencia'] = ($this->getDiasdiferencia()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO cr_covid19detalle (".$sStringField.") VALUES (".$sStringValue.");";
        $result = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $con->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdsucursal() && $this->getIdmercado() && $this->getIdprestamo())
      {
        $a_Fields = array();

        if($this->getIdsucursal()) : $a_Fields['idsucursal'] = ($this->getIdsucursal()); endif;
        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getIdprestamo()) : $a_Fields['idprestamo'] = ($this->getIdprestamo()); endif;
        if($this->getFechavencimientoanterior()) : $a_Fields['fechavencimientoanterior'] = ($this->getFechavencimientoanterior()); endif;
        if($this->getFechavencimientonuevo()) : $a_Fields['fechavencimientonuevo'] = ($this->getFechavencimientonuevo()); endif;
        if($this->getDiasdiferencia()) : $a_Fields['diasdiferencia'] = ($this->getDiasdiferencia()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE cr_covid19detalle SET ".$sStringField." WHERE 1 AND idsucursal='".$this->getIdsucursal()."' AND idmercado='".$this->getIdmercado()."' AND idprestamo='".$this->getIdprestamo()."';";
        $result = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $con->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdsucursal() && $this->getIdmercado() && $this->getIdprestamo())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM cr_covid19detalle WHERE 1 AND idsucursal='".$this->getIdsucursal()."' AND idmercado='".$this->getIdmercado()."' AND idprestamo='".$this->getIdprestamo()."';"; 
        $result = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $con->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* B�squeda del registro por la llave primaria */
  public static function selectByPK($vIdsucursal, $vIdmercado, $vIdprestamo)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idsucursal, idmercado, idprestamo, fechavencimientoanterior, fechavencimientonuevo, diasdiferencia, fecharegistro, usuarioregistro FROM cr_covid19detalle WHERE 1 AND idsucursal='".$vIdsucursal."' AND idmercado='".$vIdmercado."' AND idprestamo='".$vIdprestamo."'; ";
        $result = $con->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_CrCovid19detalleDP = new CrCovid19detalleDP();
    $o_CrCovid19detalleDP->setIdsucursal($o_propel->idsucursal);
    $o_CrCovid19detalleDP->setIdmercado($o_propel->idmercado);
    $o_CrCovid19detalleDP->setIdprestamo($o_propel->idprestamo);
    $o_CrCovid19detalleDP->setFechavencimientoanterior($o_propel->fechavencimientoanterior);
    $o_CrCovid19detalleDP->setFechavencimientonuevo($o_propel->fechavencimientonuevo);
    $o_CrCovid19detalleDP->setDiasdiferencia($o_propel->diasdiferencia);
    $o_CrCovid19detalleDP->setFecharegistro($o_propel->fecharegistro);
    $o_CrCovid19detalleDP->setUsuarioregistro($o_propel->usuarioregistro);
    return $o_CrCovid19detalleDP;
  }
}