<?php

/**
* Clase Dispacher para CapitalInicial
*
* @package IM
* @subpackage CapitalInicialDP
* @author Willy
* @version SVN: : CapitalInicialDP.class.php,v 1.1 2009/05/29 10:26:29 Exp $
*/
class CapitalInicialDP implements interfaceDP {

  protected $o_Bean;

  /**
  * Constructor donde asigna a un atributo el objeto CapitalInicialBean
  *
  * @param CapitalInicialBean $o_CapitalInicialBean
  */
  public function __construct(CapitalInicialBean $o_CapitalInicialBean){
  
    $this->o_Bean = $o_CapitalInicialBean;
    
  }
  
  /**
  * Retorna el objeto CapitalInicialBean
  *
  * @return Object
  */
  protected function getObjetoBean(){
  
    if(!$this->o_Bean){
        $this->o_Bean = new CapitalInicialBean();
    }        
    return $this->o_Bean;
    
  }
  
  /**
  * Ingresa un nuevo registro
  *
  * @return IdGenerado
  */
   public function save(){
    $con = Conexion::getConexion();
      $a_Fields = array();
      
      if($this->getObjetoBean()->getIdCapitalInicial()) : $a_Fields['IdCapitalInicial'] = ($this->getObjetoBean()->getIdCapitalInicial()); endif;
      if($this->getObjetoBean()->getIdColaborador()) : $a_Fields['IdColaborador'] = ($this->getObjetoBean()->getIdColaborador()); endif;
      if($this->getObjetoBean()->getMonto()) : $a_Fields['Monto'] = ($this->getObjetoBean()->getMonto()); endif;
      if($this->getObjetoBean()->getFecha()) : $a_Fields['Fecha'] = ($this->getObjetoBean()->getFecha()); endif;
      if($this->getObjetoBean()->getEliminado()) : $a_Fields['Eliminado'] = ($this->getObjetoBean()->getEliminado()); endif;
      if($this->getObjetoBean()->getEstado()) : $a_Fields['Estado'] = ($this->getObjetoBean()->getEstado()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getUsuarioModificacion()) : $a_Fields['UsuarioModificacion'] = ($this->getObjetoBean()->getUsuarioModificacion()); endif;
      if($this->getObjetoBean()->getFechaModificacion()) : $a_Fields['FechaModificacion'] = ($this->getObjetoBean()->getFechaModificacion()); endif;
      if($this->getObjetoBean()->getFechaEliminado()) : $a_Fields['FechaEliminado'] = ($this->getObjetoBean()->getFechaEliminado()); endif;
      if($this->getObjetoBean()->getUsuarioEliminado()) : $a_Fields['UsuarioEliminado'] = ($this->getObjetoBean()->getUsuarioEliminado()); endif;
  
      
      $sStringField = arrayClass::implode_keys(',', $a_Fields);
      $sStringValue = "'".implode("','", $a_Fields)."'";

      $sql = "INSERT INTO cr_capital_inicial (".$sStringField.")
                      VALUES (".$sStringValue.");";
      //echo $sql;
      $iResultSave = $con->query($sql);
      $iResultSave = $con->lastInsertId();
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }
  
  }
  
  
  /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
  
  public function update() {

    if($this->getObjetoBean()->getIdCapitalInicial()){
      $con = Conexion::getConexion();
      $a_Fields = array();
      
      if($this->getObjetoBean()->getIdCapitalInicial()) : $a_Fields['IdCapitalInicial'] = ($this->getObjetoBean()->getIdCapitalInicial()); endif;
      if($this->getObjetoBean()->getIdColaborador()) : $a_Fields['IdColaborador'] = ($this->getObjetoBean()->getIdColaborador()); endif;
      if($this->getObjetoBean()->getMonto()) : $a_Fields['Monto'] = ($this->getObjetoBean()->getMonto()); endif;
      if($this->getObjetoBean()->getFecha()) : $a_Fields['Fecha'] = ($this->getObjetoBean()->getFecha()); endif;
      if($this->getObjetoBean()->getEliminado()) : $a_Fields['Eliminado'] = ($this->getObjetoBean()->getEliminado()); endif;
      if($this->getObjetoBean()->getEstado()) : $a_Fields['Estado'] = ($this->getObjetoBean()->getEstado()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getUsuarioModificacion()) : $a_Fields['UsuarioModificacion'] = ($this->getObjetoBean()->getUsuarioModificacion()); endif;
      if($this->getObjetoBean()->getFechaModificacion()) : $a_Fields['FechaModificacion'] = ($this->getObjetoBean()->getFechaModificacion()); endif;
      if($this->getObjetoBean()->getFechaEliminado()) : $a_Fields['FechaEliminado'] = ($this->getObjetoBean()->getFechaEliminado()); endif;
      if($this->getObjetoBean()->getUsuarioEliminado()) : $a_Fields['UsuarioEliminado'] = ($this->getObjetoBean()->getUsuarioEliminado()); endif;
      
      $sString = arrayClass::implode_key_value(",", $a_Fields);

      $sql = "UPDATE cr_capital_inicial  SET
                  ".$sString."
            WHERE 1 AND IdCapitalInicial= '".$this->getObjetoBean()->getIdCapitalInicial()."' ";
      
      $result = $con->query($sql);
      
      //echo $sql;           
      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

    }else{
      return false;
    }

  }
  

  /**
  * Elimina registro
  *
  * @return Boolean
  */
  public function delete(){
    
      $o_CapitalInicial = new CapitalInicialBean();
      
      $con = Conexion::getConexion();
      
      if($this->getObjetoBean()->getIdCapitalInicial()){
          $o_CapitalInicial->setIdCapitalInicial($this->getObjetoBean()->getIdCapitalInicial());
      }
            
      $sql = "UPDATE cr_capital_inicial 
              SET
                Eliminado = '1',
                FechaEliminado = '".date('Y-m-d H:i:s')."',
                UsuarioEliminado = '".$this->getObjetoBean()->getUsuarioEliminado()."'
            WHERE IdCapitalInicial= '".$this->getObjetoBean()->getIdCapitalInicial()."' ";
      
      $result = $con->query($sql);
      
      $num_rows = $result->rowCount();
      
                  
      $iResultDelete = $num_rows;
      if($iResultDelete){
          return 1;
      }else{
          return false;
      }    
    
  }
  /**
  * Selecciona un nuevo registro
  *
  * @return IdGenerado
  */
  
  public function select(){
    $tamPag           = is_null($this->getObjetoBean()->tamPag)?1:$this->getObjetoBean()->tamPag;
    $pagina           = is_null($this->getObjetoBean()->page)?1:$this->getObjetoBean()->page;
    $numeroRegistros  = $this->selectNumRows();
    $limitInf         = ($pagina-1)*$tamPag;
    
    $where = $this->buildConsult();
    $orden = $this->buildOrderByField();
    
    $con = Conexion::getConexion();
    $sql = "SELECT ci.IdCapitalInicial, ci.IdColaborador, co.Nombres, co.ApellidoPaterno, co.ApellidoMaterno, ci.Monto,ci.Estado,ci.Fecha,ci.UsuarioCreacion, ci.FechaCreacion
             FROM cr_capital_inicial ci LEFT JOIN cr_colaborador co ON co.IdColaborador = ci.IdColaborador 
            WHERE ci.Eliminado <> '1' ".
            $where." ".$orden." LIMIT ".$limitInf.",".$tamPag;
    
   // echo $sql;
    $result = $con->query($sql);
    $num_rows = $result->rowCount();

    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      $a_tmp[] = $this->insertarObjetoBean($o_valor);
      }
    }

    
   
    return count($a_tmp)>0?$a_tmp:null;
      
  }
  
  
  public function buildOrderByField(){
    $order_by = "";
    if($this->getObjetoBean()->sortCampos || $this->getObjetoBean()->sortCampos != ""){
      $a_valCampos = explode(";", $this->getObjetoBean()->sortCampos);
      $a_valtype   = explode(";", $this->getObjetoBean()->sortType);
      $order_by = " ORDER BY ";
      $a_order = array();
      foreach ($a_valCampos as $key => $val){
        $sTmpOrder = "";
        if(array_key_exists($val, self::$fieldNames)){
          $sTmpOrder .= self::$fieldNames[$val];
          switch ($a_valtype[$key]){
            case 1: $sTmpOrder .= " ASC"; break;
            case 2: $sTmpOrder .= " DESC"; break;
          }
          $a_order[] = $sTmpOrder;
        }
      }
      $order_by .= implode(", ", $a_order);
    }
    return $order_by;
  }
  
  
  /**
  * Retorna un objeto CapitalInicialBean
  *
  * @return Object
  */
  public function selectByPk(){
  
    $con = Conexion::getConexion();
    $sql = " SELECT ci.IdCapitalInicial, ci.IdColaborador, co.Nombres, co.ApellidoPaterno, co.ApellidoMaterno, ci.Monto,ci.Estado,ci.Fecha,ci.UsuarioModificacion, ci.FechaModificacion FROM cr_capital_inicial ci
             left join cr_colaborador co on ci.idcolaborador = co.idcolaborador
    		 WHERE  ci.Eliminado <> '1' and IdCapitalInicial='".$this->getObjetoBean()->getIdCapitalInicial()."' ";
    $result = $con->query($sql);
    $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
    
    //echo $sql;
    return $o_Propel?$this->insertarObjetoBean($o_Propel):null;
  
  }
  
   
  /**
  * Reasigna valores retornados del propel a un objeto CapitalInicialBean
  *
  * @param Object $o_Propel
  * @return CapitalInicialBean
  */
  private function insertarObjetoBean($o_Propel){

    $o_CapitalInicialBean = new CapitalInicialBean();
    
    $o_CapitalInicialBean->setIdCapitalInicial($o_Propel->IdCapitalInicial);
    $o_CapitalInicialBean->setIdColaborador($o_Propel->IdColaborador);
    $o_CapitalInicialBean->setNombres($o_Propel->Nombres);
    $o_CapitalInicialBean->setMonto($o_Propel->Monto);
    $o_CapitalInicialBean->setFecha($o_Propel->Fecha);
    $o_CapitalInicialBean->setEstado($o_Propel->Estado);
    $o_CapitalInicialBean->setEliminado($o_Propel->Eliminado);
    $o_CapitalInicialBean->setUsuarioCreacion($o_Propel->UsuarioCreacion);
    $o_CapitalInicialBean->setFechaCreacion($o_Propel->FechaCreacion);
    $o_CapitalInicialBean->setUsuarioModificacion($o_Propel->UsuarioModificacion);
    $o_CapitalInicialBean->setFechaModificacion($o_Propel->FechaModificacion);
    $o_CapitalInicialBean->setFechaEliminado($o_Propel->FechaEliminado);
    $o_CapitalInicialBean->setUsuarioEliminado($o_Propel->UsuarioEliminado);
    $o_CapitalInicialBean->setNombreCompleto($o_Propel->ApellidoPaterno." ".$o_Propel->ApellidoMaterno." ".$o_Propel->Nombres);
     
         
    return $o_CapitalInicialBean;    
    
  }
  
 public function selectNumRows(){
    
    $where = $this->buildConsult();
    
    $con = Conexion::getConexion();
    $sql = "SELECT * FROM cr_capital_inicial ci
             left join cr_colaborador co on ci.idcolaborador = co.idcolaborador
     		WHERE ci.Eliminado <> '1'".$where;
   
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    
    
   
    return $num_rows;
    
  }
  
  public function selectAppCI($idcolaborador,$fecha,$usuario){
    
    $con = Conexion::getConexion();
    $where = " and idcolaborador ='".$idcolaborador."'";
    $where .= " and fecha ='".$fecha."'";
    $sql = "SELECT *
             FROM cr_capital_inicial           
            WHERE Eliminado <> '1' ".
            $where." ";
    
   // echo $sql;
    $result = $con->query($sql);
    $num_rows = $result->rowCount();

    $a_tmp = array();

    if($num_rows > 0){
      while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      	$a_tmp[$o_valor->IdCapitalInicial] = ($o_valor->Monto);
      }
    }else{
    	// Crear para inicalizar
    	
		$o_ci_bn = new CapitalInicialBean();
		$o_ci_bn->setIdColaborador($idcolaborador);
		$o_ci_bn->setMonto("0.00");
		$o_ci_bn->setFecha($fecha); 
		$o_ci_bn->setEstado("A");
		$o_ci_bn->setUsuarioCreacion($usuario);
		$o_ci_bn->setFechaCreacion(date("Y-m-d H:i:s"));
		$oci_dp = new CapitalInicialDP($o_ci_bn);
		$idCapitalinicial = $oci_dp->save();
		$a_tmp[$idCapitalinicial] = "";
    }
   
    return count($a_tmp)>0?$a_tmp:null;
      
  }
  
   public function selectTotalMonto(){
    
    $where = $this->buildConsult();
    
    $con = Conexion::getConexion();
    $sql = "SELECT sum(Monto) as MONTO
    		FROM cr_capital_inicial ci
             left join cr_colaborador co on ci.idcolaborador = co.idcolaborador
     		WHERE ci.Eliminado <> '1'".$where;
   
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    
     while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      $monto_total = $o_valor->MONTO;
      }
    
    
   
    return $monto_total;
    
  }
  
   private function buildConsult(){
    
    $where = "";
    
    if($this->getObjetoBean()->getIdCapitalInicial()){
       $where .= " AND IdCapitalInicial  = '".$this->getObjetoBean()->getIdCapitalInicial()."'";
    }
    if($this->getObjetoBean()->getIdColaborador()){
      
       $where .= " AND ci.IdColaborador= '".$this->getObjetoBean()->getIdColaborador()."'";
       
    }
   if($this->getObjetoBean()->getFecha()){
      	 $where .= " AND Fecha >= '".$this->getObjetoBean()->getFecha()."'";
    }
    
    if($this->getObjetoBean()->getFechaFinal()){
      	 $where .= " AND Fecha <= '".$this->getObjetoBean()->getFechaFinal()."'";
    }
    if($this->getObjetoBean()->getEstado()){
        $where .= " AND ci.Estado  = '".$this->getObjetoBean()->getEstado()."'";
    }
    
    if(is_array($this->getObjetoBean()->getIdColaboradores())){
      	 $where .= " AND ci.IdColaborador in ('".implode("','",$this->getObjetoBean()->getIdColaboradores())."')";
    }
    /*
    if($this->getObjetoBean()->getApellidoMaterno()){
       $where .= " AND ApellidoMaterno like '".$this->getObjetoBean()->getApellidoMaterno()."%'";
    }
	 if($this->getObjetoBean()->getDni()){
       $where .= " AND dni like '".$this->getObjetoBean()->getDni()."%'";
    }*/
    return $where;
    
  } 
  
  function selectResultset(){
    
    $tamPag           = is_null($this->getObjetoBean()->tamPag)?9999:$this->getObjetoBean()->tamPag;
    $pagina           = is_null($this->getObjetoBean()->page)?1:$this->getObjetoBean()->page;
    $numeroRegistros  = $this->selectNumRows();
    $limitInf         = ($pagina-1)*$tamPag;
    
    $where = $this->buildConsult();
    
    
    $con = Conexion::getConexion();
    $sql = "SELECT * FROM cr_capital_inicial ci
            left join cr_colaborador co on ci.idcolaborador = co.idcolaborador
            WHERE ci.Eliminado <> '1' ".
            $where." ".$orden." LIMIT ".$limitInf.",".$tamPag;
    
    //echo $sql;
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    
    

    $a_tmp = array();

    if($num_rows>0){
      
      return $result;
      
    }else{
      return null;
    }
        
  }
}

