<?php
/**
 * Clase ContGastoOperativoer para GastoOperativo
 *
 * @package    IM
 * @subpackage GastoOperativoCT
 * @author     Willy
 * @version    SVN: $Id: GastoOperativoCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class GastoOperativoCT implements interfaceCT{
  /**
  * Funci�n para Guardar el  GastoOperativo
  *
  * @param $o_GastoOperativoBean, objeto bean de GastoOperativo
  * @return booleam
  */
  public function guardar(&$o_GastoOperativoBean){ 
    
    $o_GastoOperativoDP = new GastoOperativoDP($o_GastoOperativoBean);
    return $o_GastoOperativoDP->save();
    
  }
  
  /**
  * Funci�n para Modificar el  GastoOperativo
  *
  * @param $o_GastoOperativoBean, objeto bean de GastoOperativo
  * @return booleam
  */
  public function modificar(&$o_GastoOperativoBean){
    
    $o_GastoOperativoDP = new GastoOperativoDP($o_GastoOperativoBean);
    return $o_GastoOperativoDP->update();
    
  }
  
  /**
  * Funci�n para Eliminar el  GastoOperativo
  *
  * @param $o_GastoOperativoBean, objeto bean de GastoOperativo
  * @return booleam
  */
  public function eliminar($o_GastoOperativoBean){ 
    $o_GastoOperativoDP = new GastoOperativoDP($o_GastoOperativoBean);
    return $o_GastoOperativoDP->delete();
  }
  
  
  public function totalRegistros($o_GastoOperativoBean){
    $o_GastoOperativoBeanDP = new GastoOperativoDP($o_GastoOperativoBean);
    return $o_GastoOperativoBeanDP->selectNumRows();
    
  }
  
   public function totalMonto($o_GastoOperativoBean){
    $o_GastoOperativoBeanDP = new GastoOperativoDP($o_GastoOperativoBean);
    return $o_GastoOperativoBeanDP->selectTotalMonto();
    
  }
  
  
  /**
  * Funci�n para Seleccionar el  GastoOperativo
  *
  * @param $o_GastoOperativoBeans, objeto bean de GastoOperativo
  * @return booleam
  */
  public function seleccionar($o_GastoOperativoBean){
  
    $o_GastoOperativoDP = new GastoOperativoDP($o_GastoOperativoBean);
    if($o_GastoOperativoBean->getIdGastoOperativo()){
      return $o_GastoOperativoDP->selectByPk();
    }else{
      return $o_GastoOperativoDP->select();
    }
      
  }
  
}