<?php
/**
 * Clase ContGastosGeneraleser para GastosGenerales
 *
 * @package    IM
 * @subpackage GastosGeneralesCT
 * @author     Willy
 * @version    SVN: $Id: GastosGeneralesCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class GastosGeneralesCT implements interfaceCT{
  /**
  * Funcin para Guardar el  GastosGenerales
  *
  * @param $o_GastosGeneralesBean, objeto bean de GastosGenerales
  * @return booleam
  */
  public function guardar(&$o_GastosGeneralesBean){ 
    
    $o_GastosGeneralesDP = new GastosGeneralesDP($o_GastosGeneralesBean);
    return $o_GastosGeneralesDP->save();
    
  }
  
  /**
  * Funcin para Modificar el  GastosGenerales
  *
  * @param $o_GastosGeneralesBean, objeto bean de GastosGenerales
  * @return booleam
  */
  public function modificar(&$o_GastosGeneralesBean){
    
    $o_GastosGeneralesDP = new GastosGeneralesDP($o_GastosGeneralesBean);
    return $o_GastosGeneralesDP->update();
    
  }
  
  /**
  * Funcin para Eliminar el  GastosGenerales
  *
  * @param $o_GastosGeneralesBean, objeto bean de GastosGenerales
  * @return booleam
  */
  public function eliminar($o_GastosGeneralesBean){ 
    $o_GastosGeneralesDP = new GastosGeneralesDP($o_GastosGeneralesBean);
    return $o_GastosGeneralesDP->delete();
  }
  
  
  public function totalRegistros($o_GastosGeneralesBean){
    $o_GastosGeneralesBeanDP = new GastosGeneralesDP($o_GastosGeneralesBean);
    return $o_GastosGeneralesBeanDP->selectNumRows();
    
  }
  
  
  /**
  * Funcin para Seleccionar el  GastosGenerales
  *
  * @param $o_GastosGeneralesBeans, objeto bean de GastosGenerales
  * @return booleam
  */
  public function seleccionar($o_GastosGeneralesBean){
  
    $o_GastosGeneralesDP = new GastosGeneralesDP($o_GastosGeneralesBean);
    if($o_GastosGeneralesBean->getIdGasto()){
      return $o_GastosGeneralesDP->selectByPk();
    }else{
      return $o_GastosGeneralesDP->select();
    }
      
  }
  
}