<?php
/**
 * Clase ContCierrePedidoer para CierrePedido
 *
 * @package    IM
 * @subpackage CierrePedidoCT
 * @author     Willy
 * @version    SVN: $Id: CierrePedidoCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class CierrePedidoCT implements interfaceCT{
  /**
  * Funci�n para Guardar el  CierrePedido
  *
  * @param $o_CierrePedidoBean, objeto bean de CierrePedido
  * @return booleam
  */
  public function guardar(&$o_CierrePedidoBean){ 
    
    $o_CierrePedidoDP = new CierrePedidoDP($o_CierrePedidoBean);
    return $o_CierrePedidoDP->save();
    
  }
  
  /**
  * Funci�n para Modificar el  CierrePedido
  *
  * @param $o_CierrePedidoBean, objeto bean de CierrePedido
  * @return booleam
  */
  public function modificar(&$o_CierrePedidoBean){
    
    $o_CierrePedidoDP = new CierrePedidoDP($o_CierrePedidoBean);
    return $o_CierrePedidoDP->update();
    
  }
  
  /**
  * Funci�n para Eliminar el  CierrePedido
  *
  * @param $o_CierrePedidoBean, objeto bean de CierrePedido
  * @return booleam
  */
  public function eliminar($o_CierrePedidoBean){ 
    $o_CierrePedidoDP = new CierrePedidoDP($o_CierrePedidoBean);
    return $o_CierrePedidoDP->delete();
  }
  
  
  public function totalRegistros($o_CierrePedidoBean){
    $o_CierrePedidoBeanDP = new CierrePedidoDP($o_CierrePedidoBean);
    return $o_CierrePedidoBeanDP->selectNumRows();
    
  }
  
   public function totalRegistrosCC($o_CierrePedidoBean){
    $o_CierrePedidoBeanDP = new CierrePedidoDP($o_CierrePedidoBean);
    return $o_CierrePedidoBeanDP->selectNumRowsCC();
    
  }
  
  
  /**
  * Funci�n para Seleccionar el  CierrePedido
  *
  * @param $o_CierrePedidoBeans, objeto bean de CierrePedido
  * @return booleam
  */
  public function seleccionar($o_CierrePedidoBean){
  
    $o_CierrePedidoDP = new CierrePedidoDP($o_CierrePedidoBean);
    if($o_CierrePedidoBean->getIdGasto()){
      return $o_CierrePedidoDP->selectByPk();
    }else{
      return $o_CierrePedidoDP->select();
    }
      
  }
  
}