<?php

/**
* Clase Dispacher para BalanceDia
*
* @package IM
* @subpackage BalanceDiaDP
* @author Willy
* @version SVN: : BalanceDiaDP.class.php,v 1.1 2009/06/23 22:29:18 Exp $
*/
class BalanceDiaDP implements interfaceDP {

  protected $o_Bean;

  /**
  * Constructor donde asigna a un atributo el objeto BalanceDiaBean
  *
  * @param BalanceDiaBean $o_BalanceDiaBean
  */
  public function __construct(BalanceDiaBean $o_BalanceDiaBean){
  
    $this->o_Bean = $o_BalanceDiaBean;
    
  }
  
  /**
  * Retorna el objeto BalanceDiaBean
  *
  * @return Object
  */
  protected function getObjetoBean(){
  
    if(!$this->o_Bean){
        $this->o_Bean = new BalanceDiaBean();
    }        
    return $this->o_Bean;
    
  }
  
  /**
  * Ingresa un nuevo registro
  *
  * @return IdGenerado
  */
  public function save(){

      $con = Conexion::getConexion();
    
      $a_Fields = array();

      if($this->getObjetoBean()->getIdSucursal()) : $a_Fields['IdSucursal'] = ($this->getObjetoBean()->getIdSucursal()); endif;
      if($this->getObjetoBean()->getNombreSucursal()) : $a_Fields['NombreSucursal'] = ($this->getObjetoBean()->getNombreSucursal()); endif;
      if($this->getObjetoBean()->getFechaBalance()) : $a_Fields['FechaBalance'] = ($this->getObjetoBean()->getFechaBalance()); endif;
      if($this->getObjetoBean()->getIdColaborador()) : $a_Fields['IdColaborador'] = ($this->getObjetoBean()->getIdColaborador()); endif;
      if($this->getObjetoBean()->getNombreColaborador()) : $a_Fields['NombreColaborador'] = ($this->getObjetoBean()->getNombreColaborador()); endif;
      if($this->getObjetoBean()->getDescripcion()) : $a_Fields['Descripcion'] = ($this->getObjetoBean()->getDescripcion()); endif;
      if($this->getObjetoBean()->getTotalCaja()) : $a_Fields['TotalCaja'] = ($this->getObjetoBean()->getTotalCaja()); endif;
      if($this->getObjetoBean()->getTotalPrestamos()) : $a_Fields['TotalPrestamos'] = ($this->getObjetoBean()->getTotalPrestamos()); endif;
      if($this->getObjetoBean()->getSaldoPrestamos()) : $a_Fields['SaldoPrestamos'] = ($this->getObjetoBean()->getSaldoPrestamos()); endif;
      if($this->getObjetoBean()->getIndicePagos()) : $a_Fields['IndicePagos'] = ($this->getObjetoBean()->getIndicePagos()); endif;
      if($this->getObjetoBean()->getTotalPagos()) : $a_Fields['TotalPagos'] = ($this->getObjetoBean()->getTotalPagos()); endif;
      if($this->getObjetoBean()->getTotalPagosMora()) : $a_Fields['TotalPagosMora'] = ($this->getObjetoBean()->getTotalPagosMora()); endif;
      if($this->getObjetoBean()->getTotalSobrantes()) : $a_Fields['TotalSobrantes'] = ($this->getObjetoBean()->getTotalSobrantes()); endif;
      if($this->getObjetoBean()->getTotalFaltantes()) : $a_Fields['TotalFaltantes'] = ($this->getObjetoBean()->getTotalFaltantes()); endif;
      if($this->getObjetoBean()->getTotalGastoAdministrativo()) : $a_Fields['TotalGastoAdministrativo'] = ($this->getObjetoBean()->getTotalGastoAdministrativo()); endif;
      if($this->getObjetoBean()->getTotalGastoMovilidad()) : $a_Fields['TotalGastoMovilidad'] = ($this->getObjetoBean()->getTotalGastoMovilidad()); endif;

      $a_Fields['SumaTotal'] = ($this->getObjetoBean()->getTotalCaja() + $this->getObjetoBean()->getTotalPagos() - $this->getObjetoBean()->getTotalPrestamos()+ $this->getObjetoBean()->getTotalGastoAdministrativo() + $this->getObjetoBean()->getTotalSobrantes()+ $this->getObjetoBean()->getTotalPagosMora() - $this->getObjetoBean()->getTotalFaltantes() - $this->getObjetoBean()->getTotalGastoMovilidad());
      
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      
      $sStringField = arrayClass::implode_keys(',', $a_Fields);
      $sStringValue = "'".implode("','", $a_Fields)."'";
      
      $sql = "INSERT INTO cr_balance_dia_detalle 
      				(".$sStringField.")
              VALUES 
                    (".$sStringValue.");";
      $result = $con->query($sql);
      
	     
      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

  }
  
  public function saveHeader(){
  	
  	$con = Conexion::getConexion();
  	
  	$sql = "	INSERT INTO cr_balance_dia
      					(	IdSucursal,FechaCierre,NombreSucursal,IdAdministrador,NombreAdministrador,TotalDia,Comentario,FechaRegistro,UsuarioRegistro)
      			VALUES 
      					('".$this->getObjetoBean()->getIdSucursal()."','".$this->getObjetoBean()->getFechaBalance()."','".$this->getObjetoBean()->getNombreSucursal()."','".$this->getObjetoBean()->getIdAdministrador()."','".$this->getObjetoBean()->getNombreAdministrador()."','".$this->getObjetoBean()->getSumaTotal()."','".$this->getObjetoBean()->getComentario()."','".$this->getObjetoBean()->getFechaCreacion()."','".$this->getObjetoBean()->getUsuarioCreacion()."')
      			";
  	
  	
  	$result = $con->query($sql);
	
	 
	$iResultSave = $result;
	if($iResultSave){
		$sql = " 	SELECT * 
					FROM cr_inicio_balance 
					WHERE IdSucursal = '".$this->getObjetoBean()->getIdSucursal()."'"; 
		//echo $sql;
		$result2 = $con->query($sql);
		
		if($result2->rowCount()==0){
			$sql = "INSERT INTO cr_inicio_balance 
						(IdSucursal,FechaCierre,FechaCreacion,UsuarioCreacion)
					VALUES
						('".$this->getObjetoBean()->getIdSucursal()."','".$this->getObjetoBean()->getFechaBalance()."','".$this->getObjetoBean()->getFechaCreacion()."','".$this->getObjetoBean()->getUsuarioCreacion()."')"; 
			//echo $sql;
			$result3 = $con->query($sql);
		}
		
		return $iResultSave;
	}else{
		return false;
	}
  }
  
  /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
  public function update() {

    if($this->getObjetoBean()->getIdBalanceDia()){
          
      if($this->getObjetoBean()->getFechaBalance()) : $a_Fields['FechaBalance'] = ($this->getObjetoBean()->getFechaBalance()); endif;
      if($this->getObjetoBean()->getIdColaborador()) : $a_Fields['IdColaborador'] = ($this->getObjetoBean()->getIdColaborador()); endif;
      if($this->getObjetoBean()->getDescripcion()) : $a_Fields['Descripcion'] = ($this->getObjetoBean()->getDescripcion()); endif;
      if($this->getObjetoBean()->getMonto()) : $a_Fields['Monto'] = ($this->getObjetoBean()->getMonto()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaModificacion()) : $a_Fields['FechaModificacion'] = ($this->getObjetoBean()->getFechaModificacion()); endif;
      if($this->getObjetoBean()->getUsuarioModificacion()) : $a_Fields['UsuarioModificacion'] = ($this->getObjetoBean()->getUsuarioModificacion()); endif;
      if($this->getObjetoBean()->getFechaModificacion2()) : $a_Fields['FechaModificacion2'] = ($this->getObjetoBean()->getFechaModificacion2()); endif;
      
      $sString = arrayClass::implode_key_value(",", $a_Fields);

      $sql = "UPDATE cr_balance_dia_detalle SET
                  ".$sString."
            WHERE 1 ";
      $result = $con->query($sql);
      

      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

    }else{
      return false;
    }

  }
  
  /**
  * Elimina registro
  *
  * @return Boolean
  */
  public function delete(){
    $con = Conexion::getConexion();
    	
  	if($this->getObjetoBean()->getIdSucursal()){
          $where_h = " and IdSucursal = '".$this->getObjetoBean()->getIdSucursal()."'";
          $where_d = " and IdSucursal = '".$this->getObjetoBean()->getIdSucursal()."'";
          $where_g = " and IdSucursal = '".$this->getObjetoBean()->getIdSucursal()."'";
          $where_dw = " and IdSucursal = '".$this->getObjetoBean()->getIdSucursal()."'";
    }
     	
  	if($this->getObjetoBean()->getFechaBalance()){
          $where_h .= " and FechaCierre = '".$this->getObjetoBean()->getFechaBalance()."'";
          $where_d .= " and FechaBalance = '".$this->getObjetoBean()->getFechaBalance()."'";
          $where_g .= " and Fecha		 = '".$this->getObjetoBean()->getFechaBalance()."'";
          $where_dw .= " and Fecha		 = '".$this->getObjetoBean()->getFechaBalance()."'";
    }
    
    //Ver que el Id del Administrador sea igual al que esta haciendo la modificacion
    
  	$sql = "	DELETE 
    			FROM cr_balance_dia
    			WHERE 1 ".$where_h;
    // echo $sql;             
    $result = $con->query($sql);
    
    $sql = "	DELETE 
    			FROM cr_balance_dia_detalle
    			WHERE 1 ".$where_d;
    // echo $sql;             
    $result = $con->query($sql);
     
    $sql = "	DELETE 
    			FROM dw_matriz
    			WHERE 1 ".$where_dw;
    // echo $sql;             
    $result = $con->query($sql);
    
    $sql = "	DELETE 
    			FROM cr_balance_general 
    			WHERE 1 ".$where_g;
    //echo $sql;             
    $iResultDelete = $con->query($sql);
    
	if($iResultDelete > 0){
	  return true;
	}else{
	  return false;
	} 
   
  }
  /**
  * Selecciona un nuevo registro
  *
  * @return IdGenerado
  */
  public function select(){
    $where = "";
    if($this->getObjetoBean()->getIdSucursal()){
      	 $where .= " AND IdSucursal = '".$this->getObjetoBean()->getIdSucursal()."'";
    }
    
    if($this->getObjetoBean()->getFechaBalance()){
      	 $where .= " AND FechaBalance >= '".$this->getObjetoBean()->getFechaBalance()."'";
    }
    
    if($this->getObjetoBean()->getFechaBalanceFinal()){
      	 $where .= " AND FechaBalance <= '".$this->getObjetoBean()->getFechaBalanceFinal()."'";
    }
    
    if($this->getObjetoBean()->getIdColaborador()){
      	 $where .= " AND IdColaborador = '".$this->getObjetoBean()->getIdColaborador()."'";
    }
    $campos = "*";
    if($this->getObjetoBean()->getObtenerSaldoPrestamos()){
      	$campo_saldoPrestamos = "NombreSucursal,FechaBalance,sum(IndicePagos) as IndicePagos";
      	$group_by_saldoPrestamos = "group by NombreSucursal";
    }
    if($this->getObjetoBean()->getObtenerTotalPagos()){
      	$campo_TotalPagos = "NombreSucursal,FechaBalance,sum(TotalPagos) as TotalPagos";
      	$group_by_TotalPagos = "group by NombreSucursal";
    }
    if($campo_saldoPrestamos) $campos = $campo_saldoPrestamos;
    if($group_by_saldoPrestamos) $group_by = $group_by_saldoPrestamos; 
    if($campo_TotalPagos) $campos = $campo_TotalPagos;
    if($group_by_TotalPagos) $group_by = $group_by_TotalPagos;
    
    
    $con = Conexion::getConexion();
    $sql = "SELECT $campos 
    		FROM cr_balance_dia_detalle
    		WHERE 1 ".$where
    		." ".$group_by
    		." order by NombreColaborador ";
	//echo $sql;
    $result = $con->query($sql);
    $num_rows = $result->rowCount();

    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      $a_tmp[] = $this->insertarObjetoBean($o_valor);
      }
    }


   
    return count($a_tmp)>0?$a_tmp:null;
      
  }
  
  public function selectHeader(){
  	$where = "";
    if($this->getObjetoBean()->getIdSucursal()){
      	 $where .= " AND IdSucursal = '".$this->getObjetoBean()->getIdSucursal()."'";
    }
    
    if($this->getObjetoBean()->getFechaBalance()){
      	 $where .= " AND FechaCierre >= '".$this->getObjetoBean()->getFechaBalance()."'";
    }
    
    if($this->getObjetoBean()->getFechaBalanceFinal()){
      	 $where .= " AND FechaCierre <= '".$this->getObjetoBean()->getFechaBalanceFinal()."'";
    }
    
    $con = Conexion::getConexion();
    $sql = "SELECT * 
    		FROM cr_balance_dia
    		WHERE 1 ".$where;
    
    
    $result = $con->query($sql);
    $num_rows = $result->rowCount();

    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      $a_tmp[] = $this->insertarObjetoBeanHedaer($o_valor);
      }
    }

    
   
    return count($a_tmp)>0?$a_tmp:null;
     
  }
  
  /**
  * Retorna un objeto BalanceDiaBean
  *
  * @return Object
  */
  public function selectByPk(){
  
    $con = Conexion::getConexion();
    $sql = "SELECT * 
    		FROM cr_balance_dia_detalle
    		WHERE 1 ";
    
    $result = $con->query($sql);
    $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
    

    return $o_Propel?$this->insertarObjetoBean($o_Propel):null;
  
  }
  
  /**
  * Reasigna valores retornados del propel a un objeto BalanceDiaBean
  *
  * @param Object $o_Propel
  * @return BalanceDiaBean
  */
  private function insertarObjetoBean($o_Propel){

    $o_BalanceDiaBean = new BalanceDiaBean();
    
    $o_BalanceDiaBean->setIdBalanceDia($o_Propel->IdBalanceDia);
    $o_BalanceDiaBean->setFechaBalance($o_Propel->FechaBalance);
    $o_BalanceDiaBean->setIdColaborador($o_Propel->IdColaborador);
    
    $o_BalanceDiaBean->setNombreColaborador($o_Propel->NombreColaborador);
    $o_BalanceDiaBean->setDescripcion($o_Propel->Descripcion);
    $o_BalanceDiaBean->setTotalCaja($o_Propel->TotalCaja);
    $o_BalanceDiaBean->setTotalPrestamos($o_Propel->TotalPrestamos);
    $o_BalanceDiaBean->setSaldoPrestamos($o_Propel->SaldoPrestamos);
    $o_BalanceDiaBean->setIndicePagos($o_Propel->IndicePagos);
    $o_BalanceDiaBean->setTotalPagos($o_Propel->TotalPagos);
    $o_BalanceDiaBean->setTotalPagosMora($o_Propel->TotalPagosMora);
    $o_BalanceDiaBean->setTotalSobrantes($o_Propel->TotalSobrantes);
    $o_BalanceDiaBean->setTotalFaltantes($o_Propel->TotalFaltantes);
    $o_BalanceDiaBean->setTotalGastoAdministrativo($o_Propel->TotalGastoAdministrativo);
	$o_BalanceDiaBean->setTotalGastoMovilidad($o_Propel->TotalGastoMovilidad);
    $o_BalanceDiaBean->setTotalCapitalEfectivo($this->ObtenerCapitalEfectivo($o_Propel->IdSucursal,$o_Propel->FechaBalance,$o_Propel->IdColaborador));
    $o_BalanceDiaBean->setTotalClientesNuevos($this->ObtenerClientesNuevos($o_Propel->IdSucursal,$o_Propel->FechaBalance,$o_Propel->IdColaborador));
    $o_BalanceDiaBean->setSumaTotal($o_Propel->SumaTotal);
    $o_BalanceDiaBean->setUsuarioCreacion($o_Propel->UsuarioCreacion);
    $o_BalanceDiaBean->setFechaModificacion($o_Propel->FechaModificacion);
    $o_BalanceDiaBean->setUsuarioModificacion($o_Propel->UsuarioModificacion);
         
    return $o_BalanceDiaBean;    
    
  }
   private function insertarObjetoBeanHedaer($o_Propel){

    $o_BalanceDiaBean = new BalanceDiaBean();
    
    $o_BalanceDiaBean->setIdSucursal($o_Propel->IdSucursal);
    $o_BalanceDiaBean->setNombreAdministrador($o_Propel->NombreAdministrador);
    $o_BalanceDiaBean->setFechaBalance($o_Propel->FechaCierre);
    $o_BalanceDiaBean->setNombreSucursal($o_Propel->NombreSucursal);
    $o_BalanceDiaBean->setSumaTotal($o_Propel->TotalDia);
    $o_BalanceDiaBean->setComentario($o_Propel->Comentario);
    $o_BalanceDiaBean->setFechaCreacion($o_Propel->FechaRegistro);
    $o_BalanceDiaBean->setUsuarioCreacion($o_Propel->UsuarioRegistro);
   
         
    return $o_BalanceDiaBean;    
    
  }
  
  function ObtenerColaboradoresNewBalance($fecha){
  	
  	if(is_array($this->getObjetoBean()->getIdColaboradorPermitido())){
      	 $where .= " AND IdColaborador in ('".implode("','",$this->getObjetoBean()->getIdColaboradorPermitido())."')";
    }
    $con = Conexion::getConexion();
  	$sql = "SELECT * 
  			FROM cr_colaborador 
  			WHERE 1 
  				
  				and Eliminado <>1	
  				and (IdRol = 'sys.ope' or IdRol = 'sys.caja')
  				".$where." 
  			order by ApellidoPaterno,ApellidoMaterno,Nombres" ;
  	//and Estado = 'A'
  	$result = $con->query($sql);
  	$num_rows = $result->rowCount();
  	$i = 0;
  	if($num_rows>0){
      while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      	$a_TotalesColaborador[$i]['IdColaborador'] 	= $o_valor->IdColaborador;
      	$a_TotalesColaborador[$i]['NombreCompleto'] = $o_valor->ApellidoPaterno." ".$o_valor->ApellidoMaterno.", ".$o_valor->Nombres;
      	$a_TotalesColaborador[$i]['TotalCaja'] 		= $this->ObtenerTotalCaja($con,$o_valor->IdColaborador,$fecha);
      	$a_TotalesColaborador[$i]['TotalPrestamo'] 	= $this->ObtenerTotalPrestamos($con,$o_valor->IdColaborador,$fecha);
      	$a_TotalesColaborador[$i]['TotalPago'] 		= $this->ObtenerTotalPagos($con,$o_valor->IdColaborador,$fecha);
      	$a_TotalesColaborador[$i]['TotalSobrantes'] = $this->ObtenerTotalSobrantes($con,$o_valor->IdColaborador,$fecha);
      	$a_TotalesColaborador[$i]['TotalFaltantes'] = $this->ObtenerTotalFaltantes($con,$o_valor->IdColaborador,$fecha);
      	$a_TotalesColaborador[$i]['TotalGastoAdmin'] = $this->ObtenerTotalGastoAdmin($con,$o_valor->IdColaborador,$fecha);
		$a_TotalesColaborador[$i]['TotalGastoMovilidad'] = $this->ObtenerTotalGastoMovilidad($con,$o_valor->IdColaborador,$fecha);
      	$a_TotalesColaborador[$i]['TotalSaldo'] = $this->ObtenerSaldoPrestamos($con,$o_valor->IdColaborador,$fecha);
      	$a_TotalesColaborador[$i]['IndicePagos'] = $this->ObtenerMedicionPagos($con,$o_valor->IdColaborador,$fecha);
      	$i++;
      }
    }
  	return $a_TotalesColaborador;  
  }
  //Para el reporte Capital efectivo
  private function ObtenerCapitalEfectivo($IdSucursal,$FechaBalance,$IdColaborador){
  	$con = Conexion::getConexion();
  	$sql = "SELECT sum(PrestamosNuevos) as Suma
  			FROM cr_promedioxrepresentante 
  			WHERE 1 
  					and IdSucursal = '$IdSucursal'
  					and IdRepresentante 	= '$IdColaborador'	
  					and Fecha			= '$FechaBalance'	
  				"
  			 ;
  
  	$result = $con->query($sql);
  	
  	while ($row = $result->fetch(PDO::FETCH_ASSOC)){
  		return $row['Suma'];
  	}
  } 
  //Para el reporte Capital efectivo
  private function ObtenerClientesnuevos($IdSucursal,$FechaBalance,$IdColaborador){
  	$con = Conexion::getConexion();
  	$sql = "SELECT sum(CantidadClientesNuevos) as Suma
  			FROM cr_promedioxrepresentante 
  			WHERE 1 
  					and IdSucursal = '$IdSucursal'
  					and IdRepresentante 	= '$IdColaborador'	
  					and Fecha			= '$FechaBalance'	
  				"
  			 ;
  	
  	$result = $con->query($sql);
  	
  	while ($row = $result->fetch(PDO::FETCH_ASSOC)){
  		return $row['Suma'];
  	}
  }
  //------------------------------------------------------------
  
  
  private function ObtenerTotalCaja($con,$idColaborador,$fecha){
  	
  	$sql = "SELECT sum(Monto) as Suma
  			FROM cr_capital_inicial 
  			WHERE 1 
  					and Estado = 'A'
  					and IdColaborador 	= $idColaborador	
  					and Fecha			= '$fecha'	
  					and Eliminado <>1	
  				".$where
  			 ;
  	
  	$result = $con->query($sql);
  	
  	while ($row = $result->fetch(PDO::FETCH_ASSOC)){
  		return $row['Suma'];
  	}
  	
  }
  
  private function ObtenerTotalSobrantes($con,$idColaborador,$fecha){
  	
  	$sql = "SELECT sum(Monto) as Suma
  			FROM cr_sobrante_faltante 
  			WHERE 1 
  					and Estado = 'A'
  					and TipoSofa = 's'
  					and IdColaborador 	= $idColaborador	
  					and FechaSofa			= '$fecha'
  					and Eliminado <>1		
  				".$where
  			 ;
  	
  	$result = $con->query($sql);
  	if($result->rowCount() > 0){
	  	while ($row = $result->fetch(PDO::FETCH_ASSOC)){
	  		return $row['Suma'];
	  	}
  	}
  	
  }
  
  private function ObtenerTotalFaltantes($con,$idColaborador,$fecha){
  	
  	$sql = "SELECT sum(Monto) as Suma2
  			FROM cr_sobrante_faltante 
  			WHERE 1 
  					and Estado = 'A'
  					and TipoSofa = 'f'
  					and IdColaborador 	= $idColaborador	
  					and FechaSofa			= '$fecha'
  					and Eliminado <>1	
  				".$where
  			 ;
  	
  	$result = $con->query($sql);
  	
  	while ($row = $result->fetch(PDO::FETCH_ASSOC)){
  		return $row['Suma2'];
  	}
  	
  }
  
  private function ObtenerTotalPrestamos($con,$idColaborador,$fecha){
  		
  		$sql = "
  				SELECT sum(MontoPrestado) as Suma
  				FROM cr_prestamo  
  				WHERE 1 and Eliminado <> 1
  						and IdColaborador = $idColaborador	
  						and FechaInicio  	= '$fecha'	
  						and origen = 'R'
  				".$where
  			
  				
  				
  			 ;
  			 
  		
  		
  	$result = $con->query($sql);
  	
  	while ($row = $result->fetch(PDO::FETCH_ASSOC)){
  		$sumaR =  $row['Suma'];
  	}
  	
  	$sql = " SELECT sum(MontoExtra) as Suma
  				FROM cr_prestamo  
  				WHERE 1 and Eliminado <> 1
  						and IdColaborador = $idColaborador	
  						and FechaInicio  	= '$fecha'	
  						and origen = 'F'
  				".$where;
  	$result = $con->query($sql);
  	
  	while ($row = $result->fetch(PDO::FETCH_ASSOC)){
  		$sumaF = $row['Suma'];
  	}	
  	return ($sumaF + $sumaR);
  }
  
  private function ObtenerSaldoPrestamos($con,$idColaborador,$fecha){
  		
  		$sql = "
  				SELECT sum(MontoPrestado) as Suma
  				FROM cr_prestamo  
  				WHERE 1 and Eliminado <> 1
  						and IdColaborador = $idColaborador	
  						and estado = 'P'
  						and FechaInicio  	= '$fecha'	
  						and Origen = 'R'
  				".$where
  			 ;
  		
  	$result = $con->query($sql);
  	
  	while ($row = $result->fetch(PDO::FETCH_ASSOC)){
  		return $row['Suma'];
  	}
  }
  
   private function ObtenerMedicionPagos($con,$idColaborador,$fecha){
  		
		$sql = "
				SELECT *
				FROM cr_pago  
				WHERE 1 and Eliminado <> 1
						and IdColaborador = $idColaborador	
						and estado = 'A'
						and FechaPago  	= '$fecha'	
						AND MontoPago > 0
				group by IdPrestamo"
			 ;
		
		$result = $con->query($sql);
		
		
		$PagosEfectivos = $result->rowCount();
		
		
		$sql = "
				SELECT *
				FROM cr_pago  
				WHERE 1 and Eliminado <> 1
						and IdColaborador = $idColaborador	
						and estado = 'A'
						and FechaPago  	= '$fecha'	
				group by IdPrestamo"
			 ;
		
		$result2 = $con->query($sql);
		
		$TotalPagos = $result2->rowCount();
		
		if($TotalPagos) $indice = ($PagosEfectivos/$TotalPagos)*100;
		else $indice = 0;
		return $indice;
  }
  
  private function ObtenerTotalGastoMovilidad($con,$idColaborador,$fecha){
   		
  		$sql = "
  				SELECT sum(Monto) as Suma
  				FROM cr_gasto_operativo  
  				WHERE 1 and Eliminado <> 1
  						and IdColaborador 	= $idColaborador
  						and Fecha  	= '$fecha'		
  				".$where
  			 ;
  	//echo $sql;
  	$result = $con->query($sql);
  	
  	while ($row = $result->fetch(PDO::FETCH_ASSOC)){
  		return $row['Suma'];
  	}
  }
  
   private function ObtenerTotalGastoAdmin($con,$idColaborador,$fecha){
   		
  		$sql = "
  				SELECT sum(GastoAdministrativo) as Suma
  				FROM cr_prestamo  
  				WHERE 1 and Eliminado <> 1
  						and IdColaborador 	= $idColaborador
  						and FechaInicio  	= '$fecha'		
  				".$where
  			 ;
  	
  	$result = $con->query($sql);
  	
  	while ($row = $result->fetch(PDO::FETCH_ASSOC)){
  		return $row['Suma'];
  	}
  }
   
  private function ObtenerTotalPagos($con,$idColaborador,$fecha){
  		
  		$sql = "
  				SELECT TipoPago,sum(MontoPago) as Suma
  				FROM cr_prestamo  pr
  				LEFT JOIN cr_pago pa on pr.IdPrestamo = pa.IdPrestamo
  				WHERE 1 and pr.Eliminado <> 1
  						and pa.IdColaborador 	= '$idColaborador'	
  						and pa.FechaPago  		= '$fecha'	
  						
  						".$where."
  				GROUP By TipoPago";
  		//echo $sql;
  	$result = $con->query($sql);
  	
  	while ($row = $result->fetch(PDO::FETCH_ASSOC)){
  			if($row['TipoPago'] == 1){
  			$a_sumaPago['PA'] = $row['Suma'];
  		}else{
  			$a_sumaPago['PAM'] = $row['Suma'];
  		}
  	}
  	return $a_sumaPago;
  } 
  
  
  
  
  public function ObtenerResumenDetalleMercado(){
  	
  	$con = Conexion::getConexion();
  	$where = " AND Fecha = '".$this->getObjetoBean()->getFechaBalance()."'";
  	$where .= " AND IdColaborador = '".$this->getObjetoBean()->getIdColaborador()."'";
  	 //Total de Prestamos por Mercado
  	$sql = "SELECT sum(Monto) as Suma 
  			FROM cr_capital_inicial 
            WHERE Eliminado <> '1'
            ".$where." "
  			;
  	
  	$result = $con->query($sql);
  	
  	while ($row = $result->fetch(PDO::FETCH_ASSOC)){
  		$a_InicioOperacion['IO'] = $row['Suma'];
  	}
  	  	 
  	$where = " AND FechaPago = '".$this->getObjetoBean()->getFechaBalance()."'";
  	$where .= " AND cr_pago.IdColaborador = '".$this->getObjetoBean()->getIdColaborador()."'";
  	
  	//Total de Prestamos por Mercado
  	$sql = "SELECT cr_cliente.IdMercado,cr_mercado.Descripcion,TipoPago,sum(MontoPago) as Suma ,Min(cr_pago.FechaCreacion) as fechaMinima,Max(cr_pago.FechaCreacion) as fechaMaxima 
  			FROM cr_pago
            LEFT JOIN cr_prestamo ON cr_pago.IdPrestamo = cr_prestamo.IdPrestamo
            LEFT JOIN cr_cliente ON cr_prestamo.IdCliente = cr_cliente.IdCliente
            LEFT JOIN cr_mercado ON cr_cliente .IdMercado = cr_mercado.IdMercado  
            WHERE cr_prestamo.Eliminado <> '1' and MontoPago > 0
            ".$where."
  			GROUP BY IdMercado,cr_mercado.Descripcion,TipoPago"
  			;
  
  	$result1 = $con->query($sql);
  	if($result1->rowCount() > 0 ){
		$fechaMinima = '9999-99-99 23:59:59';
  		$fechaMaxima = '';
	  	while ($row = $result1->fetch(PDO::FETCH_ASSOC)){
			$IdMercado = $row['IdMercado'];
	  		if($fechaMinima > $row['fechaMinima']){
	  			$fechaMinima = $row['fechaMinima'];
	  		}
	  		
	  		if($fechaMaxima < $row['fechaMaxima']){
	  			$fechaMaxima = $row['fechaMaxima'];
	  		}
			
	  		$a_PagosMonto[$row['IdMercado']]['NombreMercado'] = $row['Descripcion'];
	  		if($row['TipoPago'] == '1'){
	  			$a_PagosMonto[$row['IdMercado']]['PA'] = $row['Suma'];
	  		}
	  		if($row['TipoPago'] == '2'){
	  			$a_PagosMonto[$row['IdMercado']]['PAM'] = $row['Suma'];
	  		}
	  	}
		$a_PagosMonto[$IdMercado]['NombreMercado'] .= "<br> Hora Cobranza - ".substr($fechaMinima,10)." - ".substr($fechaMaxima,10) ;
  	}
  	
  	$where = '';
  	$where = " AND FechaSofa = '".$this->getObjetoBean()->getFechaBalance()."'";
  	$where .= " AND cr_sobrante_faltante.IdColaborador = '".$this->getObjetoBean()->getIdColaborador()."'";
  	
 	$sql = "SELECT TipoSofa,sum(Monto) as Suma 
			FROM cr_sobrante_faltante
	    	WHERE Eliminado <> '1'
	    	 
	    ".$where."
	    group by TipoSofa
		";
 	
 	$result1 = $con->query($sql);
  	if($result1->rowCount() > 0 ){
	  	while ($row = $result1->fetch(PDO::FETCH_ASSOC)){
	  		$a_SofaMonto[$row['TipoSofa']] = $row['Suma'];
	  		$a_SofaMonto[$row['TipoSofa']] = $row['Suma'];
	  	}
  	}
 	
 	
 	$where = '';
  	$where = " AND Fecha = '".$this->getObjetoBean()->getFechaBalance()."'";
  	$where .= " AND cr_gasto_operativo.IdColaborador = '".$this->getObjetoBean()->getIdColaborador()."'";
  	
 	$sql = "SELECT sum(Monto) as Suma 
			FROM cr_gasto_operativo
	    	WHERE Eliminado <> '1'
	    	 
	    ".$where."
		";
 	
 	$result1 = $con->query($sql);
  	if($result1->rowCount() > 0 ){
	  	while ($row = $result1->fetch(PDO::FETCH_ASSOC)){
	  		$a_GastoMovilidad['GMov'] = $row['Suma'];
	  	}
  	}
	
  	$where = '';
  	
  	$where = " AND FechaInicio = '".$this->getObjetoBean()->getFechaBalance()."'";
  	$where .= " AND cr_prestamo.IdColaborador = '".$this->getObjetoBean()->getIdColaborador()."'";
  	//Total de Prestamos por Mercado
  	$sql = "SELECT cr_cliente.Idcliente,cr_mercado.IdMercado,cr_mercado.Descripcion,cr_prestamo.IdPrestamo,cr_prestamo.Estado,concat(cr_cliente.ApellidoPaterno,' ',cr_cliente.ApellidoMaterno,' ',cr_cliente.Nombres) as NombreCliente, MontoPrestado as Suma ,MontoExtra, GastoAdministrativo as SumaGastoAdministrativo,Origen,InteresPorcentaje,idpedidoreferencia,cr_prestamo.FechaCreacion as FechaCreacion
  			FROM cr_prestamo
            LEFT JOIN cr_cliente ON cr_prestamo.IdCliente = cr_cliente.IdCliente
            LEFT JOIN cr_mercado ON cr_cliente .IdMercado = cr_mercado.IdMercado  
            WHERE cr_prestamo.Eliminado <> '1'
            	 
            ".$where."
  			"
  	
  			;
  	/*$sql = "SELECT cr_mercado.IdMercado,cr_mercado.Descripcion,cr_prestamo.IdPrestamo,cr_prestamo.Estado,concat(cr_cliente.ApellidoPaterno,' ',cr_cliente.ApellidoMaterno,' ',cr_cliente.Nombres) as NombreCliente, MontoPrestado as Suma ,GastoAdministrativo as SumaGastoAdministrativo,Origen,InteresPorcentaje 	
  			FROM cr_prestamo
            LEFT JOIN cr_cliente ON cr_prestamo.IdCliente = cr_cliente.IdCliente
            LEFT JOIN cr_mercado ON cr_cliente .IdMercado = cr_mercado.IdMercado  
            WHERE cr_prestamo.Eliminado <> '1'
            	 and origen = 'R' 
            ".$where."
  			"
  			;*/
     //echo $sql;
  	$result = $con->query($sql);
  	
  	while ($row = $result->fetch(PDO::FETCH_ASSOC)){
  		$a_PrestamoMonto[$row['Descripcion']][$row['IdPrestamo']]['NombreCliente'] = $row['NombreCliente'];
  		$a_PrestamoMonto[$row['Descripcion']][$row['IdPrestamo']]['PR'] = $row['Suma'];
  		$a_PrestamoMonto[$row['Descripcion']][$row['IdPrestamo']]['ME'] = $row['MontoExtra'];
  		$a_PrestamoMonto[$row['Descripcion']][$row['IdPrestamo']]['ES'] = $row['Estado'];
  		$a_PrestamoMonto[$row['Descripcion']][$row['IdPrestamo']]['OR'] = $row['Origen'];
  		$a_PrestamoMonto[$row['Descripcion']][$row['IdPrestamo']]['PO'] = $row['InteresPorcentaje'];
  		$a_PrestamoMonto[$row['Descripcion']][$row['IdPrestamo']]['Idcliente'] = $row['Idcliente'];
  		$a_PrestamoMonto[$row['Descripcion']][$row['IdPrestamo']]['GA'] = $row['SumaGastoAdministrativo'];
  		$a_PrestamoMonto[$row['Descripcion']][$row['IdPrestamo']]['idpedidoreferencia'] = $row['idpedidoreferencia'];
  		$a_PrestamoMonto[$row['Descripcion']][$row['IdPrestamo']]['FechaCreacion'] = $row['FechaCreacion'];
  	}
  	
  	$a_ResuemnMonto['InicioOperacion'] = $a_InicioOperacion;
	$a_ResuemnMonto['GMov'] = $a_GastoMovilidad;
  	$a_ResuemnMonto['Pagos'] = $a_PagosMonto;
  	$a_ResuemnMonto['Sofa'] = $a_SofaMonto;
  	$a_ResuemnMonto['Prestamos'] = $a_PrestamoMonto;
  	
  	
  	return $a_ResuemnMonto;
  }
  
  public function ObtenerMaxDiaCerrado(){
  	$fechaDiaCerrado = date('Y-m-d',strtotime($this->ObtenerDiaAbierto()." -1 days"));
  	return $fechaDiaCerrado;
  }
  
  public function ObtenerDiaAbierto(){
  	$con = Conexion::getConexion();
  	if($this->getObjetoBean()->getIdAdministrador()) $where = " AND IdAdministrador = '".$this->getObjetoBean()->getIdAdministrador()."'";
  	$where .= " AND IdSucursal = '".$this->getObjetoBean()->getIdSucursal()."'";
  	$sql = "
  				SELECT 	FechaCierre as FechaCierre
  				FROM 	cr_balance_dia  
  				WHERE 1
  						".$where." 
  				order by FechaCierre desc
  				LIMIT 0,".Constantes::V_NUM_DIAS_OPEN.""
  			 ;
  	//echo $sql;
  	$result = $con->query($sql);
  	
  	if($result){
  		if($result->rowCount() > 0 ){
  			$i = 1;
		  	while ($row = $result->fetch(PDO::FETCH_ASSOC)){
			  	if($row['FechaCierre']){
			  		if($fecha_anterior){
			  			if($fecha_anterior != $row['FechaCierre']){
			  				return $fecha_anterior;
			  			}
			  		}else{
			  			$maxDiaCerrado = $row['FechaCierre'];
			  		}
			  		$fecha_anterior = date('Y-m-d',strtotime($row['FechaCierre']." -1 days"));
			  	}else{
			  		return date('Y-m-d',strtotime(Constantes::V_INICIO_BALANCE." +1 days"));;
			  	}
			  	$i++;
		  	}
		  	
  		}else{
  			$sql = "
					SELECT 	 fechaInicioBalance 
					FROM 	cr_sucursal   
					WHERE 	1 and IdSucursal  = '".$this->getObjetoBean()->getIdSucursal()."'		
					";
  			
  			$result = $con->query($sql);
  			if($result->rowCount() > 0 ){	  		
			  	while ($row = $result->fetch(PDO::FETCH_ASSOC)){
			  		return  $row['fechaInicioBalance'];
			  	}
	  		}
  			
  		}
  		
  		if($i < Constantes::V_NUM_DIAS_OPEN ){
			$sql = "
					SELECT 	FechaCierre as FechaCierre
					FROM 	cr_inicio_balance   
					WHERE 	1
							and IdSucursal  = '".$this->getObjetoBean()->getIdSucursal()."'					
					";
			$result = $con->query($sql);
			if($result){
		  		if($result->rowCount() > 0 ){
		  			$i = 1;
				  	while ($row = $result->fetch(PDO::FETCH_ASSOC)){
				  		if($row['FechaCierre'] == $fecha_anterior){
				  			return $fecha_anterior;
				  		}
				  	}
		  		}
			}
  		}
	  	
  		return date('Y-m-d',strtotime($maxDiaCerrado." +1 days"));
  	}
   }
   
   
   function ObtenerColaboradores($padre=''){
   		$con = Conexion::getConexion();
  		//if($this->getObjetoBean()->getIdAdministrador()) $where = " AND IdAdministrador = '".$this->getObjetoBean()->getIdAdministrador()."'";
	  	$where .= " AND sm.IdSucursal = '".$this->getObjetoBean()->getIdSucursal()."'";
	  	//$where .= " AND cc.Estado= 'A'";
	  	$where .= " AND cc.Eliminado= '0'";
	  	$where .= " AND cc.IdRol= 'sys.ope'";
	  	if($padre)$where .= " AND cc.IdPadre= '$padre'";
		
		$whereCaja = " AND cc.IdRol= 'sys.caja'";
	  	$whereCaja .= " AND cc.Eliminado= '0'";
	  	$whereCaja .= " AND cc.IdPadre= '$padre'";
	  	$whereCaja .= " AND s.IdSucursal= '".$this->getObjetoBean()->getIdSucursal()."'";
	  	
	  	/*$sql = "
	  				SELECT 	cc.IdColaborador as IdColaborador
	  				FROM 	cr_balance_dia_detalle cbd
	  				LEFT JOIN cr_colaborador cc on cc.IdColaborador = cbd.IdColaborador
	  				WHERE 1
	  						".$where." 
	  				GROUP BY cc.IdColaborador"
	  	
	  			 ;*/
	  	/*
		$sql = "
	  				SELECT 	mr.IdColaborador as IdColaborador
	  				FROM 	cr_mercado_representante mr
	  				LEFT JOIN cr_colaborador cc on cc.IdColaborador = mr.IdColaborador
	  			
	  				
	  				INNER JOIN cr_sucursal_mercado  sm on sm.IdMercado = mr.IdMercado
	  				WHERE 1
	  						".$where." 
	  				GROUP BY cc.IdColaborador";
		*/
	  	
	  	/*$sql = "
	  				SELECT 	mr.IdColaborador as IdColaborador
	  				FROM 	cr_mercado_representante mr
	  				LEFT JOIN cr_colaborador cc on cc.IdColaborador = mr.IdColaborador
	  			
	  				
	  				INNER JOIN cr_sucursal_mercado  sm on sm.IdMercado = mr.IdMercado
	  				WHERE 1
	  						".$where." 
	  				GROUP BY cc.IdColaborador";
	  	*/
	  	$sql = "
	  				SELECT 	mr.IdColaborador as IdColaborador
	  				FROM 	cr_mercado_representante mr
	  				LEFT JOIN cr_colaborador cc on cc.IdColaborador = mr.IdColaborador
	  			
	  				
	  				INNER JOIN cr_sucursal_mercado  sm on sm.IdMercado = mr.IdMercado
	  				WHERE 1
	  						".$where." 
	  				GROUP BY cc.IdColaborador";
	  	$sqlu=		"
	  				UNION
	  				
	  				SELECT 	cc.IdColaborador as IdColaborador
	  				FROM 	cr_colaborador cc
	  				LEFT JOIN cr_sucursal s on s.IdAdministrador= cc.IdPadre
	  			
	  				WHERE 1
	  						".$whereCaja." 
	  				GROUP BY cc.IdColaborador
	  				
	  				ORDER BY 1";
	  	$sql = $sql." ".$sqlu;
	  	
	  	/*$sql = "
	  				SELECT 	cc.IdColaborador as IdColaborador
	  				FROM 	cr_balance_dia_detalle cbd
	  				LEFT JOIN cr_colaborador cc on cc.IdColaborador = cbd.IdColaborador
	  				WHERE 1
	  						".$where." 
	  				GROUP BY cc.IdColaborador"
	  	
	  			 ;*/
	  	
	  	
	  	
	  	
	  	//echo $sql;
	  	
	  		
	  	$result = $con->query($sql);
	  	
	  	if($result){
	  		if($result->rowCount() > 0 ){
  				while ($row = $result->fetch(PDO::FETCH_ASSOC)){
			  		$a_id_colaboradores[] = $row['IdColaborador'];
			  	}
	  		}
	   }
	   return $a_id_colaboradores;
   }

   function ObtenerPeriodosHabiles(){
   		$con = Conexion::getConexion();
  		
   		
   		$sql = "
	  				SELECT 	MAX(Periodo) AS Maximo
	  				FROM 	cr_resumen_semanal
	  				
	  				
	  				"
	  			 ;
	  	
	  	
	  	$result = $con->query($sql);
	  	
	  	if($result){
	  		if($result->rowCount() > 0 ){
  				while ($row = $result->fetch(PDO::FETCH_ASSOC)){
			  		$periodomaximo = $row['Maximo'];
			  		
			  	}
	  		}
	   }
	  	if($periodomaximo) $where = "where Periodo <='$periodomaximo'";
	  	$sql = "
	  				SELECT 	Periodo
	  				FROM 	cr_semanashabiles
	  				$where
	  				group by Periodo
	  				order by 1
	  				"
	  			 ;
	  	
	  	
	  	$result = $con->query($sql);
	  	
	  	if($result){
	  		if($result->rowCount() > 0 ){
  				while ($row = $result->fetch(PDO::FETCH_ASSOC)){
			  		$a_periodos[] = $row['Periodo'];
			  	}
	  		}
	   }
	   return $a_periodos;
   }
   
   function FechaEstaSemanasResumen($diaAbierto){
   		$con = Conexion::getConexion();
   		$sql = "
	  				SELECT 	FFin 
	  				FROM 	cr_resumen_semanal
	  				
	  				where 	FInicio >= '$diaAbierto'
	  						and FFin <= '$diaAbierto'
	  				"
	  			 ;
	  	
	  	
	  	$result = $con->query($sql);
	  	
	  	if($result){
	  		if($result->rowCount() > 0 ){
  				while ($row = $result->fetch(PDO::FETCH_ASSOC)){
			  		$FFin = $row['FFin'];
			  	}
	  		}
	   }
	   return $FFin;
   }
   
   function ObtenerUltimoPeriodo(){
   		$con = Conexion::getConexion();
  		
   		$sql = "
	  				SELECT 	MAX(Semana) AS Maximo
	  				FROM 	cr_resumen_semanal
	  				
	  				
	  				"
	  			 ;
	  	
	  	
	  	$result = $con->query($sql);
	  	
	  	if($result){
	  		if($result->rowCount() > 0 ){
  				while ($row = $result->fetch(PDO::FETCH_ASSOC)){
			  		$semanamaximo = $row['Maximo'];
			  		
			  	}
	  		}
	   }
	   $where = "and Semana = '$semanamaximo'";
	  	$sql = "
	  				SELECT 	Periodo
	  				FROM 	cr_semanashabiles
	  				WHERE   1=1
	  						$where
	  				order by 1
	  				";
	  	
	  	
	  	$result = $con->query($sql);
	  	
	  	if($result){
	  		if($result->rowCount() > 0 ){
  				while ($row = $result->fetch(PDO::FETCH_ASSOC)){
			  		$semanamaximo = $row['Periodo'];
			  	}
	  		}
	   }
	   return $semanamaximo;
   }
   
   function ObtenerSemanasHabiles($default){
   		$con = Conexion::getConexion();
  		
   		$sql = "
	  				SELECT 	MAX(Semana) AS Maximo
	  				FROM 	cr_resumen_semanal
	  				
	  				
	  				"
	  			 ;
	  	
	  	
	  	$result = $con->query($sql);
	  	
	  	if($result){
	  		if($result->rowCount() > 0 ){
  				while ($row = $result->fetch(PDO::FETCH_ASSOC)){
			  		$semanamaximo = $row['Maximo'];
			  		
			  	}
	  		}
	   }
	  	$where = "and Semana <= '$semanamaximo'";
	  	$sql = "
	  				SELECT 	Semana
	  				FROM 	cr_semanashabiles
	  				WHERE   Periodo ='".$default."'
	  						$where
	  				order by 1
	  				";
	  	
	  	
	  	$result = $con->query($sql);
	  	
	  	if($result){
	  		if($result->rowCount() > 0 ){
  				while ($row = $result->fetch(PDO::FETCH_ASSOC)){
			  		$a_semanas[] = $row['Semana'];
			  	}
	  		}
	   }
	   return $a_semanas;
   }
   
   function ObtenerIntervalos($periodo,$semana=''){
   		$con = Conexion::getConexion();
		if($periodo)$where = " and periodo 	= '".$periodo."'";
		if($semana)	$where .= " and semana 	= '".$semana."'";
		$sql = "select *
				from cr_semanashabiles
				where 1
				$where";
		$result = $con->query($sql);
		
		if($result){
			if($result->rowCount() > 0 ){
				while ($row = $result->fetch(PDO::FETCH_ASSOC)){
			  		$a_semanas[$row['Semana']]['Rango1'] = $row['Rango1'];
			  		$a_semanas[$row['Semana']]['Rango2'] = $row['Rango2'];
		  		}
			}
		}
		return $a_semanas;
   }
   
}

