<?php

/**
* Clase Dispacher para PromedioPrestamo
*
* @package IM
* @subpackage PromedioPrestamoDP
* @author Willy
* @version SVN: : PromedioPrestamoDP.class.php,v 1.1 2009/06/26 00:11:33 Exp $
*/
class PromedioPrestamoDP implements interfaceDP {

  protected $o_Bean;

  /**
  * Constructor donde asigna a un atributo el objeto PromedioPrestamoBean
  *
  * @param PromedioPrestamoBean $o_PromedioPrestamoBean
  */
  public function __construct(PromedioPrestamoBean $o_PromedioPrestamoBean){
  
    $this->o_Bean = $o_PromedioPrestamoBean;
    
  }
  
  /**
  * Retorna el objeto PromedioPrestamoBean
  *
  * @return Object
  */
  protected function getObjetoBean(){
  
    if(!$this->o_Bean){
        $this->o_Bean = new PromedioPrestamoBean();
    }        
    return $this->o_Bean;
    
  }
  
  /**
  * Ingresa un nuevo registro
  *
  * @return IdGenerado
  */
  public function save(){

      $con = Conexion::getConexion();

      $a_Fields = array();
      
      $a_Fields['IdSucursal'] 	= $this->getObjetoBean()->getIdSucursal();
      $a_Fields['Fecha'] 		= $this->getObjetoBean()->getFecha();
      
     
      
      $a_datos 					= $this->ObtenerDatosSucursalFecha($a_Fields['IdSucursal'],$a_Fields['Fecha']);	
      
     /* echo "<pre>";
      print_r($a_datos);
      echo "<pre>";*/
      //Los campos que quedan 
      foreach ($a_datos as $key => $a_dato){
	      $a_Fields['IdRepresentante'] 		= $a_dato['idRepresentante'];
	      $a_Fields['IdAdministrador'] 		= $a_dato['IdAdministrador'];
	      $a_Fields['NombreSucursal'] 		= $a_dato['NombreSucursal'];
	      $a_Fields['NombreAdministrador'] 	= $a_dato['NombreAdministrador'];
	      $a_Fields['NombreRepresentante'] 	= $a_dato['NombreRepresentante'];
	      $a_Fields['Capital'] 				= $a_dato['SumaMontoPrestado'];
	      $a_Fields['MontoTotal'] 			= $a_dato['MontoTotal'];
	      $a_Fields['Saldo'] 				= $a_dato['SaldoPrestamo'];
	      $a_Fields['Interes'] 				= $a_dato['InteresPorcentaje'];
	      $a_Fields['NumeroPrestamo'] 		= $a_dato['TotalPrestamos'];
	      $a_Fields['PrestamosNuevos'] 		= $a_dato['PrestamosNuevos'];
		  $a_Fields['CantidadPrestamosNuevos'] 		= $a_dato['CantidadPrestamosNuevos'];
	      $a_Fields['CantidadClientesNuevos'] 		= $a_dato['CantidadClientesNuevos'];
	      $a_Fields['FechaRegistro'] 		= date('Y-m-d H:i:s');
	      $a_Fields['UsuarioRegistro'] 		= myUser::getUser()->getUserId();
	      
	      $sStringField = arrayClass::implode_keys(',', $a_Fields);
	      $sStringValue = "'".implode("','", $a_Fields)."'";     
	     
	      $sql = "INSERT INTO cr_promedioxrepresentante (".$sStringField.")
	                      VALUES (".$sStringValue.");";
	      
	      $result = $con->query($sql);
	     
	      
      }
      //
       
	  
     
	 
      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

    
  }
  
  /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
  public function update() {
 
      return false;

  }
  
  /**
  * Elimina registro
  *
  * @return Boolean
  */
  public function delete(){
    if($this->getObjetoBean()->getIdSucursal()){
      	 $where .= " AND IdSucursal ='".$this->getObjetoBean()->getIdSucursal()."'";
    }
    if($this->getObjetoBean()->getIdRepresentante()){
      	 $where .= " AND IdRepresentante ='".$this->getObjetoBean()->getIdRepresentante()."'";
    }
    
     if($this->getObjetoBean()->getIdRepresentantes()){
      	 $where .= " AND IdRepresentante  in ('".implode("','",$this->getObjetoBean()->getIdRepresentantes())."')";
    }
    
     if($this->getObjetoBean()->getFecha()){
      	 $where .= " AND Fecha = '".$this->getObjetoBean()->getFecha()."'";
    }
    
    if($this->getObjetoBean()->getFechaFinal()){
      	 $where .= " AND Fecha = '".$this->getObjetoBean()->getFechaFinal()."'";
    }
    
    
    $con = Conexion::getConexion();
    $sql = "DELETE
    		FROM cr_promedioxrepresentante      
    		WHERE 1 ".$where
    			
    		
    		."";
   
    $result = $con->query($sql);
    
  }
  /**
  * Selecciona un nuevo registro
  *
  * @return IdGenerado
  */
  public function select(){
      
    $where = "";
    if($this->getObjetoBean()->getIdSucursal()){
      	 $where .= " AND IdSucursal ='".$this->getObjetoBean()->getIdSucursal()."'";
    }
    if($this->getObjetoBean()->getIdRepresentante()){
      	 $where .= " AND IdRepresentante ='".$this->getObjetoBean()->getIdRepresentante()."'";
    }
    
     if($this->getObjetoBean()->getIdRepresentantes()){
      	 $where .= " AND IdRepresentante  in ('".implode("','",$this->getObjetoBean()->getIdRepresentantes())."')";
    }
    
     if($this->getObjetoBean()->getFecha()){
      	 $where .= " AND Fecha >= '".$this->getObjetoBean()->getFecha()."'";
    }
    
    if($this->getObjetoBean()->getFechaFinal()){
      	 $where .= " AND Fecha <= '".$this->getObjetoBean()->getFechaFinal()."'";
    }
    
    
    $con = Conexion::getConexion();
    $sql = "SELECT Fecha,IdRepresentante,NombreRepresentante,NombreSucursal,sum(Capital)/count(*) as  Capital,sum(MontoTotal)/count(*) as  MontoTotal,	sum(Saldo)/count(*) as Saldo,(sum(Interes))/count(*) as Interes, sum(NumeroPrestamo)/count(*) as  NumeroPrestamo,sum(PrestamosNuevos)/count(*) as PrestamosNuevos ,count(*) as DiasPromedio
    		FROM cr_promedioxrepresentante      
    		WHERE 1 ".$where
    			." and Capital > 0" 
    		." group by Fecha,IdRepresentante"
    		." order by NombreSucursal,Fecha asc,NombreRepresentante";
   
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    
    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      $a_tmp[] = $this->insertarObjetoBean($o_valor);
      }
    }
   

    
   
    return count($a_tmp)>0?$a_tmp:null;
      
  }
  
  
  /**
  * Retorna un objeto PromedioPrestamoBean
  *
  * @return Object
  */
  public function selectByPk(){
  
    $con = Conexion::getConexion();
    $sql = "SELECT * FROM cr_balance_general WHERE 1 ";
    $result = $con->query($sql);
    $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
    

    return $o_Propel?$this->insertarObjetoBean($o_Propel):null;
  
  }
  
  /**
  * Reasigna valores retornados del propel a un objeto PromedioPrestamoBean
  *
  * @param Object $o_Propel
  * @return PromedioPrestamoBean
  */
  private function insertarObjetoBean($o_Propel){

    $o_PromedioPrestamoBean = new PromedioPrestamoBean();
    /*echo "<PRE>";
    print_r($o_Propel);
    echo "</PRE>";*/
    $o_PromedioPrestamoBean->setIdSucursal($o_Propel->IdSucursal);
    $o_PromedioPrestamoBean->setFecha($o_Propel->Fecha);
    $o_PromedioPrestamoBean->setDiasPromedio($o_Propel->DiasPromedio);
    $o_PromedioPrestamoBean->setIdRepresentante($o_Propel->IdRepresentante);
    $o_PromedioPrestamoBean->setIdAdministrador($o_Propel->IdAdministrador);
    $o_PromedioPrestamoBean->setNombreSucursal($o_Propel->NombreSucursal);
    $o_PromedioPrestamoBean->setNombreAdministrador($o_Propel->NombreAdministrador);
    $o_PromedioPrestamoBean->setNombreRepresentante($o_Propel->NombreRepresentante);
    $o_PromedioPrestamoBean->setCapital($o_Propel->Capital);
    $o_PromedioPrestamoBean->setMontoTotal($o_Propel->MontoTotal);
    $o_PromedioPrestamoBean->setSaldoPrestamos($o_Propel->Saldo);//ahora es el Saldo de los vencidos
    $o_PromedioPrestamoBean->setInteres($o_Propel->Interes);
    $o_PromedioPrestamoBean->setInteres($this->selectInteres($o_Propel->Fecha,$o_Propel->IdRepresentante));
    $o_PromedioPrestamoBean->setNumeroPrestamo($o_Propel->NumeroPrestamo);
    $o_PromedioPrestamoBean->setPrestamosNuevos($o_Propel->PrestamosNuevos);
    $o_PromedioPrestamoBean->setFechaRegistro($o_Propel->FechaRegistro);
    $o_PromedioPrestamoBean->setUsuarioRegistro($o_Propel->UsuarioRegistro);
         
    return $o_PromedioPrestamoBean;    
    
  }
   
  
  private function ObtenerDatosSucursalFecha($idSucursal,$fecha){
  	$con = Conexion::getConexion();
  	//Los datos de la Sucursal (IdAdministrador,NombreAdministrador,Nombre de Sucursal)
  	$sql =	"SELECT Descripcion,IdAdministrador,concat(ApellidoPaterno,' ',ApellidoMaterno,', ',Nombres) as NombreAdministrador 	
  			 FROM cr_sucursal s
  			 LEFT JOIN cr_colaborador c on c.IdColaborador = s.IdAdministrador
  			 where idSucursal = '$idSucursal'
  			 and c.Estado='A'
  			";
  	//echo $sql;
  	$result = $con->query($sql);
    $num_rows = $result->rowCount();
    
    if($num_rows>0){
      while ($a_valor = $result->fetch(PDO::FETCH_ASSOC)) {
     	$nombreSucursal = $a_valor['Descripcion'];
     	$IdAdministrador = $a_valor['IdAdministrador'];
     	$NombreAdministrador = $a_valor['NombreAdministrador'];
      }
    }
    
    //La lista de Representantes de la Sucursal
	$sql =	"SELECT idColaborador,concat(ApellidoPaterno,' ',ApellidoMaterno,', ',Nombres) as NombreRepresentante
			 FROM cr_colaborador c
			 where idPadre = '$IdAdministrador'
			 		and IdRol = 'sys.ope'
			 		and c.Estado='A'
			 		and c.Eliminado = '0'
			";
  	$result = $con->query($sql);
    $num_rows = $result->rowCount();
    $i = 0;
    if($num_rows>0){
      $i = 1;
      while ($a_valor = $result->fetch(PDO::FETCH_ASSOC)) {
     	
      	$a_Colaborador[$i]['idRepresentante'] 		= $a_valor['idColaborador'];
     	$a_Colaborador[$i]['NombreRepresentante'] 	= $a_valor['NombreRepresentante'];

		///
     	$clientesNuevos = $this->obtenerClientesNuevos($a_valor['idColaborador'],$con);
     	///
     	
     	$a_PromedioColaborador = $this->obtenerPromedioCapital($a_valor['idColaborador'],$con);
     	$a_prestamos_efectivos = $this->obtenerPrestamosEfectivos($a_valor['idColaborador'],$con);
     	$prestamos_vencidos = $this->obtenerPrestamosVencidos($a_valor['idColaborador'],$con);
     	     	
     	$a_Colaborador[$i]['NombreSucursal'] 		= $nombreSucursal;
     	$a_Colaborador[$i]['IdAdministrador'] 		= $IdAdministrador;
     	$a_Colaborador[$i]['NombreAdministrador'] 	= $NombreAdministrador;
     	$a_Colaborador[$i]['SumaMontoPrestado'] 	= $a_prestamos_efectivos['TotalMontoPrestado'];//$a_PromedioColaborador['SumaMontoPrestado'];
     	$a_Colaborador[$i]['MontoTotal'] 			= $a_prestamos_efectivos['TotalMontoTotal'];
     	//$a_Colaborador[$i]['MontoTotal'] 			= $a_PromedioColaborador['MontoTotal'];
     	$a_Colaborador[$i]['SaldoPrestamo'] 		= $prestamos_vencidos;
     	
     	//if($a_prestamos_efectivos['CantidadPrestamos'])$a_Colaborador[$i]['InteresPorcentaje'] 	= $a_prestamos_efectivos['TotalInteres']/$a_prestamos_efectivos['CantidadPrestamos'];else $a_Colaborador[$i]['InteresPorcentaje'] = 0;
     	$a_Colaborador[$i]['InteresPorcentaje'] 	= $a_PromedioColaborador['InteresPorcentaje'];
		$a_Colaborador[$i]['CantidadPrestamosNuevos'] = $a_PromedioColaborador['TotalPrestamos'];

     	$a_Colaborador[$i]['TotalPrestamos'] 		= $a_prestamos_efectivos['CantidadPrestamos'];
     	$a_Colaborador[$i]['PrestamosNuevos'] 		= $a_prestamos_efectivos['TotalPrestamos'];
		$a_Colaborador[$i]['CantidadClientesNuevos']= $clientesNuevos;
     	
     	
     	$i++;
      }
    }else{
    	
    	$a_Colaborador[$i]['idRepresentante'] 		= $a_valor['idColaborador'];
     	$a_Colaborador[$i]['NombreRepresentante'] 	= $a_valor['NombreRepresentante'];
     	$a_Colaborador[$i]['NombreSucursal'] 		= $nombreSucursal;
     	$a_Colaborador[$i]['IdAdministrador'] 		= $IdAdministrador;
     	$a_Colaborador[$i]['NombreAdministrador'] 	= $NombreAdministrador;
     	$a_Colaborador[$i]['SumaMontoPrestado'] 	= 0;
     	$a_Colaborador[$i]['MontoTotal'] 			= 0;
     	$a_Colaborador[$i]['SaldoPrestamo'] 		= 0;
     	$a_Colaborador[$i]['InteresPorcentaje'] 	= 0;
     	$a_Colaborador[$i]['TotalPrestamos'] 		= 0;
     	$a_Colaborador[$i]['PrestamosNuevos'] 		= 0;
    }
  	return $a_Colaborador;
  }
  
  private function selectInteres($fecha,$idcolaborador){
      
    $where = "";
    
    if($this->getObjetoBean()->getFecha()){
      	 $where .= " AND Fecha >= '".$this->getObjetoBean()->getFecha()."'";
    }
    
    if($this->getObjetoBean()->getFechaFinal()){
      	 $where .= " AND Fecha <= '".$this->getObjetoBean()->getFechaFinal()."'";
    }
    
    if($this->getObjetoBean()->getIdSucursal()){
      	 $where .= " AND IdSucursal ='".$this->getObjetoBean()->getIdSucursal()."'";
    }
    if($idcolaborador){
      	 $where .= " AND IdRepresentante ='$idcolaborador'";
    }
    
   
    
      
    
    $con = Conexion::getConexion();
    $sql = "SELECT round((sum(Interes))/count(*),2) as Interes
    				
    		FROM cr_promedioxrepresentante      
    		WHERE 1 ".$where
    			." and Interes > 0" 
    		." group by Fecha"
    		." having Interes > 0"
    		." order by Fecha asc";
    
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    
    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      	$interesSuma += round($o_valor->Interes,2);
      }
      return $interesSuma/$num_rows;
    }else{
    	return 0;
    }
  }
  
 
  
  
  private function obtenerPromedioCapital($idColaborador,$con){
  	//Acumulado de los Prestmos Pendientes a la Fecha de Cierre
  	$sql = "select count(*) as TotalPrestamos,sum(MontoPrestado)/count(*) as SumaMontoPrestado,sum(MontoTotal)/count(*) as MontoTotal,
  					sum(SaldoPrestamo)/count(*) as SaldoPrestamo,sum(InteresPorcentaje)/count(*) as InteresPorcentaje
  			from cr_prestamo
  			where IdColaborador = '".$idColaborador."'
  				and  FechaInicio = '".$this->getObjetoBean()->getFecha()."'
  				and Estado = 'P'
  				and Eliminado<>'1'
  				and Origen = 'R'
  					";
  	
  	$result = $con->query($sql);
    $num_rows = $result->rowCount();
    
    if($num_rows>0){
      while ($a_valor = $result->fetch(PDO::FETCH_ASSOC)) {
     	$a_Colaborador['SumaMontoPrestado'] 	= $a_valor['SumaMontoPrestado'];
     	$a_Colaborador['MontoTotal'] 			= $a_valor['MontoTotal'];
     	$a_Colaborador['SaldoPrestamo'] 		= $a_valor['SaldoPrestamo'];
     	$a_Colaborador['InteresPorcentaje'] 	= $a_valor['InteresPorcentaje'];
     	$a_Colaborador['TotalPrestamos'] 		= $a_valor['TotalPrestamos'];
     	
      }
    }
    return $a_Colaborador;
  }
  
  private function obtenerPrestamosEfectivos($idColaborador,$con){
  	//Acumulado de los Prestamos Pendientes a la Fecha de Cierre
  	$PrestamosEfectivos = 0;
  	$sql = "select 	sum(SaldoPrestamo) as TotalPrestamos , sum(MontoPrestado) as TotalMontoPrestado,sum(MontoTotal) as TotalMontoTotal,count(*) as CantidadPrestamos,sum(InteresPorcentaje) as TotalInteres	
  			from 	cr_prestamo
  			where 	IdColaborador = '".$idColaborador."'
  				and FechaInicio <= '".$this->getObjetoBean()->getFecha()."'				
  				and Estado = 'P'
  				and eliminado<>'1'
  				AND NoReporteCobranza = '0'";
  	//echo $sql;
  	//and Origen = 'R'
  	$result = $con->query($sql);
    $num_rows = $result->rowCount();
    
    if($num_rows>0){
      while ($a_valor = $result->fetch(PDO::FETCH_ASSOC)) {
     	$a_PrestamosEfectivos['TotalPrestamos'] 	= $a_valor['TotalPrestamos'];//Saldo
     	$a_PrestamosEfectivos['TotalMontoPrestado'] = $a_valor['TotalMontoPrestado'];
     	$a_PrestamosEfectivos['CantidadPrestamos'] 	= $a_valor['CantidadPrestamos'];
     	$a_PrestamosEfectivos['TotalInteres'] 		= $a_valor['TotalInteres'];
     	$a_PrestamosEfectivos['TotalMontoTotal'] 		= $a_valor['TotalMontoTotal'];
      }
    }
    return $a_PrestamosEfectivos;
  }
  
  private function obtenerPrestamosVencidos($idColaborador,$con){
  	//Acumulado de los Prestamos Pendientes a la Fecha de Cierre
  	$PrestamosEfectivos = 0;
  	$sql = "select 	sum(SaldoPrestamo) as TotalPrestamos 
  			from 	cr_prestamo
  			where 	IdColaborador = '".$idColaborador."'
  				and FechaVencimiento < '".$this->getObjetoBean()->getFecha()."'				
  				and Estado = 'P'
  				and eliminado<>'1'
  				AND NoReporteCobranza = '0'";
  	//echo $sql;
  	//and Origen = 'R'
  	$result = $con->query($sql);
    $num_rows = $result->rowCount();
    
    if($num_rows>0){
      while ($a_valor = $result->fetch(PDO::FETCH_ASSOC)) {
     	return  $a_valor['TotalPrestamos'];
      }
    }
    return $a_PrestamosEfectivos;
  }

   private function obtenerClientesNuevos($idColaborador,$con){
  	//Acumulado de los Prestmos Pendientes a la Fecha de Cierre
  	$sql = "select idCliente
  			from cr_prestamo
  			where IdColaborador = '".$idColaborador."'
  				and  FechaInicio = '".$this->getObjetoBean()->getFecha()."'
  				and Estado = 'P'
  			";
  	
  	$result = $con->query($sql);
    $num_rows = $result->rowCount();
    
    $numeroTotal = 0;
    if($num_rows>0){
      while ($a_valor = $result->fetch(PDO::FETCH_ASSOC)) {
     	$idCliente 	= $a_valor['idCliente'];
 		$sql = "select count(*) as cantidad
	  			from cr_prestamo
	  			where IdCliente = '".$idCliente."'
	  					and Eliminado <> '1'
	  			";
 		$result2 = $con->query($sql);
    	$num_rows2 = $result2->rowCount();
    	 if($num_rows2>0){
      		while ($a_valor2 = $result2->fetch(PDO::FETCH_ASSOC)) {
     		 if($a_valor2['cantidad'] == '1'){
     		 	$numeroTotal++;
     		 }
      		}
    	 }
      }
     }
     return $numeroTotal;
  	
  }
  
 
}

