<?php
/**
 * Clase ContBalanceGeneraler para BalanceGeneral
 *
 * @package    IM
 * @subpackage BalanceGeneralCT
 * @author     Willy
 * @version    SVN: $Id: BalanceGeneralCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class BalanceGeneralCT implements interfaceCT{
  /**
  * Funcin para Guardar el  BalanceGeneral
  *
  * @param $o_BalanceGeneralBean, objeto bean de BalanceGeneral
  * @return booleam
  */
  public function guardar(&$o_BalanceGeneralBean){ 
    
    $o_BalanceGeneralDP = new BalanceGeneralDP($o_BalanceGeneralBean);
    return $o_BalanceGeneralDP->save();
    
  }
  
  /**
  * Funcin para Modificar el  BalanceGeneral
  *
  * @param $o_BalanceGeneralBean, objeto bean de BalanceGeneral
  * @return booleam
  */
  public function modificar(&$o_BalanceGeneralBean){
    
    $o_BalanceGeneralDP = new BalanceGeneralDP($o_BalanceGeneralBean);
    return $o_BalanceGeneralDP->update();
    
  }
  
  /**
  * Funcin para Eliminar el  BalanceGeneral
  *
  * @param $o_BalanceGeneralBean, objeto bean de BalanceGeneral
  * @return booleam
  */
  public function eliminar($o_BalanceGeneralBean){ 
    $o_BalanceGeneralDP = new BalanceGeneralDP($o_BalanceGeneralBean);
    return $o_BalanceGeneralDP->delete();
  }
  
  
  public function totalRegistros($o_BalanceGeneralBean){
    $o_BalanceGeneralBeanDP = new BalanceGeneralDP($o_BalanceGeneralBean);
    return $o_BalanceGeneralBeanDP->selectNumRows();
    
  }
  
  
  /**
  * Funcin para Seleccionar el  BalanceGeneral
  *
  * @param $o_BalanceGeneralBeans, objeto bean de BalanceGeneral
  * @return booleam
  */
  public function seleccionar($o_BalanceGeneralBean){
  
    $o_BalanceGeneralDP = new BalanceGeneralDP($o_BalanceGeneralBean);
    if($o_BalanceGeneralBean->getIdBalanceGeneral()){
      return $o_BalanceGeneralDP->selectByPk();
    }else{
      return $o_BalanceGeneralDP->select();
    }
      
  }
  
}