<?php
/**
 * Clase Base FN para BaseCrAsistenciaFN
 *
 * @package    
 * @subpackage BaseCrAsistenciaFN
 * @author     Willy
 * @version    SVN:: BaseCrAsistenciaFN.class.php,v 1.1 2014-02-23 12:24:26 william.taype Exp $
 */
class BaseCrAsistenciaFN extends CrAsistenciaBN
{
  private static $fieldNames = array (
    'IdAsistencia'=>'IdAsistencia', 'IdColaborador'=>'IdColaborador', 'TipoAsistencia'=>'TipoAsistencia', 'Estado'=>'Estado', 'Fecha'=>'Fecha', 'NumeroMinutos'=>'NumeroMinutos', 'Monto'=>'Monto', 'Comentario'=>'Comentario', 'Eliminado'=>'Eliminado', 'UsuarioEliminado'=>'UsuarioEliminado', 'FechaEliminado'=>'FechaEliminado', 'FechaCreacion'=>'FechaCreacion', 'UsuarioCreacion'=>'UsuarioCreacion', 'FechaModificacion'=>'FechaModificacion', 'UsuarioModificacion'=>'UsuarioModificacion'  
  );

  public function select()
  {
    try
    {
      $tamPag = !property_exists($this, 'tamPag')?9999:$this->tamPag;
      $pagina = !property_exists($this, 'page')||$this->page==""?1:$this->page;
      $numeroRegistros = $this->selectNumRows();
      $limitInf = ($pagina-1)*$tamPag;

      $where = $this->buildConsult();
      $orden = $this->buildOrderByField();

      $con = Conexion::getConexion();
      $sql = "SELECT IdAsistencia, IdColaborador, TipoAsistencia, Estado, Fecha, NoAviso, NumeroMinutos,HoraMinutoPactado, Monto, Comentario, Eliminado, UsuarioEliminado, FechaEliminado, FechaCreacion, UsuarioCreacion, FechaModificacion, UsuarioModificacion FROM cr_asistencia WHERE 1  ".$where." ".$orden."  LIMIT ".$limitInf.",".$tamPag;
	  $sql;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      $a_tmp = array();
      if($num_rows>0){
        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
          $a_tmp[] = $this->insertObjectBN($o_valor);
        }
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function selectNumRows()
  {
    try
    {
      $where = $this->buildConsult();

      $con = Conexion::getConexion();
      $sql = "SELECT IdAsistencia, IdColaborador, TipoAsistencia, Estado, Fecha, NoAviso, NumeroMinutos, Monto, Comentario, Eliminado, UsuarioEliminado, FechaEliminado, FechaCreacion, UsuarioCreacion, FechaModificacion, UsuarioModificacion FROM cr_asistencia WHERE 1 ".$where;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      
      return $num_rows;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function montoTotal()
  {
    try
    {
      $where = $this->buildConsult();

      $con = Conexion::getConexion();
      $sql = "SELECT  sum(Monto) as Monto FROM cr_asistencia WHERE 1 ".$where;
      //echo $sql;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      if($num_rows>0){
        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
          $MontoTotal = $o_valor->Monto;
        }
      }
      
      return $MontoTotal;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  
  public function buildConsult()
  {
    try
    {
      $where = "";

      if($this->getIdAsistencia()){ $where .= " AND idasistencia = '".$this->getIdAsistencia()."'"; }
      if($this->getIdColaborador()){ $where .= " AND idcolaborador = '".$this->getIdColaborador()."'"; }
      if($this->getTipoAsistencia()){ $where .= " AND tipoasistencia = '".$this->getTipoAsistencia()."'"; }
      if($this->getEstado()){ $where .= " AND estado = '".$this->getEstado()."'"; }
      if($this->getFecha()){ $where .= " AND fecha = '".$this->getFecha()."'"; }
      if($this->getNoAviso()){ $where .= " AND NoAviso = '".$this->getNoAviso()."'"; }
      if($this->getFechaInicial()){ $where .= " AND fecha >= '".$this->getFechaInicial()."'"; }
      if($this->getFechaFinal()){ $where .= " AND fecha <= '".$this->getFechaFinal()."'"; }
      if($this->getNumeroMinutos()){ $where .= " AND numerominutos = '".$this->getNumeroMinutos()."'"; }
      if($this->getMonto()){ $where .= " AND monto = '".$this->getMonto()."'"; }
      if($this->getComentario()){ $where .= " AND comentario = '".$this->getComentario()."'"; }
      if($this->getEliminado()){ $where .= " AND eliminado = '".$this->getEliminado()."'"; }
      if($this->getUsuarioEliminado()){ $where .= " AND usuarioeliminado = '".$this->getUsuarioEliminado()."'"; }
      if($this->getFechaEliminado()){ $where .= " AND fechaeliminado = '".$this->getFechaEliminado()."'"; }
      if($this->getFechaCreacion()){ $where .= " AND fechacreacion = '".$this->getFechaCreacion()."'"; }
      if($this->getUsuarioCreacion()){ $where .= " AND usuariocreacion = '".$this->getUsuarioCreacion()."'"; }
      if($this->getFechaModificacion()){ $where .= " AND fechamodificacion = '".$this->getFechaModificacion()."'"; }
      if($this->getUsuarioModificacion()){ $where .= " AND usuariomodificacion = '".$this->getUsuarioModificacion()."'"; }
      if($this->getIdColaboradores()){
       $where .= " AND idcolaborador in ('".implode("','",$this->getIdColaboradores())."')";
   	  }
   	   if($this->getFechaFinal()){
      	 $where .= " AND Fecha <= '".$this->getFechaFinal()."'";
   		 }
   	  
      return $where;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildOrderByField()
  {
    try
    {
      $order_by = "";

      if(property_exists($this,'sortCampos')){
      if($this->sortCampos != ""){
        $a_valCampos = explode(";", $this->sortCampos);
        $a_valtype   = explode(";", $this->sortType);
        $order_by = " ORDER BY ";
        $a_order = array();
        foreach ($a_valCampos as $key => $val){
          $sTmpOrder = "";
          if(array_key_exists($val, self::$fieldNames)){
            $sTmpOrder .= self::$fieldNames[$val];
            switch ($a_valtype[$key]){
              case 1: $sTmpOrder .= " ASC"; break;
              case 2: $sTmpOrder .= " DESC"; break;
            }
            $a_order[] = $sTmpOrder;
          }
        }
        $order_by .= implode(", ", $a_order);
      }
      }
      return $order_by;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* B�squeda del registro por la llave primaria */
  public function selectByPK()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IdAsistencia, IdColaborador, TipoAsistencia, Estado, Fecha, NoAviso,NumeroMinutos, Monto,HoraMinutoPactado, Comentario, Eliminado, UsuarioEliminado, FechaEliminado, FechaCreacion, UsuarioCreacion, FechaModificacion, UsuarioModificacion FROM cr_asistencia WHERE 1 AND IdAsistencia='".$this->getIdAsistencia()."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      

      return $o_Propel?$this->insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_BaseCrAsistenciaFN = new BaseCrAsistenciaFN();
    $o_BaseCrAsistenciaFN->setIdAsistencia($o_propel->IdAsistencia);
    $o_BaseCrAsistenciaFN->setIdColaborador($o_propel->IdColaborador);
    $o_BaseCrAsistenciaFN->setTipoAsistencia($o_propel->TipoAsistencia);
    $o_BaseCrAsistenciaFN->setEstado($o_propel->Estado);
    $o_BaseCrAsistenciaFN->setFecha($o_propel->Fecha);
    $o_BaseCrAsistenciaFN->setNoAviso($o_propel->NoAviso);
    $o_BaseCrAsistenciaFN->setNumeroMinutos($o_propel->NumeroMinutos);
    $o_BaseCrAsistenciaFN->setHoraMinutoPactado($o_propel->HoraMinutoPactado);
    $o_BaseCrAsistenciaFN->setMonto($o_propel->Monto);
    $o_BaseCrAsistenciaFN->setComentario($o_propel->Comentario);
    $o_BaseCrAsistenciaFN->setEliminado($o_propel->Eliminado);
    $o_BaseCrAsistenciaFN->setUsuarioEliminado($o_propel->UsuarioEliminado);
    $o_BaseCrAsistenciaFN->setFechaEliminado($o_propel->FechaEliminado);
    $o_BaseCrAsistenciaFN->setFechaCreacion($o_propel->FechaCreacion);
    $o_BaseCrAsistenciaFN->setUsuarioCreacion($o_propel->UsuarioCreacion);
    $o_BaseCrAsistenciaFN->setFechaModificacion($o_propel->FechaModificacion);
    $o_BaseCrAsistenciaFN->setUsuarioModificacion($o_propel->UsuarioModificacion);
    return $o_BaseCrAsistenciaFN;
  }
}