<?php
/**
 * Clase Base DP para BaseCrAsistenciaDP
 *
 * @package    
 * @subpackage BaseCrAsistenciaDP
 * @author     Willy
 * @version    SVN:: BaseCrAsistenciaDP.class.php,v 1.1 2014-02-23 12:24:07 william.taype Exp $
 */
abstract class BaseCrAsistenciaDP extends CrAsistenciaBN
{
  /* N�mero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof CrAsistenciaBN )
    {
      $o_CrAsistenciaBN = $bSetDefault;
      if($o_CrAsistenciaBN->getIdAsistencia()) : $this->setIdAsistencia($o_CrAsistenciaBN->getIdAsistencia()); endif;
      if($o_CrAsistenciaBN->getIdColaborador()) : $this->setIdColaborador($o_CrAsistenciaBN->getIdColaborador()); endif;
      if($o_CrAsistenciaBN->getTipoAsistencia()) : $this->setTipoAsistencia($o_CrAsistenciaBN->getTipoAsistencia()); endif;
      if($o_CrAsistenciaBN->getEstado()) : $this->setEstado($o_CrAsistenciaBN->getEstado()); endif;
      if($o_CrAsistenciaBN->getFecha()) : $this->setFecha($o_CrAsistenciaBN->getFecha()); endif;
      if($o_CrAsistenciaBN->getNoAviso()) : $this->setNoAviso($o_CrAsistenciaBN->getNoAviso()); endif;
      if($o_CrAsistenciaBN->getNumeroMinutos()) : $this->setNumeroMinutos($o_CrAsistenciaBN->getNumeroMinutos()); endif;
      if($o_CrAsistenciaBN->getMonto()) : $this->setMonto($o_CrAsistenciaBN->getMonto()); endif;
      if($o_CrAsistenciaBN->getComentario()) : $this->setComentario($o_CrAsistenciaBN->getComentario()); endif;
      if($o_CrAsistenciaBN->getEliminado()) : $this->setEliminado($o_CrAsistenciaBN->getEliminado()); endif;
      if($o_CrAsistenciaBN->getUsuarioEliminado()) : $this->setUsuarioEliminado($o_CrAsistenciaBN->getUsuarioEliminado()); endif;
      if($o_CrAsistenciaBN->getFechaEliminado()) : $this->setFechaEliminado($o_CrAsistenciaBN->getFechaEliminado()); endif;
      if($o_CrAsistenciaBN->getFechaCreacion()) : $this->setFechaCreacion($o_CrAsistenciaBN->getFechaCreacion()); endif;
      if($o_CrAsistenciaBN->getUsuarioCreacion()) : $this->setUsuarioCreacion($o_CrAsistenciaBN->getUsuarioCreacion()); endif;
      if($o_CrAsistenciaBN->getFechaModificacion()) : $this->setFechaModificacion($o_CrAsistenciaBN->getFechaModificacion()); endif;
      if($o_CrAsistenciaBN->getUsuarioModificacion()) : $this->setUsuarioModificacion($o_CrAsistenciaBN->getUsuarioModificacion()); endif;
    }
  }

  /* Obtiene el n�mero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
    
        $a_Fields = array();

        if($this->getIdAsistencia()) : $a_Fields['IdAsistencia'] = ($this->getIdAsistencia()); endif;
        if($this->getIdColaborador()) : $a_Fields['IdColaborador'] = ($this->getIdColaborador()); endif;
        if($this->getTipoAsistencia()) : $a_Fields['TipoAsistencia'] = ($this->getTipoAsistencia()); endif;
        if($this->getEstado()) : $a_Fields['Estado'] = ($this->getEstado()); endif;
        if($this->getFecha()) : $a_Fields['Fecha'] = ($this->getFecha()); endif;
        if($this->getNumeroMinutos()) : $a_Fields['NumeroMinutos'] = ($this->getNumeroMinutos()); endif;
        if($this->getMonto()) : $a_Fields['Monto'] = ($this->getMonto()); endif;
        if($this->getNoAviso()) : $a_Fields['NoAviso'] = ($this->getNoAviso()); endif;
        if($this->getComentario()) : $a_Fields['Comentario'] = ($this->getComentario()); endif;
        
        if($this->getRegistroLongitud()) : $a_Fields['RegistroLongitud'] = ($this->getRegistroLongitud()); endif;
        if($this->getRegistroLatitud()) : $a_Fields['RegistroLatitud'] = ($this->getRegistroLatitud()); endif;
        if($this->getHoraMinutoPactado()) : $a_Fields['HoraMinutoPactado'] = ($this->getHoraMinutoPactado()); endif;
        
        if($this->getEliminado()) : $a_Fields['Eliminado'] = ($this->getEliminado()); endif;
        if($this->getUsuarioEliminado()) : $a_Fields['UsuarioEliminado'] = ($this->getUsuarioEliminado()); endif;
        if($this->getFechaEliminado()) : $a_Fields['FechaEliminado'] = ($this->getFechaEliminado()); endif;
        if($this->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getFechaCreacion()); endif;
        if($this->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getUsuarioCreacion()); endif;
        if($this->getFechaModificacion()) : $a_Fields['FechaModificacion'] = ($this->getFechaModificacion()); endif;
        if($this->getUsuarioModificacion()) : $a_Fields['UsuarioModificacion'] = ($this->getUsuarioModificacion()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO cr_asistencia (".$sStringField.") VALUES (".$sStringValue.");";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
     
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdAsistencia())
      {
        $a_Fields = array();

        if($this->getIdAsistencia()) : $a_Fields['IdAsistencia'] = ($this->getIdAsistencia()); endif;
        if($this->getIdColaborador()) : $a_Fields['IdColaborador'] = ($this->getIdColaborador()); endif;
        if($this->getTipoAsistencia()) : $a_Fields['TipoAsistencia'] = ($this->getTipoAsistencia()); endif;
        if($this->getEstado()) : $a_Fields['Estado'] = ($this->getEstado()); endif;
        if($this->getFecha()) : $a_Fields['Fecha'] = ($this->getFecha()); endif;
        if($this->getNoAviso()) : $a_Fields['NoAviso'] = ($this->getNoAviso()); endif;
        if($this->getNumeroMinutos()) : $a_Fields['NumeroMinutos'] = ($this->getNumeroMinutos()); endif;
        if($this->getMonto()) : $a_Fields['Monto'] = ($this->getMonto()); endif;
        if($this->getComentario()) : $a_Fields['Comentario'] = ($this->getComentario()); endif;
        if($this->getEliminado()) : $a_Fields['Eliminado'] = ($this->getEliminado()); endif;
        if($this->getUsuarioEliminado()) : $a_Fields['UsuarioEliminado'] = ($this->getUsuarioEliminado()); endif;
        if($this->getFechaEliminado()) : $a_Fields['FechaEliminado'] = ($this->getFechaEliminado()); endif;
        if($this->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getFechaCreacion()); endif;
        if($this->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getUsuarioCreacion()); endif;
        if($this->getFechaModificacion()) : $a_Fields['FechaModificacion'] = ($this->getFechaModificacion()); endif;
        if($this->getUsuarioModificacion()) : $a_Fields['UsuarioModificacion'] = ($this->getUsuarioModificacion()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE cr_asistencia SET ".$sStringField." WHERE 1 AND IdAsistencia='".$this->getIdAsistencia()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }
  
  
   public function delete()
  {
    try
    {
      if($this->getIdAsistencia())
      {
        $a_Fields = array();

        if($this->getIdAsistencia()) : $a_Fields['IdAsistencia'] = ($this->getIdAsistencia()); endif;
        if($this->getIdColaborador()) : $a_Fields['IdColaborador'] = ($this->getIdColaborador()); endif;
        if($this->getTipoAsistencia()) : $a_Fields['TipoAsistencia'] = ($this->getTipoAsistencia()); endif;
        if($this->getEstado()) : $a_Fields['Estado'] = ($this->getEstado()); endif;
        if($this->getFecha()) : $a_Fields['Fecha'] = ($this->getFecha()); endif;
        if($this->getNoAviso()) : $a_Fields['NoAviso'] = ($this->getNoAviso()); endif;
        if($this->getNumeroMinutos()) : $a_Fields['NumeroMinutos'] = ($this->getNumeroMinutos()); endif;
        if($this->getMonto()) : $a_Fields['Monto'] = ($this->getMonto()); endif;
        if($this->getComentario()) : $a_Fields['Comentario'] = ($this->getComentario()); endif;
        $a_Fields['eliminado'] = '1';
        if($this->getUsuarioEliminado()) : $a_Fields['UsuarioEliminado'] = ($this->getUsuarioEliminado()); endif;
        if($this->getFechaEliminado()) : $a_Fields['FechaEliminado'] = ($this->getFechaEliminado()); endif;
        if($this->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getFechaCreacion()); endif;
        if($this->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getUsuarioCreacion()); endif;
        if($this->getFechaModificacion()) : $a_Fields['FechaModificacion'] = ($this->getFechaModificacion()); endif;
        if($this->getUsuarioModificacion()) : $a_Fields['UsuarioModificacion'] = ($this->getUsuarioModificacion()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE cr_asistencia SET ".$sStringField." WHERE 1 AND IdAsistencia='".$this->getIdAsistencia()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }
  

  public function deletexx()
  {
    try
    {
      if($this->getIdAsistencia())
      {
        $a_Fields = array();

        $con = Conexion2::getConexion2();
        $sql = "DELETE FROM cr_asistencia WHERE 1 AND IdAsistencia='".$this->getIdAsistencia()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* B�squeda del registro por la llave primaria */
  public static function selectByPK($vIdAsistencia)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IdAsistencia, IdColaborador, TipoAsistencia, Estado, Fecha, NoAviso, NumeroMinutos, Monto, Comentario, Eliminado, UsuarioEliminado, FechaEliminado, FechaCreacion, UsuarioCreacion, FechaModificacion, UsuarioModificacion FROM cr_asistencia WHERE 1 AND IdAsistencia='".$vIdAsistencia."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_CrAsistenciaDP = new CrAsistenciaDP();
    $o_CrAsistenciaDP->setIdAsistencia($o_propel->IdAsistencia);
    $o_CrAsistenciaDP->setIdColaborador($o_propel->IdColaborador);
    $o_CrAsistenciaDP->setTipoAsistencia($o_propel->TipoAsistencia);
    $o_CrAsistenciaDP->setEstado($o_propel->Estado);
    $o_CrAsistenciaDP->setFecha($o_propel->Fecha);
    $o_CrAsistenciaDP->setNoAviso($o_propel->NoAviso);
    $o_CrAsistenciaDP->setNumeroMinutos($o_propel->NumeroMinutos);
    $o_CrAsistenciaDP->setMonto($o_propel->Monto);
    $o_CrAsistenciaDP->setHoraMinutoPactado($o_propel->HoraMinutoPactado);
    $o_CrAsistenciaDP->setComentario($o_propel->Comentario);
    $o_CrAsistenciaDP->setEliminado($o_propel->Eliminado);
    $o_CrAsistenciaDP->setUsuarioEliminado($o_propel->UsuarioEliminado);
    $o_CrAsistenciaDP->setFechaEliminado($o_propel->FechaEliminado);
    $o_CrAsistenciaDP->setFechaCreacion($o_propel->FechaCreacion);
    $o_CrAsistenciaDP->setUsuarioCreacion($o_propel->UsuarioCreacion);
    $o_CrAsistenciaDP->setFechaModificacion($o_propel->FechaModificacion);
    $o_CrAsistenciaDP->setUsuarioModificacion($o_propel->UsuarioModificacion);
    return $o_CrAsistenciaDP;
  }
}