
<?php

/**
* Clase Dispacher para Adelanto
*
* @package IM
* @subpackage AdelantoDP
* @author Willy
* @version SVN: : AdelantoDP.class.php,v 1.1 2009/06/01 13:16:53 Exp $
*/
class AdelantoDP implements interfaceDP {

  protected $o_Bean;

  /**
  * Constructor donde asigna a un atributo el objeto AdelantoBean
  *
  * @param AdelantoBean $o_AdelantoBean
  */
  public function __construct(AdelantoBean $o_AdelantoBean){
  
    $this->o_Bean = $o_AdelantoBean;
    
  }
  
  /**
  * Retorna el objeto AdelantoBean
  *
  * @return Object
  */
  protected function getObjetoBean(){
  
    if(!$this->o_Bean){
        $this->o_Bean = new AdelantoBean();
    }        
    return $this->o_Bean;
    
  }
  
  /**
  * Ingresa un nuevo registro
  *
  * @return IdGenerado
  */
  public function save(){
    $con = Conexion::getConexion();
      $a_Fields = array();
      
       //if($this->getObjetoBean()->getIdAdelanto()) : $a_Fields['IdAdelanto'] = ($this->getObjetoBean()->getIdAdelanto()); endif;
      if($this->getObjetoBean()->getIdColaborador()) : $a_Fields['IdColaborador'] = ($this->getObjetoBean()->getIdColaborador()); endif;
      if($this->getObjetoBean()->getFechaAdelanto()) : $a_Fields['FechaAdelanto'] = ($this->getObjetoBean()->getFechaAdelanto()); endif;
      if($this->getObjetoBean()->getMonto()) : $a_Fields['Monto'] = ($this->getObjetoBean()->getMonto()); endif;
      if($this->getObjetoBean()->getDescripcion()) : $a_Fields['Descripcion'] = ($this->getObjetoBean()->getDescripcion()); endif;
      if($this->getObjetoBean()->getEstado()) : $a_Fields['Estado'] = ($this->getObjetoBean()->getEstado()); endif;
      if($this->getObjetoBean()->getEliminado()) : $a_Fields['Eliminado'] = ($this->getObjetoBean()->getEliminado()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getUsuarioModificacion()) : $a_Fields['UsuarioModificacion'] = ($this->getObjetoBean()->getUsuarioModificacion()); endif;
      if($this->getObjetoBean()->getFechaModificacion()) : $a_Fields['FechaModificacion'] = ($this->getObjetoBean()->getFechaModificacion()); endif;
      if($this->getObjetoBean()->getFechaEliminado()) : $a_Fields['FechaEliminado'] = ($this->getObjetoBean()->getFechaEliminado()); endif;
      if($this->getObjetoBean()->getUsuarioEliminado()) : $a_Fields['UsuarioEliminado'] = ($this->getObjetoBean()->getUsuarioEliminado()); endif;
  
      
      $sStringField = arrayClass::implode_keys(',', $a_Fields);
      $sStringValue = "'".implode("','", $a_Fields)."'";

      $sql = "INSERT INTO cr_adelanto_sueldo (".$sStringField.")
                      VALUES (".$sStringValue.");";
      //echo $sql;
      $iResultSave = $con->query($sql);
      
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }
  
  }
  
  
  /**
  * Modifica un nuevo registro
  *
  * @return IdGenerado
  */
  public function update() {

    if($this->getObjetoBean()->getIdAdelanto()){
      $con = Conexion::getConexion();
      $a_Fields = array();
      
      if($this->getObjetoBean()->getIdAdelanto()) : $a_Fields['IdAdelanto'] = ($this->getObjetoBean()->getIdAdelanto()); endif;
      if($this->getObjetoBean()->getIdColaborador()) : $a_Fields['IdColaborador'] = ($this->getObjetoBean()->getIdColaborador()); endif;
      if($this->getObjetoBean()->getFechaAdelanto()) : $a_Fields['FechaAdelanto'] = ($this->getObjetoBean()->getFechaAdelanto()); endif;
      if($this->getObjetoBean()->getMonto()) : $a_Fields['Monto'] = ($this->getObjetoBean()->getMonto()); endif;
      if($this->getObjetoBean()->getDescripcion()) : $a_Fields['Descripcion'] = ($this->getObjetoBean()->getDescripcion()); endif;
      if($this->getObjetoBean()->getEstado()) : $a_Fields['Estado'] = ($this->getObjetoBean()->getEstado()); endif;
      if($this->getObjetoBean()->getEliminado()) : $a_Fields['Eliminado'] = ($this->getObjetoBean()->getEliminado()); endif;
      if($this->getObjetoBean()->getUsuarioCreacion()) : $a_Fields['UsuarioCreacion'] = ($this->getObjetoBean()->getUsuarioCreacion()); endif;
      if($this->getObjetoBean()->getFechaCreacion()) : $a_Fields['FechaCreacion'] = ($this->getObjetoBean()->getFechaCreacion()); endif;
      if($this->getObjetoBean()->getUsuarioModificacion()) : $a_Fields['UsuarioModificacion'] = ($this->getObjetoBean()->getUsuarioModificacion()); endif;
      if($this->getObjetoBean()->getFechaModificacion()) : $a_Fields['FechaModificacion'] = ($this->getObjetoBean()->getFechaModificacion()); endif;
      if($this->getObjetoBean()->getFechaEliminado()) : $a_Fields['FechaEliminado'] = ($this->getObjetoBean()->getFechaEliminado()); endif;
      if($this->getObjetoBean()->getUsuarioEliminado()) : $a_Fields['UsuarioEliminado'] = ($this->getObjetoBean()->getUsuarioEliminado()); endif;
      
      
      $sString = arrayClass::implode_key_value(",", $a_Fields);

      $sql = "UPDATE cr_adelanto_sueldo  SET
                  ".$sString."
            WHERE 1 AND IdAdelanto= '".$this->getObjetoBean()->getIdAdelanto()."' ";
      
      $result = $con->query($sql);
      
      //echo $sql;           
      $iResultSave = $result;
      if($iResultSave > 0){
        return $iResultSave;
      }else{
        return false;
      }

    }else{
      return false;
    }

  }
  
  
  /**
  * Elimina registro
  *
  * @return Boolean
  */
  public function delete(){
    
      $o_Adelanto = new AdelantoBean();
      
      $con = Conexion::getConexion();
      
      if($this->getObjetoBean()->getIdAdelanto()){
          $o_Adelanto->setIdAdelanto($this->getObjetoBean()->getIdAdelanto());
      }
            
      $sql = "UPDATE cr_adelanto_sueldo 
              SET
                Eliminado = '1',
                FechaEliminado = '".date('Y-m-d H:i:s')."',
                UsuarioEliminado = '".$this->getObjetoBean()->getUsuarioEliminado()."'
            WHERE IdAdelanto= '".$this->getObjetoBean()->getIdAdelanto()."' ";
      
      $result = $con->query($sql);
      
      $num_rows = $result->rowCount();
      
                  
      $iResultDelete = $num_rows;
      if($iResultDelete){
          return 1;
      }else{
          return false;
      }    
    
  }
  /**
  * Selecciona un nuevo registro
  *
  * @return IdGenerado
  */
  public function select(){
    $tamPag           = is_null($this->getObjetoBean()->tamPag)?1:$this->getObjetoBean()->tamPag;
    $pagina           = is_null($this->getObjetoBean()->page)?1:$this->getObjetoBean()->page;
    $numeroRegistros  = $this->selectNumRows();
    $limitInf         = ($pagina-1)*$tamPag;
    
    $where = $this->buildConsult();
    $orden = $this->buildOrderByField();
    
    $con = Conexion::getConexion();
    $sql = "SELECT ad.*, co.ApellidoPaterno,co.ApellidoMaterno,co.Nombres
            FROM cr_adelanto_sueldo ad
             LEFT JOIN cr_colaborador co ON ad.IdColaborador = co.IdColaborador 
            WHERE ad.Eliminado <> '1' ".
            $where." ".$orden." LIMIT ".$limitInf.",".$tamPag;
    
    //echo $sql;
    $result = $con->query($sql);
    $num_rows = $result->rowCount();

    $a_tmp = array();

    if($num_rows>0){
      while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      $a_tmp[] = $this->insertarObjetoBean($o_valor);
      }
    }

    
   
    return count($a_tmp)>0?$a_tmp:null;
      
  }
   public function buildOrderByField(){
    $order_by = "";
    if($this->getObjetoBean()->sortCampos || $this->getObjetoBean()->sortCampos != ""){
      $a_valCampos = explode(";", $this->getObjetoBean()->sortCampos);
      $a_valtype   = explode(";", $this->getObjetoBean()->sortType);
      $order_by = " ORDER BY ";
      $a_order = array();
      foreach ($a_valCampos as $key => $val){
        $sTmpOrder = "";
        if(array_key_exists($val, self::$fieldNames)){
          $sTmpOrder .= self::$fieldNames[$val];
          switch ($a_valtype[$key]){
            case 1: $sTmpOrder .= " ASC"; break;
            case 2: $sTmpOrder .= " DESC"; break;
          }
          $a_order[] = $sTmpOrder;
        }
      }
      $order_by .= implode(", ", $a_order);
    }
    return $order_by;
  }
  
  
  /**
  * Retorna un objeto AdelantoBean
  *
  * @return Object
  */
 
  public function selectByPk(){
  
    $con = Conexion::getConexion();
    $sql = " SELECT ad.*, co.Nombres 
             FROM cr_adelanto_sueldo ad
             LEFT JOIN cr_colaborador co ON ad.IdColaborador = co.IdColaborador 
    		 WHERE  ad.Eliminado <> '1' and IdAdelanto='".$this->getObjetoBean()->getIdAdelanto()."' ";
    $result = $con->query($sql);
    $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
    
    //echo $sql;
    return $o_Propel?$this->insertarObjetoBean($o_Propel):null;
  
  }
  
   
  
  /**
  * Reasigna valores retornados del propel a un objeto AdelantoBean
  *
  * @param Object $o_Propel
  * @return AdelantoBean
  */
  private function insertarObjetoBean($o_Propel){

    $o_AdelantoBean = new AdelantoBean();
    
    $o_AdelantoBean->setIdAdelanto($o_Propel->IdAdelanto);
    $o_AdelantoBean->setIdColaborador($o_Propel->IdColaborador);
    $o_AdelantoBean->setFechaAdelanto($o_Propel->FechaAdelanto);
    $o_AdelantoBean->setMonto($o_Propel->Monto);
    $o_AdelantoBean->setDescripcion($o_Propel->Descripcion);
    $o_AdelantoBean->setEstado($o_Propel->Estado);
    $o_AdelantoBean->setEliminado($o_Propel->Eliminado);
    $o_AdelantoBean->setUsuarioCreacion($o_Propel->UsuarioCreacion);
    $o_AdelantoBean->setFechaCreacion($o_Propel->FechaCreacion);
    $o_AdelantoBean->setUsuarioModificacion($o_Propel->UsuarioModificacion);
    $o_AdelantoBean->setFechaModificacion($o_Propel->FechaModificacion);
    $o_AdelantoBean->setFechaEliminado($o_Propel->FechaEliminado);
    $o_AdelantoBean->setUsuarioEliminado($o_Propel->UsuarioEliminado);
    $o_AdelantoBean->setNombres($o_Propel->Nombres);  
    $o_AdelantoBean->setNombreCompleto($o_Propel->ApellidoPaterno." ".$o_Propel->ApellidoMaterno." ".$o_Propel->Nombres);
         
    return $o_AdelantoBean;    
    
  }
  public function selectNumRows(){
    
    $where = $this->buildConsult();
    
    $con = Conexion::getConexion();
    $sql = "SELECT *
             FROM cr_adelanto_sueldo ad
             LEFT JOIN cr_colaborador co ON ad.IdColaborador = co.IdColaborador 
     		WHERE ad.Eliminado <> '1'".$where;
   
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    
    
   
    return $num_rows;
    
  }
  
   public function selectTotalMonto(){
    
    $where = $this->buildConsult();
    
    $con = Conexion::getConexion();
    $sql = "SELECT sum(Monto) as MONTO
    		 FROM cr_adelanto_sueldo ad
             LEFT JOIN cr_colaborador co ON ad.IdColaborador = co.IdColaborador 
     		WHERE ad.Eliminado <> '1'".$where;
   
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    
     while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
      $monto_total = $o_valor->MONTO;
      }
    
    
   
    return $monto_total;
    
  }
  private function buildConsult(){
    
    $where = "";
    
    if($this->getObjetoBean()->getIdAdelanto()){
       $where .= " AND IdAdelanto  = '".$this->getObjetoBean()->getIdAdelanto()."'";
    }
    if($this->getObjetoBean()->getIdColaborador()){
      
       $where .= " AND ad.IdColaborador= '".$this->getObjetoBean()->getIdColaborador()."'";
       
    }
    if($this->getObjetoBean()->getFechaAdelanto()){
       $where .= " AND FechaAdelanto >='".$this->getObjetoBean()->getFechaAdelanto()."'";
    }
    if($this->getObjetoBean()->getEstado()){
        $where .= " AND ad.Estado  = '".$this->getObjetoBean()->getEstado()."'";
    }
   
    if($this->getObjetoBean()->getFechaFinal()){
       $where .= " AND FechaAdelanto <= '".$this->getObjetoBean()->getFechaFinal()."'";
    }
   if($this->getObjetoBean()->getIdColaboradores()){
       $where .= " AND ad.IdColaborador in ('".implode("','",$this->getObjetoBean()->getIdColaboradores())."')";
   }
    return $where;
    
  }
  function selectResultset(){
    
    $tamPag           = is_null($this->getObjetoBean()->tamPag)?9999:$this->getObjetoBean()->tamPag;
    $pagina           = is_null($this->getObjetoBean()->page)?1:$this->getObjetoBean()->page;
    $numeroRegistros  = $this->selectNumRows();
    $limitInf         = ($pagina-1)*$tamPag;
    
    $where = $this->buildConsult();
    
    
    $con = Conexion::getConexion();
    $sql = "SELECT *
             FROM cr_adelanto_sueldo ad
             LEFT JOIN cr_colaborador co ON ad.IdColaborador = co.IdColaborador 
            WHERE ad.Eliminado <> '1' ".
            $where." ".$orden." LIMIT ".$limitInf.",".$tamPag;
    
    //echo $sql;
    $result = $con->query($sql);
    $num_rows = $result->rowCount();
    
    

    $a_tmp = array();

    if($num_rows>0){
      
      return $result;
      
    }else{
      return null;
    }
        
  }
    
}

