<?php
/**
 * Clase ContAdelantoer para Adelanto
 *
 * @package    IM
 * @subpackage AdelantoCT
 * @author     Willy
 * @version    SVN: $Id: AdelantoCT.class.php,v 1.1 2008/02/07 17:43:21 william.taype Exp $ 
 */
class AdelantoCT implements interfaceCT{
  /**
  * Funcin para Guardar el  Adelanto
  *
  * @param $o_AdelantoBean, objeto bean de Adelanto
  * @return booleam
  */
  public function guardar(&$o_AdelantoBean){ 
    
    $o_AdelantoDP = new AdelantoDP($o_AdelantoBean);
    return $o_AdelantoDP->save();
    
  }
  
  /**
  * Funcin para Modificar el  Adelanto
  *
  * @param $o_AdelantoBean, objeto bean de Adelanto
  * @return booleam
  */
  public function modificar(&$o_AdelantoBean){
    
    $o_AdelantoDP = new AdelantoDP($o_AdelantoBean);
    return $o_AdelantoDP->update();
    
  }
  
  /**
  * Funcin para Eliminar el  Adelanto
  *
  * @param $o_AdelantoBean, objeto bean de Adelanto
  * @return booleam
  */
  public function eliminar($o_AdelantoBean){ 
    $o_AdelantoDP = new AdelantoDP($o_AdelantoBean);
    return $o_AdelantoDP->delete();
  }
  
  
  public function totalRegistros($o_AdelantoBean){
    $o_AdelantoBeanDP = new AdelantoDP($o_AdelantoBean);
    return $o_AdelantoBeanDP->selectNumRows();
    
  }
  
   public function totalMonto($o_AdelantoBean){
    $o_AdelantoBeanDP = new AdelantoDP($o_AdelantoBean);
    return $o_AdelantoBeanDP->selectTotalMonto();
    
  }
  
  
  /**
  * Funcin para Seleccionar el  Adelanto
  *
  * @param $o_AdelantoBeans, objeto bean de Adelanto
  * @return booleam
  */
  public function seleccionar($o_AdelantoBean){
  
    $o_AdelantoDP = new AdelantoDP($o_AdelantoBean);
    if($o_AdelantoBean->getIdAdelanto()){
      return $o_AdelantoDP->selectByPk();
    }else{
      return $o_AdelantoDP->select();
    }
      
  }
  
}