<?php
/**
 * Clase AdelantoBL
 *
 * @package    
 * @subpackage 
 * @author     AdelantoBL
 * @version    SVN: $Id: AdelantoBL.class.php,v 1.1 2008/02/08 21:56:44 william.taype Exp $ 
 */
class AdelantoBL{
    
  /**
  * 
  *
  * @param $o_AdelantoBean, objeto de tipo Adelanto 
  * @return Boolean
  */
  public function busquedaAdelanto(AdelantoBean $o_AdelantoBean){
    
    $o_AdelantoDP = new AdelantoDP($o_AdelantoBean);
    if($o_AdelantoBean->getIdAdelanto()){
      return $o_AdelantoDP->selectByPk();
    }else{
      return $o_AdelantoDP->select();
    }
    
  }
  
  public function busquedaAdelantoResulset(AdelantoBean $o_AdelantoBean){
    
    $o_AdelantoDP = new AdelantoDP($o_AdelantoBean);
    return $o_AdelantoDP->selectResultset();
        
  }
  
  public function insertarAdelanto(AdelantoBean $o_AdelantoBean){
    
    $o_AdelantoCT = new AdelantoCT();
    return $o_AdelantoCT->guardar($o_AdelantoBean);
    
  }
  public function modificarAdelanto(AdelantoBean $o_AdelantoBean){
      $o_AdelantoCT = new AdelantoCT();
      return $o_AdelantoCT->modificar($o_AdelantoBean);
  }
  /**
	* Funcin que retorna un objeto Adelanto o una lista de Objetos de Adelanto,
	* dependiendo del parametro que se le envia si este contiene o no el Id de Adelanto
	*
	* @param $o_AdelantoBean, es un objeto de tipo Adelanto
	* @return Object
	*/
	public function modificarEstadoAdelanto(AdelantoBean $o_AdelantoBean){
	  
	}
  
  public function eliminarAdelanto(AdelantoBean $o_AdelantoBean){
    $o_AdelantoCT = new AdelantoCT();
    return $o_AdelantoCT->eliminar($o_AdelantoBean);
    
  }
  
  public function getCountResult(AdelantoBean $o_AdelantoBean){
    $o_AdelantoCT = new AdelantoCT();
    return $o_AdelantoCT->totalRegistros($o_AdelantoBean);
  }
  
  public function getTotalMonto(AdelantoBean $o_AdelantoBean){
    $o_AdelantoCT = new AdelantoCT();
    return $o_AdelantoCT->totalMonto($o_AdelantoBean);
  }
}

