<?php
/**
 * Clase Base FN para BaseCrPrAsignarDetalleFN
 *
 * @package    
 * @subpackage BaseCrPrAsignarDetalleFN
 * @author     Willy
 * @version    SVN:: BaseCrPrAsignarDetalleFN.class.php,v 1.1 2018-07-03 15:02:12 william.taype Exp $
 */
class BaseCrPrAsignarDetalleFN extends CrPrAsignarDetalleBN
{
  private static $fieldNames = array (
    'Idmercado'=>'idmercado', 'Idcolaborador'=>'idcolaborador', 'Fecha'=>'fecha', 'Idprestamo'=>'idprestamo', 'Fecharegistro'=>'fecharegistro', 'Usuarioregistro'=>'usuarioregistro'  
  );

  public function select()
  {
    try
    {
      $tamPag = !property_exists($this, 'tamPag')?9999:$this->tamPag;
      $pagina = !property_exists($this, 'page')||$this->page==""?1:$this->page;
      $numeroRegistros = $this->selectNumRows();
      $limitInf = ($pagina-1)*$tamPag;

      $where = $this->buildConsult();
      $orden = $this->buildOrderByField();

      $con = Conexion::getConexion();
      $sql = "SELECT idmercado, idcolaborador, fecha, idprestamo, fecharegistro, usuarioregistro FROM cr_pr_asignar_detalle WHERE 1 ".$where." ".$orden."  LIMIT ".$limitInf.",".$tamPag;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      $a_tmp = array();
      if($num_rows>0){
        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
          $a_tmp[] = $this->insertObjectBN($o_valor);
        }
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function selectNumRows()
  {
    try
    {
      $where = $this->buildConsult();

      $con = Conexion::getConexion();
      $sql = "SELECT idmercado, idcolaborador, fecha, idprestamo, fecharegistro, usuarioregistro FROM cr_pr_asignar_detalle WHERE 1 ".$where;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      
      return $num_rows;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildConsult()
  {
    try
    {
      $where = "";

      if($this->getIdmercado()){ $where .= " AND idmercado = '".$this->getIdmercado()."'"; }
      if($this->getIdcolaborador()){ $where .= " AND idcolaborador = '".$this->getIdcolaborador()."'"; }
      if($this->getFecha()){ $where .= " AND fecha = '".$this->getFecha()."'"; }
      if($this->getIdprestamo()){ $where .= " AND idprestamo = '".$this->getIdprestamo()."'"; }
      if($this->getFecharegistro()){ $where .= " AND fecharegistro = '".$this->getFecharegistro()."'"; }
      if($this->getUsuarioregistro()){ $where .= " AND usuarioregistro = '".$this->getUsuarioregistro()."'"; }
      return $where;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildOrderByField()
  {
    try
    {
      $order_by = "";

      if(property_exists($this,'sortCampos')){
      if($this->sortCampos != ""){
        $a_valCampos = explode(";", $this->sortCampos);
        $a_valtype   = explode(";", $this->sortType);
        $order_by = " ORDER BY ";
        $a_order = array();
        foreach ($a_valCampos as $key => $val){
          $sTmpOrder = "";
          if(array_key_exists($val, self::$fieldNames)){
            $sTmpOrder .= self::$fieldNames[$val];
            switch ($a_valtype[$key]){
              case 1: $sTmpOrder .= " ASC"; break;
              case 2: $sTmpOrder .= " DESC"; break;
            }
            $a_order[] = $sTmpOrder;
          }
        }
        $order_by .= implode(", ", $a_order);
      }
      }
      return $order_by;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* B�squeda del registro por la llave primaria */
  public function selectByPK()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idmercado, idcolaborador, fecha, idprestamo, fecharegistro, usuarioregistro FROM cr_pr_asignar_detalle WHERE 1 AND idmercado='".$this->getIdmercado()."' AND idcolaborador='".$this->getIdcolaborador()."' AND fecha='".$this->getFecha()."' AND idprestamo='".$this->getIdprestamo()."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      

      return $o_Propel?$this->insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_BaseCrPrAsignarDetalleFN = new BaseCrPrAsignarDetalleFN();
    $o_BaseCrPrAsignarDetalleFN->setIdmercado($o_propel->idmercado);
    $o_BaseCrPrAsignarDetalleFN->setIdcolaborador($o_propel->idcolaborador);
    $o_BaseCrPrAsignarDetalleFN->setFecha($o_propel->fecha);
    $o_BaseCrPrAsignarDetalleFN->setIdprestamo($o_propel->idprestamo);
    $o_BaseCrPrAsignarDetalleFN->setFecharegistro($o_propel->fecharegistro);
    $o_BaseCrPrAsignarDetalleFN->setUsuarioregistro($o_propel->usuarioregistro);
    return $o_BaseCrPrAsignarDetalleFN;
  }
}