<?php
/**
 * Clase Base FN para BaseCrPrAsignarCabeceraFN
 *
 * @package    
 * @subpackage BaseCrPrAsignarCabeceraFN
 * @author     Willy
 * @version    SVN:: BaseCrPrAsignarCabeceraFN.class.php,v 1.1 2018-07-03 15:02:12 william.taype Exp $
 */
class BaseCrPrAsignarCabeceraFN extends CrPrAsignarCabeceraBN
{
  private static $fieldNames = array (
    'Fecha'=>'fecha', 'Idmercado'=>'idmercado', 'Idcolaborador'=>'idcolaborador', 'Estado'=>'estado', 'Fecharegistro'=>'fecharegistro', 'Usuarioregistro'=>'usuarioregistro', 'Fechamodificacion'=>'fechamodificacion', 'Usuariomodificacion'=>'usuariomodificacion'  
  );

  public function select()
  {
    try
    {
      $tamPag = !property_exists($this, 'tamPag')?9999:$this->tamPag;
      $pagina = !property_exists($this, 'page')||$this->page==""?1:$this->page;
      $numeroRegistros = $this->selectNumRows();
      $limitInf = ($pagina-1)*$tamPag;

      $where = $this->buildConsult();
      $orden = $this->buildOrderByField();

      $con = Conexion::getConexion();
      $sql = "SELECT fecha, idmercado, idcolaborador, estado, fecharegistro, usuarioregistro, fechamodificacion, usuariomodificacion FROM cr_pr_asignar_cabecera WHERE 1 ".$where." ".$orden."  LIMIT ".$limitInf.",".$tamPag;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      $a_tmp = array();
      if($num_rows>0){
        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
          $a_tmp[] = $this->insertObjectBN($o_valor);
        }
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function selectNumRows()
  {
    try
    {
      $where = $this->buildConsult();

      $con = Conexion::getConexion();
      $sql = "SELECT fecha, idmercado, idcolaborador, estado, fecharegistro, usuarioregistro, fechamodificacion, usuariomodificacion FROM cr_pr_asignar_cabecera WHERE 1 ".$where;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      
      return $num_rows;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildConsult()
  {
    try
    {
      $where = "";

      if($this->getFecha()){ $where .= " AND fecha = '".$this->getFecha()."'"; }
      if($this->getFechaInicio()){ $where .= " AND fecha >= '".$this->getFechaInicio()."'"; }
      if($this->getFechaFin()){ $where .= " AND fecha <= '".$this->getFechaFin()."'"; }
      if($this->getIdmercado()){ $where .= " AND idmercado = '".$this->getIdmercado()."'"; }
      if($this->getIdcolaborador()){ $where .= " AND idcolaborador = '".$this->getIdcolaborador()."'"; }
      if($this->getEstado()){ $where .= " AND estado = '".$this->getEstado()."'"; }
      if($this->getFecharegistro()){ $where .= " AND fecharegistro = '".$this->getFecharegistro()."'"; }
      if($this->getUsuarioregistro()){ $where .= " AND usuarioregistro = '".$this->getUsuarioregistro()."'"; }
      if($this->getFechamodificacion()){ $where .= " AND fechamodificacion = '".$this->getFechamodificacion()."'"; }
      if($this->getUsuariomodificacion()){ $where .= " AND usuariomodificacion = '".$this->getUsuariomodificacion()."'"; }
      return $where;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildOrderByField()
  {
    try
    {
      $order_by = "";

      if(property_exists($this,'sortCampos')){
      if($this->sortCampos != ""){
        $a_valCampos = explode(";", $this->sortCampos);
        $a_valtype   = explode(";", $this->sortType);
        $order_by = " ORDER BY ";
        $a_order = array();
        foreach ($a_valCampos as $key => $val){
          $sTmpOrder = "";
          if(array_key_exists($val, self::$fieldNames)){
            $sTmpOrder .= self::$fieldNames[$val];
            switch ($a_valtype[$key]){
              case 1: $sTmpOrder .= " ASC"; break;
              case 2: $sTmpOrder .= " DESC"; break;
            }
            $a_order[] = $sTmpOrder;
          }
        }
        $order_by .= implode(", ", $a_order);
      }
      }
      return $order_by;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* B�squeda del registro por la llave primaria */
  public function selectByPK()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT fecha, idmercado, idcolaborador, estado, fecharegistro, usuarioregistro, fechamodificacion, usuariomodificacion FROM cr_pr_asignar_cabecera WHERE 1 AND fecha='".$this->getFecha()."' AND idmercado='".$this->getIdmercado()."' AND idcolaborador='".$this->getIdcolaborador()."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      

      return $o_Propel?$this->insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_BaseCrPrAsignarCabeceraFN = new BaseCrPrAsignarCabeceraFN();
    $o_BaseCrPrAsignarCabeceraFN->setFecha($o_propel->fecha);
    $o_BaseCrPrAsignarCabeceraFN->setIdmercado($o_propel->idmercado);
    $o_BaseCrPrAsignarCabeceraFN->setIdcolaborador($o_propel->idcolaborador);
    $o_BaseCrPrAsignarCabeceraFN->setEstado($o_propel->estado);
    $o_BaseCrPrAsignarCabeceraFN->setFecharegistro($o_propel->fecharegistro);
    $o_BaseCrPrAsignarCabeceraFN->setUsuarioregistro($o_propel->usuarioregistro);
    $o_BaseCrPrAsignarCabeceraFN->setFechamodificacion($o_propel->fechamodificacion);
    $o_BaseCrPrAsignarCabeceraFN->setUsuariomodificacion($o_propel->usuariomodificacion);
    return $o_BaseCrPrAsignarCabeceraFN;
  }
}