<?php
/**
 * Clase Base DP para BaseCrPrAsignarDetalleDP
 *
 * @package    
 * @subpackage BaseCrPrAsignarDetalleDP
 * @author     Willy
 * @version    SVN:: BaseCrPrAsignarDetalleDP.class.php,v 1.1 2018-07-03 15:01:29 william.taype Exp $
 */
abstract class BaseCrPrAsignarDetalleDP extends CrPrAsignarDetalleBN
{
  /* N�mero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof CrPreAsignarDetalleBN )
    {
      $o_CrPreAsignarDetalleBN = $bSetDefault;
      if($o_CrPreAsignarDetalleBN->getIdmercado()) : $this->setIdmercado($o_CrPreAsignarDetalleBN->getIdmercado()); endif;
      if($o_CrPreAsignarDetalleBN->getIdcolaborador()) : $this->setIdcolaborador($o_CrPreAsignarDetalleBN->getIdcolaborador()); endif;
      if($o_CrPreAsignarDetalleBN->getFecha()) : $this->setFecha($o_CrPreAsignarDetalleBN->getFecha()); endif;
      if($o_CrPreAsignarDetalleBN->getIdprestamo()) : $this->setIdprestamo($o_CrPreAsignarDetalleBN->getIdprestamo()); endif;
      if($o_CrPreAsignarDetalleBN->getFecharegistro()) : $this->setFecharegistro($o_CrPreAsignarDetalleBN->getFecharegistro()); endif;
      if($o_CrPreAsignarDetalleBN->getUsuarioregistro()) : $this->setUsuarioregistro($o_CrPreAsignarDetalleBN->getUsuarioregistro()); endif;
    }
  }

  /* Obtiene el n�mero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
     

      if($this->getIdmercado() && $this->getIdcolaborador() && $this->getFecha() && $this->getIdprestamo()){
        $a_Fields = array();

        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getIdcolaborador()) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if($this->getFecha()) : $a_Fields['fecha'] = ($this->getFecha()); endif;
        if($this->getIdprestamo()) : $a_Fields['idprestamo'] = ($this->getIdprestamo()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO cr_pr_asignar_detalle (".$sStringField.") VALUES (".$sStringValue.");";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdmercado() && $this->getIdcolaborador() && $this->getFecha() && $this->getIdprestamo())
      {
        $a_Fields = array();

        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getIdcolaborador()) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if($this->getFecha()) : $a_Fields['fecha'] = ($this->getFecha()); endif;
        if($this->getIdprestamo()) : $a_Fields['idprestamo'] = ($this->getIdprestamo()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE cr_pr_asignar_detalle SET ".$sStringField." WHERE 1 AND idmercado='".$this->getIdmercado()."' AND idcolaborador='".$this->getIdcolaborador()."' AND fecha='".$this->getFecha()."' AND idprestamo='".$this->getIdprestamo()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdmercado() && $this->getIdcolaborador() && $this->getFecha() && $this->getIdprestamo())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM cr_pr_asignar_detalle WHERE 1 AND idmercado='".$this->getIdmercado()."' AND idcolaborador='".$this->getIdcolaborador()."' AND fecha='".$this->getFecha()."' AND idprestamo='".$this->getIdprestamo()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* B�squeda del registro por la llave primaria */
  public static function selectByPK($vIdmercado, $vIdcolaborador, $vFecha, $vIdprestamo)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idmercado, idcolaborador, fecha, idprestamo, fecharegistro, usuarioregistro FROM cr_pr_asignar_detalle WHERE 1 AND idmercado='".$vIdmercado."' AND idcolaborador='".$vIdcolaborador."' AND fecha='".$vFecha."' AND idprestamo='".$vIdprestamo."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_CrPreAsignarDetalleDP = new CrPreAsignarDetalleDP();
    $o_CrPreAsignarDetalleDP->setIdmercado($o_propel->idmercado);
    $o_CrPreAsignarDetalleDP->setIdcolaborador($o_propel->idcolaborador);
    $o_CrPreAsignarDetalleDP->setFecha($o_propel->fecha);
    $o_CrPreAsignarDetalleDP->setIdprestamo($o_propel->idprestamo);
    $o_CrPreAsignarDetalleDP->setFecharegistro($o_propel->fecharegistro);
    $o_CrPreAsignarDetalleDP->setUsuarioregistro($o_propel->usuarioregistro);
    return $o_CrPreAsignarDetalleDP;
  }
}