<?php
/**
 * Clase Base DP para BaseCrPrAsignarCabeceraDP
 *
 * @package    
 * @subpackage BaseCrPrAsignarCabeceraDP
 * @author     Willy
 * @version    SVN:: BaseCrPrAsignarCabeceraDP.class.php,v 1.1 2018-07-03 15:01:29 william.taype Exp $
 */
abstract class BaseCrPrAsignarCabeceraDP extends CrPrAsignarCabeceraBN
{
  /* N�mero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof CrPrAsignarCabeceraBN )
    {
      $o_CrPrAsignarCabeceraBN = $bSetDefault;
      if($o_CrPrAsignarCabeceraBN->getFecha()) : $this->setFecha($o_CrPrAsignarCabeceraBN->getFecha()); endif;
      if($o_CrPrAsignarCabeceraBN->getIdmercado()) : $this->setIdmercado($o_CrPrAsignarCabeceraBN->getIdmercado()); endif;
      if($o_CrPrAsignarCabeceraBN->getIdcolaborador()) : $this->setIdcolaborador($o_CrPrAsignarCabeceraBN->getIdcolaborador()); endif;
      if($o_CrPrAsignarCabeceraBN->getEstado()) : $this->setEstado($o_CrPrAsignarCabeceraBN->getEstado()); endif;
      if($o_CrPrAsignarCabeceraBN->getFecharegistro()) : $this->setFecharegistro($o_CrPrAsignarCabeceraBN->getFecharegistro()); endif;
      if($o_CrPrAsignarCabeceraBN->getUsuarioregistro()) : $this->setUsuarioregistro($o_CrPrAsignarCabeceraBN->getUsuarioregistro()); endif;
      if($o_CrPrAsignarCabeceraBN->getFechamodificacion()) : $this->setFechamodificacion($o_CrPrAsignarCabeceraBN->getFechamodificacion()); endif;
      if($o_CrPrAsignarCabeceraBN->getUsuariomodificacion()) : $this->setUsuariomodificacion($o_CrPrAsignarCabeceraBN->getUsuariomodificacion()); endif;
    }
  }

  /* Obtiene el n�mero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
	  	
      if($this->getFecha() && $this->getIdmercado() && $this->getIdcolaborador()){
        $a_Fields = array();

        if($this->getFecha()) : $a_Fields['fecha'] = ($this->getFecha()); endif;
        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getIdcolaborador()) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;
        if($this->getFechamodificacion()) : $a_Fields['fechamodificacion'] = ($this->getFechamodificacion()); endif;
        if($this->getUsuariomodificacion()) : $a_Fields['usuariomodificacion'] = ($this->getUsuariomodificacion()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO cr_pr_asignar_cabecera (".$sStringField.") VALUES (".$sStringValue.");";
        
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getFecha() && $this->getIdmercado() && $this->getIdcolaborador())
      {
        $a_Fields = array();

        if($this->getFecha()) : $a_Fields['fecha'] = ($this->getFecha()); endif;
        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getIdcolaborador()) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;
        if($this->getFechamodificacion()) : $a_Fields['fechamodificacion'] = ($this->getFechamodificacion()); endif;
        if($this->getUsuariomodificacion()) : $a_Fields['usuariomodificacion'] = ($this->getUsuariomodificacion()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE cr_pr_asignar_cabecera SET ".$sStringField." WHERE 1 AND fecha='".$this->getFecha()."' AND idmercado='".$this->getIdmercado()."' AND idcolaborador='".$this->getIdcolaborador()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getFecha() && $this->getIdmercado() && $this->getIdcolaborador())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM cr_pr_asignar_cabecera WHERE 1 AND fecha='".$this->getFecha()."' AND idmercado='".$this->getIdmercado()."' AND idcolaborador='".$this->getIdcolaborador()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* B�squeda del registro por la llave primaria */
  public static function selectByPK($vFecha, $vIdmercado, $vIdcolaborador)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT fecha, idmercado, idcolaborador, estado, fecharegistro, usuarioregistro, fechamodificacion, usuariomodificacion FROM cr_pr_asignar_cabecera WHERE 1 AND fecha='".$vFecha."' AND idmercado='".$vIdmercado."' AND idcolaborador='".$vIdcolaborador."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_CrPrAsignarCabeceraDP = new CrPrAsignarCabeceraDP();
    $o_CrPrAsignarCabeceraDP->setFecha($o_propel->fecha);
    $o_CrPrAsignarCabeceraDP->setIdmercado($o_propel->idmercado);
    $o_CrPrAsignarCabeceraDP->setIdcolaborador($o_propel->idcolaborador);
    $o_CrPrAsignarCabeceraDP->setEstado($o_propel->estado);
    $o_CrPrAsignarCabeceraDP->setFecharegistro($o_propel->fecharegistro);
    $o_CrPrAsignarCabeceraDP->setUsuarioregistro($o_propel->usuarioregistro);
    $o_CrPrAsignarCabeceraDP->setFechamodificacion($o_propel->fechamodificacion);
    $o_CrPrAsignarCabeceraDP->setUsuariomodificacion($o_propel->usuariomodificacion);
    return $o_CrPrAsignarCabeceraDP;
  }
}