<?php
/**
 * Clase Base FN para BaseCrBusquedaFN
 *
 * @package    
 * @subpackage BaseCrBusquedaFN
 * @author     Willy
 * @version    SVN:: BaseCrBusquedaFN.class.php,v 1.1 2022-01-08 00:36:37 william.taype Exp $
 */
class BaseCrBusquedaFN extends CrBusquedaBN
{
  private static $fieldNames = array (
    'Idbusqueda'=>'idbusqueda', 'Tipobusqueda'=>'tipobusqueda', 'Documento'=>'documento', 'Nombrecompleto'=>'nombrecompleto', 'Origenbusqueda'=>'origenbusqueda', 'Fechaemision'=>'fechaemision', 'Fechacaducidad'=>'fechacaducidad', 'Estado'=>'estado', 'Idcliente'=>'idcliente', 'Fechaasociarbusqueda'=>'fechaasociarbusqueda', 'Tramaresultado'=>'tramaresultado', 'Fechacreacion'=>'fechacreacion', 'Usuariocreacion'=>'usuariocreacion', 'Token'=>'token'  
  );

  public function select()
  {
    try
    {
      $tamPag = !property_exists($this, 'tamPag')?9999:$this->tamPag;
      $pagina = !property_exists($this, 'page')||$this->page==""?1:$this->page;
      $numeroRegistros = $this->selectNumRows();
      $limitInf = ($pagina-1)*$tamPag;

      $where = $this->buildConsult();
      $orden = $this->buildOrderByField();

      $con = Conexion::getConexion();
      $con->query("SET NAMES 'utf8'");
      $sql = "SELECT idbusqueda, tipobusqueda, documento, nombrecompleto, origenbusqueda, fechaemision, fechacaducidad, estado, idcliente, fechaasociarbusqueda, convert(cast(convert(`tramaresultado`using latin1) as binary) using utf8) AS tramaresultado, fechacreacion, usuariocreacion, token, historico FROM cr_busqueda WHERE 1 ".$where." ".$orden."  LIMIT ".$limitInf.",".$tamPag;
      //echo $sql;
        $result = $con->query($sql);
      $num_rows = $result->rowCount();
      $a_tmp = array();
      if($num_rows>0){
        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
          $a_tmp[] = $this->insertObjectBN($o_valor);
        }
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function selectNumRows()
  {
    try
    {
      $where = $this->buildConsult();

      $con = Conexion::getConexion();
      $sql = "SELECT idbusqueda, tipobusqueda, documento, nombrecompleto, origenbusqueda, fechaemision, fechacaducidad, estado, idcliente, fechaasociarbusqueda, tramaresultado, fechacreacion, usuariocreacion, token, historico FROM cr_busqueda WHERE 1 ".$where;
        $result = $con->query($sql);
      $num_rows = $result->rowCount();
      
      return $num_rows;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildConsult()
  {
    try
    {
      $where = "";

      if($this->getIdbusqueda()){ $where .= " AND idbusqueda = '".$this->getIdbusqueda()."'"; }
      if($this->getTipobusqueda()){ $where .= " AND tipobusqueda = '".$this->getTipobusqueda()."'"; }
      if($this->getDocumento()){ $where .= " AND documento = '".$this->getDocumento()."'"; }
      if($this->getNombrecompleto()){ $where .= " AND nombrecompleto = '".$this->getNombrecompleto()."'"; }
      if($this->getNombrecompletolike()){ $where .= " AND nombrecompleto like '%".$this->getNombrecompletolike()."%'"; }
      if($this->getOrigenbusqueda()){ $where .= " AND origenbusqueda = '".$this->getOrigenbusqueda()."'"; }
      if($this->getFechaemision()){ $where .= " AND fechaemision = '".$this->getFechaemision()."'"; }
      if($this->getFechacaducidad()){ $where .= " AND fechacaducidad = '".$this->getFechacaducidad()."'"; }
      if($this->getEstado()){ $where .= " AND estado = '".$this->getEstado()."'"; }
      if($this->getIdcliente()){ $where .= " AND idcliente = '".$this->getIdcliente()."'"; }
      if($this->getFechaasociarbusqueda()){ $where .= " AND fechaasociarbusqueda = '".$this->getFechaasociarbusqueda()."'"; }
      if($this->getTramaresultado()){ $where .= " AND tramaresultado = '".$this->getTramaresultado()."'"; }
      if($this->getFechacreacion()){ $where .= " AND fechacreacion = '".$this->getFechacreacion()."'"; }
      if($this->getUsuariocreacion()){ $where .= " AND usuariocreacion = '".$this->getUsuariocreacion()."'"; }
      if($this->getToken()){ $where .= " AND token = '".$this->getToken()."'"; }
      if($this->getHistorico()){ $where .= " AND historico = '".$this->getHistorico()."'"; }
      return $where;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildOrderByField()
  {
    try
    {
      $order_by = "";

      if(property_exists($this,'sortCampos')){
      if($this->sortCampos != ""){
        $a_valCampos = explode(";", $this->sortCampos);
        $a_valtype   = explode(";", $this->sortType);
        $order_by = " ORDER BY ";
        $a_order = array();
        foreach ($a_valCampos as $key => $val){
          $sTmpOrder = "";
          if(array_key_exists($val, self::$fieldNames)){
            $sTmpOrder .= self::$fieldNames[$val];
            switch ($a_valtype[$key]){
              case 1: $sTmpOrder .= " ASC"; break;
              case 2: $sTmpOrder .= " DESC"; break;
            }
            $a_order[] = $sTmpOrder;
          }
        }
        $order_by .= implode(", ", $a_order);
      }
      }
      return $order_by;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* B�squeda del registro por la llave primaria */
  public function selectByPK()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idbusqueda, tipobusqueda, documento, nombrecompleto, origenbusqueda, fechaemision, fechacaducidad, estado, idcliente, fechaasociarbusqueda, tramaresultado, fechacreacion, usuariocreacion, token, historico FROM cr_busqueda WHERE 1 AND idbusqueda='".$this->getIdbusqueda()."'; ";
         $result = $con->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      

      return $o_Propel?$this->insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_BaseCrBusquedaFN = new BaseCrBusquedaFN();
    $o_BaseCrBusquedaFN->setIdbusqueda($o_propel->idbusqueda);
    $o_BaseCrBusquedaFN->setTipobusqueda($o_propel->tipobusqueda);
    $o_BaseCrBusquedaFN->setDocumento($o_propel->documento);
    $o_BaseCrBusquedaFN->setNombrecompleto($o_propel->nombrecompleto);
    $o_BaseCrBusquedaFN->setOrigenbusqueda($o_propel->origenbusqueda);
    $o_BaseCrBusquedaFN->setFechaemision($o_propel->fechaemision);
    $o_BaseCrBusquedaFN->setFechacaducidad($o_propel->fechacaducidad);
    $o_BaseCrBusquedaFN->setEstado($o_propel->estado);
    $o_BaseCrBusquedaFN->setIdcliente($o_propel->idcliente);
    $o_BaseCrBusquedaFN->setFechaasociarbusqueda($o_propel->fechaasociarbusqueda);
    $o_BaseCrBusquedaFN->setTramaresultado($o_propel->tramaresultado);
    $o_BaseCrBusquedaFN->setFechacreacion($o_propel->fechacreacion);
    $o_BaseCrBusquedaFN->setUsuariocreacion($o_propel->usuariocreacion);
    $o_BaseCrBusquedaFN->setToken($o_propel->token);
    $o_BaseCrBusquedaFN->setHistorico($o_propel->historico);
    return $o_BaseCrBusquedaFN;
  }
}