<?php
/**
 * Clase Base DP para BaseCrBusquedaDP
 *
 * @package    
 * @subpackage BaseCrBusquedaDP
 * @author     Willy
 * @version    SVN:: BaseCrBusquedaDP.class.php,v 1.1 2022-01-08 00:36:32 william.taype Exp $
 */
abstract class BaseCrBusquedaDP extends CrBusquedaBN
{
  /* N�mero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof CrBusquedaBN )
    {
      $o_CrBusquedaBN = $bSetDefault;
      if($o_CrBusquedaBN->getIdbusqueda()) : $this->setIdbusqueda($o_CrBusquedaBN->getIdbusqueda()); endif;
      if($o_CrBusquedaBN->getTipobusqueda()) : $this->setTipobusqueda($o_CrBusquedaBN->getTipobusqueda()); endif;
      if($o_CrBusquedaBN->getDocumento()) : $this->setDocumento($o_CrBusquedaBN->getDocumento()); endif;
      if($o_CrBusquedaBN->getNombrecompleto()) : $this->setNombrecompleto($o_CrBusquedaBN->getNombrecompleto()); endif;
      if($o_CrBusquedaBN->getOrigenbusqueda()) : $this->setOrigenbusqueda($o_CrBusquedaBN->getOrigenbusqueda()); endif;
      if($o_CrBusquedaBN->getFechaemision()) : $this->setFechaemision($o_CrBusquedaBN->getFechaemision()); endif;
      if($o_CrBusquedaBN->getFechacaducidad()) : $this->setFechacaducidad($o_CrBusquedaBN->getFechacaducidad()); endif;
      if($o_CrBusquedaBN->getEstado()) : $this->setEstado($o_CrBusquedaBN->getEstado()); endif;
      if($o_CrBusquedaBN->getIdcliente()) : $this->setIdcliente($o_CrBusquedaBN->getIdcliente()); endif;
      if($o_CrBusquedaBN->getFechaasociarbusqueda()) : $this->setFechaasociarbusqueda($o_CrBusquedaBN->getFechaasociarbusqueda()); endif;
      if($o_CrBusquedaBN->getTramaresultado()) : $this->setTramaresultado($o_CrBusquedaBN->getTramaresultado()); endif;
      if($o_CrBusquedaBN->getFechacreacion()) : $this->setFechacreacion($o_CrBusquedaBN->getFechacreacion()); endif;
      if($o_CrBusquedaBN->getUsuariocreacion()) : $this->setUsuariocreacion($o_CrBusquedaBN->getUsuariocreacion()); endif;
      if($o_CrBusquedaBN->getToken()) : $this->setToken($o_CrBusquedaBN->getToken()); endif;
    }
  }

  /* Obtiene el n�mero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
     
        $a_Fields = array();

        if($this->getIdbusqueda()) : $a_Fields['idbusqueda'] = ($this->getIdbusqueda()); endif;
        if($this->getTipobusqueda()) : $a_Fields['tipobusqueda'] = ($this->getTipobusqueda()); endif;
        if($this->getDocumento()) : $a_Fields['documento'] = ($this->getDocumento()); endif;
        if($this->getNombrecompleto()) : $a_Fields['nombrecompleto'] = ($this->getNombrecompleto()); endif;
        if($this->getOrigenbusqueda()) : $a_Fields['origenbusqueda'] = ($this->getOrigenbusqueda()); endif;
        if($this->getFechaemision()) : $a_Fields['fechaemision'] = ($this->getFechaemision()); endif;
        if($this->getFechacaducidad()) : $a_Fields['fechacaducidad'] = ($this->getFechacaducidad()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getIdcliente()) : $a_Fields['idcliente'] = ($this->getIdcliente()); endif;
        if($this->getFechaasociarbusqueda()) : $a_Fields['fechaasociarbusqueda'] = ($this->getFechaasociarbusqueda()); endif;
        if($this->getTramaresultado()) : $a_Fields['tramaresultado'] = ($this->getTramaresultado()); endif;
        if($this->getFechacreacion()) : $a_Fields['fechacreacion'] = ($this->getFechacreacion()); endif;
        if($this->getUsuariocreacion()) : $a_Fields['usuariocreacion'] = ($this->getUsuariocreacion()); endif;
        if($this->getToken()) : $a_Fields['token'] = ($this->getToken()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO cr_busqueda (".$sStringField.") VALUES (".$sStringValue.");";
        $result = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $con->errorInfo() );
        }
     
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdbusqueda())
      {
        $a_Fields = array();

        if($this->getIdbusqueda()) : $a_Fields['idbusqueda'] = ($this->getIdbusqueda()); endif;
        if($this->getTipobusqueda()) : $a_Fields['tipobusqueda'] = ($this->getTipobusqueda()); endif;
        if($this->getDocumento()) : $a_Fields['documento'] = ($this->getDocumento()); endif;
        if($this->getNombrecompleto()) : $a_Fields['nombrecompleto'] = ($this->getNombrecompleto()); endif;
        if($this->getOrigenbusqueda()) : $a_Fields['origenbusqueda'] = ($this->getOrigenbusqueda()); endif;
        if($this->getFechaemision()) : $a_Fields['fechaemision'] = ($this->getFechaemision()); endif;
        if($this->getFechacaducidad()) : $a_Fields['fechacaducidad'] = ($this->getFechacaducidad()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getIdcliente()) : $a_Fields['idcliente'] = ($this->getIdcliente()); endif;
        if($this->getFechaasociarbusqueda()) : $a_Fields['fechaasociarbusqueda'] = ($this->getFechaasociarbusqueda()); endif;
        if($this->getTramaresultado()) : $a_Fields['tramaresultado'] = ($this->getTramaresultado()); endif;
        if($this->getFechacreacion()) : $a_Fields['fechacreacion'] = ($this->getFechacreacion()); endif;
        if($this->getUsuariocreacion()) : $a_Fields['usuariocreacion'] = ($this->getUsuariocreacion()); endif;
        if($this->getToken()) : $a_Fields['token'] = ($this->getToken()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE cr_busqueda SET ".$sStringField." WHERE 1 AND idbusqueda='".$this->getIdbusqueda()."';";
        $result = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $con->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdbusqueda())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM cr_busqueda WHERE 1 AND idbusqueda='".$this->getIdbusqueda()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* B�squeda del registro por la llave primaria */
  public static function selectByPK($vIdbusqueda)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idbusqueda, tipobusqueda, documento, nombrecompleto, origenbusqueda, fechaemision, fechacaducidad, estado, idcliente, fechaasociarbusqueda, tramaresultado, fechacreacion, usuariocreacion, token FROM cr_busqueda WHERE 1 AND idbusqueda='".$vIdbusqueda."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_CrBusquedaDP = new CrBusquedaDP();
    $o_CrBusquedaDP->setIdbusqueda($o_propel->idbusqueda);
    $o_CrBusquedaDP->setTipobusqueda($o_propel->tipobusqueda);
    $o_CrBusquedaDP->setDocumento($o_propel->documento);
    $o_CrBusquedaDP->setNombrecompleto($o_propel->nombrecompleto);
    $o_CrBusquedaDP->setOrigenbusqueda($o_propel->origenbusqueda);
    $o_CrBusquedaDP->setFechaemision($o_propel->fechaemision);
    $o_CrBusquedaDP->setFechacaducidad($o_propel->fechacaducidad);
    $o_CrBusquedaDP->setEstado($o_propel->estado);
    $o_CrBusquedaDP->setIdcliente($o_propel->idcliente);
    $o_CrBusquedaDP->setFechaasociarbusqueda($o_propel->fechaasociarbusqueda);
    $o_CrBusquedaDP->setTramaresultado($o_propel->tramaresultado);
    $o_CrBusquedaDP->setFechacreacion($o_propel->fechacreacion);
    $o_CrBusquedaDP->setUsuariocreacion($o_propel->usuariocreacion);
    $o_CrBusquedaDP->setToken($o_propel->token);
    return $o_CrBusquedaDP;
  }
}