<?php
/**
 * Clase FN para ArArqueoCabeceraFN
 *
 * @package    
 * @subpackage ArArqueoCabeceraFN
 * @author     Willy
 * @version    SVN:: ArArqueoCabeceraFN.class.php,v 1.1 2020-06-23 20:22:33 william.taype Exp $
 */
class ArArqueoCabeceraFN extends BaseArArqueoCabeceraFN
{
	
	private static $fieldNames = array (
    'Idclase'=>'idclase', 'Idsucursal'=>'idsucursal', 'Idmercado'=>'idmercado', 'Idcolaborador'=>'idcolaborador', 'Fecha'=>'fecha', 'Idcliente'=>'idcliente', 'Idprestamo'=>'idprestamo', 'Nombrecliente'=>'nombrecliente', 'Idbanco'=>'idbanco', 'Idcuenta'=>'idcuenta', 'Banco'=>'banco', 'Numerocuenta'=>'numerocuenta', 'Fechadeposito'=>'fechadeposito', 'Numeroboucher'=>'numeroboucher', 'Subtotal'=>'subtotal', 'Estado'=>'estado', 'Idpagoreferencia'=>'idpagoreferencia', 'Fecharegistro'=>'fecharegistro', 'Usuarioregistro'=>'usuarioregistro'  
  );
	public function selectDetalle()
  {
    try
    {
      $tamPag = !property_exists($this, 'tamPag')?9999:$this->tamPag;
      $pagina = !property_exists($this, 'page')||$this->page==""?1:$this->page;
      $numeroRegistros = $this->selectDetalleNumRows();
      $limitInf = ($pagina-1)*$tamPag;

      $whereD = $this->buildDetalleDConsult();
      $whereP = $this->buildDetallePConsult();
      $orden = $this->buildDetalleOrderByField();

      $con = Conexion::getConexion();
      $sql = "	SELECT 	ar_arqueo_cabecera.idclase, ar_arqueo_cabecera.idsucursal, ar_arqueo_cabecera.idmercado, ar_arqueo_cabecera.idcolaborador, ar_arqueo_cabecera.fecha,  ar_arqueo_cabecera.descripcionsucursal,  ar_arqueo_cabecera.descripcionmercado,  ar_arqueo_cabecera.descripcioncolaborador,
						ar_arqueo_detalle_deposito.idcliente, ar_arqueo_detalle_deposito.idprestamo, '' as correlativo,nombrecliente, 
						idbanco, idcuenta, banco, numerocuenta, fechadeposito, numeroboucher,'' as idtipoproducto,'' as descripciontipoproducto, '' as decripcionproducto, 1 as cantidad, '' as preciounitario,
						subtotal,ar_arqueo_cabecera.estado, idpagoreferencia, ar_arqueo_cabecera.fecharegistro, ar_arqueo_cabecera.usuarioregistro 
				FROM ar_arqueo_detalle_deposito 
				LEFT JOIN ar_arqueo_cabecera on ar_arqueo_cabecera.idclase = ar_arqueo_detalle_deposito.idclase and ar_arqueo_cabecera.idsucursal = ar_arqueo_detalle_deposito.idsucursal and ar_arqueo_cabecera.idmercado = ar_arqueo_detalle_deposito.idmercado and ar_arqueo_cabecera.idcolaborador = ar_arqueo_detalle_deposito.idcolaborador and ar_arqueo_cabecera.fecha = ar_arqueo_detalle_deposito.fecha
				WHERE 1 ".$whereD."
				UNION
				SELECT 	ar_arqueo_cabecera.idclase, ar_arqueo_cabecera.idsucursal, ar_arqueo_cabecera.idmercado, ar_arqueo_cabecera.idcolaborador, ar_arqueo_cabecera.fecha,  ar_arqueo_cabecera.descripcionsucursal,  ar_arqueo_cabecera.descripcionmercado, ar_arqueo_cabecera.descripcioncolaborador, 
						ar_arqueo_detalle_producto.idcliente, ar_arqueo_detalle_producto.idprestamo, correlativo, nombrecliente, 
						'' as idbanco, '' as idcuenta, '' as banco, '' as numerocuenta,'' as fechadeposito,'' as numeroboucher, idtipoproducto, descripciontipoproducto, decripcionproducto, cantidad, preciounitario, 
						subtotal, ar_arqueo_cabecera.estado, idpagoreferencia, ar_arqueo_cabecera.fecharegistro, ar_arqueo_cabecera.usuarioregistro
				FROM ar_arqueo_detalle_producto 
				LEFT JOIN ar_arqueo_cabecera on ar_arqueo_cabecera.idclase = ar_arqueo_detalle_producto.idclase and ar_arqueo_cabecera.idsucursal = ar_arqueo_detalle_producto.idsucursal and ar_arqueo_cabecera.idmercado = ar_arqueo_detalle_producto.idmercado and ar_arqueo_cabecera.idcolaborador = ar_arqueo_detalle_producto.idcolaborador and ar_arqueo_cabecera.fecha = ar_arqueo_detalle_producto.fecha
				WHERE 1 ".$whereP."
      			 
      			
      			".$orden." LIMIT ".$limitInf.",".$tamPag;
     	//echo $sql;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      $a_tmp = array();
      if($num_rows>0){
        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
          $a_tmp[] = $this->insertDetalleObjectBN($o_valor);
        }
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function selectDetalleNumRows()
  {
    try
    {
      $whereD = $this->buildDetalleDConsult();
      $whereP = $this->buildDetallePConsult();

      $con = Conexion::getConexion();
     $sql = "	SELECT 	ar_arqueo_cabecera.idclase, ar_arqueo_cabecera.idsucursal, ar_arqueo_cabecera.idmercado, ar_arqueo_cabecera.idcolaborador, ar_arqueo_cabecera.fecha,  ar_arqueo_cabecera.descripcionsucursal,  ar_arqueo_cabecera.descripcionmercado,  ar_arqueo_cabecera.descripcioncolaborador,
						ar_arqueo_detalle_deposito.idcliente, ar_arqueo_detalle_deposito.idprestamo, '' as correlativo,nombrecliente, 
						idbanco, idcuenta, banco, numerocuenta, fechadeposito, numeroboucher,'' as idtipoproducto,'' as descripciontipoproducto, '' as decripcionproducto, 1 as cantidad, '' as preciounitario,
						subtotal,ar_arqueo_cabecera.estado, idpagoreferencia, ar_arqueo_cabecera.fecharegistro, ar_arqueo_cabecera.usuarioregistro 
				FROM ar_arqueo_detalle_deposito 
				LEFT JOIN ar_arqueo_cabecera on ar_arqueo_cabecera.idclase = ar_arqueo_detalle_deposito.idclase and ar_arqueo_cabecera.idsucursal = ar_arqueo_detalle_deposito.idsucursal and ar_arqueo_cabecera.idmercado = ar_arqueo_detalle_deposito.idmercado and ar_arqueo_cabecera.idcolaborador = ar_arqueo_detalle_deposito.idcolaborador and ar_arqueo_cabecera.fecha = ar_arqueo_detalle_deposito.fecha
				WHERE 1 ".$whereD."
				UNION
				SELECT 	ar_arqueo_cabecera.idclase, ar_arqueo_cabecera.idsucursal, ar_arqueo_cabecera.idmercado, ar_arqueo_cabecera.idcolaborador, ar_arqueo_cabecera.fecha,  ar_arqueo_cabecera.descripcionsucursal,  ar_arqueo_cabecera.descripcionmercado, ar_arqueo_cabecera.descripcioncolaborador, 
						ar_arqueo_detalle_producto.idcliente, ar_arqueo_detalle_producto.idprestamo, correlativo, nombrecliente, 
						'' as idbanco, '' as idcuenta, '' as banco, '' as numerocuenta,'' as fechadeposito,'' as numeroboucher, idtipoproducto, descripciontipoproducto, decripcionproducto, cantidad, preciounitario, 
						subtotal, ar_arqueo_cabecera.estado, idpagoreferencia, ar_arqueo_cabecera.fecharegistro, ar_arqueo_cabecera.usuarioregistro
				FROM ar_arqueo_detalle_producto 
				LEFT JOIN ar_arqueo_cabecera on ar_arqueo_cabecera.idclase = ar_arqueo_detalle_producto.idclase and ar_arqueo_cabecera.idsucursal = ar_arqueo_detalle_producto.idsucursal and ar_arqueo_cabecera.idmercado = ar_arqueo_detalle_producto.idmercado and ar_arqueo_cabecera.idcolaborador = ar_arqueo_detalle_producto.idcolaborador and ar_arqueo_cabecera.fecha = ar_arqueo_detalle_producto.fecha
				WHERE 1 ".$whereP;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      
      return $num_rows;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildDetalleDConsult()
  {
    try
    {
      $where = "";

      if($this->getIdclase()){ $where .= " AND ar_arqueo_detalle_deposito.idclase = '".$this->getIdclase()."'"; }
      if($this->getIdsucursal()){ $where .= " AND ar_arqueo_detalle_deposito.idsucursal = '".$this->getIdsucursal()."'"; }
      if($this->getIdmercado()){ $where .= " AND ar_arqueo_detalle_deposito.idmercado = '".$this->getIdmercado()."'"; }
      if($this->getIdcolaborador()){ $where .= " AND idcolaborador = '".$this->getIdcolaborador()."'"; }
      if($this->getFechainicio()){ $where .= " AND ar_arqueo_cabecera.fecha >= '".$this->getFechainicio()."'"; }
      if($this->getFechafinal()){ $where .= " AND ar_arqueo_cabecera.fecha <= '".$this->getFechafinal()."'"; }
      if($this->getIdcliente()){ $where .= " AND idcliente = '".$this->getIdcliente()."'"; }
      if($this->getIdprestamo()){ $where .= " AND idprestamo = '".$this->getIdprestamo()."'"; }
      if($this->getNombrecliente()){ $where .= " AND nombrecliente like '%".$this->getNombrecliente()."%'"; }
      if($this->getIdbanco()){ $where .= " AND idbanco = '".$this->getIdbanco()."'"; }
      if($this->getIdcuenta()){ $where .= " AND idcuenta = '".$this->getIdcuenta()."'"; }
      if($this->getBanco()){ $where .= " AND banco = '".$this->getBanco()."'"; }
      if($this->getNumerocuenta()){ $where .= " AND numerocuenta = '".$this->getNumerocuenta()."'"; }
      if($this->getFechadeposito()){ $where .= " AND fechadeposito = '".$this->getFechadeposito()."'"; }
      if($this->getNumeroboucher()){ $where .= " AND numeroboucher = '".$this->getNumeroboucher()."'"; }
      if($this->getSubtotal()){ $where .= " AND subtotal = '".$this->getSubtotal()."'"; }
      if($this->getEstado()){ $where .= " AND estado = '".$this->getEstado()."'"; }
      if($this->getIdpagoreferencia()){ $where .= " AND idpagoreferencia = '".$this->getIdpagoreferencia()."'"; }
      if($this->getFecharegistro()){ $where .= " AND fecharegistro = '".$this->getFecharegistro()."'"; }
      if($this->getUsuarioregistro()){ $where .= " AND usuarioregistro = '".$this->getUsuarioregistro()."'"; }
      return $where;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

   public function buildDetallePConsult()
  {
    try
    {
      $where = "";

      if($this->getIdclase()){ $where .= " AND ar_arqueo_detalle_producto.idclase = '".$this->getIdclase()."'"; }
      if($this->getIdsucursal()){ $where .= " AND ar_arqueo_detalle_producto.idsucursal = '".$this->getIdsucursal()."'"; }
      if($this->getIdmercado()){ $where .= " AND ar_arqueo_detalle_producto.idmercado = '".$this->getIdmercado()."'"; }
      if($this->getIdcolaborador()){ $where .= " AND ar_arqueo_detalle_producto.idcolaborador = '".$this->getIdcolaborador()."'"; }
      if($this->getFechainicio()){ $where .= " AND ar_arqueo_cabecera.fecha >= '".$this->getFechainicio()."'"; }
      if($this->getFechafinal()){ $where .= " AND ar_arqueo_cabecera.fecha <= '".$this->getFechafinal()."'"; }
      if($this->getIdcliente()){ $where .= " AND ar_arqueo_detalle_producto.idcliente = '".$this->getIdcliente()."'"; }
      if($this->getIdprestamo()){ $where .= " AND ar_arqueo_detalle_producto.idprestamo = '".$this->getIdprestamo()."'"; }
      if($this->getNombrecliente()){ $where .= " AND ar_arqueo_detalle_producto.nombrecliente like '%".$this->getNombrecliente()."%'"; }
      if($this->getIdbanco()){ $where .= " AND idbanco = '".$this->getIdbanco()."'"; }
      if($this->getIdcuenta()){ $where .= " AND idcuenta = '".$this->getIdcuenta()."'"; }
      if($this->getBanco()){ $where .= " AND banco = '".$this->getBanco()."'"; }
      if($this->getNumerocuenta()){ $where .= " AND numerocuenta = '".$this->getNumerocuenta()."'"; }
      if($this->getFechadeposito()){ $where .= " AND fechadeposito = '".$this->getFechadeposito()."'"; }
      if($this->getNumeroboucher()){ $where .= " AND numeroboucher = '".$this->getNumeroboucher()."'"; }
      if($this->getSubtotal()){ $where .= " AND subtotal = '".$this->getSubtotal()."'"; }
      if($this->getEstado()){ $where .= " AND ar_arqueo_detalle_producto.estado = '".$this->getEstado()."'"; }
      if($this->getIdpagoreferencia()){ $where .= " AND idpagoreferencia = '".$this->getIdpagoreferencia()."'"; }
      if($this->getFecharegistro()){ $where .= " AND ar_arqueo_detalle_producto.fecharegistro = '".$this->getFecharegistro()."'"; }
      if($this->getUsuarioregistro()){ $where .= " AND ar_arqueo_detalle_producto.usuarioregistro = '".$this->getUsuarioregistro()."'"; }
      return $where;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }
  public function buildDetalleOrderByField()
  {
    try
    {
      $order_by = "";

      if(property_exists($this,'sortCampos')){
      if($this->sortCampos != ""){
        $a_valCampos = explode(";", $this->sortCampos);
        $a_valtype   = explode(";", $this->sortType);
        $order_by = " ORDER BY ";
        $a_order = array();
        foreach ($a_valCampos as $key => $val){
          $sTmpOrder = "";
          if(array_key_exists($val, self::$fieldNames)){
            $sTmpOrder .= self::$fieldNames[$val];
            switch ($a_valtype[$key]){
              case 1: $sTmpOrder .= " ASC"; break;
              case 2: $sTmpOrder .= " DESC"; break;
            }
            $a_order[] = $sTmpOrder;
          }
        }
        $order_by .= implode(", ", $a_order);
      }
      }
      return $order_by;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

 
  /* Devuelve un objeto con m�todos de acceso */
  public function insertDetalleObjectBN($o_propel){
    $o_BaseArArqueoDetalleDepositoFN = new BaseArArqueoCabeceraFN();
    $o_BaseArArqueoDetalleDepositoFN->setIdclase($o_propel->idclase);
    $o_BaseArArqueoDetalleDepositoFN->setIdsucursal($o_propel->idsucursal);
    $o_BaseArArqueoDetalleDepositoFN->setIdmercado($o_propel->idmercado);
    $o_BaseArArqueoDetalleDepositoFN->setIdcolaborador($o_propel->idcolaborador);
    $o_BaseArArqueoDetalleDepositoFN->setFecha($o_propel->fecha);
    $o_BaseArArqueoDetalleDepositoFN->setIdcliente($o_propel->idcliente);
    $o_BaseArArqueoDetalleDepositoFN->setIdprestamo($o_propel->idprestamo);
    $o_BaseArArqueoDetalleDepositoFN->setCorrelativo($o_propel->correlativo);
    $o_BaseArArqueoDetalleDepositoFN->setDescripcionsucursal($o_propel->descripcionsucursal);
    $o_BaseArArqueoDetalleDepositoFN->setDescripcionmercado($o_propel->descripcionmercado);
    $o_BaseArArqueoDetalleDepositoFN->setDescripcioncolaborador($o_propel->descripcioncolaborador);
    $o_BaseArArqueoDetalleDepositoFN->setNombrecliente($o_propel->nombrecliente);
    $o_BaseArArqueoDetalleDepositoFN->setIdbanco($o_propel->idbanco);
    $o_BaseArArqueoDetalleDepositoFN->setIdcuenta($o_propel->idcuenta);
    $o_BaseArArqueoDetalleDepositoFN->setCantidad($o_propel->cantidad);
    $o_BaseArArqueoDetalleDepositoFN->setBanco($o_propel->banco);
    $o_BaseArArqueoDetalleDepositoFN->setNumerocuenta($o_propel->numerocuenta);
    $o_BaseArArqueoDetalleDepositoFN->setFechadeposito($o_propel->fechadeposito);
    $o_BaseArArqueoDetalleDepositoFN->setNumeroboucher($o_propel->numeroboucher);
    $o_BaseArArqueoDetalleDepositoFN->setSubtotal($o_propel->subtotal);
    $o_BaseArArqueoDetalleDepositoFN->setDescripciontipoproducto($o_propel->descripciontipoproducto);
    $o_BaseArArqueoDetalleDepositoFN->setDecripcionproducto($o_propel->decripcionproducto);
    $o_BaseArArqueoDetalleDepositoFN->setEstado($o_propel->estado);
    $o_BaseArArqueoDetalleDepositoFN->setIdpagoreferencia($o_propel->idpagoreferencia);
    $o_BaseArArqueoDetalleDepositoFN->setFecharegistro($o_propel->fecharegistro);
    $o_BaseArArqueoDetalleDepositoFN->setUsuarioregistro($o_propel->usuarioregistro);
    return $o_BaseArArqueoDetalleDepositoFN;
  }
}