<?php
/**
 * Clase Base DP para BaseArTipoproductoDP
 *
 * @package    
 * @subpackage BaseArTipoproductoDP
 * @author     Willy
 * @version    SVN:: BaseArTipoproductoDP.class.php,v 1.1 2020-06-30 13:51:18 william.taype Exp $
 */
abstract class BaseArTipoproductoDP extends ArTipoproductoBN
{
  /* Nmero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof ArTipoproductoBN )
    {
      $o_ArTipoproductoBN = $bSetDefault;
      if($o_ArTipoproductoBN->getIdtipoproducto()) : $this->setIdtipoproducto($o_ArTipoproductoBN->getIdtipoproducto()); endif;
      if($o_ArTipoproductoBN->getDescripcion()) : $this->setDescripcion($o_ArTipoproductoBN->getDescripcion()); endif;
      if($o_ArTipoproductoBN->getEstado()) : $this->setEstado($o_ArTipoproductoBN->getEstado()); endif;
      if($o_ArTipoproductoBN->getEliminado()) : $this->setEliminado($o_ArTipoproductoBN->getEliminado()); endif;
      if($o_ArTipoproductoBN->getFechaeliminado()) : $this->setFechaeliminado($o_ArTipoproductoBN->getFechaeliminado()); endif;
      if($o_ArTipoproductoBN->getUsuarioeliminado()) : $this->setUsuarioeliminado($o_ArTipoproductoBN->getUsuarioeliminado()); endif;
      if($o_ArTipoproductoBN->getFecharegistro()) : $this->setFecharegistro($o_ArTipoproductoBN->getFecharegistro()); endif;
      if($o_ArTipoproductoBN->getUsuarioregistro()) : $this->setUsuarioregistro($o_ArTipoproductoBN->getUsuarioregistro()); endif;
      if($o_ArTipoproductoBN->getUsuariomodificacion()) : $this->setUsuariomodificacion($o_ArTipoproductoBN->getUsuariomodificacion()); endif;
      if($o_ArTipoproductoBN->getFechamodificacion()) : $this->setFechamodificacion($o_ArTipoproductoBN->getFechamodificacion()); endif;
    }
  }

  /* Obtiene el nmero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(idtipoproducto),(MAX(idtipoproducto)+1), 1) AS Maximo FROM ar_tipoproducto;";
      $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
      $result = $oLink->query($sql);
      $row = $result->fetch(PDO::FETCH_ASSOC);
      $this->setIdtipoproducto($row["Maximo"]);

      if($this->getIdtipoproducto()){
        $a_Fields = array();

        if($this->getIdtipoproducto()) : $a_Fields['idtipoproducto'] = ($this->getIdtipoproducto()); endif;
        if($this->getDescripcion()) : $a_Fields['descripcion'] = ($this->getDescripcion()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getEliminado()) : $a_Fields['eliminado'] = ($this->getEliminado()); endif;
        if($this->getFechaeliminado()) : $a_Fields['fechaeliminado'] = ($this->getFechaeliminado()); endif;
        if($this->getUsuarioeliminado()) : $a_Fields['usuarioeliminado'] = ($this->getUsuarioeliminado()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;
        if($this->getUsuariomodificacion()) : $a_Fields['usuariomodificacion'] = ($this->getUsuariomodificacion()); endif;
        if($this->getFechamodificacion()) : $a_Fields['fechamodificacion'] = ($this->getFechamodificacion()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO ar_tipoproducto (".$sStringField.") VALUES (".$sStringValue.");";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdtipoproducto())
      {
        $a_Fields = array();

        if($this->getIdtipoproducto()) : $a_Fields['idtipoproducto'] = ($this->getIdtipoproducto()); endif;
        if($this->getDescripcion()) : $a_Fields['descripcion'] = ($this->getDescripcion()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getEliminado()) : $a_Fields['eliminado'] = ($this->getEliminado()); endif;
        if($this->getFechaeliminado()) : $a_Fields['fechaeliminado'] = ($this->getFechaeliminado()); endif;
        if($this->getUsuarioeliminado()) : $a_Fields['usuarioeliminado'] = ($this->getUsuarioeliminado()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;
        if($this->getUsuariomodificacion()) : $a_Fields['usuariomodificacion'] = ($this->getUsuariomodificacion()); endif;
        if($this->getFechamodificacion()) : $a_Fields['fechamodificacion'] = ($this->getFechamodificacion()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE ar_tipoproducto SET ".$sStringField." WHERE 1 AND idtipoproducto='".$this->getIdtipoproducto()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdtipoproducto())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM ar_tipoproducto WHERE 1 AND idtipoproducto='".$this->getIdtipoproducto()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* Bsqueda del registro por la llave primaria */
  public static function selectByPK($vIdtipoproducto)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idtipoproducto, descripcion, estado, eliminado, fechaeliminado, usuarioeliminado, fecharegistro, usuarioregistro, usuariomodificacion, fechamodificacion FROM ar_tipoproducto WHERE 1 AND idtipoproducto='".$vIdtipoproducto."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con mtodos de acceso */
  private function insertObjectBN($o_propel){
    $o_ArTipoproductoDP = new ArTipoproductoDP();
    $o_ArTipoproductoDP->setIdtipoproducto($o_propel->idtipoproducto);
    $o_ArTipoproductoDP->setDescripcion($o_propel->descripcion);
    $o_ArTipoproductoDP->setEstado($o_propel->estado);
    $o_ArTipoproductoDP->setEliminado($o_propel->eliminado);
    $o_ArTipoproductoDP->setFechaeliminado($o_propel->fechaeliminado);
    $o_ArTipoproductoDP->setUsuarioeliminado($o_propel->usuarioeliminado);
    $o_ArTipoproductoDP->setFecharegistro($o_propel->fecharegistro);
    $o_ArTipoproductoDP->setUsuarioregistro($o_propel->usuarioregistro);
    $o_ArTipoproductoDP->setUsuariomodificacion($o_propel->usuariomodificacion);
    $o_ArTipoproductoDP->setFechamodificacion($o_propel->fechamodificacion);
    return $o_ArTipoproductoDP;
  }
}