<?php
/**
 * Clase Base DP para BaseArClaseDP
 *
 * @package    
 * @subpackage BaseArClaseDP
 * @author     Willy
 * @version    SVN:: BaseArClaseDP.class.php,v 1.1 2020-06-30 13:51:18 william.taype Exp $
 */
abstract class BaseArClaseDP extends ArClaseBN
{
  /* N�mero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof ArClaseBN )
    {
      $o_ArClaseBN = $bSetDefault;
      if($o_ArClaseBN->getIdclase()) : $this->setIdclase($o_ArClaseBN->getIdclase()); endif;
      if($o_ArClaseBN->getDescripcion()) : $this->setDescripcion($o_ArClaseBN->getDescripcion()); endif;
      if($o_ArClaseBN->getEstado()) : $this->setEstado($o_ArClaseBN->getEstado()); endif;
      if($o_ArClaseBN->getOrden()) : $this->setOrden($o_ArClaseBN->getOrden()); endif;
    }
  }

  /* Obtiene el n�mero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(idclase),(MAX(idclase)+1), 1) AS Maximo FROM ar_clase;";
      $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
      $result = $oLink->query($sql);
      $row = $result->fetch(PDO::FETCH_ASSOC);
      $this->setIdclase($row["Maximo"]);

      if($this->getIdclase()){
        $a_Fields = array();

        if($this->getIdclase()) : $a_Fields['idclase'] = ($this->getIdclase()); endif;
        if($this->getDescripcion()) : $a_Fields['descripcion'] = ($this->getDescripcion()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getOrden()) : $a_Fields['orden'] = ($this->getOrden()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO ar_clase (".$sStringField.") VALUES (".$sStringValue.");";
       $result = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdclase())
      {
        $a_Fields = array();

        if($this->getIdclase()) : $a_Fields['idclase'] = ($this->getIdclase()); endif;
        if($this->getDescripcion()) : $a_Fields['descripcion'] = ($this->getDescripcion()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getOrden()) : $a_Fields['orden'] = ($this->getOrden()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE ar_clase SET ".$sStringField." WHERE 1 AND idclase='".$this->getIdclase()."';";
        $result = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdclase())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM ar_clase WHERE 1 AND idclase='".$this->getIdclase()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* B�squeda del registro por la llave primaria */
  public static function selectByPK($vIdclase)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idclase, descripcion, estado, orden FROM ar_clase WHERE 1 AND idclase='".$vIdclase."'; ";
      $result = $con->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_ArClaseDP = new ArClaseDP();
    $o_ArClaseDP->setIdclase($o_propel->idclase);
    $o_ArClaseDP->setDescripcion($o_propel->descripcion);
    $o_ArClaseDP->setEstado($o_propel->estado);
    $o_ArClaseDP->setOrden($o_propel->orden);
    return $o_ArClaseDP;
  }
}