<?php
/**
 * Clase Base DP para BaseArBancoDP
 *
 * @package    
 * @subpackage BaseArBancoDP
 * @author     Willy
 * @version    SVN:: BaseArBancoDP.class.php,v 1.1 2020-06-30 13:51:18 william.taype Exp $
 */
abstract class BaseArBancoDP extends ArBancoBN
{
  /* N�mero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof ArBancoBN )
    {
      $o_ArBancoBN = $bSetDefault;
      if($o_ArBancoBN->getIdbanco()) : $this->setIdbanco($o_ArBancoBN->getIdbanco()); endif;
      if($o_ArBancoBN->getDescripcion()) : $this->setDescripcion($o_ArBancoBN->getDescripcion()); endif;
      if($o_ArBancoBN->getEstado()) : $this->setEstado($o_ArBancoBN->getEstado()); endif;
      if($o_ArBancoBN->getEliminado()) : $this->setEliminado($o_ArBancoBN->getEliminado()); endif;
      if($o_ArBancoBN->getUsuarioeliminado()) : $this->setUsuarioeliminado($o_ArBancoBN->getUsuarioeliminado()); endif;
      if($o_ArBancoBN->getFechaeliminado()) : $this->setFechaeliminado($o_ArBancoBN->getFechaeliminado()); endif;
      if($o_ArBancoBN->getFecharegistro()) : $this->setFecharegistro($o_ArBancoBN->getFecharegistro()); endif;
      if($o_ArBancoBN->getUsuarioregistro()) : $this->setUsuarioregistro($o_ArBancoBN->getUsuarioregistro()); endif;
    }
  }

  /* Obtiene el n�mero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(idbanco),(MAX(idbanco)+1), 1) AS Maximo FROM ar_banco;";
      $result = $con->query($sql);
      $row = $result->fetch(PDO::FETCH_ASSOC);
      $this->setIdbanco($row["Maximo"]);

      if($this->getIdbanco()){
        $a_Fields = array();

        if($this->getIdbanco()) : $a_Fields['idbanco'] = ($this->getIdbanco()); endif;
        if($this->getDescripcion()) : $a_Fields['descripcion'] = ($this->getDescripcion()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getEliminado()) : $a_Fields['eliminado'] = ($this->getEliminado()); endif;
        if($this->getUsuarioeliminado()) : $a_Fields['usuarioeliminado'] = ($this->getUsuarioeliminado()); endif;
        if($this->getFechaeliminado()) : $a_Fields['fechaeliminado'] = ($this->getFechaeliminado()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO ar_banco (".$sStringField.") VALUES (".$sStringValue.");";
        $result = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $con->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdbanco())
      {
        $a_Fields = array();

        if($this->getIdbanco()) : $a_Fields['idbanco'] = ($this->getIdbanco()); endif;
        if($this->getDescripcion()) : $a_Fields['descripcion'] = ($this->getDescripcion()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getEliminado()) : $a_Fields['eliminado'] = ($this->getEliminado()); endif;
        if($this->getUsuarioeliminado()) : $a_Fields['usuarioeliminado'] = ($this->getUsuarioeliminado()); endif;
        if($this->getFechaeliminado()) : $a_Fields['fechaeliminado'] = ($this->getFechaeliminado()); endif;
        if($this->getFechamodificacion()) : $a_Fields['fechamodificacion'] = ($this->getFechamodificacion()); endif;
        if($this->getUsuariomodificacion()) : $a_Fields['usuariomodificacion'] = ($this->getUsuariomodificacion()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE ar_banco SET ".$sStringField." WHERE 1 AND idbanco='".$this->getIdbanco()."';";
        //echo $sql; 
        $result = $con->query($sql);
        //echo $result;
        //echo "*-*-*-*-";
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $con->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdbanco())
      {
        $a_Fields = array();
         if($this->getEliminado()) : $a_Fields['eliminado'] = ($this->getEliminado()); endif;
		if($this->getUsuarioeliminado()) : $a_Fields['usuarioeliminado'] = ($this->getUsuarioeliminado()); endif;
        if($this->getFechaeliminado()) : $a_Fields['fechaeliminado'] = ($this->getFechaeliminado()); endif;
        
        $sStringField = arrayClass::implode_key_value(',', $a_Fields);
        $con = Conexion::getConexion();
        $sql = "UPDATE ar_banco 
        SET ".$sStringField."
        WHERE 1 AND idbanco='".$this->getIdbanco()."';"; 
        $result = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $con->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* B�squeda del registro por la llave primaria */
  public static function selectByPK($vIdbanco)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idbanco, descripcion, estado, eliminado, usuarioeliminado, fechaeliminado, fecharegistro, usuarioregistro FROM ar_banco WHERE 1 AND idbanco='".$vIdbanco."'; ";
      $result = $con->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_ArBancoDP = new ArBancoDP();
    $o_ArBancoDP->setIdbanco($o_propel->idbanco);
    $o_ArBancoDP->setDescripcion($o_propel->descripcion);
    $o_ArBancoDP->setEstado($o_propel->estado);
    $o_ArBancoDP->setEliminado($o_propel->eliminado);
    $o_ArBancoDP->setUsuarioeliminado($o_propel->usuarioeliminado);
    $o_ArBancoDP->setFechaeliminado($o_propel->fechaeliminado);
    $o_ArBancoDP->setFecharegistro($o_propel->fecharegistro);
    $o_ArBancoDP->setUsuarioregistro($o_propel->usuarioregistro);
    return $o_ArBancoDP;
  }
}