<?php
/**
 * Clase Base DP para BaseArArqueoDetalleProductoDP
 *
 * @package    
 * @subpackage BaseArArqueoDetalleProductoDP
 * @author     Willy
 * @version    SVN:: BaseArArqueoDetalleProductoDP.class.php,v 1.1 2020-07-06 21:36:06 william.taype Exp $
 */
abstract class BaseArArqueoDetalleProductoDP extends ArArqueoDetalleProductoBN
{
  /* N�mero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof ArArqueoDetalleProductoBN )
    {
      $o_ArArqueoDetalleProductoBN = $bSetDefault;
      if($o_ArArqueoDetalleProductoBN->getIdclase()) : $this->setIdclase($o_ArArqueoDetalleProductoBN->getIdclase()); endif;
      if($o_ArArqueoDetalleProductoBN->getIdsucursal()) : $this->setIdsucursal($o_ArArqueoDetalleProductoBN->getIdsucursal()); endif;
      if($o_ArArqueoDetalleProductoBN->getIdmercado()) : $this->setIdmercado($o_ArArqueoDetalleProductoBN->getIdmercado()); endif;
      if($o_ArArqueoDetalleProductoBN->getIdcolaborador()) : $this->setIdcolaborador($o_ArArqueoDetalleProductoBN->getIdcolaborador()); endif;
      if($o_ArArqueoDetalleProductoBN->getFecha()) : $this->setFecha($o_ArArqueoDetalleProductoBN->getFecha()); endif;
      if($o_ArArqueoDetalleProductoBN->getIdcliente()) : $this->setIdcliente($o_ArArqueoDetalleProductoBN->getIdcliente()); endif;
      if($o_ArArqueoDetalleProductoBN->getIdprestamo()) : $this->setIdprestamo($o_ArArqueoDetalleProductoBN->getIdprestamo()); endif;
      if($o_ArArqueoDetalleProductoBN->getCorrelativo()) : $this->setCorrelativo($o_ArArqueoDetalleProductoBN->getCorrelativo()); endif;
      if($o_ArArqueoDetalleProductoBN->getNombrecliente()) : $this->setNombrecliente($o_ArArqueoDetalleProductoBN->getNombrecliente()); endif;
      if($o_ArArqueoDetalleProductoBN->getIdtipoproducto()) : $this->setIdtipoproducto($o_ArArqueoDetalleProductoBN->getIdtipoproducto()); endif;
      if($o_ArArqueoDetalleProductoBN->getDescripciontipoproducto()) : $this->setDescripciontipoproducto($o_ArArqueoDetalleProductoBN->getDescripciontipoproducto()); endif;
      if($o_ArArqueoDetalleProductoBN->getDecripcionproducto()) : $this->setDecripcionproducto($o_ArArqueoDetalleProductoBN->getDecripcionproducto()); endif;
      if($o_ArArqueoDetalleProductoBN->getCantidad()) : $this->setCantidad($o_ArArqueoDetalleProductoBN->getCantidad()); endif;
      if($o_ArArqueoDetalleProductoBN->getPreciounitario()) : $this->setPreciounitario($o_ArArqueoDetalleProductoBN->getPreciounitario()); endif;
      if($o_ArArqueoDetalleProductoBN->getSubtotal()) : $this->setSubtotal($o_ArArqueoDetalleProductoBN->getSubtotal()); endif;
      if($o_ArArqueoDetalleProductoBN->getEstado()) : $this->setEstado($o_ArArqueoDetalleProductoBN->getEstado()); endif;
      if($o_ArArqueoDetalleProductoBN->getIdpagoreferencia()) : $this->setIdpagoreferencia($o_ArArqueoDetalleProductoBN->getIdpagoreferencia()); endif;
      if($o_ArArqueoDetalleProductoBN->getFecharegistro()) : $this->setFecharegistro($o_ArArqueoDetalleProductoBN->getFecharegistro()); endif;
      if($o_ArArqueoDetalleProductoBN->getUsuarioregistro()) : $this->setUsuarioregistro($o_ArArqueoDetalleProductoBN->getUsuarioregistro()); endif;
    }
  }

  /* Obtiene el n�mero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(correlativo),(MAX(correlativo)+1), 1) AS Maximo FROM ar_arqueo_detalle_producto where 1 and idclase='".$this->getIdclase()."' AND idsucursal='".$this->getIdsucursal()."' AND idmercado='".$this->getIdmercado()."' AND idcolaborador='".$this->getIdcolaborador()."' AND fecha='".$this->getFecha()."' AND idcliente='".$this->getIdcliente()."' AND idprestamo='".$this->getIdprestamo()."';";
      //echo $sql;
      $result = $con->query($sql);
      $row = $result->fetch(PDO::FETCH_ASSOC);
      $this->setCorrelativo($row["Maximo"]);

      if($this->getIdclase() && $this->getIdsucursal() && $this->getIdmercado() && $this->getIdcolaborador() && $this->getFecha() && $this->getIdcliente() && $this->getIdprestamo() && $this->getCorrelativo()){
        $a_Fields = array();
		    
        if($this->getIdclase()) : $a_Fields['idclase'] = ($this->getIdclase()); endif;
        if($this->getIdsucursal()) : $a_Fields['idsucursal'] = ($this->getIdsucursal()); endif;
        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getIdcolaborador()) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if($this->getFecha()) : $a_Fields['fecha'] = ($this->getFecha()); endif;
        if($this->getIdcliente()) : $a_Fields['idcliente'] = ($this->getIdcliente()); endif;
        if($this->getIdprestamo()) : $a_Fields['idprestamo'] = ($this->getIdprestamo()); endif;
        if($this->getCorrelativo()) : $a_Fields['correlativo'] = ($this->getCorrelativo()); endif;
        if($this->getNombrecliente()) : $a_Fields['nombrecliente'] = ($this->getNombrecliente()); endif;
        if($this->getIdtipoproducto()) : $a_Fields['idtipoproducto'] = ($this->getIdtipoproducto()); endif;
        if($this->getDescripciontipoproducto()) : $a_Fields['descripciontipoproducto'] = ($this->getDescripciontipoproducto()); endif;
        if($this->getDecripcionproducto()) : $a_Fields['decripcionproducto'] = ($this->getDecripcionproducto()); endif;
        if($this->getCantidad()) : $a_Fields['cantidad'] = ($this->getCantidad()); endif;
        if($this->getPreciounitario()) : $a_Fields['preciounitario'] = ($this->getPreciounitario()); endif;
        if($this->getSubtotal()) : $a_Fields['subtotal'] = ($this->getSubtotal()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getIdpagoreferencia()) : $a_Fields['idpagoreferencia'] = ($this->getIdpagoreferencia()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO ar_arqueo_detalle_producto (".$sStringField.") VALUES (".$sStringValue.");";
        //echo $sql;
        $result = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }
  
  public function savelog()
  {
    try
    {
      $con = Conexion::getConexion();
      

      if($this->getIdclase() && $this->getIdsucursal() && $this->getIdmercado() && $this->getIdcolaborador() && $this->getFecha() && $this->getIdcliente() && $this->getIdprestamo() && $this->getCorrelativo()){
        $a_Fields = array();
		    
        if($this->getIdclase()) : $a_Fields['idclase'] = ($this->getIdclase()); endif;
        if($this->getIdsucursal()) : $a_Fields['idsucursal'] = ($this->getIdsucursal()); endif;
        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getIdcolaborador()) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if($this->getFecha()) : $a_Fields['fecha'] = ($this->getFecha()); endif;
        if($this->getIdcliente()) : $a_Fields['idcliente'] = ($this->getIdcliente()); endif;
        if($this->getIdprestamo()) : $a_Fields['idprestamo'] = ($this->getIdprestamo()); endif;
        if($this->getCorrelativo()) : $a_Fields['correlativo'] = ($this->getCorrelativo()); endif;
        if($this->getNombrecliente()) : $a_Fields['nombrecliente'] = ($this->getNombrecliente()); endif;
        if($this->getIdtipoproducto()) : $a_Fields['idtipoproducto'] = ($this->getIdtipoproducto()); endif;
        if($this->getDescripciontipoproducto()) : $a_Fields['descripciontipoproducto'] = ($this->getDescripciontipoproducto()); endif;
        if($this->getDecripcionproducto()) : $a_Fields['decripcionproducto'] = ($this->getDecripcionproducto()); endif;
        if($this->getCantidad()) : $a_Fields['cantidad'] = ($this->getCantidad()); endif;
        if($this->getPreciounitario()) : $a_Fields['preciounitario'] = ($this->getPreciounitario()); endif;
        if($this->getSubtotal()) : $a_Fields['subtotal'] = ($this->getSubtotal()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getIdpagoreferencia()) : $a_Fields['idpagoreferencia'] = ($this->getIdpagoreferencia()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO ar_arqueo_detalle_producto_log (idlogdp,".$sStringField.") VALUES (null,".$sStringValue.");";
        //echo $sql;
        $result = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }


  public function update()
  {
    try
    {
      if($this->getIdclase() && $this->getIdsucursal() && $this->getIdmercado() && $this->getIdcolaborador() && $this->getFecha() && $this->getIdcliente() && $this->getIdprestamo() && $this->getCorrelativo())
      {
        $a_Fields = array();

        if($this->getIdclase()) : $a_Fields['idclase'] = ($this->getIdclase()); endif;
        if($this->getIdsucursal()) : $a_Fields['idsucursal'] = ($this->getIdsucursal()); endif;
        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getIdcolaborador()) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if($this->getFecha()) : $a_Fields['fecha'] = ($this->getFecha()); endif;
        if($this->getIdcliente()) : $a_Fields['idcliente'] = ($this->getIdcliente()); endif;
        if($this->getIdprestamo()) : $a_Fields['idprestamo'] = ($this->getIdprestamo()); endif;
        if($this->getCorrelativo()) : $a_Fields['correlativo'] = ($this->getCorrelativo()); endif;
        if($this->getNombrecliente()) : $a_Fields['nombrecliente'] = ($this->getNombrecliente()); endif;
        if($this->getIdtipoproducto()) : $a_Fields['idtipoproducto'] = ($this->getIdtipoproducto()); endif;
        if($this->getDescripciontipoproducto()) : $a_Fields['descripciontipoproducto'] = ($this->getDescripciontipoproducto()); endif;
        if($this->getDecripcionproducto()) : $a_Fields['decripcionproducto'] = ($this->getDecripcionproducto()); endif;
        if($this->getCantidad()) : $a_Fields['cantidad'] = ($this->getCantidad()); endif;
        if($this->getPreciounitario()) : $a_Fields['preciounitario'] = ($this->getPreciounitario()); endif;
        if($this->getSubtotal()) : $a_Fields['subtotal'] = ($this->getSubtotal()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getIdpagoreferencia()) : $a_Fields['idpagoreferencia'] = ($this->getIdpagoreferencia()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE ar_arqueo_detalle_producto SET ".$sStringField." WHERE 1 AND idclase='".$this->getIdclase()."' AND idsucursal='".$this->getIdsucursal()."' AND idmercado='".$this->getIdmercado()."' AND idcolaborador='".$this->getIdcolaborador()."' AND fecha='".$this->getFecha()."' AND idcliente='".$this->getIdcliente()."' AND idprestamo='".$this->getIdprestamo()."' AND correlativo='".$this->getCorrelativo()."';";
        echo $sql;
        $result = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $con->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdclase() && $this->getIdsucursal() && $this->getIdmercado() && $this->getIdcolaborador() && $this->getFecha() && $this->getIdcliente() && $this->getIdprestamo() && $this->getCorrelativo())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM ar_arqueo_detalle_producto WHERE 1 AND idclase='".$this->getIdclase()."' AND idsucursal='".$this->getIdsucursal()."' AND idmercado='".$this->getIdmercado()."' AND idcolaborador='".$this->getIdcolaborador()."' AND fecha='".$this->getFecha()."' AND idcliente='".$this->getIdcliente()."' AND idprestamo='".$this->getIdprestamo()."' AND correlativo='".$this->getCorrelativo()."';"; 
        $result = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $con->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* B�squeda del registro por la llave primaria */
  public static function selectByPK($vIdclase, $vIdsucursal, $vIdmercado, $vIdcolaborador, $vFecha, $vIdcliente, $vIdprestamo, $vCorrelativo)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idclase, idsucursal, idmercado, idcolaborador, fecha, idcliente, idprestamo, correlativo, nombrecliente, idtipoproducto, descripciontipoproducto, decripcionproducto, cantidad, preciounitario, subtotal, estado, idpagoreferencia, fecharegistro, usuarioregistro FROM ar_arqueo_detalle_producto WHERE 1 AND idclase='".$vIdclase."' AND idsucursal='".$vIdsucursal."' AND idmercado='".$vIdmercado."' AND idcolaborador='".$vIdcolaborador."' AND fecha='".$vFecha."' AND idcliente='".$vIdcliente."' AND idprestamo='".$vIdprestamo."' AND correlativo='".$vCorrelativo."'; ";
      $result = $con->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_ArArqueoDetalleProductoDP = new ArArqueoDetalleProductoDP();
    $o_ArArqueoDetalleProductoDP->setIdclase($o_propel->idclase);
    $o_ArArqueoDetalleProductoDP->setIdsucursal($o_propel->idsucursal);
    $o_ArArqueoDetalleProductoDP->setIdmercado($o_propel->idmercado);
    $o_ArArqueoDetalleProductoDP->setIdcolaborador($o_propel->idcolaborador);
    $o_ArArqueoDetalleProductoDP->setFecha($o_propel->fecha);
    $o_ArArqueoDetalleProductoDP->setIdcliente($o_propel->idcliente);
    $o_ArArqueoDetalleProductoDP->setIdprestamo($o_propel->idprestamo);
    $o_ArArqueoDetalleProductoDP->setCorrelativo($o_propel->correlativo);
    $o_ArArqueoDetalleProductoDP->setNombrecliente($o_propel->nombrecliente);
    $o_ArArqueoDetalleProductoDP->setIdtipoproducto($o_propel->idtipoproducto);
    $o_ArArqueoDetalleProductoDP->setDescripciontipoproducto($o_propel->descripciontipoproducto);
    $o_ArArqueoDetalleProductoDP->setDecripcionproducto($o_propel->decripcionproducto);
    $o_ArArqueoDetalleProductoDP->setCantidad($o_propel->cantidad);
    $o_ArArqueoDetalleProductoDP->setPreciounitario($o_propel->preciounitario);
    $o_ArArqueoDetalleProductoDP->setSubtotal($o_propel->subtotal);
    $o_ArArqueoDetalleProductoDP->setEstado($o_propel->estado);
    $o_ArArqueoDetalleProductoDP->setIdpagoreferencia($o_propel->idpagoreferencia);
    $o_ArArqueoDetalleProductoDP->setFecharegistro($o_propel->fecharegistro);
    $o_ArArqueoDetalleProductoDP->setUsuarioregistro($o_propel->usuarioregistro);
    return $o_ArArqueoDetalleProductoDP;
  }
}