<?php
/**
 * Clase Base DP para BaseArArqueoDetalleDepositoDP
 *
 * @package    
 * @subpackage BaseArArqueoDetalleDepositoDP
 * @author     Willy
 * @version    SVN:: BaseArArqueoDetalleDepositoDP.class.php,v 1.1 2020-07-01 22:10:01 william.taype Exp $
 */
abstract class BaseArArqueoDetalleDepositoDP extends ArArqueoDetalleDepositoBN
{
  /* N�mero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof ArArqueoDetalleDepositoBN )
    {
      $o_ArArqueoDetalleDepositoBN = $bSetDefault;
      if($o_ArArqueoDetalleDepositoBN->getIdclase()) : $this->setIdclase($o_ArArqueoDetalleDepositoBN->getIdclase()); endif;
      if($o_ArArqueoDetalleDepositoBN->getIdsucursal()) : $this->setIdsucursal($o_ArArqueoDetalleDepositoBN->getIdsucursal()); endif;
      if($o_ArArqueoDetalleDepositoBN->getIdmercado()) : $this->setIdmercado($o_ArArqueoDetalleDepositoBN->getIdmercado()); endif;
      if($o_ArArqueoDetalleDepositoBN->getIdcolaborador()) : $this->setIdcolaborador($o_ArArqueoDetalleDepositoBN->getIdcolaborador()); endif;
      if($o_ArArqueoDetalleDepositoBN->getFecha()) : $this->setFecha($o_ArArqueoDetalleDepositoBN->getFecha()); endif;
      if($o_ArArqueoDetalleDepositoBN->getMedio()) : $this->setMedio($o_ArArqueoDetalleDepositoBN->getMedio()); endif;
      if($o_ArArqueoDetalleDepositoBN->getIdcliente()) : $this->setIdcliente($o_ArArqueoDetalleDepositoBN->getIdcliente()); endif;
      if($o_ArArqueoDetalleDepositoBN->getIdprestamo()) : $this->setIdprestamo($o_ArArqueoDetalleDepositoBN->getIdprestamo()); endif;
      if($o_ArArqueoDetalleDepositoBN->getNombrecliente()) : $this->setNombrecliente($o_ArArqueoDetalleDepositoBN->getNombrecliente()); endif;
      if($o_ArArqueoDetalleDepositoBN->getIdbanco()) : $this->setIdbanco($o_ArArqueoDetalleDepositoBN->getIdbanco()); endif;
      if($o_ArArqueoDetalleDepositoBN->getIdcuenta()) : $this->setIdcuenta($o_ArArqueoDetalleDepositoBN->getIdcuenta()); endif;
      if($o_ArArqueoDetalleDepositoBN->getBanco()) : $this->setBanco($o_ArArqueoDetalleDepositoBN->getBanco()); endif;
      if($o_ArArqueoDetalleDepositoBN->getNumerocuenta()) : $this->setNumerocuenta($o_ArArqueoDetalleDepositoBN->getNumerocuenta()); endif;
      if($o_ArArqueoDetalleDepositoBN->getFechadeposito()) : $this->setFechadeposito($o_ArArqueoDetalleDepositoBN->getFechadeposito()); endif;
      if($o_ArArqueoDetalleDepositoBN->getNumeroboucher()) : $this->setNumeroboucher($o_ArArqueoDetalleDepositoBN->getNumeroboucher()); endif;
      if($o_ArArqueoDetalleDepositoBN->getSubtotal()) : $this->setSubtotal($o_ArArqueoDetalleDepositoBN->getSubtotal()); endif;
      if($o_ArArqueoDetalleDepositoBN->getEstado()) : $this->setEstado($o_ArArqueoDetalleDepositoBN->getEstado()); endif;
      if($o_ArArqueoDetalleDepositoBN->getIdpagoreferencia()) : $this->setIdpagoreferencia($o_ArArqueoDetalleDepositoBN->getIdpagoreferencia()); endif;
      if($o_ArArqueoDetalleDepositoBN->getFecharegistro()) : $this->setFecharegistro($o_ArArqueoDetalleDepositoBN->getFecharegistro()); endif;
      if($o_ArArqueoDetalleDepositoBN->getUsuarioregistro()) : $this->setUsuarioregistro($o_ArArqueoDetalleDepositoBN->getUsuarioregistro()); endif;
    }
  }

  /* Obtiene el n�mero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
     

      if($this->getIdclase() && $this->getIdsucursal() && $this->getIdmercado() && $this->getIdcolaborador() && $this->getFecha() && $this->getMedio() && $this->getIdcliente() && $this->getIdprestamo()){
        $a_Fields = array();

        if($this->getIdclase()) : $a_Fields['idclase'] = ($this->getIdclase()); endif;
        if($this->getIdsucursal()) : $a_Fields['idsucursal'] = ($this->getIdsucursal()); endif;
        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getIdcolaborador()) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if($this->getFecha()) : $a_Fields['fecha'] = ($this->getFecha()); endif;
        if($this->getMedio()) : $a_Fields['medio'] = ($this->getMedio()); endif;
        if($this->getIdcliente()) : $a_Fields['idcliente'] = ($this->getIdcliente()); endif;
        if($this->getIdprestamo()) : $a_Fields['idprestamo'] = ($this->getIdprestamo()); endif;
        if($this->getTipopago()) : $a_Fields['tipopago'] = ($this->getTipopago()); endif;
        if($this->getNombrecliente()) : $a_Fields['nombrecliente'] = ($this->getNombrecliente()); endif;
        if($this->getIdbanco()) : $a_Fields['idbanco'] = ($this->getIdbanco()); endif;
        if($this->getIdcuenta()) : $a_Fields['idcuenta'] = ($this->getIdcuenta()); endif;
        if($this->getBanco()) : $a_Fields['banco'] = ($this->getBanco()); endif;
        if($this->getNumerocuenta()) : $a_Fields['numerocuenta'] = ($this->getNumerocuenta()); endif;
        if($this->getFechadeposito()) : $a_Fields['fechadeposito'] = ($this->getFechadeposito()); endif;
        if($this->getNumeroboucher()) : $a_Fields['numeroboucher'] = ($this->getNumeroboucher()); endif;
        if($this->getNombrearchivo()) : $a_Fields['nombrearchivo'] = ($this->getNombrearchivo()); endif;
        if($this->getSubtotal()) : $a_Fields['subtotal'] = ($this->getSubtotal()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getIdpagoreferencia()) : $a_Fields['idpagoreferencia'] = ($this->getIdpagoreferencia()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO ar_arqueo_detalle_deposito (".$sStringField.") VALUES (".$sStringValue.");";
        $result = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $con->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function savelog()
  {
    try
    {
      $con = Conexion::getConexion();
     

      if($this->getIdclase() && $this->getIdsucursal() && $this->getIdmercado() && $this->getIdcolaborador() && $this->getFecha() && $this->getMedio() && $this->getIdcliente() && $this->getIdprestamo()){
        $a_Fields = array();

        if($this->getIdclase()) : $a_Fields['idclase'] = ($this->getIdclase()); endif;
        if($this->getIdsucursal()) : $a_Fields['idsucursal'] = ($this->getIdsucursal()); endif;
        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getIdcolaborador()) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if($this->getFecha()) : $a_Fields['fecha'] = ($this->getFecha()); endif;
        if($this->getMedio()) : $a_Fields['medio'] = ($this->getMedio()); endif;
        if($this->getIdcliente()) : $a_Fields['idcliente'] = ($this->getIdcliente()); endif;
        if($this->getIdprestamo()) : $a_Fields['idprestamo'] = ($this->getIdprestamo()); endif;
        if($this->getTipopago()) : $a_Fields['tipopago'] = ($this->getTipopago()); endif;
        if($this->getNombrecliente()) : $a_Fields['nombrecliente'] = ($this->getNombrecliente()); endif;
        if($this->getIdbanco()) : $a_Fields['idbanco'] = ($this->getIdbanco()); endif;
        if($this->getIdcuenta()) : $a_Fields['idcuenta'] = ($this->getIdcuenta()); endif;
        if($this->getBanco()) : $a_Fields['banco'] = ($this->getBanco()); endif;
        if($this->getNumerocuenta()) : $a_Fields['numerocuenta'] = ($this->getNumerocuenta()); endif;
        if($this->getNombrearchivo()) : $a_Fields['nombrearchivo'] = ($this->getNombrearchivo()); endif;
        if($this->getFechadeposito()) : $a_Fields['fechadeposito'] = ($this->getFechadeposito()); endif;
        if($this->getNumeroboucher()) : $a_Fields['numeroboucher'] = ($this->getNumeroboucher()); endif;
        if($this->getSubtotal()) : $a_Fields['subtotal'] = ($this->getSubtotal()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getIdpagoreferencia()) : $a_Fields['idpagoreferencia'] = ($this->getIdpagoreferencia()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getComentario()) : $a_Fields['comentario'] = ($this->getComentario()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;
        if($this->getFechaaprobacion()) : $a_Fields['fechaaprobacion'] = ($this->getFechaaprobacion()); endif;
        if($this->getUsuarioaprobacion()) : $a_Fields['usuarioaprobacion'] = ($this->getUsuarioaprobacion()); endif;
        if($this->getFecharechazo()) : $a_Fields['fecharechazo'] = ($this->getFecharechazo()); endif;
        if($this->getUsuariorechazo()) : $a_Fields['usuariorechazo'] = ($this->getUsuariorechazo()); endif;
        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO ar_arqueo_detalle_deposito_log (idlogdd,".$sStringField.") VALUES (null,".$sStringValue.");";
        $result = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $con->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
    //echo $this->getIdclase()." && ".$this->getIdsucursal()." && ".$this->getIdmercado()." && ".$this->getIdcolaborador() ." && ".$this->getFecha()." && ". $this->getMedio() ." && ".$this->getIdcliente() ." && ". $this->getIdprestamo() ." && ".$this->getNumeroboucher()." && ".$this->getTipopago();    
      if($this->getIdclase() && $this->getIdsucursal() && $this->getIdmercado() && $this->getIdcolaborador() && $this->getFecha() && $this->getMedio() && $this->getIdcliente() && $this->getIdprestamo() && $this->getNumeroboucher() && $this->getTipopago())
      {
        $a_Fields = array();

        if($this->getIdclase()) : $a_Fields['idclase'] = ($this->getIdclase()); endif;
        if($this->getIdsucursal()) : $a_Fields['idsucursal'] = ($this->getIdsucursal()); endif;
        if($this->getIdmercado()) : $a_Fields['idmercado'] = ($this->getIdmercado()); endif;
        if($this->getIdcolaborador()) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if($this->getFecha()) : $a_Fields['fecha'] = ($this->getFecha()); endif;
        if($this->getMedio()) : $a_Fields['medio'] = ($this->getMedio()); endif;
        if($this->getIdcliente()) : $a_Fields['idcliente'] = ($this->getIdcliente()); endif;
        if($this->getIdprestamo()) : $a_Fields['idprestamo'] = ($this->getIdprestamo()); endif;
        if($this->getNombrecliente()) : $a_Fields['nombrecliente'] = ($this->getNombrecliente()); endif;
        if($this->getIdbanco()) : $a_Fields['idbanco'] = ($this->getIdbanco()); endif;
        if($this->getIdcuenta()) : $a_Fields['idcuenta'] = ($this->getIdcuenta()); endif;
        if($this->getBanco()) : $a_Fields['banco'] = ($this->getBanco()); endif;
        if($this->getNumerocuenta()) : $a_Fields['numerocuenta'] = ($this->getNumerocuenta()); endif;
        if($this->getFechadeposito()) : $a_Fields['fechadeposito'] = ($this->getFechadeposito()); endif;
        if($this->getNumeroboucher()) : $a_Fields['numeroboucher'] = ($this->getNumeroboucher()); endif;
        if($this->getNombrearchivo()) : $a_Fields['nombrearchivo'] = ($this->getNombrearchivo()); endif;
        if($this->getSubtotal()) : $a_Fields['subtotal'] = ($this->getSubtotal()); endif;
        if($this->getComentario()) : $a_Fields['comentario'] = ($this->getComentario()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getIdpagoreferencia()) : $a_Fields['idpagoreferencia'] = ($this->getIdpagoreferencia()); endif;
        if($this->getFecharegistro()) : $a_Fields['fecharegistro'] = ($this->getFecharegistro()); endif;
        if($this->getUsuarioregistro()) : $a_Fields['usuarioregistro'] = ($this->getUsuarioregistro()); endif;
        if($this->getFechaaprobacion()) : $a_Fields['fechaaprobacion'] = ($this->getFechaaprobacion()); endif;
        if($this->getUsuarioaprobacion()) : $a_Fields['usuarioaprobacion'] = ($this->getUsuarioaprobacion()); endif;
        if($this->getFecharechazo()) : $a_Fields['fecharechazo'] = ($this->getFecharechazo()); endif;
        if($this->getUsuariorechazo()) : $a_Fields['usuariorechazo'] = ($this->getUsuariorechazo()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE ar_arqueo_detalle_deposito SET ".$sStringField." WHERE 1 AND idclase='".$this->getIdclase()."' AND idsucursal='".$this->getIdsucursal()."' AND idmercado='".$this->getIdmercado()."' AND idcolaborador='".$this->getIdcolaborador()."' AND fecha='".$this->getFecha()."' AND medio='".$this->getMedio()."' AND idcliente='".$this->getIdcliente()."' AND idprestamo='".$this->getIdprestamo()."' AND numeroboucher='".$this->getNumeroboucher()."' AND tipopago='".$this->getTipopago()."';";
        $result = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $con->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

 public function delete()
  {
    try
    {
      //echo $this->getIdclase()."&&".$this->getIdsucursal()."&&".$this->getIdmercado()."&&".$this->getIdcolaborador()."&&".$this->getFecha()."&&".$this->getIdcliente()."&&".$this->getIdprestamo()."&&".$this->getNumeroboucher()."&&".$this->getMedio()."&&".$this->getTipopago();
      if($this->getIdclase() && $this->getIdsucursal() && $this->getIdmercado() && $this->getIdcolaborador() && $this->getFecha() && $this->getIdcliente() && $this->getIdprestamo() && $this->getNumeroboucher() && $this->getMedio() && $this->getTipopago())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM ar_arqueo_detalle_deposito WHERE 1 AND idclase='".$this->getIdclase()."' AND idsucursal='".$this->getIdsucursal()."' AND idmercado='".$this->getIdmercado()."' AND idcolaborador='".$this->getIdcolaborador()."' AND fecha='".$this->getFecha()."' AND idcliente='".$this->getIdcliente()."' AND idprestamo='".$this->getIdprestamo()."' AND numeroboucher='".$this->getNumeroboucher()."' AND medio='".$this->getMedio()."' AND tipopago='".$this->getTipopago()."';"; 
        //echo $sql;
        //exit;
        $result = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $con->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* B�squeda del registro por la llave primaria */
  public static function selectByPK($vIdclase, $vIdsucursal, $vIdmercado, $vIdcolaborador, $vFecha,$vMedio, $vIdcliente, $vIdprestamo)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idclase, idsucursal, idmercado, idcolaborador, fecha, medio, idcliente, idprestamo, nombrecliente, idbanco, idcuenta, banco, numerocuenta, fechadeposito, numeroboucher, subtotal, estado, idpagoreferencia, fecharegistro, usuarioregistro FROM ar_arqueo_detalle_deposito WHERE 1 AND idclase='".$vIdclase."' AND idsucursal='".$vIdsucursal."' AND idmercado='".$vIdmercado."' AND idcolaborador='".$vIdcolaborador."' AND fecha='".$vFecha."' AND medio='".$vMedio."' AND idcliente='".$vIdcliente."' AND idprestamo='".$vIdprestamo."'; ";
       $result = $con->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_ArArqueoDetalleDepositoDP = new ArArqueoDetalleDepositoDP();
    $o_ArArqueoDetalleDepositoDP->setIdclase($o_propel->idclase);
    $o_ArArqueoDetalleDepositoDP->setIdsucursal($o_propel->idsucursal);
    $o_ArArqueoDetalleDepositoDP->setIdmercado($o_propel->idmercado);
    $o_ArArqueoDetalleDepositoDP->setIdcolaborador($o_propel->idcolaborador);
    $o_ArArqueoDetalleDepositoDP->setFecha($o_propel->fecha);
    $o_ArArqueoDetalleDepositoDP->setMedio($o_propel->medio);
    $o_ArArqueoDetalleDepositoDP->setTipopago($o_propel->tipopago);
    $o_ArArqueoDetalleDepositoDP->setIdcliente($o_propel->idcliente);
    $o_ArArqueoDetalleDepositoDP->setIdprestamo($o_propel->idprestamo);
    $o_ArArqueoDetalleDepositoDP->setNombrecliente($o_propel->nombrecliente);
    $o_ArArqueoDetalleDepositoDP->setIdbanco($o_propel->idbanco);
    $o_ArArqueoDetalleDepositoDP->setIdcuenta($o_propel->idcuenta);
    $o_ArArqueoDetalleDepositoDP->setBanco($o_propel->banco);
    $o_ArArqueoDetalleDepositoDP->setNumerocuenta($o_propel->numerocuenta);
    $o_ArArqueoDetalleDepositoDP->setFechadeposito($o_propel->fechadeposito);
    $o_ArArqueoDetalleDepositoDP->setNumeroboucher($o_propel->numeroboucher);
    $o_ArArqueoDetalleDepositoDP->setSubtotal($o_propel->subtotal);
    $o_ArArqueoDetalleDepositoDP->setEstado($o_propel->estado);
    $o_ArArqueoDetalleDepositoDP->setIdpagoreferencia($o_propel->idpagoreferencia);
    $o_ArArqueoDetalleDepositoDP->setFecharegistro($o_propel->fecharegistro);
    $o_ArArqueoDetalleDepositoDP->setUsuarioregistro($o_propel->usuarioregistro);
    $o_ArArqueoDetalleDepositoDP->setFechaaprobacion($o_propel->fechaaprobacion);
    $o_ArArqueoDetalleDepositoDP->setUsuarioaprobacion($o_propel->usuarioaprobacion);
    $o_ArArqueoDetalleDepositoDP->setFecharechazo($o_propel->fecharechazo);
    $o_ArArqueoDetalleDepositoDP->setUsuariorechazo($o_propel->usuariorechazo);
    return $o_ArArqueoDetalleDepositoDP;
  }
}