<?php
/**
 * Clase Base FN para BaseRhMarcacionTipoFN
 *
 * @package    
 * @subpackage BaseRhMarcacionTipoFN
 * @author     Willy
 * @version    SVN:: BaseRhMarcacionTipoFN.class.php,v 1.1 2019-05-13 15:05:39 william.taype Exp $
 */
class BaseRhMarcacionTipoFN extends RhMarcacionTipoBN
{
  private static $fieldNames = array (
    'Idtipo'=>'idtipo', 'Idregistro'=>'idregistro', 'Descripcion'=>'descripcion', 'Flagtienedescuento'=>'flagtienedescuento', 'Secuencia'=>'secuencia'  
  );

  public function select()
  {
    try
    {
      $tamPag = !property_exists($this, 'tamPag')?9999:$this->tamPag;
      $pagina = !property_exists($this, 'page')||$this->page==""?1:$this->page;
      $numeroRegistros = $this->selectNumRows();
      $limitInf = ($pagina-1)*$tamPag;

      $where = $this->buildConsult();
      $orden = $this->buildOrderByField();

      $con = Conexion::getConexion();
      $sql = "SELECT idtipo, idregistro, descripcion, flagtienedescuento, secuencia FROM rh_marcacion_tipo WHERE 1 ".$where." ".$orden."  LIMIT ".$limitInf.",".$tamPag;
       
       $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
       $result = $oLink->query($sql);
       
       //echo Conexion::getNameDb()."---------";
        //$result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      $a_tmp = array();
      if($num_rows>0){
      	
        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
          $a_tmp[] = $this->insertObjectBN($o_valor);
        }
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function selectNumRows()
  {
    try
    {
      $where = $this->buildConsult();

      $con = Conexion::getConexion();
      $sql = "SELECT idtipo, idregistro, descripcion, flagtienedescuento, secuencia FROM rh_marcacion_tipo WHERE 1 ".$where;
        //$oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      
      return $num_rows;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildConsult()
  {
    try
    {
      $where = "";

      if($this->getIdtipo()){ $where .= " AND idtipo = '".$this->getIdtipo()."'"; }
      if($this->getIdregistro()){ $where .= " AND idregistro = '".$this->getIdregistro()."'"; }
      if($this->getDescripcion()){ $where .= " AND descripcion = '".$this->getDescripcion()."'"; }
      if($this->getFlagtienedescuento()){ $where .= " AND flagtienedescuento = '".$this->getFlagtienedescuento()."'"; }
      if($this->getSecuencia()){ $where .= " AND secuencia = '".$this->getSecuencia()."'"; }
      return $where;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildOrderByField()
  {
    try
    {
      $order_by = "";

      if(property_exists($this,'sortCampos')){
      if($this->sortCampos != ""){
        $a_valCampos = explode(";", $this->sortCampos);
        $a_valtype   = explode(";", $this->sortType);
        $order_by = " ORDER BY ";
        $a_order = array();
        foreach ($a_valCampos as $key => $val){
          $sTmpOrder = "";
          if(array_key_exists($val, self::$fieldNames)){
            $sTmpOrder .= self::$fieldNames[$val];
            switch ($a_valtype[$key]){
              case 1: $sTmpOrder .= " ASC"; break;
              case 2: $sTmpOrder .= " DESC"; break;
            }
            $a_order[] = $sTmpOrder;
          }
        }
        $order_by .= implode(", ", $a_order);
      }
      }
      return $order_by;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* B�squeda del registro por la llave primaria */
  public function selectByPK()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idtipo, idregistro, descripcion, flagtienedescuento, secuencia FROM rh_marcacion_tipo WHERE 1 AND idtipo='".$this->getIdtipo()."' AND idregistro='".$this->getIdregistro()."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      

      return $o_Propel?$this->insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_BaseRhMarcacionTipoFN = new BaseRhMarcacionTipoFN();
    $o_BaseRhMarcacionTipoFN->setIdtipo($o_propel->idtipo);
    $o_BaseRhMarcacionTipoFN->setIdregistro($o_propel->idregistro);
    $o_BaseRhMarcacionTipoFN->setDescripcion($o_propel->descripcion);
    $o_BaseRhMarcacionTipoFN->setFlagtienedescuento($o_propel->flagtienedescuento);
    $o_BaseRhMarcacionTipoFN->setSecuencia($o_propel->secuencia);
    return $o_BaseRhMarcacionTipoFN;
  }
}