<?php
/**
 * Clase Base FN para BaseRhMarcacionRegistroFN
 *
 * @package    
 * @subpackage BaseRhMarcacionRegistroFN
 * @author     Willy
 * @version    SVN:: BaseRhMarcacionRegistroFN.class.php,v 1.1 2019-05-13 15:05:39 william.taype Exp $
 */
class BaseRhMarcacionRegistroFN extends RhMarcacionRegistroBN
{
  private static $fieldNames = array (
    'Idregistro'=>'idregistro', 'Descripcion'=>'descripcion', 'Secuencia'=>'secuencia', 'Estado'=>'estado', 'Flagobligatorio'=>'flagobligatorio', 'Idequivalencia'=>'idequivalencia'  
  );

  public function select()
  {
    try
    {
      $tamPag = !property_exists($this, 'tamPag')?9999:$this->tamPag;
      $pagina = !property_exists($this, 'page')||$this->page==""?1:$this->page;
      $numeroRegistros = $this->selectNumRows();
      $limitInf = ($pagina-1)*$tamPag;

      $where = $this->buildConsult();
      $orden = $this->buildOrderByField();

      $con = Conexion::getConexion();
      $sql = "SELECT idregistro, descripcion, secuencia, estado, flagobligatorio, idequivalencia FROM rh_marcacion_registro WHERE 1 ".$where." ".$orden."  LIMIT ".$limitInf.",".$tamPag;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      $a_tmp = array();
      if($num_rows>0){
        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
          $a_tmp[] = $this->insertObjectBN($o_valor);
        }
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function selectNumRows()
  {
    try
    {
      $where = $this->buildConsult();

      $con = Conexion::getConexion();
      $sql = "SELECT idregistro, descripcion, secuencia, estado, flagobligatorio, idequivalencia FROM rh_marcacion_registro WHERE 1 ".$where;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      
      return $num_rows;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildConsult()
  {
    try
    {
      $where = "";

      if($this->getIdregistro()){ $where .= " AND idregistro = '".$this->getIdregistro()."'"; }
      if($this->getDescripcion()){ $where .= " AND descripcion = '".$this->getDescripcion()."'"; }
      if($this->getSecuencia()){ $where .= " AND secuencia = '".$this->getSecuencia()."'"; }
      if($this->getEstado()){ $where .= " AND estado = '".$this->getEstado()."'"; }
      if($this->getFlagobligatorio()){ $where .= " AND flagobligatorio = '".$this->getFlagobligatorio()."'"; }
      if($this->getIdequivalencia()){ $where .= " AND idequivalencia = '".$this->getIdequivalencia()."'"; }
      return $where;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildOrderByField()
  {
    try
    {
      $order_by = "";

      if(property_exists($this,'sortCampos')){
      if($this->sortCampos != ""){
        $a_valCampos = explode(";", $this->sortCampos);
        $a_valtype   = explode(";", $this->sortType);
        $order_by = " ORDER BY ";
        $a_order = array();
        foreach ($a_valCampos as $key => $val){
          $sTmpOrder = "";
          if(array_key_exists($val, self::$fieldNames)){
            $sTmpOrder .= self::$fieldNames[$val];
            switch ($a_valtype[$key]){
              case 1: $sTmpOrder .= " ASC"; break;
              case 2: $sTmpOrder .= " DESC"; break;
            }
            $a_order[] = $sTmpOrder;
          }
        }
        $order_by .= implode(", ", $a_order);
      }
      }
      return $order_by;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Bsqueda del registro por la llave primaria */
  public function selectByPK()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idregistro, descripcion, secuencia, estado, flagobligatorio, idequivalencia FROM rh_marcacion_registro WHERE 1 AND idregistro='".$this->getIdregistro()."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      

      return $o_Propel?$this->insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con mtodos de acceso */
  private function insertObjectBN($o_propel){
    $o_BaseRhMarcacionRegistroFN = new BaseRhMarcacionRegistroFN();
    $o_BaseRhMarcacionRegistroFN->setIdregistro($o_propel->idregistro);
    $o_BaseRhMarcacionRegistroFN->setDescripcion($o_propel->descripcion);
    $o_BaseRhMarcacionRegistroFN->setSecuencia($o_propel->secuencia);
    $o_BaseRhMarcacionRegistroFN->setEstado($o_propel->estado);
    $o_BaseRhMarcacionRegistroFN->setFlagobligatorio($o_propel->flagobligatorio);
    $o_BaseRhMarcacionRegistroFN->setIdequivalencia($o_propel->idequivalencia);
    return $o_BaseRhMarcacionRegistroFN;
  }
}