<?php
/**
 * Clase Base FN para BaseRhMarcacionColaboradorFN
 *
 * @package    
 * @subpackage BaseRhMarcacionColaboradorFN
 * @author     Willy
 * @version    SVN:: BaseRhMarcacionColaboradorFN.class.php,v 1.1 2019-05-13 15:05:39 william.taype Exp $
 */
class BaseRhMarcacionColaboradorFN extends RhMarcacionColaboradorBN
{
  private static $fieldNames = array (
    'Idregistro'=>'idregistro', 'Idtipo'=>'idtipo', 'Idcolaborador'=>'idcolaborador', 'Horaminutoinicio'=>'horaminutodesde', 'Flagdiasiguiente'=>'flagdiasiguiente', 'Horaminutofin'=>'horaminutohasta', 'Montodescuento'=>'montodescuento', 'Estado'=>'estado', 'Secuencia'=>'secuencia'  
  );

  public function select()
  {
    try
    {
      $tamPag = !property_exists($this, 'tamPag')?9999:$this->tamPag;
      $pagina = !property_exists($this, 'page')||$this->page==""?1:$this->page;
      $numeroRegistros = $this->selectNumRows();
      $limitInf = ($pagina-1)*$tamPag;

      $where = $this->buildConsult();
      $orden = $this->buildOrderByField();

      $con = Conexion::getConexion();
      $sql = "SELECT idregistro, idtipo, idcolaborador, horaminutodesde, flagdiasiguiente, horaminutohasta, montodescuento, estado, secuencia FROM rh_marcacion_colaborador WHERE 1 ".$where." ".$orden."  LIMIT ".$limitInf.",".$tamPag;
      //echo $sql;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result  = $con->query($sql);
      $num_rows = $result->rowCount();
      $a_tmp = array();
      if($num_rows>0){
        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
          $a_tmp[] = $this->insertObjectBN($o_valor);
        }
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function selectNumRows()
  {
    try
    {
      $where = $this->buildConsult();

      $con = Conexion::getConexion();
      $sql = "SELECT idregistro, idtipo, idcolaborador, horaminutodesde, flagdiasiguiente, horaminutohasta, montodescuento, estado, secuencia FROM rh_marcacion_colaborador WHERE 1 ".$where;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result  = $con->query($sql);
      $num_rows = $result->rowCount();
      
      return $num_rows;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildConsult()
  {
    try
    {
      $where = "";

      if($this->getIdregistro()){ $where .= " AND idregistro = '".$this->getIdregistro()."'"; }
      if($this->getIdtipo()){ $where .= " AND idtipo = '".$this->getIdtipo()."'"; }
      if($this->getIdcolaborador()){ $where .= " AND idcolaborador = '".$this->getIdcolaborador()."'"; }
      if($this->getHoraminutoinicio()){ $where .= " AND horaminutodesde = '".$this->getHoraminutoinicio()."'"; }
      if($this->getFlagdiasiguiente()){ $where .= " AND flagdiasiguiente = '".$this->getFlagdiasiguiente()."'"; }
      if($this->getHoraminutofin()){ $where .= " AND horaminutohasta = '".$this->getHoraminutofin()."'"; }
      if($this->getMontodescuento()){ $where .= " AND montodescuento = '".$this->getMontodescuento()."'"; }
      if($this->getEstado()){ $where .= " AND estado = '".$this->getEstado()."'"; }
      if($this->getSecuencia()){ $where .= " AND secuencia = '".$this->getSecuencia()."'"; }
      return $where;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildOrderByField()
  {
    try
    {
      $order_by = "";

      if(property_exists($this,'sortCampos')){
      if($this->sortCampos != ""){
        $a_valCampos = explode(";", $this->sortCampos);
        $a_valtype   = explode(";", $this->sortType);
        $order_by = " ORDER BY ";
        $a_order = array();
        foreach ($a_valCampos as $key => $val){
          $sTmpOrder = "";
          if(array_key_exists($val, self::$fieldNames)){
            $sTmpOrder .= self::$fieldNames[$val];
            switch ($a_valtype[$key]){
              case 1: $sTmpOrder .= " ASC"; break;
              case 2: $sTmpOrder .= " DESC"; break;
            }
            $a_order[] = $sTmpOrder;
          }
        }
        $order_by .= implode(", ", $a_order);
      }
      }
      return $order_by;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* B�squeda del registro por la llave primaria */
  public function selectByPK()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idregistro, idtipo, idcolaborador, horaminutodesde, flagdiasiguiente, horaminutohasta, montodescuento, estado, secuencia FROM rh_marcacion_colaborador WHERE 1 AND idregistro='".$this->getIdregistro()."' AND idtipo='".$this->getIdtipo()."' AND idcolaborador='".$this->getIdcolaborador()."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result  = $con->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      

      return $o_Propel?$this->insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_BaseRhMarcacionColaboradorFN = new BaseRhMarcacionColaboradorFN();
    $o_BaseRhMarcacionColaboradorFN->setIdregistro($o_propel->idregistro);
    $o_BaseRhMarcacionColaboradorFN->setIdtipo($o_propel->idtipo);
    $o_BaseRhMarcacionColaboradorFN->setIdcolaborador($o_propel->idcolaborador);
    $o_BaseRhMarcacionColaboradorFN->setHoraminutoinicio($o_propel->horaminutodesde);
    $o_BaseRhMarcacionColaboradorFN->setFlagdiasiguiente($o_propel->flagdiasiguiente);
    $o_BaseRhMarcacionColaboradorFN->setHoraminutofin($o_propel->horaminutohasta);
    $o_BaseRhMarcacionColaboradorFN->setMontodescuento($o_propel->montodescuento);
    $o_BaseRhMarcacionColaboradorFN->setEstado($o_propel->estado);
    $o_BaseRhMarcacionColaboradorFN->setSecuencia($o_propel->secuencia);
    return $o_BaseRhMarcacionColaboradorFN;
  }
}