<?php
/**
 * Clase Base FN para BasePlSucursalHorarioFN
 *
 * @package    
 * @subpackage BasePlSucursalHorarioFN
 * @author     Willy
 * @version    SVN:: BasePlSucursalHorarioFN.class.php,v 1.1 2019-05-13 15:05:39 william.taype Exp $
 */
class BasePlSucursalHorarioFN extends PlSucursalHorarioBN
{
  private static $fieldNames = array (
    'Idsucursal'=>'idsucursal', 'Horaminutoninicio'=>'horaminutoninicio', 'Diasiguiente'=>'diasiguiente', 'Horaminutofin'=>'horaminutofin', 'Monto'=>'monto'  
  );

  public function select()
  {
    try
    {
      $tamPag = !property_exists($this, 'tamPag')?9999:$this->tamPag;
      $pagina = !property_exists($this, 'page')||$this->page==""?1:$this->page;
      $numeroRegistros = $this->selectNumRows();
      $limitInf = ($pagina-1)*$tamPag;

      $where = $this->buildConsult();
      $orden = $this->buildOrderByField();

      $con = Conexion::getConexion();
      $sql = "SELECT idsucursal, horaminutoninicio, diasiguiente, horaminutofin, monto FROM pl_sucursal_horario WHERE 1 ".$where." ".$orden."  LIMIT ".$limitInf.",".$tamPag;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      $a_tmp = array();
      if($num_rows>0){
        while ($o_valor = $result->fetch(PDO::FETCH_OBJ)) {
          $a_tmp[] = $this->insertObjectBN($o_valor);
        }
      }
      
      return count($a_tmp)>0?$a_tmp:null;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function selectNumRows()
  {
    try
    {
      $where = $this->buildConsult();

      $con = Conexion::getConexion();
      $sql = "SELECT idsucursal, horaminutoninicio, diasiguiente, horaminutofin, monto FROM pl_sucursal_horario WHERE 1 ".$where;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $num_rows = $result->rowCount();
      
      return $num_rows;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildConsult()
  {
    try
    {
      $where = "";

      if($this->getIdsucursal()){ $where .= " AND idsucursal = '".$this->getIdsucursal()."'"; }
      if($this->getHoraminutoninicio()){ $where .= " AND horaminutoninicio = '".$this->getHoraminutoninicio()."'"; }
      if($this->getDiasiguiente()){ $where .= " AND diasiguiente = '".$this->getDiasiguiente()."'"; }
      if($this->getHoraminutofin()){ $where .= " AND horaminutofin = '".$this->getHoraminutofin()."'"; }
      if($this->getMonto()){ $where .= " AND monto = '".$this->getMonto()."'"; }
      return $where;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  public function buildOrderByField()
  {
    try
    {
      $order_by = "";

      if(property_exists($this,'sortCampos')){
      if($this->sortCampos != ""){
        $a_valCampos = explode(";", $this->sortCampos);
        $a_valtype   = explode(";", $this->sortType);
        $order_by = " ORDER BY ";
        $a_order = array();
        foreach ($a_valCampos as $key => $val){
          $sTmpOrder = "";
          if(array_key_exists($val, self::$fieldNames)){
            $sTmpOrder .= self::$fieldNames[$val];
            switch ($a_valtype[$key]){
              case 1: $sTmpOrder .= " ASC"; break;
              case 2: $sTmpOrder .= " DESC"; break;
            }
            $a_order[] = $sTmpOrder;
          }
        }
        $order_by .= implode(", ", $a_order);
      }
      }
      return $order_by;
    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Bsqueda del registro por la llave primaria */
  public function selectByPK()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idsucursal, horaminutoninicio, diasiguiente, horaminutofin, monto FROM pl_sucursal_horario WHERE 1 AND idsucursal='".$this->getIdsucursal()."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      

      return $o_Propel?$this->insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con mtodos de acceso */
  private function insertObjectBN($o_propel){
    $o_BasePlSucursalHorarioFN = new BasePlSucursalHorarioFN();
    $o_BasePlSucursalHorarioFN->setIdsucursal($o_propel->idsucursal);
    $o_BasePlSucursalHorarioFN->setHoraminutoninicio($o_propel->horaminutoninicio);
    $o_BasePlSucursalHorarioFN->setDiasiguiente($o_propel->diasiguiente);
    $o_BasePlSucursalHorarioFN->setHoraminutofin($o_propel->horaminutofin);
    $o_BasePlSucursalHorarioFN->setMonto($o_propel->monto);
    return $o_BasePlSucursalHorarioFN;
  }
}