<?php
/**
 * Clase Base DP para BaseRhMarcacionTipoDP
 *
 * @package    
 * @subpackage BaseRhMarcacionTipoDP
 * @author     Willy
 * @version    SVN:: BaseRhMarcacionTipoDP.class.php,v 1.1 2019-05-13 12:56:33 william.taype Exp $
 */
abstract class BaseRhMarcacionTipoDP extends RhMarcacionTipoBN
{
  /* Nmero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof RhMarcacionTipoBN )
    {
      $o_RhMarcacionTipoBN = $bSetDefault;
      if($o_RhMarcacionTipoBN->getIdtipo()) : $this->setIdtipo($o_RhMarcacionTipoBN->getIdtipo()); endif;
      if($o_RhMarcacionTipoBN->getIdregistro()) : $this->setIdregistro($o_RhMarcacionTipoBN->getIdregistro()); endif;
      if($o_RhMarcacionTipoBN->getDescripcion()) : $this->setDescripcion($o_RhMarcacionTipoBN->getDescripcion()); endif;
      if($o_RhMarcacionTipoBN->getFlagtienedescuento()) : $this->setFlagtienedescuento($o_RhMarcacionTipoBN->getFlagtienedescuento()); endif;
      if($o_RhMarcacionTipoBN->getSecuencia()) : $this->setSecuencia($o_RhMarcacionTipoBN->getSecuencia()); endif;
    }
  }

  /* Obtiene el nmero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(idtipo),(MAX(idtipo)+1), 1) AS Maximo FROM rh_marcacion_tipo;";
      $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
      $result = $oLink->query($sql);
      $row = $result->fetch(PDO::FETCH_ASSOC);
      $this->setIdtipo($row["Maximo"]);

      if($this->getIdtipo() && $this->getIdregistro()){
        $a_Fields = array();

        if($this->getIdtipo()) : $a_Fields['idtipo'] = ($this->getIdtipo()); endif;
        if($this->getIdregistro()) : $a_Fields['idregistro'] = ($this->getIdregistro()); endif;
        if($this->getDescripcion()) : $a_Fields['descripcion'] = ($this->getDescripcion()); endif;
        if($this->getFlagtienedescuento()) : $a_Fields['flagtienedescuento'] = ($this->getFlagtienedescuento()); endif;
        if($this->getSecuencia()) : $a_Fields['secuencia'] = ($this->getSecuencia()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO rh_marcacion_tipo (".$sStringField.") VALUES (".$sStringValue.");";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdtipo() && $this->getIdregistro())
      {
        $a_Fields = array();

        if($this->getIdtipo()) : $a_Fields['idtipo'] = ($this->getIdtipo()); endif;
        if($this->getIdregistro()) : $a_Fields['idregistro'] = ($this->getIdregistro()); endif;
        if($this->getDescripcion()) : $a_Fields['descripcion'] = ($this->getDescripcion()); endif;
        if($this->getFlagtienedescuento()) : $a_Fields['flagtienedescuento'] = ($this->getFlagtienedescuento()); endif;
        if($this->getSecuencia()) : $a_Fields['secuencia'] = ($this->getSecuencia()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE rh_marcacion_tipo SET ".$sStringField." WHERE 1 AND idtipo='".$this->getIdtipo()."' AND idregistro='".$this->getIdregistro()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdtipo() && $this->getIdregistro())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM rh_marcacion_tipo WHERE 1 AND idtipo='".$this->getIdtipo()."' AND idregistro='".$this->getIdregistro()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* Bsqueda del registro por la llave primaria */
  public static function selectByPK($vIdtipo, $vIdregistro)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idtipo, idregistro, descripcion, flagtienedescuento, secuencia FROM rh_marcacion_tipo WHERE 1 AND idtipo='".$vIdtipo."' AND idregistro='".$vIdregistro."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con mtodos de acceso */
  private function insertObjectBN($o_propel){
    $o_RhMarcacionTipoDP = new RhMarcacionTipoDP();
    $o_RhMarcacionTipoDP->setIdtipo($o_propel->idtipo);
    $o_RhMarcacionTipoDP->setIdregistro($o_propel->idregistro);
    $o_RhMarcacionTipoDP->setDescripcion($o_propel->descripcion);
    $o_RhMarcacionTipoDP->setFlagtienedescuento($o_propel->flagtienedescuento);
    $o_RhMarcacionTipoDP->setSecuencia($o_propel->secuencia);
    return $o_RhMarcacionTipoDP;
  }
}