<?php
/**
 * Clase Base DP para BaseRhMarcacionRegistroDP
 *
 * @package    
 * @subpackage BaseRhMarcacionRegistroDP
 * @author     Willy
 * @version    SVN:: BaseRhMarcacionRegistroDP.class.php,v 1.1 2019-05-13 12:56:33 william.taype Exp $
 */
abstract class BaseRhMarcacionRegistroDP extends RhMarcacionRegistroBN
{
  /* Nmero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof RhMarcacionRegistroBN )
    {
      $o_RhMarcacionRegistroBN = $bSetDefault;
      if($o_RhMarcacionRegistroBN->getIdregistro()) : $this->setIdregistro($o_RhMarcacionRegistroBN->getIdregistro()); endif;
      if($o_RhMarcacionRegistroBN->getDescripcion()) : $this->setDescripcion($o_RhMarcacionRegistroBN->getDescripcion()); endif;
      if($o_RhMarcacionRegistroBN->getSecuencia()) : $this->setSecuencia($o_RhMarcacionRegistroBN->getSecuencia()); endif;
      if($o_RhMarcacionRegistroBN->getEstado()) : $this->setEstado($o_RhMarcacionRegistroBN->getEstado()); endif;
      if($o_RhMarcacionRegistroBN->getFlagobligatorio()) : $this->setFlagobligatorio($o_RhMarcacionRegistroBN->getFlagobligatorio()); endif;
      if($o_RhMarcacionRegistroBN->getIdequivalencia()) : $this->setIdequivalencia($o_RhMarcacionRegistroBN->getIdequivalencia()); endif;
    }
  }

  /* Obtiene el nmero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(idregistro),(MAX(idregistro)+1), 1) AS Maximo FROM rh_marcacion_registro;";
      $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
      $result = $oLink->query($sql);
      $row = $result->fetch(PDO::FETCH_ASSOC);
      $this->setIdregistro($row["Maximo"]);

      if($this->getIdregistro()){
        $a_Fields = array();

        if($this->getIdregistro()) : $a_Fields['idregistro'] = ($this->getIdregistro()); endif;
        if($this->getDescripcion()) : $a_Fields['descripcion'] = ($this->getDescripcion()); endif;
        if($this->getSecuencia()) : $a_Fields['secuencia'] = ($this->getSecuencia()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getFlagobligatorio()) : $a_Fields['flagobligatorio'] = ($this->getFlagobligatorio()); endif;
        if($this->getIdequivalencia()) : $a_Fields['idequivalencia'] = ($this->getIdequivalencia()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO rh_marcacion_registro (".$sStringField.") VALUES (".$sStringValue.");";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdregistro())
      {
        $a_Fields = array();

        if($this->getIdregistro()) : $a_Fields['idregistro'] = ($this->getIdregistro()); endif;
        if($this->getDescripcion()) : $a_Fields['descripcion'] = ($this->getDescripcion()); endif;
        if($this->getSecuencia()) : $a_Fields['secuencia'] = ($this->getSecuencia()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getFlagobligatorio()) : $a_Fields['flagobligatorio'] = ($this->getFlagobligatorio()); endif;
        if($this->getIdequivalencia()) : $a_Fields['idequivalencia'] = ($this->getIdequivalencia()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE rh_marcacion_registro SET ".$sStringField." WHERE 1 AND idregistro='".$this->getIdregistro()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdregistro())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM rh_marcacion_registro WHERE 1 AND idregistro='".$this->getIdregistro()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* Bsqueda del registro por la llave primaria */
  public static function selectByPK($vIdregistro)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idregistro, descripcion, secuencia, estado, flagobligatorio, idequivalencia FROM rh_marcacion_registro WHERE 1 AND idregistro='".$vIdregistro."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con mtodos de acceso */
  private function insertObjectBN($o_propel){
    $o_RhMarcacionRegistroDP = new RhMarcacionRegistroDP();
    $o_RhMarcacionRegistroDP->setIdregistro($o_propel->idregistro);
    $o_RhMarcacionRegistroDP->setDescripcion($o_propel->descripcion);
    $o_RhMarcacionRegistroDP->setSecuencia($o_propel->secuencia);
    $o_RhMarcacionRegistroDP->setEstado($o_propel->estado);
    $o_RhMarcacionRegistroDP->setFlagobligatorio($o_propel->flagobligatorio);
    $o_RhMarcacionRegistroDP->setIdequivalencia($o_propel->idequivalencia);
    return $o_RhMarcacionRegistroDP;
  }
}