<?php
/**
 * Clase Base DP para BaseRhMarcacionDetalleDP
 *
 * @package    
 * @subpackage BaseRhMarcacionDetalleDP
 * @author     Willy
 * @version    SVN:: BaseRhMarcacionDetalleDP.class.php,v 1.1 2019-04-30 11:03:24 william.taype Exp $
 */
abstract class BaseRhMarcacionDetalleDP extends RhMarcacionDetalleBN
{
  /* Nmero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof RhMarcacionDetalleBN )
    {
      $o_RhMarcacionDetalleBN = $bSetDefault;
      if($o_RhMarcacionDetalleBN->getIddetalle()) : $this->setIddetalle($o_RhMarcacionDetalleBN->getIddetalle()); endif;
      if($o_RhMarcacionDetalleBN->getIdmarcacion()) : $this->setIdmarcacion($o_RhMarcacionDetalleBN->getIdmarcacion()); endif;
      if($o_RhMarcacionDetalleBN->getDescripcion()) : $this->setDescripcion($o_RhMarcacionDetalleBN->getDescripcion()); endif;
      if($o_RhMarcacionDetalleBN->getFlagtienedescuento()) : $this->setFlagtienedescuento($o_RhMarcacionDetalleBN->getFlagtienedescuento()); endif;
      if($o_RhMarcacionDetalleBN->getSecuencia()) : $this->setSecuencia($o_RhMarcacionDetalleBN->getSecuencia()); endif;
    }
  }

  /* Obtiene el nmero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(iddetalle),(MAX(iddetalle)+1), 1) AS Maximo FROM rh_marcacion_detalle;";
      $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
      $result = $oLink->query($sql);
      $row = $result->fetch(PDO::FETCH_ASSOC);
      $this->setIddetalle($row["Maximo"]);

      if($this->getIddetalle() && $this->getIdmarcacion()){
        $a_Fields = array();

        if($this->getIddetalle()) : $a_Fields['iddetalle'] = ($this->getIddetalle()); endif;
        if($this->getIdmarcacion()) : $a_Fields['idmarcacion'] = ($this->getIdmarcacion()); endif;
        if($this->getDescripcion()) : $a_Fields['descripcion'] = ($this->getDescripcion()); endif;
        if($this->getFlagtienedescuento()) : $a_Fields['flagtienedescuento'] = ($this->getFlagtienedescuento()); endif;
        if($this->getSecuencia()) : $a_Fields['secuencia'] = ($this->getSecuencia()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO rh_marcacion_detalle (".$sStringField.") VALUES (".$sStringValue.");";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIddetalle() && $this->getIdmarcacion())
      {
        $a_Fields = array();

        if($this->getIddetalle()) : $a_Fields['iddetalle'] = ($this->getIddetalle()); endif;
        if($this->getIdmarcacion()) : $a_Fields['idmarcacion'] = ($this->getIdmarcacion()); endif;
        if($this->getDescripcion()) : $a_Fields['descripcion'] = ($this->getDescripcion()); endif;
        if($this->getFlagtienedescuento()) : $a_Fields['flagtienedescuento'] = ($this->getFlagtienedescuento()); endif;
        if($this->getSecuencia()) : $a_Fields['secuencia'] = ($this->getSecuencia()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE rh_marcacion_detalle SET ".$sStringField." WHERE 1 AND iddetalle='".$this->getIddetalle()."' AND idmarcacion='".$this->getIdmarcacion()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIddetalle() && $this->getIdmarcacion())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM rh_marcacion_detalle WHERE 1 AND iddetalle='".$this->getIddetalle()."' AND idmarcacion='".$this->getIdmarcacion()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* Bsqueda del registro por la llave primaria */
  public static function selectByPK($vIddetalle, $vIdmarcacion)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT iddetalle, idmarcacion, descripcion, flagtienedescuento, secuencia FROM rh_marcacion_detalle WHERE 1 AND iddetalle='".$vIddetalle."' AND idmarcacion='".$vIdmarcacion."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con mtodos de acceso */
  private function insertObjectBN($o_propel){
    $o_RhMarcacionDetalleDP = new RhMarcacionDetalleDP();
    $o_RhMarcacionDetalleDP->setIddetalle($o_propel->iddetalle);
    $o_RhMarcacionDetalleDP->setIdmarcacion($o_propel->idmarcacion);
    $o_RhMarcacionDetalleDP->setDescripcion($o_propel->descripcion);
    $o_RhMarcacionDetalleDP->setFlagtienedescuento($o_propel->flagtienedescuento);
    $o_RhMarcacionDetalleDP->setSecuencia($o_propel->secuencia);
    return $o_RhMarcacionDetalleDP;
  }
}