<?php
/**
 * Clase Base DP para BaseRhMarcacionColaboradorDP
 *
 * @package    
 * @subpackage BaseRhMarcacionColaboradorDP
 * @author     Willy
 * @version    SVN:: BaseRhMarcacionColaboradorDP.class.php,v 1.1 2019-05-13 12:56:33 william.taype Exp $
 */
abstract class BaseRhMarcacionColaboradorDP extends RhMarcacionColaboradorBN
{
  /* N�mero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof RhMarcacionColaboradorBN )
    {
      $o_RhMarcacionColaboradorBN = $bSetDefault;
      if($o_RhMarcacionColaboradorBN->getIdregistro()) : $this->setIdregistro($o_RhMarcacionColaboradorBN->getIdregistro()); endif;
      if($o_RhMarcacionColaboradorBN->getIdtipo()) : $this->setIdtipo($o_RhMarcacionColaboradorBN->getIdtipo()); endif;
      if($o_RhMarcacionColaboradorBN->getIdcolaborador()) : $this->setIdcolaborador($o_RhMarcacionColaboradorBN->getIdcolaborador()); endif;
      if($o_RhMarcacionColaboradorBN->getHoraminutoinicio()) : $this->setHoraminutoinicio($o_RhMarcacionColaboradorBN->getHoraminutoinicio()); endif;
      if($o_RhMarcacionColaboradorBN->getFlagdiasiguiente()) : $this->setFlagdiasiguiente($o_RhMarcacionColaboradorBN->getFlagdiasiguiente()); endif;
      if($o_RhMarcacionColaboradorBN->getHoraminutofin()) : $this->setHoraminutofin($o_RhMarcacionColaboradorBN->getHoraminutofin()); endif;
      if($o_RhMarcacionColaboradorBN->getMontodescuento()) : $this->setMontodescuento($o_RhMarcacionColaboradorBN->getMontodescuento()); endif;
      if($o_RhMarcacionColaboradorBN->getEstado()) : $this->setEstado($o_RhMarcacionColaboradorBN->getEstado()); endif;
      if($o_RhMarcacionColaboradorBN->getSecuencia()) : $this->setSecuencia($o_RhMarcacionColaboradorBN->getSecuencia()); endif;
    }
  }

  /* Obtiene el n�mero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      
      if($this->getIdregistro() && $this->getIdtipo() && $this->getIdcolaborador()){
        $a_Fields = array();

        if($this->getIdregistro()) : $a_Fields['idregistro'] = ($this->getIdregistro()); endif;
        if($this->getIdtipo()) : $a_Fields['idtipo'] = ($this->getIdtipo()); endif;
        if($this->getIdcolaborador()) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if($this->getHoraminutoinicio()) : $a_Fields['horaminutodesde'] = ($this->getHoraminutoinicio()); endif;
        if($this->getFlagdiasiguiente()) : $a_Fields['flagdiasiguiente'] = ($this->getFlagdiasiguiente()); endif;
        if($this->getHoraminutofin()) : $a_Fields['horaminutohasta'] = ($this->getHoraminutofin()); endif;
        if($this->getMontodescuento()) : $a_Fields['montodescuento'] = ($this->getMontodescuento()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getSecuencia()) : $a_Fields['secuencia'] = ($this->getSecuencia()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO rh_marcacion_colaborador (".$sStringField.") VALUES (".$sStringValue.");";
		echo $sql;
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result  = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdregistro() && $this->getIdtipo() && $this->getIdcolaborador())
      {
        $a_Fields = array();

        if($this->getIdregistro()) : $a_Fields['idregistro'] = ($this->getIdregistro()); endif;
        if($this->getIdtipo()) : $a_Fields['idtipo'] = ($this->getIdtipo()); endif;
        if($this->getIdcolaborador()) : $a_Fields['idcolaborador'] = ($this->getIdcolaborador()); endif;
        if($this->getHoraminutoinicio()) : $a_Fields['horaminutodesde'] = ($this->getHoraminutoinicio()); endif;
        if($this->getFlagdiasiguiente()) : $a_Fields['flagdiasiguiente'] = ($this->getFlagdiasiguiente()); endif;
        if($this->getHoraminutofin()) : $a_Fields['horaminutohasta'] = ($this->getHoraminutofin()); endif;
        if($this->getMontodescuento()) : $a_Fields['montodescuento'] = ($this->getMontodescuento()); endif;
        if($this->getEstado()) : $a_Fields['estado'] = ($this->getEstado()); endif;
        if($this->getSecuencia()) : $a_Fields['secuencia'] = ($this->getSecuencia()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE rh_marcacion_colaborador SET ".$sStringField." WHERE 1 AND idregistro='".$this->getIdregistro()."' AND idtipo='".$this->getIdtipo()."' AND idcolaborador='".$this->getIdcolaborador()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result  = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdregistro() && $this->getIdtipo() && $this->getIdcolaborador())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM rh_marcacion_colaborador WHERE 1 AND idregistro='".$this->getIdregistro()."' AND idtipo='".$this->getIdtipo()."' AND idcolaborador='".$this->getIdcolaborador()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result  = $con->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* B�squeda del registro por la llave primaria */
  public static function selectByPK($vIdregistro, $vIdtipo, $vIdcolaborador)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idregistro, idtipo, idcolaborador, horaminutodesde, flagdiasiguiente, horaminutohasta, montodescuento, estado, secuencia FROM rh_marcacion_colaborador WHERE 1 AND idregistro='".$vIdregistro."' AND idtipo='".$vIdtipo."' AND idcolaborador='".$vIdcolaborador."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result  = $con->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con m�todos de acceso */
  private function insertObjectBN($o_propel){
    $o_RhMarcacionColaboradorDP = new RhMarcacionColaboradorDP();
    $o_RhMarcacionColaboradorDP->setIdregistro($o_propel->idregistro);
    $o_RhMarcacionColaboradorDP->setIdtipo($o_propel->idtipo);
    $o_RhMarcacionColaboradorDP->setIdcolaborador($o_propel->idcolaborador);
    $o_RhMarcacionColaboradorDP->setHoraminutoinicio($o_propel->horaminutodesde);
    $o_RhMarcacionColaboradorDP->setFlagdiasiguiente($o_propel->flagdiasiguiente);
    $o_RhMarcacionColaboradorDP->setHoraminutofin($o_propel->horaminutohasta);
    $o_RhMarcacionColaboradorDP->setMontodescuento($o_propel->montodescuento);
    $o_RhMarcacionColaboradorDP->setEstado($o_propel->estado);
    $o_RhMarcacionColaboradorDP->setSecuencia($o_propel->secuencia);
    return $o_RhMarcacionColaboradorDP;
  }
}