<?php
/**
 * Clase Base DP para BaseRhDiasemanaDP
 *
 * @package    
 * @subpackage BaseRhDiasemanaDP
 * @author     Willy
 * @version    SVN:: BaseRhDiasemanaDP.class.php,v 1.1 2019-05-13 12:56:33 william.taype Exp $
 */
abstract class BaseRhDiasemanaDP extends RhDiasemanaBN
{
  /* Nmero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof RhDiasemanaBN )
    {
      $o_RhDiasemanaBN = $bSetDefault;
    }
  }

  /* Obtiene el nmero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(),(MAX()+1), 1) AS Maximo FROM rh_diasemana;";
      $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
      $result = $oLink->query($sql);
      $row = $result->fetch(PDO::FETCH_ASSOC);
      $this->set($row["Maximo"]);

      if(){
        $a_Fields = array();


        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO rh_diasemana (".$sStringField.") VALUES (".$sStringValue.");";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if()
      {
        $a_Fields = array();


        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE rh_diasemana SET ".$sStringField." WHERE 1 AND ;";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if()
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM rh_diasemana WHERE 1 AND ;"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* Bsqueda del registro por la llave primaria */
  public static function selectByPK()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT  FROM rh_diasemana WHERE 1 AND ; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con mtodos de acceso */
  private function insertObjectBN($o_propel){
    $o_RhDiasemanaDP = new RhDiasemanaDP();
    return $o_RhDiasemanaDP;
  }
}