<?php
/**
 * Clase Base DP para BasePlSucursalHorarioDP
 *
 * @package    
 * @subpackage BasePlSucursalHorarioDP
 * @author     Willy
 * @version    SVN:: BasePlSucursalHorarioDP.class.php,v 1.1 2019-05-13 12:56:33 william.taype Exp $
 */
abstract class BasePlSucursalHorarioDP extends PlSucursalHorarioBN
{
  /* Nmero de registros afectados */
  private $nRowsAffected;

  public function __construct($bSetDefault = true)
  {
    if( $bSetDefault instanceof PlSucursalHorarioBN )
    {
      $o_PlSucursalHorarioBN = $bSetDefault;
      if($o_PlSucursalHorarioBN->getIdsucursal()) : $this->setIdsucursal($o_PlSucursalHorarioBN->getIdsucursal()); endif;
      if($o_PlSucursalHorarioBN->getHoraminutoninicio()) : $this->setHoraminutoninicio($o_PlSucursalHorarioBN->getHoraminutoninicio()); endif;
      if($o_PlSucursalHorarioBN->getDiasiguiente()) : $this->setDiasiguiente($o_PlSucursalHorarioBN->getDiasiguiente()); endif;
      if($o_PlSucursalHorarioBN->getHoraminutofin()) : $this->setHoraminutofin($o_PlSucursalHorarioBN->getHoraminutofin()); endif;
      if($o_PlSucursalHorarioBN->getMonto()) : $this->setMonto($o_PlSucursalHorarioBN->getMonto()); endif;
    }
  }

  /* Obtiene el nmero de registros afectados */
  public function getRowsAffected()
  {
    return $this->nRowsAffected;
  }

  public function save()
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT IF(MAX(idsucursal),(MAX(idsucursal)+1), 1) AS Maximo FROM pl_sucursal_horario;";
      $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
      $result = $oLink->query($sql);
      $row = $result->fetch(PDO::FETCH_ASSOC);
      $this->setIdsucursal($row["Maximo"]);

      if($this->getIdsucursal()){
        $a_Fields = array();

        if($this->getIdsucursal()) : $a_Fields['idsucursal'] = ($this->getIdsucursal()); endif;
        if($this->getHoraminutoninicio()) : $a_Fields['horaminutoninicio'] = ($this->getHoraminutoninicio()); endif;
        if($this->getDiasiguiente()) : $a_Fields['diasiguiente'] = ($this->getDiasiguiente()); endif;
        if($this->getHoraminutofin()) : $a_Fields['horaminutofin'] = ($this->getHoraminutofin()); endif;
        if($this->getMonto()) : $a_Fields['monto'] = ($this->getMonto()); endif;

        $sStringField = arrayClass::implode_keys(',', $a_Fields);
        $sStringValue = "'".implode("','", $a_Fields)."'";

        $sql = "INSERT INTO pl_sucursal_horario (".$sStringField.") VALUES (".$sStringValue.");";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function update()
  {
    try
    {
      if($this->getIdsucursal())
      {
        $a_Fields = array();

        if($this->getIdsucursal()) : $a_Fields['idsucursal'] = ($this->getIdsucursal()); endif;
        if($this->getHoraminutoninicio()) : $a_Fields['horaminutoninicio'] = ($this->getHoraminutoninicio()); endif;
        if($this->getDiasiguiente()) : $a_Fields['diasiguiente'] = ($this->getDiasiguiente()); endif;
        if($this->getHoraminutofin()) : $a_Fields['horaminutofin'] = ($this->getHoraminutofin()); endif;
        if($this->getMonto()) : $a_Fields['monto'] = ($this->getMonto()); endif;

        $sStringField = arrayClass::implode_key_value(',', $a_Fields);

        $con = Conexion::getConexion();
        $sql = "UPDATE pl_sucursal_horario SET ".$sStringField." WHERE 1 AND idsucursal='".$this->getIdsucursal()."';";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  public function delete()
  {
    try
    {
      if($this->getIdsucursal())
      {
        $a_Fields = array();

        $con = Conexion::getConexion();
        $sql = "DELETE FROM pl_sucursal_horario WHERE 1 AND idsucursal='".$this->getIdsucursal()."';"; 
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
        if($result)
        {
          $this->nRowsAffected = (int) $result->rowCount();
        }
        else
        {
          throw new Exception( $oLink->errorInfo() );
        }
      }
      else
      {
        throw new Exception( 'El id no esta registrado.');
      }
    }
    catch ( Exception $o_Error )
    {
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
    return true;
  }

  /* Bsqueda del registro por la llave primaria */
  public static function selectByPK($vIdsucursal)
  {
    try
    {
      $con = Conexion::getConexion();
      $sql = "SELECT idsucursal, horaminutoninicio, diasiguiente, horaminutofin, monto FROM pl_sucursal_horario WHERE 1 AND idsucursal='".$vIdsucursal."'; ";
        $oLink = method_exists($con, 'getResource')?$con->getResource():$con;
        $result = $oLink->query($sql);
      $o_Propel = $result ? $result->fetch(PDO::FETCH_OBJ) : null;
      
      return $o_Propel?self::insertObjectBN($o_Propel):null;

    }catch ( Exception $o_Error ){
      throw new Exception($o_Error->getMessage().' en '.$o_Error->getFile().' linea '.$o_Error->getLine());
    }
  }

  /* Devuelve un objeto con mtodos de acceso */
  private function insertObjectBN($o_propel){
    $o_PlSucursalHorarioDP = new PlSucursalHorarioDP();
    $o_PlSucursalHorarioDP->setIdsucursal($o_propel->idsucursal);
    $o_PlSucursalHorarioDP->setHoraminutoninicio($o_propel->horaminutoninicio);
    $o_PlSucursalHorarioDP->setDiasiguiente($o_propel->diasiguiente);
    $o_PlSucursalHorarioDP->setHoraminutofin($o_propel->horaminutofin);
    $o_PlSucursalHorarioDP->setMonto($o_propel->monto);
    return $o_PlSucursalHorarioDP;
  }
}